/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.PolicyType;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AddGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.AddPolicyAction;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.CutGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.DeleteGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.DeletePolicyAction;
import com.blixx.boom.gui.views.actions.DupliactePolicyAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ExportPolicyAction;
import com.blixx.boom.gui.views.actions.ExportPolicyCSVAction;
import com.blixx.boom.gui.views.actions.ImportOVPolicy;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.PolicyCompareActioin;
import com.blixx.boom.gui.views.actions.PolicyObjectTestingAction;
import com.blixx.boom.gui.views.actions.PolicyRenamingAction;
import com.blixx.boom.gui.views.actions.PolicySearchTextTestingAction;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.RefreshTreeAction;
import com.blixx.boom.gui.views.actions.RenameGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.SearchPolicyAction;
import com.blixx.boom.gui.views.actions.ShowMessagesForSource;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.boom.gui.views.dnd.DNDCutCopyPolicyAction;
import com.blixx.boom.gui.views.dnd.DNDPasteToPolicyTreeAction;
import com.blixx.boom.gui.views.dnd.DNDSourceTreeProcessor;
import com.blixx.boom.gui.views.dnd.DNDTargetTreeProcessor;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class PolicyListView
extends ViewPart
implements IDoubleClickListener {
    public static final String ID = "com.blixx.boom.gui.views.policylistview";
    protected STreeViewer m_treeViewer;
    public Shell m_parentShell = null;
    public GroupTreeObject m_policyROOT;
    public static PolicyListView m_plv = null;
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static String POLICY_LIST = "POLICY_LIST";
    public static String DND_COPY = "DND_COPY";
    public static String DND_CUT = "DND_CUT";
    public static String DND_COPY_POLICY = "DND_COPY_POLICY";
    public static String DND_CUT_POLICY = "DND_CUT_POLICY";
    public static String DND_COPY_POLICY_FOLDER = "DND_COPY_POLICY_FOLDER";
    public static String DND_CUT_POLICY_FOLDER = "DND_CUT_POLICY_FOLDER";
    private Clipboard m_clipboard = null;
    private DNDTreeIconManager m_treeIconManager = null;

    public static synchronized PolicyListView getInstance() {
        return m_plv;
    }

    public PolicyListView() {
        m_plv = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1001) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    PolicyListView.this.getSite().getPage().hideView(PolicyListView.this.getSite().getPage().findView(PolicyListView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.policylistview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PolicyListView.this.getSite().getPage().hideView(PolicyListView.this.getSite().getPage().findView(PolicyListView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parentShell = parent.getShell();
        this.m_clipboard = new Clipboard(Display.getCurrent());
        this.m_treeIconManager = new DNDTreeIconManager();
        parent.setLayout((Layout)new GridLayout(1, false));
        new FilterComposite(parent, (Object)this);
        this.m_treeViewer = new STreeViewer(parent, 268438274);
        this.m_treeViewer.setData(TREE_VIEWER_TYPE, POLICY_LIST);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setComparer(new TreeElementComparer());
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, this.m_treeViewer));
        this.m_policyROOT = PolicyTreeProvider.getInstance().createPolicyTree();
        this.m_treeViewer.setInput(this.m_policyROOT);
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.addDoubleClickListener(this);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.m_treeViewer.addDragSupport(6, types, new DNDSourceTreeProcessor(this.m_treeViewer));
        this.m_treeViewer.addDropSupport(6, types, new DNDTargetTreeProcessor(this.m_treeViewer));
        this.m_treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 120) {
                        DNDCutCopyPolicyAction cutAction = new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_CUT, PolicyListView.this.m_clipboard);
                        cutAction.run();
                    } else if (e.keyCode == 99) {
                        DNDCutCopyPolicyAction copyAction = new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_COPY, PolicyListView.this.m_clipboard);
                        copyAction.run();
                    } else if (e.keyCode == 118) {
                        DNDPasteToPolicyTreeAction pasteAction = new DNDPasteToPolicyTreeAction(PolicyListView.this.m_treeViewer, PolicyListView.this.m_clipboard);
                        pasteAction.run();
                    }
                }
                if (e.keyCode == 27) {
                    String dndType = (String)PolicyListView.this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
                    PolicyListView.this.m_treeIconManager.restorePolicyTreeIcons((Object)PolicyListView.this.m_treeViewer, dndType);
                    PolicyListView.this.m_clipboard.clearContents();
                }
            }
        });
        this.createContentMenu();
        this.setTitleImage(BMUI.IMAGE_NAG);
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)PolicyListView.this.m_treeViewer.getSelection();
                    manager.add((IAction)new RefreshTreeAction(PolicyListView.this.m_treeViewer, null, null, null));
                    manager.add((IContributionItem)new Separator());
                    if (!ssel.isEmpty()) {
                        boolean selectionContainsReadOnlyElements = false;
                        for (Object obj : ssel) {
                            if (!(obj instanceof GroupTreeObject)) continue;
                            GroupTreeObject gt = (GroupTreeObject)obj;
                            boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gt);
                            boolean permittedPolicyRead = PolicyManager.getInstance().isPermittedPolicyRead(gt);
                            if (permittedPolicyModify && permittedPolicyRead) continue;
                            selectionContainsReadOnlyElements = true;
                            break;
                        }
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                                ImportOVPolicy act = new ImportOVPolicy(PolicyListView.this.m_treeViewer, gto);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                            }
                            manager.add((IContributionItem)new Separator("additions"));
                            manager.add((IContributionItem)new Separator());
                            Action act = new AddGroupTreeObjectAction(PolicyListView.this.m_treeViewer, gto, BMUI.type_tree_policy, null);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                                act = new RenameGroupTreeObjectAction(PolicyListView.this.m_treeViewer, gto, BMUI.type_tree_policy);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                                act = new DeleteGroupTreeObjectAction(PolicyListView.this.m_treeViewer, BMUI.type_tree_policy);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                                act = new CutGroupTreeObjectAction(PolicyListView.this.m_treeViewer, gto, BMUI.type_tree_policy);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                            }
                            manager.add((IContributionItem)new Separator());
                            this.createAddPolicySubMenu(manager, selectionContainsReadOnlyElements, gto);
                            if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                                act = new PolicyRenamingAction(PolicyListView.this.m_parentShell, PolicyListView.this.m_treeViewer, PolicyRenamingDialog.RENAME_POLICY);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                            }
                            manager.add((IContributionItem)new Separator());
                            if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                                act = new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_CUT_POLICY_FOLDER, PolicyListView.this.m_clipboard);
                                if (selectionContainsReadOnlyElements) {
                                    act.setEnabled(false);
                                }
                                manager.add((IAction)act);
                                act = new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_COPY_POLICY_FOLDER, PolicyListView.this.m_clipboard);
                                manager.add((IAction)act);
                            }
                            act = new DNDPasteToPolicyTreeAction(PolicyListView.this.m_treeViewer, PolicyListView.this.m_clipboard);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            manager.add((IContributionItem)new Separator());
                        } else if (o instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                            Action act = new ImportOVPolicy(PolicyListView.this.m_treeViewer, ((GroupTreeObjectLast)o).getParent());
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            ExportPolicyAction exportPolicyAction = new ExportPolicyAction(PolicyListView.this.m_treeViewer, PolicyListView.this.m_policyROOT);
                            manager.add((IAction)exportPolicyAction);
                            ExportPolicyCSVAction exportPolicyCSVAction = new ExportPolicyCSVAction(PolicyListView.this.m_treeViewer, PolicyListView.this.m_policyROOT);
                            manager.add((IAction)exportPolicyCSVAction);
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new AssignToNodeAction(PolicyListView.this.m_treeViewer, "DEPLOY"));
                            manager.add((IAction)new RedeployAction(PolicyListView.this.m_treeViewer, "DEPLOY"));
                            manager.add((IAction)new AssignToNodeAction(PolicyListView.this.m_treeViewer, "UNDEPLOY"));
                            manager.add((IAction)new RedeployAction(PolicyListView.this.m_treeViewer, "UNDEPLOY"));
                            manager.add((IAction)new AssignToNodeAction(PolicyListView.this.m_treeViewer, "DEPLOY_VIRTUAL"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new AssignToNodeAction(PolicyListView.this.m_treeViewer, "DEPLOY_DELAYED"));
                            manager.add((IAction)new RedeployAction(PolicyListView.this.m_treeViewer, "DEPLOY_DELAYED"));
                            manager.add((IAction)new AssignToNodeAction(PolicyListView.this.m_treeViewer, "UNDEPLOY_DELAYED"));
                            manager.add((IAction)new RedeployAction(PolicyListView.this.m_treeViewer, "UNDEPLOY_DELAYED"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new OpenPolicyAction(PolicyListView.this.m_treeViewer, false));
                            this.createAddPolicySubMenu(manager, selectionContainsReadOnlyElements, gtoLast.getParent());
                            act = new DupliactePolicyAction(PolicyListView.this.m_treeViewer);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            act = new PolicyRenamingAction(PolicyListView.this.m_parentShell, PolicyListView.this.m_treeViewer, PolicyRenamingDialog.RENAME_POLICY);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            act = new DeletePolicyAction(PolicyListView.this.m_treeViewer);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            manager.add((IContributionItem)new Separator());
                            act = new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_CUT_POLICY, PolicyListView.this.m_clipboard);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            manager.add((IAction)new DNDCutCopyPolicyAction(PolicyListView.this.m_treeViewer, DND_COPY_POLICY, PolicyListView.this.m_clipboard));
                            act = new DNDPasteToPolicyTreeAction(PolicyListView.this.m_treeViewer, PolicyListView.this.m_clipboard);
                            if (selectionContainsReadOnlyElements) {
                                act.setEnabled(false);
                            }
                            manager.add((IAction)act);
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ShowRelatedPolicyInfosAction((Object)PolicyListView.this.m_treeViewer, PolicyListView.this.m_parentShell));
                            manager.add((IAction)new ShowMessagesForSource(PolicyListView.this.m_treeViewer));
                            if (ssel.size() == 2) {
                                Object sel1 = ssel.toArray()[0];
                                Object sel2 = ssel.toArray()[1];
                                if (sel1 instanceof GroupTreeObjectLast && !(ssel.toArray()[0] instanceof GroupTreeObjectUnsubmitted) && sel2 instanceof GroupTreeObjectLast && !(ssel.toArray()[1] instanceof GroupTreeObjectUnsubmitted)) {
                                    GroupTreeObjectLast p1 = (GroupTreeObjectLast)sel1;
                                    GroupTreeObjectLast p2 = (GroupTreeObjectLast)sel2;
                                    manager.add((IAction)new PolicyCompareActioin(p1.getName(), p1.getTreeObject().getType(), p2.getName(), p2.getTreeObject().getType()));
                                }
                            }
                        }
                    }
                    manager.add((IAction)new SearchPolicyAction());
                    Object o = ssel.getFirstElement();
                    if (o instanceof GroupTreeObject && o instanceof GroupTreeObjectLast) {
                        Iterator it;
                        MsgCondition mc;
                        PolicyManager pm;
                        MsgPolicy mp;
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new PolicySearchTextTestingAction(PolicyListView.this.m_treeViewer));
                        GroupTreeObject gto = (GroupTreeObject)o;
                        String polName = gto.getTreeObject().getName();
                        String polType = gto.getTreeObject().getType();
                        File fileP = Repository.getInstance().fetchFile(polName, polType);
                        if (fileP != null && (mp = (pm = PolicyManager.getInstance()).getMessagePolicy(fileP)) != null && (mc = (MsgCondition)(it = mp.getConditions().getConditionList().iterator()).next()).getApplicationFilter() == "SNMPTrapd") {
                            manager.add((IAction)new PolicyObjectTestingAction(PolicyListView.this.m_treeViewer));
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(PolicyListView.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(PolicyListView.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }

            private void createAddPolicySubMenu(IMenuManager manager, boolean selectionContainsReadOnlyElements, GroupTreeObject gto) {
                MenuManager policyActions = new MenuManager("Create Policy ...", "addpolicy");
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_EXTERNAL);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_EXEC);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_OPM_LBL);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_OPM_TABLE);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_OPM_PUNCHCARD);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_SNMP_WALK);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_mon, PolicyType.MON_JAVA);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_INDI);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_LOGFIL);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_TRANSACT_LOGFILE);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_TRANSACT_LOGFILE_ML);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_NAGIN);
                this.addActionP(policyActions, gto, selectionContainsReadOnlyElements, BMUI.type_msg, PolicyType.MSG_SNMP_TRAP);
                manager.add((IContributionItem)policyActions);
            }

            private void addActionP(MenuManager policyActions, GroupTreeObject gto, boolean selectionContainsReadOnlyElements, String typeMon, PolicyType monExternal) {
                AddPolicyAction act = new AddPolicyAction(PolicyListView.this.m_treeViewer, gto, typeMon, monExternal);
                if (selectionContainsReadOnlyElements) {
                    act.setEnabled(false);
                }
                policyActions.add((IAction)act);
            }
        });
    }

    public GroupTreeObject getPolicyRoot() {
        return this.m_policyROOT;
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public void setFocus() {
        try {
            this.m_treeViewer.getControl().setFocus();
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
        block4: {
            int size;
            ISelection iSelect;
            block2: {
                Object obj;
                block3: {
                    iSelect = event.getViewer().getSelection();
                    size = ((IStructuredSelection)iSelect).size();
                    if (size != 1) break block2;
                    obj = ((IStructuredSelection)iSelect).getFirstElement();
                    if (!(obj instanceof GroupTreeObjectLast)) break block3;
                    GroupTreeObjectLast l = (GroupTreeObjectLast)obj;
                    PolicyView.displayPolicy(l, this.m_treeViewer);
                    break block4;
                }
                if (!(obj instanceof GroupTreeObject)) break block4;
                this.m_treeViewer.setExpandedState((GroupTreeObject)obj, !this.m_treeViewer.getExpandedState(obj));
                break block4;
            }
            if (size > 1) {
                for (Object o : (IStructuredSelection)iSelect) {
                    if (!(o instanceof GroupTreeObjectLast)) continue;
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                    PolicyView.displayPolicy(gtol, this.m_treeViewer);
                }
            }
        }
    }
}

