/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyOverviewTableProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.DeletePolicyAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.PolicyObjectTestingAction;
import com.blixx.boom.gui.views.actions.PolicyRenamingAction;
import com.blixx.boom.gui.views.actions.PolicySearchTextTestingAction;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.SearchPolicyAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ShowMessagesForSource;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class PolicyOverviewTab
extends CTabItem
implements IDoubleClickListener,
SelectionListener {
    private static PolicyOverviewTab m_tab = null;
    private CTabFolder m_folder = null;
    private boolean m_hasAsnRights = true;
    private boolean m_hasAgentRights = true;
    public static String POLICY_TYPE = "policy_type";
    public static String POLICY_OVERVIEW = "POLICY_OVERVIEW";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String TAB_NAME = "Policy Overview";
    public static String DIRTY_STATUS = "dirty_Status";
    private GUIDisplayElements m_gui = null;
    private Composite m_sc = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    public PolicyOverviewTableProvider m_policyTableProvider = null;
    private Composite m_compositeInView = null;
    private Composite m_compMain = null;
    private Composite m_compTable = null;
    private Composite m_compLabel = null;
    private Button m_showAsn_chk = null;
    private Button m_showAgent_chk = null;
    private Button m_refresh_btn = null;
    private Button m_searchPol_btn = null;
    private Text m_counter_label = null;
    private static String SHOW_ASN_CHK = "DISPLAY_ASN_CHK";
    private static String SHOW_AGENTS_CHK = "DISPLAY_AGENT_CHK";
    private static String REFRESH_BTN = "REFRESH_BTN";
    private static String SEARCH_POL_BTN = "SEARCH_POL_BTN";
    private boolean m_showColumn_agent = false;
    private boolean m_showColumn_asn = false;
    public static HashMap<String, Integer> m_colIndices = null;
    public static HashMap<Integer, String> m_colNames = null;
    public static HashMap<String, Integer> m_columnWidth = new HashMap();
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = PolicyOverviewTab.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = PolicyOverviewTab.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    PolicyOverviewTab.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                PolicyOverviewTab.this.m_policyTableProvider.setConfig(sortIdentifier, dir);
                PolicyOverviewTab.this.m_tableViewer.getTable().setSortDirection(dir);
                ISelection sel = PolicyOverviewTab.this.m_tableViewer.getSelection();
                if (PolicyOverviewTab.this.m_tableViewer.getSorter() != PolicyOverviewTab.this.m_policyTableProvider) {
                    PolicyOverviewTab.this.m_tableViewer.setSorter((ViewerSorter)PolicyOverviewTab.this.m_policyTableProvider);
                } else {
                    PolicyOverviewTab.this.m_tableViewer.refresh(true, false);
                }
                PolicyOverviewTab.this.m_tableViewer.setSelection(sel, false);
            }
        }
    };

    static {
        m_columnWidth.put("Policy Type", 28);
        m_columnWidth.put("Name", 200);
        m_columnWidth.put("Version", 60);
        m_columnWidth.put("Group", 80);
        m_columnWidth.put("Application", 80);
        m_columnWidth.put("Call Type", 80);
        m_columnWidth.put("Path", 100);
        m_columnWidth.put("Related Assignments", 120);
        m_columnWidth.put("Related Agents", 120);
    }

    public PolicyOverviewTab(CTabFolder parent) {
        super(parent, 0, 0);
        m_tab = this;
        this.m_folder = parent;
        this.setText(TAB_NAME);
        this.setImage(BMUI.IMAGE_POLICY_OVERVIEW);
        this.setData(DIRTY_STATUS, false);
        if (Repository.getInstance().getRights(1008) <= 1) {
            this.m_hasAsnRights = false;
        }
        if (Repository.getInstance().getRights(1002) <= 1) {
            this.m_hasAgentRights = false;
        }
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInView = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInView.setLayout((Layout)gl);
        this.m_sc = new Composite(this.m_compositeInView, 0);
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain = new Composite(this.m_sc, 2048);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        Group showColGroup = new Group(this.m_compMain, 0);
        showColGroup.setText("Additional Columns");
        gl = new GridLayout(4, false);
        gl.horizontalSpacing = 0;
        showColGroup.setLayout((Layout)gl);
        showColGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_showAsn_chk = this.m_gui.addCheckbox((Composite)showColGroup, SHOW_ASN_CHK, "Related Assignments", this.m_showColumn_asn, 1, 1, 0, this);
        ((GridData)this.m_showAsn_chk.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_showAsn_chk.getLayoutData()).verticalIndent = 3;
        this.m_showAsn_chk.setEnabled(this.m_hasAsnRights);
        this.m_showAgent_chk = this.m_gui.addCheckbox((Composite)showColGroup, SHOW_AGENTS_CHK, "Related Agents", this.m_showColumn_agent, 1, 1, 0, this);
        ((GridData)this.m_showAgent_chk.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_showAgent_chk.getLayoutData()).horizontalIndent = 10;
        ((GridData)this.m_showAgent_chk.getLayoutData()).verticalIndent = 3;
        this.m_showAgent_chk.setEnabled(this.m_hasAgentRights);
        Group filterGroup = new Group(this.m_compMain, 0);
        filterGroup.setText("Filter on Name");
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        filterGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 100;
        filterGroup.setLayoutData((Object)gd);
        FilterComposite filterComp = new FilterComposite((Composite)filterGroup, (Object)this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
        this.m_searchPol_btn = this.m_gui.addButton(this.m_compMain, SEARCH_POL_BTN, "Search Policy", true, 60, 0, 0, this);
        this.m_searchPol_btn.setImage(BMUI.IMAGE_SEARCH);
        ((GridData)this.m_searchPol_btn.getLayoutData()).horizontalIndent = 10;
        ((GridData)this.m_searchPol_btn.getLayoutData()).verticalIndent = 5;
        ((GridData)this.m_searchPol_btn.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_refresh_btn = this.m_gui.addButton(this.m_compMain, REFRESH_BTN, "Refresh ", true, 60, 0, 10, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        this.m_compTable = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.createTable();
        this.m_table.setSortColumn(this.m_table.getColumn(1));
        this.m_table.setSortDirection(128);
        this.m_compLabel = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compLabel.setLayout((Layout)gl);
        this.m_compLabel.setLayoutData((Object)new GridData(4, 1024, false, false, 3, 1));
        this.updateCounters();
        this.setControl((Control)this.m_compositeInView);
    }

    public void createTable() {
        GridData gd = null;
        GridLayout gl = null;
        this.m_table = new Table(this.m_compTable, 68354);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gl = new GridLayout();
        gl.verticalSpacing = 0;
        this.m_table.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true, 4, 1);
        gd.verticalIndent = 5;
        gd.heightHint = 50;
        this.m_table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)POLICY_OVERVIEW);
        this.m_policyTableProvider = new PolicyOverviewTableProvider(this.m_tableViewer, this.m_hasAsnRights, this.m_hasAgentRights);
        TableViewerColumn tv_col0 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col0.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col0 = tv_col0.getColumn();
        col0.setText("Policy Type");
        col0.setWidth(Integer.parseInt("" + m_columnWidth.get("Policy Type")));
        col0.addListener(13, this.sortListener);
        TableViewerColumn tv_col1 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col1.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col1 = tv_col1.getColumn();
        col1.setText("Name");
        col1.setWidth(Integer.parseInt("" + m_columnWidth.get("Name")));
        col1.addListener(13, this.sortListener);
        TableViewerColumn tv_col2 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col2.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col2 = tv_col2.getColumn();
        col2.setText("Version");
        col2.setWidth(Integer.parseInt("" + m_columnWidth.get("Version")));
        col2.addListener(13, this.sortListener);
        TableViewerColumn tv_col3 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col3.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col3 = tv_col3.getColumn();
        col3.setText("Group");
        col3.setWidth(Integer.parseInt("" + m_columnWidth.get("Group")));
        col3.addListener(13, this.sortListener);
        TableViewerColumn tv_col4 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col4.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col4 = tv_col4.getColumn();
        col4.setText("Application");
        col4.setWidth(Integer.parseInt("" + m_columnWidth.get("Application")));
        col4.addListener(13, this.sortListener);
        TableViewerColumn tv_col5 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col5.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col5 = tv_col5.getColumn();
        col5.setText("Call Type");
        col5.setWidth(Integer.parseInt("" + m_columnWidth.get("Call Type")));
        col5.addListener(13, this.sortListener);
        TableViewerColumn tv_col6 = new TableViewerColumn(this.m_tableViewer, 16384);
        tv_col6.setLabelProvider(this.m_policyTableProvider.labelProvider);
        TableColumn col6 = tv_col6.getColumn();
        col6.setText("Path");
        col6.setWidth(Integer.parseInt("" + m_columnWidth.get("Path")));
        col6.addListener(13, this.sortListener);
        TableColumn col7 = null;
        TableColumn col8 = null;
        if (this.m_showColumn_asn) {
            TableViewerColumn tv_col7 = new TableViewerColumn(this.m_tableViewer, 16384);
            tv_col7.setLabelProvider(this.m_policyTableProvider.labelProvider);
            col7 = tv_col7.getColumn();
            col7.setText("Related Assignments");
            col7.setWidth(Integer.parseInt("" + m_columnWidth.get("Related Assignments")));
            col7.addListener(13, this.sortListener);
        }
        if (this.m_showColumn_agent) {
            TableViewerColumn tv_col8 = new TableViewerColumn(this.m_tableViewer, 16384);
            tv_col8.setLabelProvider(this.m_policyTableProvider.labelProvider);
            col8 = tv_col8.getColumn();
            col8.setText("Related Agents");
            col8.setWidth(Integer.parseInt("" + m_columnWidth.get("Related Agents")));
            col8.addListener(13, this.sortListener);
        }
        m_colIndices = new HashMap();
        m_colNames = new HashMap();
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            m_colIndices.put(col.getText(), i);
            m_colNames.put(i, col.getText());
            ++i;
        }
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.m_compTable.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(0, col5.getWidth()));
        if (col7 == null && col8 == null) {
            tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(100, col6.getWidth()));
        } else if (col7 != null && col8 == null) {
            tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(30, col6.getWidth()));
            tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(70, col7.getWidth()));
        } else if (col7 == null && col8 != null) {
            tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(30, col6.getWidth()));
            tableLayout.setColumnData((Widget)col8, (ColumnLayoutData)new ColumnWeightData(70, col8.getWidth()));
        } else if (col7 != null && col8 != null) {
            tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(40, col6.getWidth()));
            tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(30, col7.getWidth()));
            tableLayout.setColumnData((Widget)col8, (ColumnLayoutData)new ColumnWeightData(30, col8.getWidth()));
        }
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_policyTableProvider);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        this.m_tableViewer.setSorter((ViewerSorter)this.m_policyTableProvider);
        this.m_tableViewer.setComparer((IElementComparer)this.m_policyTableProvider);
        this.m_tableViewer.setInput((Object)this.m_policyTableProvider.getElements(null));
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PolicyOverviewTab.this.updateCounters();
                PolicyOverviewTab.this.m_compLabel.layout(true);
            }
        });
        this.m_table.setToolTipText("");
        this.addListenersToTable();
        this.createPolicyTable_CM();
    }

    public void createPolicyTable_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = PolicyView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    Iterator it;
                    MsgCondition mc;
                    PolicyManager pm;
                    MsgPolicy mp;
                    manager.add((IAction)new RefreshTableAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ShowHideColumnAction(PolicyOverviewTab.this.m_tableViewer, "Related Assignments"));
                    manager.add((IAction)new ShowHideColumnAction(PolicyOverviewTab.this.m_tableViewer, "Related Agents"));
                    manager.add((IAction)new ShowRelatedPolicyInfosAction(PolicyOverviewTab.this.m_tableViewer, PolicyOverviewTab.this.m_folder.getShell()));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new PolicySearchTextTestingAction(PolicyOverviewTab.this.m_tableViewer));
                    IStructuredSelection ssel = (IStructuredSelection)PolicyOverviewTab.this.m_tableViewer.getSelection();
                    Object o = ssel.getFirstElement();
                    String[] sb = (String[])o;
                    File fileP = Repository.getInstance().fetchFile(sb[1], sb[0]);
                    if (fileP != null && (mp = (pm = PolicyManager.getInstance()).getMessagePolicy(fileP)) != null && (mc = (MsgCondition)(it = mp.getConditions().getConditionList().iterator()).next()).getApplicationFilter() == "SNMPTrapd") {
                        manager.add((IAction)new PolicyObjectTestingAction(PolicyOverviewTab.this.m_tableViewer));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ShowMessagesForSource(PolicyOverviewTab.this.m_tableViewer));
                    manager.add((IAction)new SearchPolicyAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new OpenPolicyAction(PolicyOverviewTab.this.m_tableViewer, true));
                    manager.add((IAction)new SelectPolicyInTreeAction(PolicyOverviewTab.this.m_tableViewer));
                    manager.add((IAction)new PolicyRenamingAction(PolicyOverviewTab.this.m_folder.getShell(), PolicyOverviewTab.this.m_tableViewer, PolicyRenamingDialog.RENAME_POLICY, (CTabItem)m_tab));
                    manager.add((IAction)new DeletePolicyAction(PolicyOverviewTab.this.m_tableViewer, m_tab));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AssignToNodeAction(PolicyOverviewTab.this.m_tableViewer, "DEPLOY"));
                    manager.add((IAction)new RedeployAction(PolicyOverviewTab.this.m_tableViewer, "DEPLOY"));
                    manager.add((IAction)new AssignToNodeAction(PolicyOverviewTab.this.m_tableViewer, "UNDEPLOY"));
                    manager.add((IAction)new RedeployAction(PolicyOverviewTab.this.m_tableViewer, "UNDEPLOY"));
                    manager.add((IAction)new AssignToNodeAction(PolicyOverviewTab.this.m_tableViewer, "DEPLOY_VIRTUAL"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AssignToNodeAction(PolicyOverviewTab.this.m_tableViewer, "DEPLOY_DELAYED"));
                    manager.add((IAction)new RedeployAction(PolicyOverviewTab.this.m_tableViewer, "DEPLOY_DELAYED"));
                    manager.add((IAction)new AssignToNodeAction(PolicyOverviewTab.this.m_tableViewer, "UNDEPLOY_DELAYED"));
                    manager.add((IAction)new RedeployAction(PolicyOverviewTab.this.m_tableViewer, "UNDEPLOY_DELAYED"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void addListenersToTable() {
        Listener multiLineListener = new Listener(){

            public void handleEvent(Event event) {
                int colIndex = event.index;
                String colName = m_colNames.get(colIndex);
                if (colName == null) {
                    return;
                }
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        String text = this.getText(item, event.index);
                        if (text == null) break;
                        Point size = event.gc.textExtent(text);
                        event.width = size.x + 4;
                        event.height = Math.max(event.height, size.y + 2);
                        break;
                    }
                    case 42: {
                        String text;
                        TableItem item = (TableItem)event.item;
                        Image image = item.getImage(event.index);
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(image, event.x + 4, event.y + 2 + offset);
                        }
                        if ((text = this.getText(item, event.index)) == null) break;
                        Point size = event.gc.textExtent(text);
                        int offset2 = Math.max(0, (event.height - size.y) / 2);
                        event.gc.drawText(text, event.x + 4, event.y + 2 + offset2, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }

            String getText(TableItem item, int column) {
                String text = item.getText(column);
                if (text == null || text.length() == 0) {
                    return null;
                }
                return text;
            }
        };
        this.m_table.addListener(41, multiLineListener);
        this.m_table.addListener(42, multiLineListener);
        this.m_table.addListener(40, multiLineListener);
    }

    public void reloadTable() {
        String sortColName = null;
        int sortDir = -1;
        boolean doSorting = false;
        TableColumn sortCol = this.m_table.getSortColumn();
        if (sortCol != null) {
            sortColName = sortCol.getText();
            sortDir = this.m_table.getSortDirection();
            if (m_colIndices.containsKey(sortColName) && sortDir != -1) {
                doSorting = true;
            }
        }
        ArrayList<String> selection = this.getTableSelection();
        if (this.doesColNumberChange()) {
            this.m_table.dispose();
            this.createTable();
            this.updateCounters();
            this.m_compTable.layout(true);
            this.m_compLabel.layout(true);
        } else {
            this.m_tableViewer.setInput((Object)this.m_policyTableProvider.getElements("REFRESH"));
            this.updateCounters();
            this.m_compTable.layout(true);
            this.m_compLabel.layout(true);
        }
        if (!doSorting) {
            return;
        }
        if (m_colIndices.containsKey(sortColName)) {
            int colIndex = m_colIndices.get(sortColName);
            sortCol = this.m_table.getColumn(colIndex);
            this.m_policyTableProvider.setConfig(sortColName, sortDir);
            this.m_tableViewer.getTable().setSortDirection(sortDir);
            this.m_tableViewer.getTable().setSortColumn(sortCol);
            if (this.m_tableViewer.getSorter() != this.m_policyTableProvider) {
                this.m_tableViewer.setSorter((ViewerSorter)this.m_policyTableProvider);
            } else {
                this.m_tableViewer.refresh(true, false);
            }
        }
        this.setTableSelection(selection);
    }

    public boolean doesColNumberChange() {
        boolean doChange = false;
        boolean isAgentColActiv = false;
        boolean isAsnColActive = false;
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            if (col.getText().equals("Related Agents")) {
                isAgentColActiv = true;
            } else if (col.getText().equals("Related Assignments")) {
                isAsnColActive = true;
            }
            ++i;
        }
        if (isAgentColActiv != this.m_showColumn_agent || isAsnColActive != this.m_showColumn_asn) {
            doChange = true;
        }
        return doChange;
    }

    private void updateCounters() {
        int pCount = this.m_policyTableProvider.getElements(null).length;
        int monCount = this.m_policyTableProvider.getMonCount();
        int msgCount = this.m_policyTableProvider.getMsgCount();
        int selected = this.m_table.getSelectionCount();
        if (this.m_counter_label != null && !this.m_counter_label.isDisposed()) {
            this.m_counter_label.dispose();
        }
        this.m_counter_label = this.m_gui.addTextReadOnlyNoBorder(this.m_compLabel, null, "", 1, 1, 0, 5, null);
        String txtStr = "Selected (" + selected + ")   Total Policies (" + pCount + ")   Indications (" + msgCount + ")   Monitors (" + monCount + ")";
        this.m_counter_label.setText(txtStr);
    }

    private ArrayList<String> getTableSelection() {
        ArrayList<String> list = new ArrayList<String>();
        TableItem[] tableItems = this.m_table.getSelection();
        int i = 0;
        while (i < tableItems.length) {
            TableItem ti = tableItems[i];
            String[] item = (String[])ti.getData();
            list.add(item[1]);
            ++i;
        }
        return list;
    }

    private void setTableSelection(ArrayList<String> list) {
        if (list.size() == 0) {
            return;
        }
        String polName = "";
        ArrayList<TableItem> tableItem = new ArrayList<TableItem>();
        int i = 0;
        while (i < list.size()) {
            polName = list.get(i);
            TableItem item = this.getTableItem(polName);
            if (item != null) {
                tableItem.add(item);
            }
            ++i;
        }
        if (tableItem.size() == 0) {
            return;
        }
        TableItem[] newTI = new TableItem[tableItem.size()];
        int i2 = 0;
        while (i2 < tableItem.size()) {
            newTI[i2] = (TableItem)tableItem.get(i2);
            ++i2;
        }
        this.m_table.setSelection(newTI);
    }

    private TableItem getTableItem(String polName) {
        TableItem[] tableItems = this.m_table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem ti = tableItems[i];
            String[] item = (String[])ti.getData();
            if (item[1].equals(polName)) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public void dispose() {
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (!(obj instanceof Table) && obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (name.equals(REFRESH_BTN)) {
                RefreshTableAction action = new RefreshTableAction();
                action.run();
            } else if (name.equals(SEARCH_POL_BTN)) {
                SearchPolicyAction action = new SearchPolicyAction();
                action.run();
            } else if (name.equals(SHOW_ASN_CHK)) {
                ShowHideColumnAction action = new ShowHideColumnAction(this.m_tableViewer, "Related Assignments");
                action.run();
            } else if (name.equals(SHOW_AGENTS_CHK)) {
                ShowHideColumnAction action = new ShowHideColumnAction(this.m_tableViewer, "Related Agents");
                action.run();
            } else {
                name.equals("STATISTICS");
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection ssel = (IStructuredSelection)this.m_tableViewer.getSelection();
        if (!ssel.isEmpty()) {
            if (ssel.size() == 1) {
                Object obj = ssel.getFirstElement();
                if (obj instanceof String[]) {
                    String[] pol = (String[])obj;
                    PolicyView.displayPolicy(pol[1], pol[0], pol[6], null);
                }
            } else if (ssel.size() > 1) {
                if (ssel.size() > 50) {
                    return;
                }
                for (Object o : ssel) {
                    if (!(o instanceof String[])) continue;
                    String[] pol = (String[])o;
                    PolicyView.displayPolicy(pol[1], pol[0], pol[6], null);
                }
            }
        }
    }

    public int getColumnIndex(Table t, int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = t.getColumns();
        int index = 0;
        while (index < t.getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    private class RefreshTableAction
    extends Action {
        public RefreshTableAction() {
            super("refreshtable");
            this.setId("refreshtable");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            }
        }

        public void run() {
            PolicyOverviewTab.this.reloadTable();
        }
    }

    private class ShowHideColumnAction
    extends Action {
        private String m_colName;

        public ShowHideColumnAction(TableViewer tableViewer, String colName) {
            super("showhidecolumnAction");
            this.m_colName = null;
            this.setId("showhidecolumnAction");
            PolicyOverviewTab.this.m_tableViewer = tableViewer;
            this.m_colName = colName;
            if (this.m_colName.equals("Related Agents")) {
                if (PolicyOverviewTab.this.m_showColumn_agent) {
                    this.setText("Hide Column Agents");
                } else {
                    this.setText("Show Column Agents");
                }
                this.setEnabled(PolicyOverviewTab.this.m_hasAgentRights);
            } else if (this.m_colName.equals("Related Assignments")) {
                if (PolicyOverviewTab.this.m_showColumn_asn) {
                    this.setText("Hide Column Assignments");
                } else {
                    this.setText("Show Column Assignments");
                }
                this.setEnabled(PolicyOverviewTab.this.m_hasAsnRights);
            }
        }

        public void run() {
            if (this.m_colName.equals("Related Agents")) {
                PolicyOverviewTab.this.m_showColumn_agent = !PolicyOverviewTab.this.m_showColumn_agent;
                PolicyOverviewTab.this.m_showAgent_chk.setSelection(PolicyOverviewTab.this.m_showColumn_agent);
                PolicyOverviewTab.this.reloadTable();
            } else if (this.m_colName.equals("Related Assignments")) {
                PolicyOverviewTab.this.m_showColumn_asn = !PolicyOverviewTab.this.m_showColumn_asn;
                PolicyOverviewTab.this.m_showAsn_chk.setSelection(PolicyOverviewTab.this.m_showColumn_asn);
                PolicyOverviewTab.this.reloadTable();
            }
        }
    }
}

