/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.policies.PolicySearchTableProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ImageCombo;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.DeletePolicyAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.PolicyRenamingAction;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.SearchPolicyAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ShowMessagesForSource;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.log.RTLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class PolicySearchTab
extends CTabItem
implements IDoubleClickListener,
SelectionListener,
ModifyListener,
DisposeListener,
KeyListener {
    private PolicySearchTab m_tab = null;
    private CTabFolder m_folder = null;
    private PolicyView m_pView = null;
    private HashMap<Object, String> m_mainPropsFields = null;
    private HashMap<Object, String> m_condPropsFields = null;
    private GUIDisplayElements m_gui = null;
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    private ImageCombo m_polTypes_imgCbo = null;
    public static String DIRTY_STATUS = "dirty_Status";
    public static String POLICY_SEARCH = "POLICY_SEARCH";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String TAB_NAME = "Policy Search";
    public static String POLICY_TYPES = "POLICY_TYPES";
    private static String[] m_policyTypes = new String[]{"all Policies", "Monitor Policies", "Indication Policies"};
    private static HashMap<String, Image> m_polImageList = new HashMap();
    private static String GLOBAL_SEARCH;
    private static String GLOBAL_SEARCH_FIELD;
    private static String START_GLOBAL_SEARCH_BTN;
    private Text m_gloablSearch_field = null;
    private Button m_globalSearch_btn = null;
    public static String PROPERTY_TYPE;
    public static String POL;
    public static String COND;
    private static String ADVANCED_SEARCH;
    private static String START_ADVANCED_SEARCH_BTN;
    private static String CLEAR_SEARCH_BTN;
    private static String ANY_ATTRIBUTES;
    private Button m_advancedSearch_btn = null;
    private Button m_clearSearch_btn = null;
    private Button m_searchPolName_rBtn = null;
    private Button m_searchAllMainProps_rBtn = null;
    private Button m_searchCondID_rBtn = null;
    private Button m_searchAllCondProps_rBtn = null;
    private Text m_polName_field = null;
    private Text m_searchAllMainProps_field = null;
    private Text m_condID_field = null;
    private Text m_searchAllCond_field = null;
    private static String SEARCH_POLNAME_RBTN;
    private static String SEARCH_ALL_MAINPROPS_RBTN;
    private static String SEARCH_COND_ID_RBTN;
    private static String SEARCH_ALL_CONDPROPS_RBTN;
    private Label m_resultHeader_label = null;
    private Label m_resultFooter_label = null;
    private Composite m_TableComp = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private PolicySearchTableProvider m_tableProvider = null;
    private Map<String, String> m_result = null;
    private String m_searchType = null;
    private static String POL_NAME_FIELD;
    private static String COND_ID_FIELD;
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = PolicySearchTab.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = PolicySearchTab.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    PolicySearchTab.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                PolicySearchTab.this.m_tableProvider.setConfig(sortIdentifier, dir);
                PolicySearchTab.this.m_tableViewer.getTable().setSortDirection(dir);
                ISelection sel = PolicySearchTab.this.m_tableViewer.getSelection();
                if (PolicySearchTab.this.m_tableViewer.getSorter() != PolicySearchTab.this.m_tableProvider) {
                    PolicySearchTab.this.m_tableViewer.setSorter((ViewerSorter)PolicySearchTab.this.m_tableProvider);
                } else {
                    PolicySearchTab.this.m_tableViewer.refresh(true, false);
                }
                PolicySearchTab.this.m_tableViewer.setSelection(sel, false);
            }
        }
    };

    static {
        m_polImageList.put(m_policyTypes[0], null);
        m_polImageList.put(m_policyTypes[1], BMUI.IMAGE_MON);
        m_polImageList.put(m_policyTypes[2], BMUI.IMAGE_MSG);
        GLOBAL_SEARCH = "GLOBAL_SEARCH";
        GLOBAL_SEARCH_FIELD = "GLOBAL_SEARCH_FIELD";
        START_GLOBAL_SEARCH_BTN = "GLOBAL_SEARCH_BTN";
        PROPERTY_TYPE = "PROPERTY_TYPE";
        POL = "p";
        COND = "c";
        ADVANCED_SEARCH = "ADVANCED_SEARCH";
        START_ADVANCED_SEARCH_BTN = "START_ADVANCED_SEARCH_BTN";
        CLEAR_SEARCH_BTN = "CLEAR_SEARCH_BTN";
        ANY_ATTRIBUTES = "ANY_ATTRIBUTES";
        SEARCH_POLNAME_RBTN = "SEARCH_POLNAME_RBTN";
        SEARCH_ALL_MAINPROPS_RBTN = "SEARCH_ALL_MAINPROPS_RBTN";
        SEARCH_COND_ID_RBTN = "SEARCH_COND_ID_RBTN";
        SEARCH_ALL_CONDPROPS_RBTN = "SEARCH_ALL_CONDPROPS_RBTN";
        POL_NAME_FIELD = "NAME";
        COND_ID_FIELD = "CONDITION_ID";
    }

    public PolicySearchTab(CTabFolder parent) {
        super(parent, 64, 1);
        this.setText(TAB_NAME);
        this.setImage(BMUI.IMAGE_SEARCH);
        this.setData(DIRTY_STATUS, false);
        this.addDisposeListener(this);
        this.m_tab = this;
        this.m_folder = parent;
        this.m_pView = PolicyView.getInstance();
        this.m_gui = new GUIDisplayElements();
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_sc = new ScrolledComposite((Composite)this.m_folder, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite sc = (ScrolledComposite)event.widget;
                sc.getVerticalBar().setIncrement(event.count * 4);
            }
        });
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_polTypes_imgCbo = this.m_gui.addDropDownWithImage(this.m_mainComp, POLICY_TYPES, "Search in: ", m_polImageList, m_policyTypes, m_policyTypes[0], null, 1, 1, 1, 10, null);
        ((GridData)this.m_polTypes_imgCbo.getLayoutData()).verticalIndent = 10;
        ((GridData)this.m_polTypes_imgCbo.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_polTypes_imgCbo.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_polTypes_imgCbo.select(0);
        this.m_polTypes_imgCbo.addSelectionListener(this);
        this.createGlobalSearchSection();
        this.createAdvancedSearchSection();
        this.createResultSection();
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        this.setControl((Control)this.m_sc);
    }

    public void createGlobalSearchSection() {
        Section globalSearchSection = BMUI.getFormToolkit(Display.getCurrent()).createSection(this.m_mainComp, 578);
        globalSearchSection.setText("Global Search");
        globalSearchSection.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 20;
        globalSearchSection.setLayoutData((Object)gd);
        globalSearchSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                PolicySearchTab.this.m_sc.setContent((Control)PolicySearchTab.this.m_mainComp);
                PolicySearchTab.this.m_sc.setMinSize(PolicySearchTab.this.m_mainComp.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite globalSearchComp = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)globalSearchSection, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 10;
        globalSearchComp.setLayout((Layout)gl);
        globalSearchSection.setClient((Control)globalSearchComp);
        this.m_gloablSearch_field = this.m_gui.addInputFieldSingle(globalSearchComp, GLOBAL_SEARCH_FIELD, "Search for: ", "", 1, 1, 10, 1, 60, this);
        this.m_gloablSearch_field.addKeyListener((KeyListener)this);
        this.m_globalSearch_btn = this.m_gui.addButton(globalSearchComp, START_GLOBAL_SEARCH_BTN, "Start Search", false, this);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.m_globalSearch_btn.setLayoutData((Object)gd);
        Label label = new Label(globalSearchComp, 0);
        label.setText("Search inside all Policy and Condition Properties!");
        gd = new GridData(4, 0x1000000, true, false, 3, 1);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
    }

    public void createAdvancedSearchSection() {
        Section advancedSearchSection = BMUI.getFormToolkit(Display.getCurrent()).createSection(this.m_mainComp, 578);
        advancedSearchSection.setText("Advanced Search");
        advancedSearchSection.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 20;
        advancedSearchSection.setLayoutData((Object)gd);
        advancedSearchSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                PolicySearchTab.this.m_sc.setContent((Control)PolicySearchTab.this.m_mainComp);
                PolicySearchTab.this.m_sc.setMinSize(PolicySearchTab.this.m_mainComp.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite advancedSarchComp = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)advancedSearchSection, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 10;
        advancedSarchComp.setLayout((Layout)gl);
        advancedSearchSection.setClient((Control)advancedSarchComp);
        Composite leftComp = new Composite(advancedSarchComp, 0);
        leftComp.setLayout((Layout)new GridLayout(1, false));
        leftComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Group polGrp = new Group(leftComp, 0);
        polGrp.setText("Main Properties");
        gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.marginBottom = 5;
        gl.marginTop = 5;
        gl.marginLeft = 5;
        polGrp.setLayout((Layout)gl);
        polGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_searchPolName_rBtn = this.m_gui.addRadioButton((Composite)polGrp, SEARCH_POLNAME_RBTN, "Policy Name: ", false, 1, 1, 1, 1, this);
        this.m_polName_field = this.m_gui.addInputFieldSingle((Composite)polGrp, POL_NAME_FIELD, null, "", 1, 1, 1, 1, 60, this);
        this.m_gui.enableField(this.m_polName_field, false);
        this.m_polName_field.addKeyListener((KeyListener)this);
        this.m_searchAllMainProps_rBtn = this.m_gui.addRadioButton((Composite)polGrp, SEARCH_ALL_MAINPROPS_RBTN, "Search all Main Properties: ", true, 1, 1, 1, 1, this);
        this.m_searchAllMainProps_field = this.m_gui.addInputFieldSingle((Composite)polGrp, null, null, "", 1, 1, 1, 1, 60, this);
        this.m_searchAllMainProps_field.addKeyListener((KeyListener)this);
        this.m_searchAllMainProps_field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Text field = (Text)e.getSource();
                if (field != null && !field.isDisposed() && field.getText().length() > 0) {
                    PolicySearchTab.this.m_gui.enableField(PolicySearchTab.this.m_advancedSearch_btn, true);
                }
            }
        });
        Group condGrp = new Group(leftComp, 0);
        condGrp.setText("Condition Properties");
        gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.marginBottom = 5;
        gl.marginTop = 5;
        gl.marginLeft = 5;
        condGrp.setLayout((Layout)gl);
        condGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_searchCondID_rBtn = this.m_gui.addRadioButton((Composite)condGrp, SEARCH_COND_ID_RBTN, "Condition ID: ", false, 1, 1, 1, 1, this);
        this.m_condID_field = this.m_gui.addInputFieldSingle((Composite)condGrp, COND_ID_FIELD, null, "", 1, 1, 1, 1, 60, this);
        this.m_gui.enableField(this.m_condID_field, false);
        this.m_condID_field.addKeyListener((KeyListener)this);
        this.m_searchAllCondProps_rBtn = this.m_gui.addRadioButton((Composite)condGrp, SEARCH_ALL_CONDPROPS_RBTN, "Search all Condition Properties: ", true, 1, 1, 1, 1, this);
        this.m_searchAllCond_field = this.m_gui.addInputFieldSingle((Composite)condGrp, null, null, "", 1, 1, 1, 1, 60, this);
        this.m_searchAllCond_field.addKeyListener((KeyListener)this);
        this.m_searchAllCond_field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Text field = (Text)e.getSource();
                if (field != null && !field.isDisposed() && field.getText().length() > 0) {
                    PolicySearchTab.this.m_gui.enableField(PolicySearchTab.this.m_advancedSearch_btn, true);
                }
            }
        });
        Composite rightComp = new Composite(advancedSarchComp, 0);
        rightComp.setLayout((Layout)new GridLayout(1, false));
        rightComp.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_advancedSearch_btn = this.m_gui.addButton(rightComp, START_ADVANCED_SEARCH_BTN, "Start Search", false, this);
        this.m_advancedSearch_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_clearSearch_btn = this.m_gui.addButton(rightComp, CLEAR_SEARCH_BTN, "Clear", false, this);
        this.m_clearSearch_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.initSearchFields();
        this.setFieldData();
    }

    public void createResultSection() {
        this.m_resultHeader_label = new Label(this.m_mainComp, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.verticalIndent = 20;
        this.m_resultHeader_label.setLayoutData((Object)gd);
        this.m_resultHeader_label.setFont(BMUI.font_arial8_bold);
        this.m_TableComp = new Composite(this.m_mainComp, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_TableComp.setLayout((Layout)gl);
        this.m_TableComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    public void refreshResultSection() {
        if (this.m_result == null || this.m_result.size() == 0) {
            if (this.m_table != null && !this.m_table.isDisposed()) {
                Control[] controls = this.m_TableComp.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].dispose();
                    ++i;
                }
            }
            if (this.m_tableProvider != null) {
                this.m_tableProvider.setResult(this.m_result);
            }
            if (this.m_resultFooter_label == null || this.m_resultFooter_label.isDisposed()) {
                this.m_resultFooter_label = new Label(this.m_TableComp, 0);
                GridData gd = new GridData(4, 0x1000000, true, false);
                gd.verticalIndent = 10;
                this.m_resultFooter_label.setLayoutData((Object)gd);
            }
        } else if (this.m_table == null || this.m_table.isDisposed()) {
            Control[] controls = this.m_TableComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
            this.m_table = new Table(this.m_TableComp, 68354);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            GridData gd = new GridData(4, 4, true, true);
            gd.verticalIndent = 5;
            gd.heightHint = 200;
            this.m_table.setLayoutData((Object)gd);
            this.m_tableViewer = new TableViewer(this.m_table);
            this.m_tableViewer.setData(VIEWER_TYPE, (Object)POLICY_SEARCH);
            this.m_tableProvider = new PolicySearchTableProvider(this.m_result);
            TableViewerColumn col0 = new TableViewerColumn(this.m_tableViewer, 16384);
            col0.getColumn().setText("Type");
            col0.getColumn().setWidth(28);
            col0.getColumn().addListener(13, this.sortListener);
            col0.setLabelProvider(this.m_tableProvider.labelProvider);
            TableViewerColumn col1 = new TableViewerColumn(this.m_tableViewer, 16384);
            col1.getColumn().setText("Name");
            col1.getColumn().setWidth(200);
            col1.getColumn().addListener(13, this.sortListener);
            col1.setLabelProvider(this.m_tableProvider.labelProvider);
            TableViewerColumn col2 = new TableViewerColumn(this.m_tableViewer, 16384);
            col2.getColumn().setText("Version");
            col2.getColumn().setWidth(60);
            col2.getColumn().addListener(13, this.sortListener);
            col2.setLabelProvider(this.m_tableProvider.labelProvider);
            TableViewerColumn col3 = new TableViewerColumn(this.m_tableViewer, 16384);
            col3.getColumn().setText("Results in Main Properties");
            col3.getColumn().setWidth(250);
            col3.getColumn().addListener(13, this.sortListener);
            col3.setLabelProvider(this.m_tableProvider.labelProvider);
            TableViewerColumn col4 = new TableViewerColumn(this.m_tableViewer, 16384);
            col4.getColumn().setText("Results in Condition Properties");
            col4.getColumn().setWidth(250);
            col4.getColumn().addListener(13, this.sortListener);
            col4.setLabelProvider(this.m_tableProvider.labelProvider);
            this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
            this.m_tableViewer.setSorter((ViewerSorter)this.m_tableProvider);
            this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
            this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
            this.createContentMenu();
            FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
            this.m_table.setToolTipText("");
            this.m_resultFooter_label = new Label(this.m_TableComp, 0);
            this.m_resultFooter_label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            this.m_tableProvider.setResult(this.m_result);
            this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        }
        this.updateLabels();
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = PolicyView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)PolicySearchTab.this.m_tableViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        String polName = null;
                        String polType = null;
                        String[] item = (String[])ssel.getFirstElement();
                        if (item != null && item.length >= 2) {
                            polName = item[1];
                            polType = item[0];
                        }
                        manager.add((IAction)new OpenPolicyAction(PolicySearchTab.this.m_tableViewer, true));
                        manager.add((IAction)new SelectPolicyInTreeAction(PolicySearchTab.this.m_tableViewer));
                        manager.add((IAction)new PolicyRenamingAction(PolicySearchTab.this.m_folder.getShell(), PolicySearchTab.this.m_tableViewer, PolicyRenamingDialog.RENAME_POLICY, PolicySearchTab.this.m_tab));
                        manager.add((IAction)new DeletePolicyAction(PolicySearchTab.this.m_tableViewer, PolicySearchTab.this.m_tab));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ShowRelatedPolicyInfosAction(polName, polType, PolicySearchTab.this.m_folder.getShell()));
                        manager.add((IAction)new ShowMessagesForSource(PolicySearchTab.this.m_tableViewer));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new AssignToNodeAction(PolicySearchTab.this.m_tableViewer, "DEPLOY"));
                        manager.add((IAction)new RedeployAction(PolicySearchTab.this.m_tableViewer, "DEPLOY"));
                        manager.add((IAction)new AssignToNodeAction(PolicySearchTab.this.m_tableViewer, "UNDEPLOY"));
                        manager.add((IAction)new RedeployAction(PolicySearchTab.this.m_tableViewer, "UNDEPLOY"));
                        manager.add((IAction)new AssignToNodeAction(PolicySearchTab.this.m_tableViewer, "DEPLOY_VIRTUAL"));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new AssignToNodeAction(PolicySearchTab.this.m_tableViewer, "DEPLOY_DELAYED"));
                        manager.add((IAction)new RedeployAction(PolicySearchTab.this.m_tableViewer, "DEPLOY_DELAYED"));
                        manager.add((IAction)new AssignToNodeAction(PolicySearchTab.this.m_tableViewer, "UNDEPLOY_DELAYED"));
                        manager.add((IAction)new RedeployAction(PolicySearchTab.this.m_tableViewer, "UNDEPLOY_DELAYED"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    private void updateLabels() {
        if (!this.m_resultHeader_label.isDisposed()) {
            if (this.m_searchType.equals(GLOBAL_SEARCH)) {
                this.m_resultHeader_label.setText("Global Search Result");
            } else if (this.m_searchType.equals(ADVANCED_SEARCH)) {
                this.m_resultHeader_label.setText("Advanced Search Result");
            }
        }
        if (!this.m_resultFooter_label.isDisposed()) {
            int count = 0;
            if (this.m_tableProvider != null) {
                count = this.m_tableProvider.getPolicyCount();
            }
            StringBuffer resultText = new StringBuffer();
            if (count == 0) {
                resultText.append("No Policies found!");
            } else if (count == 1) {
                resultText.append("").append(count).append(" Policy found!");
            } else {
                resultText.append("").append(count).append(" Policies found!");
            }
            this.m_resultFooter_label.setText(resultText.toString());
        }
    }

    public void reRunSearch() {
        if (this.m_searchType == null) {
            return;
        }
        if (this.m_searchType.equals(GLOBAL_SEARCH)) {
            this.startGloabalSearch();
        } else if (this.m_searchType.equals(ADVANCED_SEARCH)) {
            this.startAdvancedSearch();
        }
    }

    private void startGloabalSearch() {
        String searchText = this.m_gloablSearch_field.getText().trim();
        if ("".equals(searchText)) {
            this.checkButtonStatus(GLOBAL_SEARCH);
            return;
        }
        LinkedList<String> props = new LinkedList<String>();
        props.add(this.getPolicyTypes());
        String[] properties = props.toArray(new String[0]);
        SearchPolicyAction action = new SearchPolicyAction(properties, searchText);
        action.run();
        this.m_result = action.getResult();
        this.m_searchType = GLOBAL_SEARCH;
        this.refreshResultSection();
    }

    private void startAdvancedSearch() {
        List<String> props = new LinkedList<String>();
        props.add(this.getPolicyTypes());
        props = this.addProperties(POL, this.m_mainPropsFields, props);
        props = this.addProperties(COND, this.m_condPropsFields, props);
        String[] properties = props.toArray(new String[0]);
        SearchPolicyAction action = new SearchPolicyAction(properties);
        action.run();
        this.m_result = action.getResult();
        this.m_searchType = ADVANCED_SEARCH;
        this.refreshResultSection();
    }

    private List<String> addProperties(String type, HashMap<Object, String> properties, List<String> props) {
        StringBuffer sb = new StringBuffer();
        if (type.equals(POL) && this.m_searchAllMainProps_rBtn.getSelection()) {
            String searchText = this.m_searchAllMainProps_field.getText().trim();
            if (searchText.length() > 0) {
                sb = new StringBuffer();
                sb.append(POL).append('\u25ba').append(ANY_ATTRIBUTES).append('\u25ba').append(searchText);
                props.add(sb.toString());
            }
        } else if (type.endsWith(COND) && this.m_searchAllCondProps_rBtn.getSelection()) {
            String searchText = this.m_searchAllCond_field.getText().trim();
            if (searchText.length() > 0) {
                sb = new StringBuffer();
                sb.append(COND).append('\u25ba').append(ANY_ATTRIBUTES).append('\u25ba').append(searchText);
                props.add(sb.toString());
            }
        } else {
            for (Object o : properties.keySet()) {
                Object combo;
                String searchText = "";
                String fieldName = "";
                if (o instanceof Text) {
                    Text field = (Text)o;
                    fieldName = properties.get(field);
                    if (field == null || field.isDisposed()) continue;
                    searchText = field.getText().trim();
                } else if (o instanceof CCombo) {
                    combo = (CCombo)o;
                    fieldName = properties.get(combo);
                    if (combo == null || combo.isDisposed()) continue;
                    searchText = combo.getText();
                } else if (o instanceof ImageCombo) {
                    combo = (ImageCombo)((Object)o);
                    fieldName = properties.get(combo);
                    if (combo == null || combo.isDisposed()) continue;
                    searchText = ((ImageCombo)((Object)combo)).getText();
                }
                if (searchText.length() <= 0 || fieldName.length() <= 0) continue;
                sb = new StringBuffer();
                sb.append(type).append('\u25ba').append(fieldName).append('\u25ba').append(searchText);
                props.add(sb.toString());
            }
        }
        return props;
    }

    private void clearAdvancedSearch() {
        this.clearFields(this.m_mainPropsFields);
        this.clearFields(this.m_condPropsFields);
        this.m_gui.enableField(this.m_advancedSearch_btn, false);
        this.m_gui.enableField(this.m_clearSearch_btn, false);
    }

    private void clearFields(HashMap<Object, String> fields) {
        for (Object o : fields.keySet()) {
            Object combo;
            if (o instanceof Text) {
                Text field = (Text)o;
                if (field == null || field.isDisposed()) continue;
                field.setText("");
                continue;
            }
            if (o instanceof CCombo) {
                combo = (CCombo)o;
                if (combo == null || combo.isDisposed()) continue;
                combo.select(0);
                continue;
            }
            if (!(o instanceof ImageCombo) || (combo = (ImageCombo)((Object)o)) == null || combo.isDisposed()) continue;
            ((ImageCombo)((Object)combo)).select(0);
        }
    }

    private void initSearchFields() {
        this.m_mainPropsFields = new HashMap();
        this.m_mainPropsFields.put(this.m_polName_field, POL_NAME_FIELD);
        this.m_condPropsFields = new HashMap();
        this.m_condPropsFields.put(this.m_condID_field, COND_ID_FIELD);
    }

    private void setFieldData() {
        this.setData(this.m_mainPropsFields);
        this.setData(this.m_condPropsFields);
    }

    public void setData(HashMap<Object, String> fields) {
        for (Object o : fields.keySet()) {
            Object combo;
            if (o instanceof Text) {
                Text field = (Text)o;
                if (field == null || field.isDisposed()) continue;
                field.setData((Object)fields.get(field));
                continue;
            }
            if (o instanceof CCombo) {
                combo = (CCombo)o;
                if (combo == null || combo.isDisposed()) continue;
                combo.setData((Object)fields.get(combo));
                continue;
            }
            if (!(o instanceof ImageCombo) || (combo = (ImageCombo)((Object)o)) == null || combo.isDisposed()) continue;
            combo.setData((Object)fields.get(combo));
        }
    }

    public String getPolicyTypes() {
        StringBuffer types = new StringBuffer();
        int sel = this.m_polTypes_imgCbo.getSelectionIndex();
        switch (sel) {
            case 0: {
                types.append(BMUI.type_mon).append('\u25ba').append(BMUI.type_msg);
                break;
            }
            case 1: {
                types.append(BMUI.type_mon);
                break;
            }
            case 2: {
                types.append(BMUI.type_msg);
            }
        }
        return types.toString();
    }

    public void checkButtonStatus(String type) {
        block9: {
            boolean isEmpty;
            block12: {
                Object combo;
                Text field;
                block13: {
                    block11: {
                        block10: {
                            block8: {
                                if (!GLOBAL_SEARCH.equals(type)) break block8;
                                if ("".equals(this.m_gloablSearch_field.getText().trim())) {
                                    this.m_gui.enableField(this.m_globalSearch_btn, false);
                                } else {
                                    this.m_gui.enableField(this.m_globalSearch_btn, true);
                                }
                                break block9;
                            }
                            if (!ADVANCED_SEARCH.equals(type)) break block9;
                            isEmpty = true;
                            if (!this.m_searchAllMainProps_rBtn.getSelection()) break block10;
                            if (this.m_searchAllMainProps_field.getText().trim().length() <= 0) break block11;
                            isEmpty = false;
                            break block11;
                        }
                        for (Object o : this.m_mainPropsFields.keySet()) {
                            if (o instanceof Text) {
                                field = (Text)o;
                                if (field == null || field.isDisposed() || field.getText().trim().length() <= 0) continue;
                                isEmpty = false;
                                break;
                            }
                            if (o instanceof CCombo) {
                                combo = (CCombo)o;
                                if (combo == null || combo.isDisposed() || combo.getSelectionIndex() <= 0) continue;
                                isEmpty = false;
                                break;
                            }
                            if (!(o instanceof ImageCombo) || (combo = (ImageCombo)((Object)o)) == null || combo.isDisposed() || ((ImageCombo)((Object)combo)).getSelectionIndex() <= 0) continue;
                            isEmpty = false;
                            break;
                        }
                    }
                    if (!isEmpty) break block12;
                    if (!this.m_searchAllCondProps_rBtn.getSelection()) break block13;
                    if (this.m_searchAllCond_field.getText().trim().length() <= 0) break block12;
                    isEmpty = false;
                    break block12;
                }
                for (Object o : this.m_condPropsFields.keySet()) {
                    if (o instanceof Text) {
                        field = (Text)o;
                        if (field == null || field.isDisposed() || field.getText().trim().length() <= 0) continue;
                        isEmpty = false;
                        break;
                    }
                    if (o instanceof CCombo) {
                        combo = (CCombo)o;
                        if (combo == null || combo.isDisposed() || combo.getSelectionIndex() <= 0) continue;
                        isEmpty = false;
                        break;
                    }
                    if (!(o instanceof ImageCombo) || (combo = (ImageCombo)((Object)o)) == null || combo.isDisposed() || ((ImageCombo)((Object)combo)).getSelectionIndex() <= 0) continue;
                    isEmpty = false;
                    break;
                }
            }
            this.m_gui.enableField(this.m_advancedSearch_btn, !isEmpty);
            this.m_gui.enableField(this.m_clearSearch_btn, !isEmpty);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (!(e.getSource() instanceof Table)) {
            CCombo cbo;
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                name = (String)b.getData();
                if (name.equals(SEARCH_POLNAME_RBTN)) {
                    this.m_gui.enableField(this.m_polName_field, this.m_searchPolName_rBtn.getSelection());
                    this.m_gui.enableField(this.m_searchAllMainProps_field, !this.m_searchPolName_rBtn.getSelection());
                    this.checkButtonStatus(ADVANCED_SEARCH);
                } else if (name.equals(SEARCH_ALL_MAINPROPS_RBTN)) {
                    this.m_gui.enableField(this.m_polName_field, !this.m_searchAllMainProps_rBtn.getSelection());
                    this.m_gui.enableField(this.m_searchAllMainProps_field, this.m_searchAllMainProps_rBtn.getSelection());
                    this.checkButtonStatus(ADVANCED_SEARCH);
                } else if (name.equals(SEARCH_COND_ID_RBTN)) {
                    this.m_gui.enableField(this.m_condID_field, this.m_searchCondID_rBtn.getSelection());
                    this.m_gui.enableField(this.m_searchAllCond_field, !this.m_searchCondID_rBtn.getSelection());
                    this.checkButtonStatus(ADVANCED_SEARCH);
                } else if (name.equals(SEARCH_ALL_CONDPROPS_RBTN)) {
                    this.m_gui.enableField(this.m_condID_field, !this.m_searchAllCondProps_rBtn.getSelection());
                    this.m_gui.enableField(this.m_searchAllCond_field, this.m_searchAllCondProps_rBtn.getSelection());
                    this.checkButtonStatus(ADVANCED_SEARCH);
                } else if (name.equals(START_GLOBAL_SEARCH_BTN)) {
                    this.startGloabalSearch();
                } else if (name.equals(START_ADVANCED_SEARCH_BTN)) {
                    this.startAdvancedSearch();
                } else if (name.equals(CLEAR_SEARCH_BTN)) {
                    this.clearAdvancedSearch();
                }
            } else if (e.getSource() instanceof CCombo && (name = (String)(cbo = (CCombo)e.getSource()).getData()).equals(POLICY_TYPES)) {
                return;
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.m_pView.getTabList().containsKey(TAB_NAME)) {
            this.m_pView.getTabList().remove(TAB_NAME);
        }
        try {
            this.getControl().dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
        OpenPolicyAction openPolicyAction = new OpenPolicyAction(this.m_tableViewer, false);
        openPolicyAction.run();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source instanceof Text) {
            Text field = (Text)source;
            String name = (String)field.getData();
            if (name != null && name.equals(GLOBAL_SEARCH_FIELD)) {
                this.checkButtonStatus(GLOBAL_SEARCH);
            } else {
                this.checkButtonStatus(ADVANCED_SEARCH);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object o;
        if ((e.character == '\r' || e.keyCode == 13 || e.keyCode == 0x1000050) && (o = e.getSource()) instanceof Text) {
            Text field = (Text)o;
            String name = (String)field.getData();
            if (name != null && name.equals(GLOBAL_SEARCH_FIELD)) {
                this.startGloabalSearch();
            } else {
                this.startAdvancedSearch();
            }
        }
    }
}

