/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.SaveDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyOverviewTab;
import com.blixx.boom.gui.views.PolicySearchTab;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.DeletePolicyAction;
import com.blixx.boom.gui.views.actions.DupliactePolicyAction;
import com.blixx.boom.gui.views.actions.PolicyRenamingAction;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.SearchPolicyAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ShowMessagesForSource;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.BM;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class PolicyView
extends ViewPart
implements Listener,
MenuListener,
CTabFolder2Listener,
SelectionListener {
    public static final int VIEW_ID = 1001;
    public static final String ID = "com.blixx.boom.gui.views.policyview";
    private static PolicyView m_instance = null;
    public static Map<String, CTabItem> tabList = new HashMap<String, CTabItem>();
    public static CTabFolder folder = null;
    public static PolicyOverviewTab m_policyOverviewTab = null;
    public Composite parent = null;
    public static String POLICY_TYPE = "policy_type";
    public static String DIRTY_STATUS = "dirty_Status";
    public static final String CLOSE_ALL = "CLOSE_ALL";
    public static final String CLOSE_OTHERS = "CLOSE_OTHERS";
    public static final String CLOSE = "CLOSE";
    public static String YES = "YES";
    public static String NO = "NO";
    public static String CANCEL = "CANCEL";
    public static String DUPLICATE_POLICY = "Duplicate Policy";
    public static String COPY_RENAME_POLICY = "Copy and Rename Policy";
    public static String DELETE_POLICY = "Delete Policy";
    public static String SELECT_IN_TREE = "Select Policy in Tree";
    public static String SHOW_RELATED_INFORMATION = "Related Information";
    public static String SHOW_INDICATIONS = "Show Indications";
    public static String SEARCH_POLICY = "Search Policy";
    public static String DEPLOY_ON = "Deploy on ...";
    public static String REDEPLOY_TO_ALL = "Re-Deploy to all";
    public static String UNDEPLOY_FROM = "UnDeploy from ...";
    public static String UNDEPLOY_FROM_ALL = "UnDeploy from all";
    public static String MARK_AS_DEPLOYED_ON = "Mark as Deployed on ...";
    public static String ENQUEUE_DEPLOY_ON = "Enqueue Deployment on ...";
    public static String ENQUEUE_REDEPLOY_TO_ALL = "Enqueue Re-Deployment to all";
    public static String ENQUEUE_UNDEPLOY_FROM = "Enqueue UnDeployment from ...";
    public static String ENQUEUE_UNDEPLOY_FROM_ALL = "Enqueue UnDeployment from all";
    private static Map<String, String> m_actionTypMap = new HashMap<String, String>();

    static {
        m_actionTypMap.put(DEPLOY_ON, "DEPLOY");
        m_actionTypMap.put(REDEPLOY_TO_ALL, "DEPLOY");
        m_actionTypMap.put(UNDEPLOY_FROM, "UNDEPLOY");
        m_actionTypMap.put(UNDEPLOY_FROM_ALL, "UNDEPLOY");
        m_actionTypMap.put(MARK_AS_DEPLOYED_ON, "DEPLOY_VIRTUAL");
        m_actionTypMap.put(ENQUEUE_DEPLOY_ON, "DEPLOY_DELAYED");
        m_actionTypMap.put(ENQUEUE_REDEPLOY_TO_ALL, "DEPLOY_DELAYED");
        m_actionTypMap.put(ENQUEUE_UNDEPLOY_FROM, "UNDEPLOY_DELAYED");
        m_actionTypMap.put(ENQUEUE_UNDEPLOY_FROM_ALL, "UNDEPLOY_DELAYED");
    }

    public PolicyView() {
        m_instance = this;
    }

    public static PolicyView getInstance() {
        return m_instance;
    }

    public CTabFolder getFolder() {
        return folder;
    }

    public Map<String, CTabItem> getTabList() {
        return tabList;
    }

    public static void activate() {
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)PolicyView.getInstance());
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1001) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    PolicyView.this.getSite().getPage().hideView(PolicyView.this.getSite().getPage().findView(PolicyView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.policyview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PolicyView.this.getSite().getPage().hideView(PolicyView.this.getSite().getPage().findView(PolicyView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        PolicyView.m_instance.parent = parent;
        PolicyView.createFolder();
        this.setTitleImage(BMUI.IMAGE_NAG);
    }

    public static void createFolder() {
        folder = new CTabFolder(PolicyView.m_instance.parent, 2816);
        folder.setSimple(false);
        folder.setMinimizeVisible(false);
        folder.setMaximizeVisible(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        folder.addCTabFolder2Listener((CTabFolder2Listener)m_instance);
        folder.addSelectionListener((SelectionListener)m_instance);
        folder.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = folder.getDisplay().map(null, (Control)folder, new Point(event.x, event.y));
                CTabItem newSelectedTab = folder.getItem(point);
                PolicyView.restoreOpened(newSelectedTab);
            }
        });
        PolicyView.createContentMenu();
        m_policyOverviewTab = new PolicyOverviewTab(folder);
        folder.setSelection((CTabItem)m_policyOverviewTab);
    }

    public static void createContentMenu() {
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        Menu menu = new Menu((Control)folder);
        menu.addMenuListener((MenuListener)m_instance);
        MenuItem mi = new MenuItem(menu, -1);
        mi.setText(DEPLOY_ON);
        mi.setData((Object)DEPLOY_ON);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(REDEPLOY_TO_ALL);
        mi.setData((Object)REDEPLOY_TO_ALL);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(UNDEPLOY_FROM);
        mi.setData((Object)UNDEPLOY_FROM);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(UNDEPLOY_FROM_ALL);
        mi.setData((Object)UNDEPLOY_FROM_ALL);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(MARK_AS_DEPLOYED_ON);
        mi.setData((Object)MARK_AS_DEPLOYED_ON);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText(ENQUEUE_DEPLOY_ON);
        mi.setData((Object)ENQUEUE_DEPLOY_ON);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(ENQUEUE_REDEPLOY_TO_ALL);
        mi.setData((Object)ENQUEUE_REDEPLOY_TO_ALL);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(ENQUEUE_UNDEPLOY_FROM);
        mi.setData((Object)ENQUEUE_UNDEPLOY_FROM);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(ENQUEUE_UNDEPLOY_FROM_ALL);
        mi.setData((Object)ENQUEUE_UNDEPLOY_FROM_ALL);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setImage(sharedImages.getImage("IMG_TOOL_COPY"));
        mi.setText(DUPLICATE_POLICY);
        mi.setData((Object)DUPLICATE_POLICY);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setImage(sharedImages.getImage("IMG_TOOL_COPY"));
        mi.setText(COPY_RENAME_POLICY);
        mi.setData((Object)COPY_RENAME_POLICY);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        mi.setText(DELETE_POLICY);
        mi.setData((Object)DELETE_POLICY);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText(SELECT_IN_TREE);
        mi.setData((Object)SELECT_IN_TREE);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(SHOW_RELATED_INFORMATION);
        mi.setData((Object)SHOW_RELATED_INFORMATION);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setImage(BMUI.IMAGE_INDICATIONS);
        mi.setText(SHOW_INDICATIONS);
        mi.setData((Object)SHOW_INDICATIONS);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(SEARCH_POLICY);
        mi.setImage(BMUI.IMAGE_SEARCH);
        mi.setData((Object)SEARCH_POLICY);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText("Close");
        mi.setData((Object)CLOSE);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText("Close Others");
        mi.setData((Object)CLOSE_OTHERS);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText("Close All");
        mi.setData((Object)CLOSE_ALL);
        mi.addListener(13, (Listener)m_instance);
        folder.setMenu(menu);
    }

    public static void displayPolicySearch() {
        PolicySearchTab polSearchTab = null;
        PolicyView.activate();
        if (tabList.containsKey(PolicySearchTab.TAB_NAME)) {
            polSearchTab = (PolicySearchTab)tabList.get(PolicySearchTab.TAB_NAME);
            if (polSearchTab.isDisposed()) {
                tabList.remove(PolicySearchTab.TAB_NAME);
                polSearchTab = new PolicySearchTab(folder);
                tabList.put(PolicySearchTab.TAB_NAME, polSearchTab);
            } else if (polSearchTab.getControl().isDisposed()) {
                polSearchTab.dispose();
                tabList.remove(PolicySearchTab.TAB_NAME);
                polSearchTab = new PolicySearchTab(folder);
                tabList.put(PolicySearchTab.TAB_NAME, polSearchTab);
            } else {
                polSearchTab.getControl().setVisible(true);
            }
        } else {
            polSearchTab = new PolicySearchTab(folder);
            tabList.put(PolicySearchTab.TAB_NAME, polSearchTab);
        }
        folder.setSelection((CTabItem)polSearchTab);
    }

    public static void displayPolicy(GroupTreeObjectLast pTreeObj, TreeViewer treeViewer) {
        PolicyView.displayPolicyEXT(pTreeObj.getName(), pTreeObj.getType(), null, null, treeViewer, null);
    }

    public static CTabItem displayPolicy(String name, String type, String treePath, String selectedCondUUID) {
        CTabItem cTabItem = null;
        cTabItem = tabList.containsKey(name) || name.equals(PolicyOverviewTab.TAB_NAME) || name.equals(PolicySearchTab.TAB_NAME) ? PolicyView.restoreOpened(name, selectedCondUUID) : PolicyView.displayPolicyEXT(name, type, null, selectedCondUUID, null, null);
        return cTabItem;
    }

    private static CTabItem openMonPolicyTab(String parentTreePath, String selectedCondUUID, TreeViewer treeViewer, Policy p, boolean isNew) {
        MonitorPolicyTab cTabItem = new MonitorPolicyTab(folder, 64, folder.getItemCount(), treeViewer, p, parentTreePath, selectedCondUUID, isNew);
        tabList.put(p.getName(), cTabItem);
        return cTabItem;
    }

    private static CTabItem openMsgPolicyTab(String parentTreePath, String selectedCondUUID, TreeViewer treeViewer, MsgPolicy mp, boolean isNew) {
        FilterPolicyTab cTabItem = new FilterPolicyTab(folder, 64, folder.getItemCount(), treeViewer, mp, parentTreePath, selectedCondUUID, isNew);
        tabList.put(mp.getName(), cTabItem);
        return cTabItem;
    }

    public static void checkPowerGroups(AbstractPolicy p, AbstractPolicyTab<? extends AbstractPolicy> cTabItem) {
        String type = BMUI.type_mon;
        if (p instanceof MsgPolicy) {
            type = BMUI.type_msg;
        }
        GroupTreeObjectLast policyGTO = PolicyManager.getInstance().getPolicyTree().findElement(p.getName(), type);
        cTabItem.setReadOnlyFlag(!PolicyManager.getInstance().isPermittedPolicyModify(policyGTO));
    }

    public static CTabItem displayPolicy(AbstractPolicy pol, String type) {
        String polName = pol.getName();
        if (PolicyView.isTabOpen(polName)) {
            PolicyView.closeTab(pol.getName());
        }
        PolicyView.activate();
        CTabItem cTabItem = null;
        if (type.equals(BMUI.type_msg)) {
            MsgPolicy mp = (MsgPolicy)pol;
            cTabItem = PolicyView.openMsgPolicyTab("", null, null, mp, false);
        } else if (type.equals(BMUI.type_mon)) {
            Policy p = (Policy)pol;
            cTabItem = PolicyView.openMonPolicyTab("", null, null, p, false);
        }
        folder.setSelection(cTabItem);
        PolicyView.hideAllOther(cTabItem);
        return cTabItem;
    }

    public static CTabItem displayPolicyEXT(String name, String type, String slaveServer, String selectedCondUUID, TreeViewer treeViewer, SEvent sEvent) {
        CTabItem cTabItem = null;
        PolicyListView instance = PolicyListView.getInstance();
        if (instance == null) {
            return cTabItem;
        }
        if (type.length() > 3) {
            type = type.substring(0, 3);
        }
        if (treeViewer == null) {
            treeViewer = instance.m_treeViewer;
        }
        String expectedName = "(" + slaveServer + ") " + name;
        if (slaveServer == null) {
            expectedName = name;
        }
        if (tabList.containsKey(expectedName)) {
            if (sEvent != null && type.equals(BMUI.type_msg)) {
                cTabItem = tabList.get(expectedName);
                if (cTabItem != null) {
                    MsgPolicy mp = ((FilterPolicyTab)cTabItem).getPolicy();
                    selectedCondUUID = PolicyView.addMsgCondition(mp, sEvent);
                    PolicyView.restoreOpened(expectedName, selectedCondUUID);
                } else {
                    cTabItem = PolicyView.restoreOpened(expectedName, selectedCondUUID);
                }
                PolicyView.activate();
                ((FilterPolicyTab)cTabItem).setDirty(true);
            } else {
                PolicyView.activate();
                cTabItem = PolicyView.restoreOpened(expectedName, selectedCondUUID);
            }
        } else {
            PolicyManager pm = PolicyManager.getInstance();
            if (!pm.isPermittedPolicyRead(name, type)) {
                new ShowMessageBox("Not permitted", "Insufficient rights to open the policy! ", 8);
                return cTabItem;
            }
            File fileP = null;
            if (slaveServer != null) {
                ServerClient sc = ServerClient.getFileSlave(new String[]{name, type, slaveServer, String.valueOf(Repository.getUserPoliciesDirectory()) + "slaves" + File.separator + slaveServer + File.separator});
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    fileP = (File)sc.getResultObject();
                }
            } else {
                fileP = Repository.getInstance().fetchFile(name, type);
            }
            if (fileP == null) {
                if (slaveServer != null) {
                    new ShowMessageBox("Warning.", "Please check policy on the slave server: " + slaveServer, 8);
                    return cTabItem;
                }
                new ShowMessageBox("Sync error.", "Policy not found on the server: " + name, 1);
                return cTabItem;
            }
            PolicyView.activate();
            if (type.equals(BMUI.type_msg)) {
                MsgPolicy mp = pm.getMessagePolicy(fileP);
                if (mp == null) {
                    new ShowMessageBox("Indication Policy", "The Policy is not available on the Server! ", 8);
                    return cTabItem;
                }
                if (slaveServer != null) {
                    cTabItem = new FilterPolicyTab(slaveServer, folder, 64, folder.getItemCount(), treeViewer, mp, "", selectedCondUUID, false);
                    tabList.put(cTabItem.getText(), cTabItem);
                } else {
                    if (sEvent != null) {
                        selectedCondUUID = PolicyView.addMsgCondition(mp, sEvent);
                    }
                    cTabItem = PolicyView.openMsgPolicyTab("", selectedCondUUID, treeViewer, mp, false);
                    if (sEvent != null) {
                        ((FilterPolicyTab)cTabItem).setDirty(true);
                    }
                }
            } else if (type.equals(BMUI.type_mon)) {
                Policy p = pm.getMonitorPolicy(fileP);
                if (p == null) {
                    new ShowMessageBox("Monitor Policy", "The Policy is not available on the Server! ", 8);
                    return cTabItem;
                }
                if (slaveServer != null) {
                    cTabItem = new MonitorPolicyTab(slaveServer, folder, 64, folder.getItemCount(), treeViewer, p, "", selectedCondUUID, false);
                    tabList.put(cTabItem.getText(), cTabItem);
                } else {
                    cTabItem = PolicyView.openMonPolicyTab("", selectedCondUUID, treeViewer, p, false);
                }
            }
        }
        folder.setSelection(cTabItem);
        PolicyView.hideAllOther(cTabItem);
        return cTabItem;
    }

    public static void displayPolicyEXT(SEvent m_se) {
        String source = m_se.getSource();
        String type = null;
        String name = null;
        String selectedCondUUID = null;
        if (source.startsWith("Message:")) {
            type = BMUI.type_msg;
        } else if (source.startsWith("Monitor:")) {
            type = BMUI.type_mon;
        } else {
            RTLogger.print(1, "Error displaying policy because of unknown policy type source=" + source);
            new ShowMessageBox("Error", "Error getting policy from the server", 1);
            return;
        }
        String[] arr = source.split("\\Q:\\E");
        name = arr[1];
        if (arr.length == 3) {
            selectedCondUUID = arr[2];
        }
        String tempSlaveServer = null;
        String slaveServer = null;
        if (m_se instanceof SEventFwd) {
            AgentCard aac;
            SEventFwd sef = (SEventFwd)m_se;
            if (sef.getSrv() != null && !sef.getSrv().equals("")) {
                slaveServer = !sef.getSrvtype().equals(BM.PRODUCT_lowercase) ? sef.getSrvtype() : sef.getSrv();
            }
            if (slaveServer != null && (aac = Repository.getInstance().getAgentCard(sef.getT1())) != null && (aac.getOSName().contains("(BS:1") || aac.getOSName().contains("(BS:2"))) {
                tempSlaveServer = slaveServer;
                slaveServer = null;
            }
        }
        if (type != null && name != null && PolicyListView.getInstance() != null) {
            CTabItem ctab = PolicyView.displayPolicyEXT(name, type, slaveServer, selectedCondUUID, null, null);
            if (ctab != null) {
                PolicyTreeProvider.getInstance().setTreeSelection(name, type);
            } else if (slaveServer == null && tempSlaveServer != null && (ctab = PolicyView.displayPolicyEXT(name, type, tempSlaveServer, selectedCondUUID, null, null)) != null) {
                PolicyTreeProvider.getInstance().setTreeSelection(name, type);
            }
        }
    }

    public static void hideAllOther(CTabItem cTabItem) {
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            if (!(item instanceof PolicyOverviewTab || item instanceof PolicySearchTab || item.equals(cTabItem) || item.getControl() == null)) {
                item.getControl().dispose();
            }
            ++i;
        }
    }

    private static void restoreOpened(CTabItem newSelectedTab) {
        if (newSelectedTab == null) {
            return;
        }
        CTabItem activeTab = folder.getSelection();
        if (!newSelectedTab.equals(activeTab)) {
            int i = 0;
            while (i < folder.getItemCount()) {
                CTabItem tab = folder.getItem(i);
                if (tab != null && tab.equals(newSelectedTab)) {
                    if (tab instanceof MonitorPolicyTab) {
                        ((MonitorPolicyTab)tab).internalRestore(null);
                        ((MonitorPolicyTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof FilterPolicyTab) {
                        ((FilterPolicyTab)tab).internalRestore(null);
                        ((FilterPolicyTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof PolicyOverviewTab) {
                        ((PolicyOverviewTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof PolicySearchTab) {
                        if (((PolicySearchTab)tab).getControl().isDisposed()) {
                            SearchPolicyAction searchPolicy = new SearchPolicyAction();
                            searchPolicy.run();
                        } else {
                            ((PolicySearchTab)tab).getControl().setVisible(true);
                        }
                    }
                    folder.setSelection(tab);
                    break;
                }
                ++i;
            }
            PolicyView.hideAllOther(newSelectedTab);
        }
    }

    private static CTabItem restoreOpened(String name, String selectedCondUUID) {
        CTabItem activeTab;
        CTabItem newSelectedTab = tabList.get(name);
        if (newSelectedTab == null) {
            newSelectedTab = folder.getItem(0);
        }
        if (!newSelectedTab.equals(activeTab = folder.getSelection())) {
            int i = 0;
            while (i < folder.getItemCount()) {
                CTabItem tab = folder.getItem(i);
                if (tab != null && tab.equals(newSelectedTab)) {
                    if (tab instanceof MonitorPolicyTab) {
                        ((MonitorPolicyTab)tab).internalRestore(null);
                        ((MonitorPolicyTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof FilterPolicyTab) {
                        ((FilterPolicyTab)tab).internalRestore(null);
                        ((FilterPolicyTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof PolicyOverviewTab) {
                        ((PolicyOverviewTab)tab).getControl().setVisible(true);
                    } else if (tab instanceof PolicySearchTab) {
                        if (((PolicySearchTab)tab).getControl().isDisposed()) {
                            SearchPolicyAction searchPolicy = new SearchPolicyAction();
                            searchPolicy.run();
                        } else {
                            ((PolicySearchTab)tab).getControl().setVisible(true);
                        }
                    }
                    folder.setSelection(tab);
                    break;
                }
                ++i;
            }
            PolicyView.hideAllOther(newSelectedTab);
        } else if (activeTab instanceof MonitorPolicyTab) {
            MonitorPolicyTab tab = (MonitorPolicyTab)activeTab;
            tab.setConditionListSelection(selectedCondUUID);
        } else if (activeTab instanceof FilterPolicyTab) {
            FilterPolicyTab tab = (FilterPolicyTab)activeTab;
            tab.setConditionListSelection(selectedCondUUID);
        }
        return newSelectedTab;
    }

    public static void showNewPolicyTab(Object policy, TreeViewer treeViewer, GroupTreeObjectLast gtol, boolean forceSetSelection) {
        CTabItem cTabItem = null;
        PolicyView.activate();
        if (policy instanceof MsgPolicy) {
            MsgPolicy mp = (MsgPolicy)policy;
            mp.setVersion("1.0");
            cTabItem = PolicyView.openMsgPolicyTab(gtol.getParentPath(), null, treeViewer, mp, true);
        } else if (policy instanceof Policy) {
            Policy p = (Policy)policy;
            p.setVersion("1.0");
            cTabItem = PolicyView.openMonPolicyTab(gtol.getParentPath(), null, treeViewer, p, true);
        }
        if (forceSetSelection) {
            folder.setSelection(cTabItem);
            PolicyView.hideAllOther(cTabItem);
        } else {
            cTabItem.getControl().dispose();
        }
    }

    public static CTabItem getTab(String name) {
        return tabList.get(name);
    }

    public static boolean isTabOpen(String name) {
        boolean b = false;
        if (tabList.get(name) != null) {
            b = true;
        }
        return b;
    }

    public static boolean isTabActiv(CTabItem tab) {
        boolean b = false;
        CTabItem activeTab = folder.getSelection();
        if (tab.getText().equals(activeTab.getText())) {
            b = true;
        }
        return b;
    }

    public static void closeTab(String name) {
        String newName = name;
        if (name.startsWith("*")) {
            newName = name.substring(2);
        }
        if (tabList.containsKey(newName)) {
            CTabItem cTabItem = tabList.get(newName);
            cTabItem.dispose();
            tabList.remove(newName);
        }
    }

    public void closeOpenTabs() {
        for (String tabName : tabList.keySet()) {
            CTabItem cTabItem = tabList.get(tabName);
            try {
                cTabItem.dispose();
                tabList.remove(tabName);
            }
            catch (Exception exception) {}
        }
    }

    public static void reOpenTab(String oldName, String newName, String type, String treePath, String selectedCondCTab) {
        if (newName == null) {
            newName = oldName;
        }
        if (tabList.get(oldName) != null) {
            PolicyView.closeTab(oldName);
            CTabItem cTab = PolicyView.displayPolicy(newName, type, treePath, null);
            if (selectedCondCTab != null) {
                if (cTab instanceof FilterPolicyTab) {
                    ((FilterPolicyTab)cTab).setCondViewSelection(selectedCondCTab);
                } else if (cTab instanceof MonitorPolicyTab) {
                    ((MonitorPolicyTab)cTab).setCondViewSelection(selectedCondCTab);
                }
            }
        }
    }

    public static String addMsgCondition(MsgPolicy mp, SEvent sEvent) {
        MsgCondition newCond;
        MsgCondition condition;
        String condID = null;
        String condID_matched = null;
        String[] arr = sEvent.getSource().split(":");
        if (arr != null && arr.length == 3 && (condID_matched = arr[2]) != null && condID_matched.length() > 0 && (condition = (MsgCondition)mp.getConditions().getCondition(condID_matched)) != null && (newCond = condition.clone()) != null) {
            String msgText = sEvent.getText();
            newCond.setDescription(msgText.length() > 50 ? msgText.substring(0, 49) : msgText);
            newCond.setTextFilter(msgText);
            mp.getConditions().addCondition(newCond);
            condID = newCond.getConditionId();
        }
        if (condID == null) {
            MsgCondition newCond2 = mp.getConditions().addNewCondition();
            newCond2.setApplicationFilter(sEvent.getApplication());
            newCond2.setNodeFilter("<*>");
            newCond2.setObjectFilter(sEvent.getObject());
            newCond2.setGroupFilter(sEvent.getGroup());
            newCond2.setTextFilter(sEvent.getText());
            condID = newCond2.getConditionId();
        }
        return condID;
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
    }

    public void handleEvent(Event event) {
        boolean dirtyStatus = false;
        String menuAction = (String)event.widget.getData();
        CTabItem selectedTab = folder.getSelection();
        if (menuAction.equals(CLOSE)) {
            if (((Boolean)selectedTab.getData(DIRTY_STATUS)).booleanValue()) {
                this.openSaveDialogMulitple_BATCH(CLOSE);
            } else {
                this.runContentMenuAction(CLOSE);
            }
        } else if (menuAction.equals(CLOSE_OTHERS)) {
            CTabItem[] cTabs = folder.getItems();
            int index = 0;
            while (index < cTabs.length) {
                CTabItem tab = cTabs[index];
                if (!selectedTab.equals(tab) && !(tab instanceof PolicyOverviewTab) && ((Boolean)tab.getData(DIRTY_STATUS)).booleanValue()) {
                    dirtyStatus = true;
                    break;
                }
                ++index;
            }
            if (dirtyStatus) {
                this.openSaveDialogMulitple_BATCH(CLOSE_OTHERS);
            } else {
                this.runContentMenuAction(CLOSE_OTHERS);
            }
        } else if (menuAction.equals(CLOSE_ALL)) {
            CTabItem[] cTabs = folder.getItems();
            int i = 0;
            while (i < cTabs.length) {
                if (!(cTabs[i] instanceof PolicyOverviewTab) && ((Boolean)cTabs[i].getData(DIRTY_STATUS)).booleanValue()) {
                    dirtyStatus = true;
                    break;
                }
                ++i;
            }
            if (dirtyStatus) {
                this.openSaveDialogMulitple_BATCH(CLOSE_ALL);
            } else {
                this.runContentMenuAction(CLOSE_ALL);
            }
        } else if (menuAction.equals(SHOW_RELATED_INFORMATION)) {
            AbstractPolicyTab tab;
            GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
            GroupTreeObjectLast gtoLast = null;
            if (selectedTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)selectedTab;
                gtoLast = root.findElement(((FilterPolicyTab)tab).getPolicy().getName(), BMUI.type_msg);
            } else if (selectedTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)selectedTab;
                gtoLast = root.findElement(((MonitorPolicyTab)tab).getPolicy().getName(), BMUI.type_mon);
            }
            if (gtoLast == null || gtoLast instanceof GroupTreeObjectUnsubmitted) {
                return;
            }
            StructuredSelection ssel = new StructuredSelection((Object)gtoLast);
            ShowRelatedPolicyInfosAction action = new ShowRelatedPolicyInfosAction(ssel, this.parent.getShell());
            action.run();
        } else if (menuAction.equals(SHOW_INDICATIONS)) {
            AbstractPolicyTab tab;
            GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
            GroupTreeObjectLast gtol = null;
            if (selectedTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)selectedTab;
                gtol = root.findElement(((FilterPolicyTab)tab).getPolicy().getName(), BMUI.type_msg);
            } else if (selectedTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)selectedTab;
                gtol = root.findElement(((MonitorPolicyTab)tab).getPolicy().getName(), BMUI.type_mon);
            }
            if (gtol == null || gtol instanceof GroupTreeObjectUnsubmitted) {
                return;
            }
            ShowMessagesForSource action = new ShowMessagesForSource(gtol);
            action.run();
        } else if (menuAction.equals(SEARCH_POLICY)) {
            SearchPolicyAction action = new SearchPolicyAction();
            action.run();
        } else if (menuAction.equals(SELECT_IN_TREE)) {
            String pName = null;
            String pType = null;
            if (selectedTab instanceof FilterPolicyTab) {
                pName = ((FilterPolicyTab)selectedTab).getPolicy().getName();
                pType = BMUI.type_msg;
            } else if (selectedTab instanceof MonitorPolicyTab) {
                pName = ((MonitorPolicyTab)selectedTab).getPolicy().getName();
                pType = BMUI.type_mon;
            }
            if (pName == null || pName.isEmpty() || pType == null | pType.isEmpty()) {
                return;
            }
            SelectPolicyInTreeAction action = new SelectPolicyInTreeAction(pName, pType);
            action.run();
        } else if (menuAction.equals(DUPLICATE_POLICY)) {
            String pName = null;
            String pType = null;
            if (selectedTab instanceof FilterPolicyTab) {
                pName = ((FilterPolicyTab)selectedTab).getPolicy().getName();
                pType = BMUI.type_msg;
            } else if (selectedTab instanceof MonitorPolicyTab) {
                pName = ((MonitorPolicyTab)selectedTab).getPolicy().getName();
                pType = BMUI.type_mon;
            }
            if (pName == null || pName.isEmpty() || pType == null | pType.isEmpty()) {
                return;
            }
            GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
            GroupTreeObjectLast gtoLast = root.findElement(pName, pType);
            if (gtoLast != null) {
                DupliactePolicyAction action = new DupliactePolicyAction(pName, pType);
                action.run();
                GroupTreeObjectUnsubmitted gtolUS = action.getUnsubmittedGTO();
                PolicyTreeProvider.getInstance().setTreeSelection(gtolUS.getName(), gtolUS.getType());
            }
        } else if (menuAction.equals(COPY_RENAME_POLICY)) {
            AbstractPolicyTab tab;
            GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
            GroupTreeObjectLast gtol = null;
            String pName = null;
            if (selectedTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)selectedTab;
                gtol = root.findElement(((FilterPolicyTab)tab).getPolicy().getName(), BMUI.type_msg);
                pName = ((FilterPolicyTab)selectedTab).getPolicy().getName();
            } else if (selectedTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)selectedTab;
                gtol = root.findElement(((MonitorPolicyTab)tab).getPolicy().getName(), BMUI.type_mon);
                pName = ((MonitorPolicyTab)selectedTab).getPolicy().getName();
            }
            if (gtol == null || gtol instanceof GroupTreeObjectUnsubmitted || pName == null || pName.isEmpty()) {
                return;
            }
            PolicyRenamingAction action = new PolicyRenamingAction(this.parent.getShell(), pName, PolicyRenamingDialog.RENAME_POLICY, m_policyOverviewTab);
            action.run();
        } else if (menuAction.equals(DELETE_POLICY)) {
            AbstractPolicyTab tab;
            GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
            GroupTreeObjectLast gtol = null;
            if (selectedTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)selectedTab;
                gtol = root.findElement(((FilterPolicyTab)tab).getPolicy().getName(), BMUI.type_msg);
            } else if (selectedTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)selectedTab;
                gtol = root.findElement(((MonitorPolicyTab)tab).getPolicy().getName(), BMUI.type_mon);
            }
            if (gtol != null) {
                DeletePolicyAction action = new DeletePolicyAction(gtol);
                action.run();
            }
        } else if (menuAction.equals(DEPLOY_ON) || menuAction.equals(UNDEPLOY_FROM) || menuAction.equals(MARK_AS_DEPLOYED_ON) || menuAction.equals(ENQUEUE_DEPLOY_ON) || menuAction.equals(ENQUEUE_UNDEPLOY_FROM)) {
            String sc_type = m_actionTypMap.get(menuAction);
            if (selectedTab instanceof FilterPolicyTab) {
                FilterPolicyTab tab = (FilterPolicyTab)selectedTab;
                AssignToNodeAction action = new AssignToNodeAction(tab.getPolicy().getName(), BMUI.type_msg, sc_type);
                action.run();
            } else if (selectedTab instanceof MonitorPolicyTab) {
                MonitorPolicyTab tab = (MonitorPolicyTab)selectedTab;
                AssignToNodeAction action = new AssignToNodeAction(tab.getPolicy().getName(), BMUI.type_mon, sc_type);
                action.run();
            }
        } else if (menuAction.equals(REDEPLOY_TO_ALL) || menuAction.equals(UNDEPLOY_FROM_ALL) || menuAction.equals(ENQUEUE_REDEPLOY_TO_ALL) || menuAction.equals(ENQUEUE_UNDEPLOY_FROM_ALL)) {
            String sc_type = m_actionTypMap.get(menuAction);
            if (selectedTab instanceof FilterPolicyTab) {
                FilterPolicyTab tab = (FilterPolicyTab)selectedTab;
                RedeployAction action = new RedeployAction(tab.getPolicy().getName(), BMUI.type_msg, sc_type);
                ((AssignToNodeAction)action).run();
            } else if (selectedTab instanceof MonitorPolicyTab) {
                MonitorPolicyTab tab = (MonitorPolicyTab)selectedTab;
                RedeployAction action = new RedeployAction(tab.getPolicy().getName(), BMUI.type_mon, sc_type);
                ((AssignToNodeAction)action).run();
            }
        }
    }

    public int openSaveDialogMulitple_BATCH(String action) {
        int returnCode = -1;
        SaveDialog dialog = new SaveDialog(m_instance.getFolder().getShell());
        dialog.init(this.getFolder(), action, null, SaveDialog.POLICY);
        dialog.setBlockOnOpen(true);
        dialog.open();
        returnCode = dialog.getReturnCode();
        if (returnCode == 0) {
            block51: {
                ArrayList<CTabItem> tabs_doSave = dialog.m_tabs_doSave;
                ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
                ArrayList<CTabItem> tabs_unchanged = dialog.m_unchangedTabs;
                PolicyManager.getInstance().allowRefresh(false);
                int total = tabs_doSave.size() + tabs_doNotSave.size() + tabs_unchanged.size() + 2;
                int processingNumber = 0;
                String pdTitle = "   Saving Policies";
                if (tabs_doSave.size() == 0) {
                    pdTitle = "   Closing Policies";
                }
                ProgressDialog pd = new ProgressDialog(pdTitle, "", 0, total);
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    try {
                        CTabItem cTab;
                        pd.setProgress("Preparing ...", ++processingNumber);
                        LinkedHashMap<CTabItem, String> policiesError = new LinkedHashMap<CTabItem, String>();
                        LinkedList<Policy> policies4BatchSaving = new LinkedList<Policy>();
                        LinkedList<CTabItem> tabs2Close = new LinkedList<CTabItem>();
                        HashMap<Policy, CTabItem> policies4BatchSaving_map = new HashMap<Policy, CTabItem>();
                        if (tabs_doSave.size() > 0) {
                            int index = 0;
                            while (index < tabs_doSave.size()) {
                                AbstractPolicy policy;
                                CTabItem cTab2 = (CTabItem)tabs_doSave.get(index);
                                if (cTab2 instanceof MonitorPolicyTab) {
                                    policy = ((MonitorPolicyTab)cTab2).save_batch(true);
                                    if (policy == null) {
                                        policy = ((MonitorPolicyTab)cTab2).getPolicy();
                                        policiesError.put(cTab2, "Invalid Policy");
                                    } else {
                                        policies4BatchSaving.add((Policy)policy);
                                        policies4BatchSaving_map.put((Policy)policy, cTab2);
                                    }
                                } else if (cTab2 instanceof FilterPolicyTab) {
                                    policy = ((FilterPolicyTab)cTab2).save_batch(true);
                                    if (policy == null) {
                                        policy = ((FilterPolicyTab)cTab2).getPolicy();
                                        policiesError.put(cTab2, "Invalid Policy");
                                    } else {
                                        policies4BatchSaving.add((Policy)policy);
                                        policies4BatchSaving_map.put((Policy)policy, cTab2);
                                    }
                                }
                                ++index;
                            }
                            if (policies4BatchSaving.size() > 0) {
                                RTLogger.print(3, "BATCH saving of " + policies4BatchSaving.size() + " policies started");
                                ServerClientBatch scBatch = new ServerClientBatch("BATCH");
                                scBatch.openSocket();
                                PolicyManager pm = PolicyManager.getInstance();
                                Iterator it = policies4BatchSaving_map.keySet().iterator();
                                while (it.hasNext()) {
                                    Object obj;
                                    AbstractPolicy pol;
                                    GroupTreeObjectLast polGTOL = null;
                                    String target_path = null;
                                    String fiName = null;
                                    Map.Entry p = it.next();
                                    CTabItem cTab3 = (CTabItem)policies4BatchSaving_map.get(p);
                                    if (p instanceof Policy) {
                                        pol = (Policy)((Object)p);
                                        polGTOL = PolicyManager.getInstance().getPolicyTree().findElement(pol.getName(), BMUI.type_mon);
                                        target_path = polGTOL != null ? polGTOL.getParentPath() : ((obj = ((CTabItem)policies4BatchSaving_map.get(pol)).getData(MonitorPolicyTab.TREE_PATH)) == null || !(obj instanceof String) ? "/root/Policies" : (String)obj);
                                        fiName = String.valueOf(pol.getName()) + BMUI.file_extension_mon;
                                        pd.setProgress("Saving " + pol.getName(), ++processingNumber);
                                        RTLogger.print(3, "Save Policy: " + pol.getName());
                                        pm.saveAbstractPolicyBatch(scBatch, null, pol, fiName, target_path);
                                        if (!scBatch.isSuccess()) {
                                            policiesError.put(cTab3, "" + scBatch.getResultObject());
                                            continue;
                                        }
                                        tabs2Close.add(cTab3);
                                        continue;
                                    }
                                    if (!(p instanceof MsgPolicy)) continue;
                                    pol = (MsgPolicy)((Object)p);
                                    polGTOL = PolicyManager.getInstance().getPolicyTree().findElement(pol.getName(), BMUI.type_msg);
                                    target_path = polGTOL != null ? polGTOL.getParentPath() : ((obj = ((CTabItem)policies4BatchSaving_map.get(pol)).getData(FilterPolicyTab.TREE_PATH)) == null || !(obj instanceof String) ? "/root/Policies" : (String)obj);
                                    fiName = String.valueOf(pol.getName()) + BMUI.file_extension_msg;
                                    pd.setProgress("Saving " + pol.getName(), ++processingNumber);
                                    RTLogger.print(3, "Save Policy: " + pol.getName());
                                    pm.saveAbstractPolicyBatch(scBatch, null, pol, fiName, target_path);
                                    if (!scBatch.isSuccess()) {
                                        policiesError.put(cTab3, "" + scBatch.getResultObject());
                                        continue;
                                    }
                                    tabs2Close.add(cTab3);
                                }
                                if (scBatch.isSuccess()) {
                                    RTLogger.print(3, "BATCH saving policies finished successfully");
                                } else {
                                    RTLogger.print(3, "BATCH saving policies finished with errors");
                                }
                                scBatch.close();
                            }
                            if (tabs2Close.size() > 0) {
                                folder.setSelection((CTabItem)m_policyOverviewTab);
                                int i = 0;
                                while (i < tabs2Close.size()) {
                                    AbstractPolicyTab tab;
                                    CTabItem cTtab = (CTabItem)tabs2Close.get(i);
                                    pd.setProgress("Closing ... ", ++processingNumber);
                                    if (cTtab instanceof MonitorPolicyTab) {
                                        tab = (MonitorPolicyTab)cTtab;
                                        ((MonitorPolicyTab)tab).setDirty(false);
                                        tab.dispose();
                                    } else if (cTtab instanceof FilterPolicyTab) {
                                        tab = (FilterPolicyTab)cTtab;
                                        ((FilterPolicyTab)tab).setDirty(false);
                                        tab.dispose();
                                    }
                                    ++i;
                                }
                            }
                        }
                        CTabItem selected = folder.getSelection();
                        int index = 0;
                        while (index < tabs_doNotSave.size()) {
                            cTab = (CTabItem)tabs_doNotSave.get(index);
                            if (!action.equals(CLOSE_ALL) || !cTab.equals(selected)) {
                                pd.setProgress("Closing " + cTab.getData("POLICY_NAME"), ++processingNumber);
                                cTab.setData(DIRTY_STATUS, (Object)false);
                                cTab.dispose();
                            }
                            ++index;
                        }
                        if ((action.equals(CLOSE_ALL) || action.equals(CLOSE)) && selected != null && !(selected instanceof PolicyOverviewTab)) {
                            if (policiesError.containsKey(selected)) {
                                returnCode = 1;
                            } else {
                                selected.setData(DIRTY_STATUS, (Object)false);
                                selected.dispose();
                            }
                        }
                        index = 0;
                        while (index < tabs_unchanged.size()) {
                            cTab = (CTabItem)tabs_unchanged.get(index);
                            if (!(cTab instanceof PolicyOverviewTab)) {
                                pd.setProgress("Closing " + cTab.getData("POLICY_NAME"), ++processingNumber);
                                cTab.dispose();
                            }
                            ++index;
                        }
                        if (policiesError.size() > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry entry : policiesError.entrySet()) {
                                if (!(entry.getKey() instanceof AbstractPolicyTab)) continue;
                                AbstractPolicyTab at = (AbstractPolicyTab)entry.getKey();
                                sb.append(((AbstractPolicy)at.getPolicy()).getName()).append(": ").append((String)entry.getValue()).append("\n");
                            }
                            ShowMessageDialog smd = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Server Error", "Error saving policies:", sb.toString(), String.valueOf(policiesError.size()) + " Poicies cannot be saved!", false, " Close ");
                            smd.open();
                        }
                    }
                    catch (Throwable e) {
                        RTLogger.print(3, "Error BATCH save policies", e);
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable) {}
                        break block51;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    pd.close();
                }
                catch (Throwable throwable) {}
            }
            PolicyManager.getInstance().allowRefresh(true);
        } else if (returnCode == SaveDialog.JUST_CLOSE_ID) {
            ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
            int index = 0;
            while (index < tabs_doNotSave.size()) {
                CTabItem cTab = tabs_doNotSave.get(index);
                if (cTab instanceof MonitorPolicyTab) {
                    ((MonitorPolicyTab)cTab).setDirty(false);
                } else if (cTab instanceof FilterPolicyTab) {
                    ((FilterPolicyTab)cTab).setDirty(false);
                }
                cTab.dispose();
                ++index;
            }
            ArrayList<CTabItem> tabs_unchanged = dialog.m_unchangedTabs;
            int index2 = 0;
            while (index2 < tabs_unchanged.size()) {
                CTabItem cTab = tabs_unchanged.get(index2);
                if (!(cTab instanceof PolicyOverviewTab)) {
                    cTab.dispose();
                }
                ++index2;
            }
        }
        return returnCode;
    }

    public void runContentMenuAction(String type) {
        block8: {
            CTabItem selTab;
            CTabItem[] openTabs;
            block7: {
                openTabs = folder.getItems();
                selTab = folder.getSelection();
                if (!type.equals(CLOSE)) break block7;
                if (selTab instanceof PolicyOverviewTab) break block8;
                selTab.dispose();
                break block8;
            }
            if (type.equals(CLOSE_ALL)) {
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab = openTabs[index];
                    if (!(cTab instanceof PolicyOverviewTab)) {
                        cTab.dispose();
                    }
                    ++index;
                }
            } else if (type.equals(CLOSE_OTHERS)) {
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab;
                    if (!openTabs[index].equals(selTab) && !((cTab = openTabs[index]) instanceof PolicyOverviewTab)) {
                        cTab.dispose();
                    }
                    ++index;
                }
            }
        }
    }

    public void menuHidden(MenuEvent e) {
    }

    public void menuShown(MenuEvent e) {
        block96: {
            CTabItem selTab;
            int cTabCount;
            MenuItem[] mi;
            block97: {
                AbstractPolicyTab tab;
                block94: {
                    block95: {
                        Menu menu = (Menu)e.getSource();
                        mi = menu.getItems();
                        cTabCount = folder.getItemCount();
                        selTab = folder.getSelection();
                        if (cTabCount == 0) {
                            int index = 0;
                            while (index < mi.length) {
                                String action = (String)mi[index].getData();
                                if (action != null && !action.equals(SEARCH_POLICY)) {
                                    mi[index].setEnabled(false);
                                }
                                ++index;
                            }
                            return;
                        }
                        if (!(selTab instanceof PolicyOverviewTab)) break block94;
                        if (cTabCount != 1) break block95;
                        int index = 0;
                        while (index < mi.length) {
                            String action = (String)mi[index].getData();
                            if (action != null) {
                                if (action.equals(SEARCH_POLICY)) {
                                    mi[index].setEnabled(true);
                                } else {
                                    mi[index].setEnabled(false);
                                }
                            }
                            ++index;
                        }
                        break block96;
                    }
                    if (cTabCount <= 1) break block96;
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(CLOSE_ALL) || action.equals(CLOSE_OTHERS) || action.equals(SEARCH_POLICY)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                    break block96;
                }
                if (!(selTab instanceof MonitorPolicyTab) && !(selTab instanceof FilterPolicyTab)) break block97;
                GroupTreeObjectLast gtoLast = null;
                if (selTab instanceof MonitorPolicyTab) {
                    tab = (MonitorPolicyTab)selTab;
                    gtoLast = PolicyManager.getInstance().getPolicyTree().findElement(((MonitorPolicyTab)tab).getPolicy().getName(), BMUI.type_mon);
                } else if (selTab instanceof FilterPolicyTab) {
                    tab = (FilterPolicyTab)selTab;
                    gtoLast = PolicyManager.getInstance().getPolicyTree().findElement(((FilterPolicyTab)tab).getPolicy().getName(), BMUI.type_msg);
                }
                if (gtoLast == null) break block96;
                boolean isUnsubmitted = gtoLast instanceof GroupTreeObjectUnsubmitted;
                if (isUnsubmitted) {
                    if (cTabCount > 2) {
                        int index = 0;
                        while (index < mi.length) {
                            String action = (String)mi[index].getData();
                            if (action != null) {
                                if (action.equals(SHOW_RELATED_INFORMATION)) {
                                    mi[index].setEnabled(false);
                                } else if (action.equals(SHOW_INDICATIONS)) {
                                    mi[index].setEnabled(false);
                                } else if (action.equals(DELETE_POLICY)) {
                                    mi[index].setEnabled(true);
                                } else if (!(action.equals(SELECT_IN_TREE) || action.equals(CLOSE) || action.equals(CLOSE_ALL) || action.equals(CLOSE_OTHERS))) {
                                    mi[index].setEnabled(false);
                                } else {
                                    mi[index].setEnabled(true);
                                }
                            }
                            ++index;
                        }
                    } else if (cTabCount == 2) {
                        int index = 0;
                        while (index < mi.length) {
                            String action = (String)mi[index].getData();
                            if (action != null) {
                                if (action.equals(SHOW_RELATED_INFORMATION)) {
                                    mi[index].setEnabled(false);
                                } else if (action.equals(DELETE_POLICY)) {
                                    mi[index].setEnabled(true);
                                } else if (!(action.equals(SELECT_IN_TREE) || action.equals(CLOSE) || action.equals(CLOSE_ALL))) {
                                    mi[index].setEnabled(false);
                                } else {
                                    mi[index].setEnabled(true);
                                }
                            }
                            ++index;
                        }
                    } else {
                        int index = 0;
                        while (index < mi.length) {
                            String action = (String)mi[index].getData();
                            if (action != null) {
                                if (action.equals(SHOW_RELATED_INFORMATION)) {
                                    mi[index].setEnabled(false);
                                } else if (action.equals(SHOW_INDICATIONS)) {
                                    mi[index].setEnabled(false);
                                } else if (action.equals(DELETE_POLICY)) {
                                    mi[index].setEnabled(true);
                                } else {
                                    mi[index].setEnabled(false);
                                }
                            }
                            ++index;
                        }
                    }
                } else if (cTabCount > 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(SHOW_RELATED_INFORMATION)) {
                                if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1) {
                                    mi[index].setEnabled(false);
                                } else {
                                    mi[index].setEnabled(true);
                                }
                            } else {
                                mi[index].setEnabled(true);
                            }
                        }
                        ++index;
                    }
                } else if (cTabCount == 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(SHOW_RELATED_INFORMATION)) {
                                if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1) {
                                    mi[index].setEnabled(false);
                                } else {
                                    mi[index].setEnabled(true);
                                }
                            } else if (action.equals(CLOSE_OTHERS)) {
                                mi[index].setEnabled(false);
                            } else {
                                mi[index].setEnabled(true);
                            }
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(SHOW_RELATED_INFORMATION)) {
                                if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1) {
                                    mi[index].setEnabled(false);
                                } else {
                                    mi[index].setEnabled(true);
                                }
                            } else if (action.equals(COPY_RENAME_POLICY)) {
                                mi[index].setEnabled(true);
                            } else if (action.equals(DELETE_POLICY)) {
                                mi[index].setEnabled(true);
                            } else if (mi[index].getData().equals(CLOSE)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                }
                break block96;
            }
            if (selTab instanceof PolicySearchTab) {
                if (cTabCount == 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(CLOSE) || action.equals(CLOSE_ALL)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                } else if (cTabCount > 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(CLOSE) || action.equals(CLOSE_ALL) || action.equals(CLOSE_OTHERS)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                }
            } else {
                int index = 0;
                while (index < mi.length) {
                    String action = (String)mi[index].getData();
                    if (action != null) {
                        mi[index].setEnabled(false);
                    }
                    ++index;
                }
            }
        }
    }

    public void minimize(CTabFolderEvent event) {
        folder.setMinimized(true);
        PolicyView.m_instance.parent.layout(true);
    }

    public void maximize(CTabFolderEvent event) {
        folder.setMaximized(true);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        PolicyView.m_instance.parent.layout(true);
    }

    public void restore(CTabFolderEvent event) {
        folder.setMinimized(false);
        folder.setMaximized(false);
        folder.setLayoutData((Object)new GridData(4, 4, true, false));
        PolicyView.m_instance.parent.layout(true);
    }

    public void close(CTabFolderEvent event) {
        int returnCode;
        AbstractPolicyTab tab;
        CTabItem cTab = (CTabItem)event.item;
        String polName = null;
        if (cTab instanceof FilterPolicyTab) {
            tab = (FilterPolicyTab)cTab;
            polName = ((FilterPolicyTab)tab).getPolicy().getName();
            if (!PolicyView.isTabActiv(tab) || tab.getControl().isDisposed()) {
                ((FilterPolicyTab)tab).internalRestore(null);
            }
            tab.getControl().setVisible(true);
            folder.setSelection((CTabItem)tab);
        } else if (cTab instanceof MonitorPolicyTab) {
            tab = (MonitorPolicyTab)cTab;
            polName = ((MonitorPolicyTab)tab).getPolicy().getName();
            if (!PolicyView.isTabActiv(tab) || tab.getControl().isDisposed()) {
                ((MonitorPolicyTab)tab).internalRestore(null);
            }
            tab.getControl().setVisible(true);
            folder.setSelection((CTabItem)tab);
        } else {
            return;
        }
        if (polName == null || polName.isEmpty()) {
            new ShowMessageBox("Error Saving Policy", "Invalid Policy Name!", 1);
            event.doit = false;
        } else if (((Boolean)cTab.getData(DIRTY_STATUS)).booleanValue() && (returnCode = this.openSaveDialogMulitple_BATCH(CLOSE)) == 1) {
            event.doit = false;
        }
    }

    public void showList(CTabFolderEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        CTabFolder folder = (CTabFolder)e.getSource();
        CTabItem cTabItem = folder.getSelection();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem tab = folder.getItem(i);
            if (tab != null) {
                if (!tab.equals(cTabItem)) {
                    if (!(tab instanceof PolicyOverviewTab || tab instanceof PolicySearchTab || tab.getControl().isDisposed())) {
                        tab.getControl().dispose();
                    }
                } else if (tab instanceof MonitorPolicyTab) {
                    ((MonitorPolicyTab)tab).internalRestore(null);
                    ((MonitorPolicyTab)tab).getControl().setVisible(true);
                } else if (tab instanceof FilterPolicyTab) {
                    ((FilterPolicyTab)tab).internalRestore(null);
                    ((FilterPolicyTab)tab).getControl().setVisible(true);
                } else if (tab instanceof PolicyOverviewTab) {
                    ((PolicyOverviewTab)tab).getControl().setVisible(true);
                } else if (tab instanceof PolicySearchTab) {
                    if (((PolicySearchTab)tab).getControl().isDisposed()) {
                        SearchPolicyAction searchPolicy = new SearchPolicyAction();
                        searchPolicy.run();
                    } else {
                        ((PolicySearchTab)tab).getControl().setVisible(true);
                    }
                }
            }
            ++i;
        }
    }
}

