/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PrintJob
extends Job {
    Point screenDPI = null;
    Point printerDPI = null;
    Image m_image = null;
    Printer m_printer = null;
    Control m_tree = null;

    public PrintJob(String name, Control tree) {
        super(name);
        this.m_tree = tree;
    }

    public boolean showDialog() {
        PrintDialog dialog = new PrintDialog(Display.getCurrent().getActiveShell(), 0);
        PrinterData data = dialog.open();
        if (data == null) {
            return false;
        }
        this.m_printer = new Printer(data);
        this.screenDPI = Display.getCurrent().getDPI();
        this.printerDPI = this.m_printer.getDPI();
        int scaleFactor = this.printerDPI.x / this.screenDPI.x;
        Rectangle treeBounds = new Rectangle(0, 0, this.m_tree.getSize().x, this.m_tree.getSize().y);
        Image treeImage = new Image((Device)this.m_tree.getDisplay(), treeBounds.width, treeBounds.height);
        GC gc = new GC((Drawable)treeImage);
        this.m_tree.print(gc);
        gc.dispose();
        ImageData imageData = treeImage.getImageData().scaledTo(treeBounds.width * scaleFactor, treeBounds.height * scaleFactor);
        this.m_image = new Image((Device)this.m_printer, imageData);
        treeImage.dispose();
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.m_printer.startJob("Tree")) {
            GC gc = new GC((Drawable)this.m_printer);
            this.m_printer.startPage();
            Rectangle imageBounds = this.m_image.getBounds();
            gc.drawImage(this.m_image, 0, 0, imageBounds.width, imageBounds.height, 0, 0, imageBounds.width, imageBounds.height);
            this.m_printer.endPage();
            this.m_printer.endJob();
            gc.dispose();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

