/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ServerFilterTableProvider;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.boom.gui.views.actions.ActivateServerFilterAction;
import com.blixx.boom.gui.views.actions.DeleteServerFilterAction;
import com.blixx.boom.gui.views.actions.ShowRelatedServerFilterInfosAction;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class ServerFilterOverviewTab
extends CTabItem
implements SelectionListener,
IDoubleClickListener {
    private static ServerFilterOverviewTab m_instance = null;
    private CTabFolder m_folder = null;
    private Composite m_parent = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_compInTab = null;
    private Composite m_compCounter_nFilter = null;
    private Composite m_compCounter_uFilter = null;
    private Button m_refresh_btn = null;
    private Text m_nFilterCounter_label = null;
    private Text m_uFilterCounter_label = null;
    private Table m_notificationFilter_tbl = null;
    private TableViewer m_notifiactionFilter_tv = null;
    private Table m_userFilter_tbl = null;
    private TableViewer m_userFilter_tv = null;
    private ServerFilterTableProvider m_notificationFilter_tblProvider = null;
    private ServerFilterTableProvider m_userFilter_tblProvider = null;
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String NOTIFICATION_FILTER_OVERVIEW_TABLE = "NOTIFICATION_FILTER_OVERVIEW_TABLE";
    public static String USER_FILTER_OVERVIEW_TABLE = "USER_FILTER_OVERVIEW_TABLE";
    public static HashMap<String, Integer> m_colIndices = new HashMap();
    public static HashMap<Integer, String> m_colNames;
    public static HashMap<String, Integer> m_columnWidth;
    public Listener sortListenerNotificationFilter = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                ServerFilterOverviewTab.this.m_notificationFilter_tblProvider.setSortingProps(sortIdentifier, dir);
                ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getTable().setSortDirection(dir);
                ISelection sel = ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getSelection();
                if (ServerFilterOverviewTab.this.m_notifiactionFilter_tv.getSorter() != ServerFilterOverviewTab.this.m_notificationFilter_tblProvider) {
                    ServerFilterOverviewTab.this.m_notifiactionFilter_tv.setSorter((ViewerSorter)ServerFilterOverviewTab.this.m_notificationFilter_tblProvider);
                } else {
                    ServerFilterOverviewTab.this.m_notifiactionFilter_tv.refresh(true, false);
                }
                ServerFilterOverviewTab.this.m_notifiactionFilter_tv.setSelection(sel, false);
            }
        }
    };
    public Listener sortListenerUserFilter = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = ServerFilterOverviewTab.this.m_userFilter_tv.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = ServerFilterOverviewTab.this.m_userFilter_tv.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ServerFilterOverviewTab.this.m_userFilter_tv.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                ServerFilterOverviewTab.this.m_userFilter_tblProvider.setSortingProps(sortIdentifier, dir);
                ServerFilterOverviewTab.this.m_userFilter_tv.getTable().setSortDirection(dir);
                ISelection sel = ServerFilterOverviewTab.this.m_userFilter_tv.getSelection();
                if (ServerFilterOverviewTab.this.m_userFilter_tv.getSorter() != ServerFilterOverviewTab.this.m_userFilter_tblProvider) {
                    ServerFilterOverviewTab.this.m_userFilter_tv.setSorter((ViewerSorter)ServerFilterOverviewTab.this.m_userFilter_tblProvider);
                } else {
                    ServerFilterOverviewTab.this.m_userFilter_tv.refresh(true, false);
                }
                ServerFilterOverviewTab.this.m_userFilter_tv.setSelection(sel, false);
            }
        }
    };
    public static Listener multiLineListener;

    static {
        m_colIndices.put(ServerFilterTableProvider.COL_STATUS, 0);
        m_colIndices.put(ServerFilterTableProvider.COL_NAME, 1);
        m_colIndices.put(ServerFilterTableProvider.COL_DESC, 2);
        m_colIndices.put(ServerFilterTableProvider.COL_ATTR_FILTERS, 3);
        m_colIndices.put(ServerFilterTableProvider.COL_FCONDITIONS, 4);
        m_colIndices.put(ServerFilterTableProvider.COL_NOTIFICATION, 5);
        m_colIndices.put(ServerFilterTableProvider.COL_USERROLES, 4);
        m_colNames = new HashMap();
        m_colNames.put(0, ServerFilterTableProvider.COL_STATUS);
        m_colNames.put(1, ServerFilterTableProvider.COL_NAME);
        m_colNames.put(2, ServerFilterTableProvider.COL_DESC);
        m_colNames.put(3, ServerFilterTableProvider.COL_ATTR_FILTERS);
        m_colNames.put(4, ServerFilterTableProvider.COL_FCONDITIONS);
        m_colNames.put(5, ServerFilterTableProvider.COL_NOTIFICATION);
        m_columnWidth = new HashMap();
        m_columnWidth.put(ServerFilterTableProvider.COL_STATUS, 30);
        m_columnWidth.put(ServerFilterTableProvider.COL_NAME, 200);
        m_columnWidth.put(ServerFilterTableProvider.COL_DESC, 200);
        m_columnWidth.put(ServerFilterTableProvider.COL_ATTR_FILTERS, 200);
        m_columnWidth.put(ServerFilterTableProvider.COL_FCONDITIONS, 200);
        m_columnWidth.put(ServerFilterTableProvider.COL_USERROLES, 200);
        m_columnWidth.put(ServerFilterTableProvider.COL_NOTIFICATION, 200);
        multiLineListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        String text = this.getText(item, event.index);
                        if (text == null) break;
                        Point size = event.gc.textExtent(text);
                        event.width = size.x + 4;
                        event.height = Math.max(event.height, size.y + 2);
                        break;
                    }
                    case 42: {
                        String text;
                        int hIndent = 0;
                        TableItem item = (TableItem)event.item;
                        Image image = item.getImage(event.index);
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(image, event.x + 4, event.y + 2 + offset);
                            hIndent = rect.width + 4;
                        }
                        if ((text = this.getText(item, event.index)) == null) break;
                        Point size = event.gc.textExtent(text);
                        int offset2 = Math.max(0, (event.height - size.y) / 2);
                        event.gc.drawText(text, event.x + 4 + hIndent, event.y + 2 + offset2, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }

            String getText(TableItem item, int column) {
                String text = item.getText(column);
                if (text == null || text.length() == 0) {
                    return null;
                }
                if (text.indexOf(",") != -1) {
                    text = text.replaceAll(",", "");
                }
                return text;
            }
        };
    }

    public ServerFilterOverviewTab(CTabFolder parent) {
        super(parent, 0, 0);
        m_instance = this;
        ServerFilterOverviewTab.m_instance.m_parent = parent;
        this.m_folder = parent;
        this.setText("Overview");
        this.setImage(BMUI.IMAGE_FWD_OVERVIEW);
        this.setData(ServerFilterView.OVERVIEW_TAB);
        this.createMainArea();
    }

    public static ServerFilterOverviewTab getInstance() {
        return m_instance;
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compInTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 10;
        this.m_compInTab.setLayout((Layout)gl);
        this.m_compInTab.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_refresh_btn = this.m_gui.addButton(this.m_compInTab, ServerFilterView.RELOAD_VIEW_BUTTON, "Reload  ", true, 60, 0, 10, this);
        ((GridData)this.m_refresh_btn.getLayoutData()).horizontalIndent = 5;
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH);
        SashForm sash = new SashForm(this.m_compInTab, 512);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp_top = new Composite((Composite)sash, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginBottom = 10;
        comp_top.setLayout((Layout)gl);
        comp_top.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp_bottom = new Composite((Composite)sash, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        comp_bottom.setLayout((Layout)gl);
        comp_bottom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createNotificationFilterTable(comp_top);
        this.createUserFilterTable(comp_bottom);
        sash.setWeights(new int[]{50, 50});
        this.setControl((Control)this.m_compInTab);
    }

    public void createNotificationFilterTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        folder.setLayout((Layout)gl);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem nTab = new CTabItem(folder, 0);
        nTab.setText("Notification Filters");
        Composite compInTab = new Composite((Composite)folder, 0);
        compInTab.setBackground(BMUI.color_critical);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        compInTab.setLayout((Layout)gl);
        compInTab.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(compInTab, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_notificationFilter_tbl = new Table(tableComp, 268503810);
        this.m_notificationFilter_tbl.setHeaderVisible(true);
        this.m_notificationFilter_tbl.setLinesVisible(true);
        this.m_notificationFilter_tbl.setLayout((Layout)gl);
        this.m_notificationFilter_tbl.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_notificationFilter_tbl.setData((Object)NOTIFICATION_FILTER_OVERVIEW_TABLE);
        this.m_notifiactionFilter_tv = new TableViewer(this.m_notificationFilter_tbl);
        this.m_notifiactionFilter_tv.setData(VIEWER_TYPE, (Object)NOTIFICATION_FILTER_OVERVIEW_TABLE);
        this.m_notificationFilter_tblProvider = new ServerFilterTableProvider(this.m_notifiactionFilter_tv, ServerFilterTableProvider.SERVER_POLICIES);
        TableViewerColumn tv_col0 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col0.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col0 = tv_col0.getColumn();
        col0.setText(ServerFilterTableProvider.COL_STATUS);
        col0.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_STATUS).intValue());
        col0.addListener(13, this.sortListenerNotificationFilter);
        TableViewerColumn tv_col1 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col1.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col1 = tv_col1.getColumn();
        col1.setText(ServerFilterTableProvider.COL_NAME);
        col1.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_NAME).intValue());
        col1.addListener(13, this.sortListenerNotificationFilter);
        TableViewerColumn tv_col2 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col2.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col2 = tv_col2.getColumn();
        col2.setText(ServerFilterTableProvider.COL_DESC);
        col2.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_DESC).intValue());
        col2.addListener(13, this.sortListenerNotificationFilter);
        TableViewerColumn tv_col3 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col3.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col3 = tv_col3.getColumn();
        col3.setText(ServerFilterTableProvider.COL_ATTR_FILTERS);
        col3.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_ATTR_FILTERS).intValue());
        col3.addListener(13, this.sortListenerNotificationFilter);
        TableViewerColumn tv_col4 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col4.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col4 = tv_col4.getColumn();
        col4.setText(ServerFilterTableProvider.COL_FCONDITIONS);
        col4.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_FCONDITIONS).intValue());
        col4.addListener(13, this.sortListenerNotificationFilter);
        TableViewerColumn tv_col5 = new TableViewerColumn(this.m_notifiactionFilter_tv, 16384);
        tv_col5.setLabelProvider(this.m_notificationFilter_tblProvider.labelProvider);
        TableColumn col5 = tv_col5.getColumn();
        col5.setText(ServerFilterTableProvider.COL_NOTIFICATION);
        col5.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_NOTIFICATION).intValue());
        col5.addListener(13, this.sortListenerNotificationFilter);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(100, col5.getWidth()));
        this.m_notifiactionFilter_tv.setContentProvider((IContentProvider)this.m_notificationFilter_tblProvider);
        this.m_notifiactionFilter_tv.setInput((Object)this.m_notificationFilter_tblProvider.getElements(null));
        this.m_notifiactionFilter_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = event.getSource();
                if (o instanceof TableViewer) {
                    TableViewer tv = (TableViewer)o;
                    List<ForwardPolicy> selItems = ServerFilterOverviewTab.this.getTableSelection(tv);
                    OpenServerFilterAction action = new OpenServerFilterAction(selItems);
                    action.run();
                }
            }
        });
        this.m_notificationFilter_tbl.setSortColumn(col1);
        this.m_notificationFilter_tbl.setSortDirection(128);
        this.m_notifiactionFilter_tv.setSorter((ViewerSorter)this.m_notificationFilter_tblProvider);
        this.m_notifiactionFilter_tv.setComparer((IElementComparer)this.m_notificationFilter_tblProvider);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_notifiactionFilter_tv, 2);
        this.m_notificationFilter_tbl.setToolTipText("");
        this.m_notificationFilter_tbl.addListener(41, multiLineListener);
        this.m_notificationFilter_tbl.addListener(42, multiLineListener);
        this.m_notificationFilter_tbl.addListener(40, multiLineListener);
        this.createCM_notificationFilter();
        this.m_compCounter_nFilter = new Composite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 5;
        this.m_compCounter_nFilter.setLayout((Layout)gl);
        this.m_compCounter_nFilter.setLayoutData((Object)new GridData(4, 1024, true, false, 4, 1));
        this.m_nFilterCounter_label = this.m_gui.addTextReadOnlyNoBorder(this.m_compCounter_nFilter, "Total:", "" + this.m_notificationFilter_tblProvider.getNumOfFwdPolicies(), 1, 1, 0, 0, null);
        this.m_nFilterCounter_label.setLayoutData((Object)new GridData(4, 4, true, false));
        nTab.setControl((Control)compInTab);
        folder.setSelection(nTab);
    }

    public void createUserFilterTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        folder.setLayout((Layout)gl);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("User Filters");
        Composite compInTab = new Composite((Composite)folder, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        compInTab.setLayout((Layout)gl);
        compInTab.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(compInTab, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_userFilter_tbl = new Table(tableComp, 268503810);
        this.m_userFilter_tbl.setHeaderVisible(true);
        this.m_userFilter_tbl.setLinesVisible(true);
        this.m_userFilter_tbl.setLayout((Layout)gl);
        this.m_userFilter_tbl.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_userFilter_tbl.setData((Object)USER_FILTER_OVERVIEW_TABLE);
        this.m_userFilter_tv = new TableViewer(this.m_userFilter_tbl);
        this.m_userFilter_tv.setData(VIEWER_TYPE, (Object)USER_FILTER_OVERVIEW_TABLE);
        this.m_userFilter_tblProvider = new ServerFilterTableProvider(this.m_userFilter_tv, ServerFilterTableProvider.USER_POLICIES);
        TableViewerColumn tv_col0 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col0.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col0 = tv_col0.getColumn();
        col0.setText(ServerFilterTableProvider.COL_STATUS);
        col0.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_STATUS).intValue());
        col0.addListener(13, this.sortListenerUserFilter);
        TableViewerColumn tv_col1 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col1.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col1 = tv_col1.getColumn();
        col1.setText(ServerFilterTableProvider.COL_NAME);
        col1.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_NAME).intValue());
        col1.addListener(13, this.sortListenerUserFilter);
        TableViewerColumn tv_col2 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col2.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col2 = tv_col2.getColumn();
        col2.setText(ServerFilterTableProvider.COL_DESC);
        col2.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_DESC).intValue());
        col2.addListener(13, this.sortListenerUserFilter);
        TableViewerColumn tv_col3 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col3.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col3 = tv_col3.getColumn();
        col3.setText(ServerFilterTableProvider.COL_ATTR_FILTERS);
        col3.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_ATTR_FILTERS).intValue());
        col3.addListener(13, this.sortListenerUserFilter);
        TableViewerColumn tv_col4 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col4.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col4 = tv_col4.getColumn();
        col4.setText(ServerFilterTableProvider.COL_USERROLES);
        col4.setWidth(m_columnWidth.get(ServerFilterTableProvider.COL_USERROLES).intValue());
        col4.addListener(13, this.sortListenerUserFilter);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(100, col4.getWidth()));
        this.m_userFilter_tv.setContentProvider((IContentProvider)this.m_userFilter_tblProvider);
        this.m_userFilter_tv.setInput((Object)this.m_userFilter_tblProvider.getElements(null));
        this.m_userFilter_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (Repository.getInstance().getRights(1004) < 3) {
                    return;
                }
                Object o = event.getSource();
                if (o instanceof TableViewer) {
                    TableViewer tv = (TableViewer)o;
                    List<ForwardPolicy> selItems = ServerFilterOverviewTab.this.getTableSelection(tv);
                    OpenServerFilterAction action = new OpenServerFilterAction(selItems);
                    action.run();
                }
            }
        });
        this.m_userFilter_tbl.setSortColumn(col1);
        this.m_userFilter_tbl.setSortDirection(128);
        this.m_userFilter_tv.setSorter((ViewerSorter)this.m_userFilter_tblProvider);
        this.m_userFilter_tv.setComparer((IElementComparer)this.m_userFilter_tblProvider);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_userFilter_tv, 2);
        this.m_userFilter_tbl.setToolTipText("");
        this.m_userFilter_tbl.addListener(41, multiLineListener);
        this.m_userFilter_tbl.addListener(42, multiLineListener);
        this.m_userFilter_tbl.addListener(40, multiLineListener);
        this.createCM_userFilter();
        this.m_compCounter_uFilter = new Composite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 5;
        this.m_compCounter_uFilter.setLayout((Layout)gl);
        this.m_compCounter_uFilter.setLayoutData((Object)new GridData(4, 1024, true, false, 4, 1));
        this.m_uFilterCounter_label = this.m_gui.addTextReadOnlyNoBorder(this.m_compCounter_uFilter, "Total:", "" + this.m_userFilter_tblProvider.getNumOfFwdPolicies(), 1, 1, 0, 0, null);
        this.m_uFilterCounter_label.setLayoutData((Object)new GridData(4, 4, true, false));
        tab.setControl((Control)compInTab);
        folder.setSelection(tab);
    }

    public void createCM_notificationFilter() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_notifiactionFilter_tv.getControl());
        this.m_notifiactionFilter_tv.getControl().setMenu(menu);
        IWorkbenchPartSite site = ServerFilterView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_notifiactionFilter_tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    List<ForwardPolicy> selItems = ServerFilterOverviewTab.this.getTableSelection(ServerFilterOverviewTab.this.m_notifiactionFilter_tv);
                    manager.add((IAction)new ReloadTableAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new OpenServerFilterAction(selItems));
                    manager.add((IAction)new ShowRelatedServerFilterInfosAction(ServerFilterOverviewTab.this.m_parent.getShell(), selItems));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ActivateServerFilterAction(m_instance, selItems));
                    manager.add((IAction)new DeleteServerFilterAction(selItems, "NOTIFICATION"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createCM_userFilter() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_userFilter_tv.getControl());
        this.m_userFilter_tv.getControl().setMenu(menu);
        IWorkbenchPartSite site = ServerFilterView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_userFilter_tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    List<ForwardPolicy> selItems = ServerFilterOverviewTab.this.getTableSelection(ServerFilterOverviewTab.this.m_userFilter_tv);
                    manager.add((IAction)new ReloadTableAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new OpenServerFilterAction(selItems));
                    manager.add((IAction)new ShowRelatedServerFilterInfosAction(ServerFilterOverviewTab.this.m_parent.getShell(), selItems));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ActivateServerFilterAction(m_instance, selItems));
                    manager.add((IAction)new DeleteServerFilterAction(selItems, "USERS"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void updateCounters() {
        if (this.m_nFilterCounter_label != null && !this.m_nFilterCounter_label.isDisposed()) {
            this.m_nFilterCounter_label.setText("" + this.m_notificationFilter_tblProvider.getNumOfFwdPolicies());
            this.m_compCounter_nFilter.layout(true);
        }
        if (this.m_uFilterCounter_label != null && !this.m_uFilterCounter_label.isDisposed()) {
            this.m_uFilterCounter_label.setText("" + this.m_userFilter_tblProvider.getNumOfFwdPolicies());
            this.m_compCounter_uFilter.layout(true);
        }
    }

    public void refreshTables() {
        int colIndex;
        List<ForwardPolicy> selection;
        TableColumn sortCol;
        boolean doSorting;
        int sortDir;
        String sortColName;
        if (this.m_notificationFilter_tbl != null && !this.m_notificationFilter_tbl.isDisposed() && this.m_notifiactionFilter_tv != null) {
            sortColName = null;
            sortDir = -1;
            doSorting = false;
            sortCol = this.m_notificationFilter_tbl.getSortColumn();
            if (sortCol != null) {
                sortColName = sortCol.getText();
                sortDir = this.m_notificationFilter_tbl.getSortDirection();
                if (m_colIndices.containsKey(sortColName) && sortDir != -1) {
                    doSorting = true;
                }
            }
            selection = this.getTableSelection(this.m_notifiactionFilter_tv);
            this.m_notificationFilter_tblProvider.loadFwdPolicies();
            this.m_notifiactionFilter_tv.setInput((Object)this.m_notificationFilter_tblProvider.getElements(null));
            this.m_notifiactionFilter_tv.refresh(true);
            this.updateCounters();
            if (!doSorting) {
                return;
            }
            if (m_colIndices.containsKey(sortColName)) {
                colIndex = m_colIndices.get(sortColName);
                sortCol = this.m_notificationFilter_tbl.getColumn(colIndex);
                this.m_notificationFilter_tblProvider.setSortingProps(sortColName, sortDir);
                this.m_notifiactionFilter_tv.getTable().setSortDirection(sortDir);
                this.m_notifiactionFilter_tv.getTable().setSortColumn(sortCol);
                if (this.m_notifiactionFilter_tv.getSorter() != this.m_notificationFilter_tblProvider) {
                    this.m_notifiactionFilter_tv.setSorter((ViewerSorter)this.m_notificationFilter_tblProvider);
                } else {
                    this.m_notifiactionFilter_tv.refresh(true, false);
                }
            }
            this.setTableSelection(this.m_notifiactionFilter_tv, selection);
        }
        if (this.m_userFilter_tbl != null && !this.m_userFilter_tbl.isDisposed() && this.m_userFilter_tv != null) {
            sortColName = null;
            sortDir = -1;
            doSorting = false;
            sortCol = this.m_userFilter_tbl.getSortColumn();
            if (sortCol != null) {
                sortColName = sortCol.getText();
                sortDir = this.m_userFilter_tbl.getSortDirection();
                if (m_colIndices.containsKey(sortColName) && sortDir != -1) {
                    doSorting = true;
                }
            }
            selection = this.getTableSelection(this.m_userFilter_tv);
            this.m_userFilter_tblProvider.loadFwdPolicies();
            this.m_userFilter_tv.setInput((Object)this.m_userFilter_tblProvider.getElements(null));
            this.m_userFilter_tv.refresh(true);
            this.updateCounters();
            this.m_compCounter_uFilter.layout(true);
            if (!doSorting) {
                return;
            }
            if (m_colIndices.containsKey(sortColName)) {
                colIndex = m_colIndices.get(sortColName);
                sortCol = this.m_userFilter_tbl.getColumn(colIndex);
                this.m_userFilter_tblProvider.setSortingProps(sortColName, sortDir);
                this.m_userFilter_tv.getTable().setSortDirection(sortDir);
                this.m_userFilter_tv.getTable().setSortColumn(sortCol);
                if (this.m_userFilter_tv.getSorter() != this.m_userFilter_tblProvider) {
                    this.m_userFilter_tv.setSorter((ViewerSorter)this.m_userFilter_tblProvider);
                } else {
                    this.m_userFilter_tv.refresh(true, false);
                }
            }
            this.setTableSelection(this.m_userFilter_tv, selection);
        }
    }

    public List<ForwardPolicy> getTableSelection(TableViewer tv) {
        ArrayList<ForwardPolicy> list = new ArrayList<ForwardPolicy>();
        StructuredSelection ssel = (StructuredSelection)tv.getSelection();
        if (!ssel.isEmpty()) {
            for (Object o : ssel) {
                if (!(o instanceof ForwardPolicy)) continue;
                list.add((ForwardPolicy)o);
            }
        }
        return list;
    }

    private void setTableSelection(TableViewer tv, List<ForwardPolicy> list) {
        if (list.size() == 0) {
            return;
        }
        ForwardPolicy fp = null;
        ArrayList<TableItem> tableItem = new ArrayList<TableItem>();
        int i = 0;
        while (i < list.size()) {
            fp = list.get(i);
            TableItem item = this.getTableItem(fp);
            if (item != null) {
                tableItem.add(item);
            }
            ++i;
        }
        if (tableItem.size() == 0) {
            return;
        }
        TableItem[] newTI = new TableItem[tableItem.size()];
        int i2 = 0;
        while (i2 < tableItem.size()) {
            newTI[i2] = (TableItem)tableItem.get(i2);
            ++i2;
        }
        tv.getTable().setSelection(newTI);
    }

    private TableItem getTableItem(ForwardPolicy fp) {
        TableItem[] tableItems = this.m_userFilter_tbl.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem ti = tableItems[i];
            ForwardPolicy fp1 = (ForwardPolicy)ti.getData();
            if (fp1 != null && fp1.equals(fp)) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    public void doubleClick(DoubleClickEvent event) {
        Object o = event.getSource();
        if (o instanceof TableViewer) {
            TableViewer tv = (TableViewer)o;
            List<ForwardPolicy> selItems = this.getTableSelection(tv);
            OpenServerFilterAction action = new OpenServerFilterAction(selItems);
            action.run();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button b;
        String name;
        Object obj = e.getSource();
        if (obj instanceof Button && (name = (String)(b = (Button)e.getSource()).getData()).equals(ServerFilterView.RELOAD_VIEW_BUTTON)) {
            b.setEnabled(false);
            try {
                ReloadTableAction action = new ReloadTableAction();
                action.run();
            }
            finally {
                b.setEnabled(true);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public static class OpenServerFilterAction
    extends Action {
        private ForwardPolicy m_fp = null;

        public OpenServerFilterAction(List<ForwardPolicy> selItems) {
            super("openServerFilter");
            this.setId("openserverfilter");
            this.setText("Open Server Filter");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FWD);
            if (selItems == null || selItems.size() == 0) {
                this.setEnabled(false);
                return;
            }
            if (selItems.size() > 1) {
                this.m_fp = selItems.get(0);
                if (this.m_fp.isUserPolicyValid()) {
                    this.setText("Open User Filter");
                    this.setEnabled(false);
                    return;
                }
                this.setText("Open Notification Filter");
                this.setEnabled(false);
                return;
            }
            if (selItems.size() == 1) {
                this.m_fp = selItems.get(0);
                try {
                    if (this.m_fp.isUserPolicyValid()) {
                        this.setText("Open User Filter");
                        if (Repository.getInstance().getRights(1004) < 3) {
                            this.setEnabled(false);
                            return;
                        }
                    } else {
                        this.setText("Open Notification Filter");
                    }
                }
                catch (Exception exception) {
                    this.setEnabled(false);
                    return;
                }
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_fp.isUserPolicyValid()) {
                ServerFilterView.getInstance().getFolder().setSelection((CTabItem)ServerFilterUsersTab.getInstance());
                ServerFilterUsersTab.getInstance().changeFPolicySelection(this.m_fp.getPolicyName());
            } else {
                ServerFilterView.getInstance().getFolder().setSelection(ServerFilterView.getInstance().getSeverFilterTab());
                ServerFilterView.getInstance().changeNotificationSelection(this.m_fp.getPolicyName());
            }
        }
    }

    public class ReloadTableAction
    extends Action {
        public ReloadTableAction() {
            super("refreshtable");
            this.setId("refreshtable");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        }

        public void run() {
            ServerFilterView.getInstance().refreshView(true);
        }
    }
}

