/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.views.ServerFilterOverviewTab;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardConditions;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ServerFilterTableProvider
extends ViewerSorter
implements IElementComparer,
IStructuredContentProvider,
Comparator {
    private ArrayList<ForwardPolicy> m_fPolicies = null;
    private String m_polType = null;
    private String column = null;
    private int dir = 128;
    public static String COL_STATUS = "Active";
    public static String COL_NAME = "Name";
    public static String COL_DESC = "Description";
    public static String COL_ATTR_FILTERS = "Attribute Filters";
    public static String COL_FCONDITIONS = "Forward Conditions";
    public static String COL_USERROLES = "UserRoles";
    public static String COL_NOTIFICATION = "Notification";
    public static int MAX_LINES = 3;
    public static String SERVER_POLICIES = "SERVER_POLICIES";
    public static String USER_POLICIES = "USER_POLICIES";
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            StringBuffer htmlStr = new StringBuffer();
            if (element instanceof ForwardPolicy) {
                ForwardPolicy fp = (ForwardPolicy)element;
                String sFilterName = fp.policyName;
                String sFilterDesc = fp.description;
                String isSFilterActive = "NOT ACTIVE";
                if (fp.isActive()) {
                    isSFilterActive = "ACTIVE";
                }
                String fFilters = ServerFilterTableProvider.this.getFFilterString(fp);
                String fConditions = ServerFilterTableProvider.this.getFConditionString(fp);
                String polType = fp.isUserPolicyValid() ? "UserFilter" : "ServerPolicy";
                String type2 = fp.isUserPolicyValid() ? "UserRole(s)" : "Notification";
                String fCondToString = ServerFilterTableProvider.this.getFCondToString(fp);
                htmlStr.append("<html><body bgcolor='#FFFFE1'>").append("  <table border='0' cellspacing='0' cellpadding='0'>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>Server Filter:&nbsp;&nbsp;</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(sFilterName).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>Status:</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(isSFilterActive).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>Type:</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(polType).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>Description:</font></td>").append("      <td nowrap ><font face='Arial' size='1' color='#000000'><b>").append(sFilterDesc).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>FFilters:</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(fFilters).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>FConditions:&nbsp;&nbsp;</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(fConditions).append("</b></font></td></tr>").append("    <tr valign='top'>").append("      <td nowrap><font face='Arial' size='1' color='#000000'>").append(type2).append(":&nbsp;&nbsp;</font></td>").append("      <td nowrap><font face='Arial' size='1' color='#000000'><b>").append(fCondToString).append("</b></font></td></tr>").append("  </table>").append("</body></html>");
            }
            return htmlStr.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            ForwardPolicy fp = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof ForwardPolicy)) {
                return;
            }
            fp = (ForwardPolicy)cell.getElement();
            String result = ServerFilterTableProvider.getText(columnIndex, fp);
            Image image = ServerFilterTableProvider.getImage(columnIndex, fp);
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public ServerFilterTableProvider(TableViewer tableViewer, String polType) {
        this.column = COL_NAME;
        this.m_polType = polType;
        this.loadFwdPolicies();
    }

    public void setSortingProps(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public void loadFwdPolicies() {
        if (this.m_polType != null) {
            if (this.m_polType.equals(USER_POLICIES)) {
                this.m_fPolicies = FPolicyManager.getInstance().getUserPolicies();
            } else if (this.m_polType.equals(SERVER_POLICIES)) {
                this.m_fPolicies = FPolicyManager.getInstance().getServerPolicies();
            }
        }
        if (this.m_fPolicies == null) {
            this.m_fPolicies = FPolicyManager.getInstance().getAllForwardPolicies();
        }
        Collections.sort(this.m_fPolicies);
    }

    public int getNumOfFwdPolicies() {
        if (this.m_fPolicies == null) {
            return 0;
        }
        return this.m_fPolicies.size();
    }

    public ForwardPolicy getFirstElement() {
        if (this.m_fPolicies != null && this.m_fPolicies.size() > 0) {
            return this.m_fPolicies.get(0);
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_polType != null) {
            if (this.m_polType.equals(SERVER_POLICIES)) {
                if (ServerFilterView.getInstance() != null && ServerFilterView.getInstance().isNew()) {
                    this.m_fPolicies.remove(ServerFilterView.getInstance().getCurrentPolicy());
                }
            } else if (this.m_polType.equals(USER_POLICIES) && ServerFilterUsersTab.getInstance() != null && ServerFilterUsersTab.getInstance().isNew()) {
                this.m_fPolicies.remove(ServerFilterUsersTab.getInstance().getCurrentPolicy());
            }
        }
        Collections.sort(this.m_fPolicies);
        return this.m_fPolicies.toArray();
    }

    public static String getText(int columnIndex, ForwardPolicy fp) {
        String result = "";
        int maxCount = 0;
        if (fp == null) {
            return result;
        }
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                result = fp.policyName;
                break;
            }
            case 2: {
                result = fp.description;
                break;
            }
            case 3: {
                Properties p = fp.getMainProperties();
                String fFiltersNumbersStr = (String)p.get(ForwardPolicy.FILTER_LIST);
                if (fFiltersNumbersStr.length() == 0) {
                    return "";
                }
                String[] fFilterNumbers = fFiltersNumbersStr.split(",");
                maxCount = fFilterNumbers.length;
                if (maxCount > MAX_LINES) {
                    maxCount = MAX_LINES;
                }
                int i = 0;
                while (i < maxCount) {
                    try {
                        int num = Integer.valueOf(fFilterNumbers[i]);
                        ForwardFilter ff = FFilterManager.getInstance().getFilter(num);
                        if (ff == null) {
                            ff = ForwardFilter.getFakeFilter(num);
                        }
                        result = String.valueOf(result) + ff.toString() + ", \n";
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++i;
                }
                if (!result.endsWith(", \n")) break;
                result = result.substring(0, result.length() - 3);
                break;
            }
            case 4: {
                ArrayList<ForwardCondition> fCondList = fp.getConditions().getConditionList();
                if (fp.isUserPolicyValid()) {
                    List<String> userRoles = fCondList.get(0).getUsersAssociated();
                    Iterator<String> it = userRoles.iterator();
                    while (it.hasNext()) {
                        String ur = it.next();
                        if (!ur.contains(UserManager.DUMMY_USERROLE)) continue;
                        it.remove();
                    }
                    String users = ServerFilterView.getSimplifiedUserString(userRoles.toString());
                    if (users.startsWith("[")) {
                        users = users.replace("[", "");
                        users = users.replace("]", "");
                    }
                    if (users.contains(",")) {
                        users = users.replace(",", "\n");
                    }
                    result = users;
                } else {
                    maxCount = fCondList.size();
                    if (maxCount > MAX_LINES) {
                        maxCount = MAX_LINES;
                    }
                    int i = 0;
                    while (i < maxCount) {
                        ForwardCondition fc = fCondList.get(i);
                        result = String.valueOf(result) + fc.name + "\n";
                        ++i;
                    }
                }
                if (!result.endsWith("\n")) break;
                result = result.substring(0, result.length() - 1);
                break;
            }
            case 5: {
                ForwardConditions fConditions2 = fp.getConditions();
                ArrayList<ForwardCondition> fCondList2 = fConditions2.getConditionList();
                maxCount = fCondList2.size();
                if (maxCount > MAX_LINES) {
                    maxCount = MAX_LINES;
                }
                int i = 0;
                while (i < maxCount) {
                    ForwardCondition fc = fCondList2.get(i);
                    result = String.valueOf(result) + fc.to + "\n";
                    ++i;
                }
                if (!result.endsWith("\n")) break;
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public static Image getImage(int columnIndex, ForwardPolicy fp) {
        Image image = null;
        switch (columnIndex) {
            case 0: {
                image = fp.isActive() ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
            }
        }
        return image;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public String getFFilterString(ForwardPolicy fp) {
        String fFilterString = "";
        List<ForwardFilter> filterList = ServerFilterView.getCurrentAttrFilters_SortedByNumber(fp);
        int i = 0;
        while (i < filterList.size()) {
            ForwardFilter ff = filterList.get(i);
            if (ff != null) {
                fFilterString = String.valueOf(fFilterString) + ff.toString() + "<br>";
            }
            ++i;
        }
        return fFilterString;
    }

    public String getFConditionString(ForwardPolicy fp) {
        String fCondString = "";
        ForwardConditions fConditions = fp.conditions;
        ArrayList<ForwardCondition> fCondList = fConditions.getConditionList();
        int i = 0;
        while (i < fCondList.size()) {
            ForwardCondition fc = fCondList.get(i);
            if (fc != null) {
                fCondString = String.valueOf(fCondString) + fc.name + "<br>";
            }
            ++i;
        }
        return fCondString;
    }

    public String getFCondToString(ForwardPolicy fp) {
        String fCondToString = "";
        if (fp.isUserPolicyValid()) {
            ForwardCondition fc = fp.getConditions().getConditionList().get(0);
            if (fc != null) {
                String users = fc.getUsersAssociated().toString();
                if ((users = ServerFilterView.getSimplifiedUserString(users)).startsWith("[")) {
                    users = users.replace("[", "");
                    users = users.replace("]", "");
                }
                fCondToString = users;
            }
        } else {
            ForwardConditions fConditions = fp.conditions;
            for (ForwardCondition fc : fConditions.getConditionList()) {
                if (fc == null) continue;
                fCondToString = String.valueOf(fCondToString) + fc.to + "<br>";
            }
        }
        return fCondToString;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object o1, Object o2) {
        int returnValue = 0;
        if (o1 instanceof ForwardPolicy && o2 instanceof ForwardPolicy) {
            ForwardPolicy fp1 = (ForwardPolicy)o1;
            ForwardPolicy fp2 = (ForwardPolicy)o2;
            String p1Str = "";
            String p2Str = "";
            int colIndex = ServerFilterOverviewTab.m_colIndices.get(this.column);
            if (colIndex > -1) {
                if (this.column.equals(COL_NAME) || this.column.equals(COL_DESC) || this.column.equals(COL_ATTR_FILTERS) || this.column.equals(COL_FCONDITIONS) || this.column.equals(COL_NOTIFICATION)) {
                    p1Str = ServerFilterTableProvider.getText(colIndex, fp1);
                    p2Str = ServerFilterTableProvider.getText(colIndex, fp2);
                    returnValue = p1Str.compareTo(p2Str);
                } else if (this.column.equals(COL_USERROLES)) {
                    p1Str = ServerFilterTableProvider.getText(colIndex, fp1);
                    p2Str = ServerFilterTableProvider.getText(colIndex, fp2);
                    if (colIndex == ServerFilterOverviewTab.m_colIndices.get(COL_USERROLES)) {
                        if (p1Str.equals(UserManager.DUMMY_USERROLE)) {
                            p1Str = "";
                        }
                        if (p2Str.equals(UserManager.DUMMY_USERROLE)) {
                            p2Str = "";
                        }
                    }
                    returnValue = p1Str.compareTo(p2Str);
                } else if (this.column.equals(COL_STATUS)) {
                    boolean r2;
                    boolean r1 = fp1.isActive();
                    boolean bl = r2 = fp2.isActive();
                    if (r1 < r2) {
                        returnValue = -1;
                    }
                    if (r1 > r2) {
                        returnValue = 1;
                    }
                    if (r1 == r2) {
                        returnValue = 0;
                    }
                }
            }
            if (this.dir == 1024) {
                returnValue *= -1;
            }
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof GroupTreeObjectLast && b instanceof GroupTreeObjectLast) {
            return a == null ? b == null : ((GroupTreeObjectLast)a).getName().equals(((GroupTreeObjectLast)b).getName());
        }
        if (a instanceof ForwardPolicy && b instanceof ForwardPolicy) {
            return a == null ? b == null : ((ForwardPolicy)a).getPolicyName().equals(((ForwardPolicy)b).getPolicyName());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof GroupTreeObjectLast) {
            return ((GroupTreeObjectLast)element).getName().hashCode();
        }
        return element.hashCode();
    }

    public void dispose() {
    }
}

