/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.NotificationSaveDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.utils.BGridLayout;
import com.blixx.boom.gui.utils.FilterComposite_ServerFilterUserTab;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.UserRoleTableFilter;
import com.blixx.boom.gui.views.ServerFilterTableProvider;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.boom.gui.views.actions.DeleteServerFilterAction;
import com.blixx.boom.gui.views.actions.EditAttributeFilterAction;
import com.blixx.boom.gui.views.actions.LinkAttributeFilterAction;
import com.blixx.boom.gui.views.actions.SelectUsersAction;
import com.blixx.boom.gui.views.actions.UnlinkAttributeFilterAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.space.GCube;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class ServerFilterUsersTab
extends CTabItem
implements SelectionListener,
ModifyListener,
ISelectionProvider {
    public ServerFilterView m_sfv = null;
    private static ServerFilterUsersTab m_instance = null;
    private CTabFolder m_folder = null;
    public CTabFolder m_parent = null;
    private boolean m_isDirty = false;
    private boolean m_isNew = false;
    private boolean m_isPolSectionEnabled = true;
    private FPolicyManager m_fPolicyManager = null;
    private ArrayList<UserRoleTableFilter> m_userRoleFilters = new ArrayList();
    private ForwardPolicy m_currentPolicy = null;
    private String m_origPolicyName = null;
    private boolean m_isValidPolName = true;
    private GUIDisplayElements m_gui = null;
    private CTabItem m_tabPolDetails = null;
    private ServerFilterTableProvider m_userFilter_tblProvider = null;
    private Table m_userFilter_tbl = null;
    private TableViewer m_userFilter_tv = null;
    private org.eclipse.swt.widgets.List m_attrFilterList = null;
    private org.eclipse.swt.widgets.List m_userRoleList = null;
    private Text m_polName_field = null;
    private Text m_desc_field = null;
    private Text m_activate_field = null;
    private Text m_deactivate_field = null;
    private Text m_polCounter_label = null;
    private Composite m_counter_comp = null;
    private Button m_addLink_attrFilter_btn = null;
    public Button m_unlink_attrFilter_btn = null;
    private Button m_active_chk = null;
    private Button m_unknown_chk = null;
    private Button m_normal_chk = null;
    private Button m_warn_chk = null;
    private Button m_minor_chk = null;
    private Button m_major_chk = null;
    private Button m_critical_chk = null;
    private Button m_typeA_chk = null;
    private Button m_typeK_chk = null;
    private Button m_reloadView_btn = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_del_btn = null;
    private Button m_selectUser_button = null;
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String ACTIVE = "ACTIVE";
    public static final String ACTIVATION_TIME = "ACTIVATION_TIME";
    public static final String DEACTIVATION_TIME = "DEACTIVATION_TIME";
    public static final String TYPE_A = "TYPE_A";
    public static final String TYPE_K = "TYPE_K";
    public static final String USER_ROLE_LIST = "USER_ROLE_LIST";
    public static final String SELECT_USER_BUTTON = "SELECT_USER_BUTTON";
    public static final String USERS = "USERS";
    public static final String USER_FILTER_TAB = "USER_FILTER_TAB";
    public static final String SAVE_BUTTON = "SAVE_BUTTON";
    public static final String UNDO_BUTTON = "UNDO_BUTTON";
    public static final String DELETE_BUTTON = "DELETE_BUTTON";
    public static final String NEW_BUTTON = "NEW_BUTTON";
    public static final String FP = "FP";
    public static final String USER_FILTER_TABLE = "USER_FILTER_TABLE";
    private GCube m_gcube = null;
    private Graph m_graph = null;

    public ServerFilterUsersTab(CTabFolder parent, ServerFilterView sfView) {
        super(parent, 0, 3);
        this.setText("User Filters");
        this.setImage(BMUI.IMAGE_FWD);
        this.setData(USER_FILTER_TAB);
        m_instance = this;
        this.m_parent = parent;
        this.m_folder = parent;
        this.m_sfv = sfView;
        this.m_fPolicyManager = FPolicyManager.getInstance();
        this.m_gui = new GUIDisplayElements();
        this.createMainArea();
    }

    public static ServerFilterUsersTab getInstance() {
        return m_instance;
    }

    public void createMainArea() {
        Composite compInFolder = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        compInFolder.setLayout((Layout)gl);
        compInFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(compInFolder, 768);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 20;
        sc.setLayout((Layout)gl);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite compMain = new Composite((Composite)sc, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        compMain.setLayout((Layout)gl);
        compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_reloadView_btn = this.m_gui.addButton(compMain, ServerFilterView.RELOAD_VIEW_BUTTON, "Reload  ", true, 60, 0, 10, this);
        ((GridData)this.m_reloadView_btn.getLayoutData()).horizontalIndent = 5;
        this.m_reloadView_btn.setImage(BMUI.IMAGE_REFRESH);
        this.createTopFilterSection(compMain);
        SashForm sash = new SashForm(compMain, 256);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        sash.setLayout((Layout)gl);
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createUserFilterTable((Composite)sash);
        this.createUserFilterDetails(sash);
        this.createMapSection(compMain);
        this.createButtonSection(compInFolder);
        sash.setWeights(new int[]{1, 3});
        sc.setContent((Control)compMain);
        sc.setMinSize(compMain.computeSize(-1, -1, true));
        this.setControl((Control)compInFolder);
    }

    public void createTopFilterSection(Composite parent) {
        Group filterGroup = new Group(parent, 0);
        filterGroup.setText(" Filter on UserGroup ");
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        filterGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 128, true, false);
        gd.minimumWidth = 120;
        filterGroup.setLayoutData((Object)gd);
        FilterComposite_ServerFilterUserTab filterComp = new FilterComposite_ServerFilterUserTab((Composite)filterGroup, this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
    }

    public void createUserFilterTable(Composite sash) {
        Composite comp = new Composite(sash, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite table_comp = new Composite(comp, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        table_comp.setLayout((Layout)gl);
        table_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_userFilter_tbl = new Table(table_comp, 268503812);
        this.m_userFilter_tbl.setData((Object)USER_FILTER_TABLE);
        this.m_userFilter_tbl.setHeaderVisible(true);
        this.m_userFilter_tbl.setLinesVisible(true);
        this.m_userFilter_tbl.setLayout((Layout)gl);
        this.m_userFilter_tbl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_userFilter_tbl.addSelectionListener((SelectionListener)this);
        this.m_userFilter_tv = new TableViewer(this.m_userFilter_tbl);
        this.m_userFilter_tblProvider = new ServerFilterTableProvider(this.m_userFilter_tv, ServerFilterTableProvider.USER_POLICIES);
        TableViewerColumn tv_col0 = new TableViewerColumn(this.m_userFilter_tv, 0);
        tv_col0.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col0 = tv_col0.getColumn();
        col0.setText(ServerFilterTableProvider.COL_STATUS);
        col0.setWidth(25);
        TableViewerColumn tv_col1 = new TableViewerColumn(this.m_userFilter_tv, 0);
        tv_col1.setLabelProvider(this.m_userFilter_tblProvider.labelProvider);
        TableColumn col1 = tv_col1.getColumn();
        col1.setText(ServerFilterTableProvider.COL_NAME);
        col1.setWidth(130);
        TableColumnLayout tableLayout = new TableColumnLayout();
        table_comp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(100, col1.getWidth()));
        this.m_userFilter_tv.setContentProvider((IContentProvider)this.m_userFilter_tblProvider);
        this.createCM_userFilterTable(this.m_userFilter_tv);
        this.m_counter_comp = new Composite(comp, 0);
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_counter_comp.setLayout((Layout)gl);
        this.m_counter_comp.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.m_polCounter_label = this.m_gui.addTextReadOnlyNoBorder(this.m_counter_comp, "Total: ", "" + this.m_userFilter_tblProvider.getNumOfFwdPolicies(), 1, 1, 0, 0, null);
        this.m_polCounter_label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public void createCM_userFilterTable(TableViewer tv) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tv.getControl());
        tv.getControl().setMenu(menu);
        IWorkbenchPartSite site = ServerFilterView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    ArrayList<ForwardPolicy> selItems = new ArrayList<ForwardPolicy>();
                    StructuredSelection ssel = (StructuredSelection)ServerFilterUsersTab.this.m_userFilter_tv.getSelection();
                    if (!ssel.isEmpty()) {
                        for (Object o : ssel) {
                            if (o == null || !(o instanceof ForwardPolicy)) continue;
                            selItems.add((ForwardPolicy)o);
                        }
                    }
                    manager.add((IAction)new DeleteServerFilterAction(ServerFilterUsersTab.this.m_userFilter_tv, selItems, ServerFilterUsersTab.USERS));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createUserFilterDetails(SashForm sash) {
        Composite rightFrame = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        rightFrame.setLayout((Layout)gl);
        CTabFolder m_uFilterFolder = new CTabFolder(rightFrame, 768);
        m_uFilterFolder.setSimple(true);
        m_uFilterFolder.setBorderVisible(false);
        m_uFilterFolder.setBackground(BMUI.color_unknown);
        m_uFilterFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tabPolDetails = new CTabItem(m_uFilterFolder, 0);
        this.m_tabPolDetails.setText("");
        Composite compInFolder = new Composite((Composite)m_uFilterFolder, 0);
        compInFolder.setLayout((Layout)new GridLayout(2, false));
        compInFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Group comp_details = new Group(compInFolder, 0);
        comp_details.setText("Details");
        comp_details.setLayout((Layout)new GridLayout(2, false));
        comp_details.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_polName_field = this.m_gui.addInputFieldSingle((Composite)comp_details, NAME, "Name: ", "", 1, 1, 1, 0, 40, this);
        ((GridData)this.m_polName_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_polName_field.getLayoutData()).grabExcessHorizontalSpace = true;
        if (!this.m_isNew) {
            this.m_gui.setEditable(this.m_polName_field, false);
            this.m_gui.enableField(this.m_polName_field, false);
            this.m_polName_field.getMenu().setEnabled(false);
        }
        this.m_desc_field = this.m_gui.addInputFieldMultiLine((Composite)comp_details, DESCRIPTION, "Description: ", "", 1, 1, 80, 40, 1, 0, this);
        ((GridData)this.m_desc_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_desc_field.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_active_chk = this.m_gui.addCheckbox((Composite)comp_details, ACTIVE, "active", false, 2, 1, 0, this);
        this.m_gui.addTextField((Composite)comp_details, null, "Activated: ", 1, 1, 0, 1, null);
        Composite comp_activated = new Composite((Composite)comp_details, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp_activated.setLayout((Layout)gl);
        comp_activated.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.m_activate_field = this.m_gui.addInputFieldSingle(comp_activated, ACTIVATION_TIME, null, "", 1, 1, 1, 0, 35, this);
        this.m_activate_field.setTextLimit(5);
        ((GridData)this.m_activate_field.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_activate_field.getLayoutData()).grabExcessHorizontalSpace = true;
        Label l = this.m_gui.addTextField(comp_activated, null, "(hh:mm)", 1, 1, 0, 1, null);
        ((GridData)l.getLayoutData()).horizontalAlignment = 16384;
        this.m_typeA_chk = this.m_gui.addCheckbox(comp_activated, TYPE_A, "Availability Metric", false, 1, 1, 0, this);
        ((GridData)this.m_typeA_chk.getLayoutData()).horizontalIndent = 20;
        this.m_gui.addTextField((Composite)comp_details, null, "Deactivated: ", 1, 1, 0, 1, null);
        Composite comp_deactivated = new Composite((Composite)comp_details, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp_deactivated.setLayout((Layout)gl);
        comp_deactivated.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.m_deactivate_field = this.m_gui.addInputFieldSingle(comp_deactivated, DEACTIVATION_TIME, null, "", 1, 1, 10, 0, 35, this);
        this.m_deactivate_field.setTextLimit(5);
        ((GridData)this.m_deactivate_field.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_deactivate_field.getLayoutData()).grabExcessHorizontalSpace = true;
        l = this.m_gui.addTextField(comp_deactivated, null, "(hh:mm)", 1, 1, 0, 1, null);
        ((GridData)l.getLayoutData()).horizontalAlignment = 16384;
        this.m_typeK_chk = this.m_gui.addCheckbox(comp_deactivated, TYPE_K, "KPI Metric", false, 1, 1, 0, this);
        ((GridData)this.m_typeK_chk.getLayoutData()).horizontalIndent = 20;
        Composite comp_type_left = new Composite((Composite)comp_details, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        comp_type_left.setLayout((Layout)gl);
        comp_type_left.setLayoutData((Object)new GridData(16384, 128, false, false));
        l = this.m_gui.addTextField(comp_type_left, null, "UserRoles: ", 1, 1, 3, 1, null);
        ((GridData)l.getLayoutData()).verticalAlignment = 128;
        Composite comp_type_right = new Composite((Composite)comp_details, 0);
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        comp_type_right.setLayout((Layout)gl);
        comp_type_right.setLayoutData((Object)new GridData(4, 4, false, true));
        this.m_userRoleList = new org.eclipse.swt.widgets.List(comp_type_right, 2818);
        this.m_userRoleList.setData((Object)USER_ROLE_LIST);
        this.m_userRoleList.setEnabled(false);
        GridData gd = new GridData(4, 4, false, true, 1, 2);
        gd.widthHint = 170;
        this.m_userRoleList.setLayoutData((Object)gd);
        Group severityComp2 = new Group((Composite)comp_details, 0);
        severityComp2.setText("Severities");
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 10;
        severityComp2.setLayout((Layout)gl);
        severityComp2.setLayoutData((Object)new GridData(1, 4, false, false, 2, 1));
        this.m_unknown_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_UNKNOWN", "unknown", false, 1, 1, 0, BMUI.IMAGE_UNKNOWN, this);
        this.m_normal_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_NORMAL", "normal", false, 1, 1, 0, BMUI.IMAGE_NORMAL, this);
        this.m_warn_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_WARNING", "warning", false, 1, 1, 0, BMUI.IMAGE_WARNING, this);
        this.m_minor_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_MINOR", "minor", false, 1, 1, 0, BMUI.IMAGE_MINOR, this);
        this.m_major_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_MAJOR", "major", false, 1, 1, 0, BMUI.IMAGE_MAJOR, this);
        this.m_critical_chk = this.m_gui.addCheckbox((Composite)severityComp2, "SELECT_CRITICAL", "critical", false, 1, 1, 0, BMUI.IMAGE_CRITICAL, this);
        Group attrFilter_grp = new Group(compInFolder, 0);
        attrFilter_grp.setText("Attribute Filters");
        attrFilter_grp.setLayout((Layout)new GridLayout(2, false));
        attrFilter_grp.setLayoutData((Object)new GridData(4, 4, false, true));
        this.m_attrFilterList = new org.eclipse.swt.widgets.List((Composite)attrFilter_grp, 2818);
        this.m_attrFilterList.setData((Object)"ATTR_FILTER_LIST");
        gd = new GridData(16384, 4, true, true, 1, 2);
        gd.widthHint = 200;
        this.m_attrFilterList.setLayoutData((Object)gd);
        ListViewer listViewer = new ListViewer(this.m_attrFilterList);
        this.createCM_attrFilterList(listViewer);
        this.m_attrFilterList.addSelectionListener((SelectionListener)this);
        this.m_attrFilterList.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String[] selection = ServerFilterUsersTab.this.m_attrFilterList.getSelection();
                if (selection.length > 0) {
                    ServerFilterUsersTab.this.m_gui.enableField(ServerFilterUsersTab.this.m_unlink_attrFilter_btn, true);
                } else {
                    ServerFilterUsersTab.this.m_gui.enableField(ServerFilterUsersTab.this.m_unlink_attrFilter_btn, false);
                }
            }
        });
        this.m_attrFilterList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.getSource() instanceof org.eclipse.swt.widgets.List) {
                    String[] selection = ServerFilterUsersTab.this.m_attrFilterList.getSelection();
                    ForwardFilter ff = ServerFilterView.getAttrFilter(selection[0]);
                    TableItem[] items = ServerFilterUsersTab.this.m_sfv.m_attrFilter_tv.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        ForwardFilter f = (ForwardFilter)items[i].getData();
                        if (ff.getNumber().equals(f.getNumber())) {
                            EditAttributeFilterAction edit = new EditAttributeFilterAction(ServerFilterUsersTab.this.m_sfv, ff, null);
                            edit.run();
                            return;
                        }
                        ++i;
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.m_addLink_attrFilter_btn = this.m_gui.addButton((Composite)attrFilter_grp, "ADDLINK_ATTR_FILTER_BTN", "Add", true, this);
        this.m_addLink_attrFilter_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_unlink_attrFilter_btn = this.m_gui.addButton((Composite)attrFilter_grp, "UNLINK_ATTR_FILTER_BTN", " Remove ", false, this);
        this.m_unlink_attrFilter_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_tabPolDetails.setControl((Control)compInFolder);
        m_uFilterFolder.setSelection(this.m_tabPolDetails);
    }

    public void createCM_attrFilterList(ListViewer listViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(listViewer.getControl());
        listViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = ServerFilterView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)listViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new LinkAttributeFilterAction((Object)m_instance, ServerFilterUsersTab.USERS));
                    manager.add((IAction)new UnlinkAttributeFilterAction((Object)m_instance, ServerFilterUsersTab.this.m_attrFilterList.getSelection(), ServerFilterUsersTab.USERS));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createMapSection(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("Map");
        Composite comp = new Composite((Composite)folder, 2048);
        comp.setLayout((Layout)new FillLayout());
        tab.setControl((Control)comp);
        folder.setSelection(tab);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        folder.setLayoutData((Object)gd);
        this.m_gcube = this.m_fPolicyManager.getCube();
        this.m_graph = new Graph(comp, 0);
        GraphUtils.initGraphOrig(this.m_graph, this.m_gcube);
        BGridLayout layout = new BGridLayout(this.m_graph, 1);
        this.m_graph.setLayoutAlgorithm((LayoutAlgorithm)layout, true);
        this.m_graph.setConnectionStyle(2);
        this.m_graph.addSelectionListener(this);
        this.m_graph.setPreferredSize(400, 200);
        this.addContentMenu();
    }

    public void addContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.m_graph);
        this.m_graph.setMenu(menu);
        this.m_sfv.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Refresh";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCR_REFRESH;
                        }

                        public void run() {
                            ServerFilterUsersTab.this.refreshGraph();
                        }
                    });
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void createButtonSection(Composite parent) {
        Composite compLine = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 10;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Composite compBtn = new Composite(parent, 0);
        gl = new GridLayout(4, true);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.marginBottom = 5;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(16384, 4, false, false, 4, 1));
        this.m_save_btn = this.m_gui.addButton(compBtn, SAVE_BUTTON, "Save User Filter", false, this);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_undo_btn = this.m_gui.addButton(compBtn, UNDO_BUTTON, "Undo Changes", false, this);
        this.m_undo_btn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_del_btn = this.m_gui.addButton(compBtn, DELETE_BUTTON, " Delete User Filter ", true, this);
        this.m_del_btn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
    }

    public void filterByUserRole(String filterText) {
        this.m_userRoleFilters.clear();
        if (filterText == null || filterText.length() == 0) {
            this.updateTable();
        } else {
            UserRoleTableFilter filter = new UserRoleTableFilter(filterText);
            this.m_userRoleFilters.add(filter);
            this.updateTable();
        }
    }

    public void updateTable() {
        if (this.m_userRoleFilters.size() == 0) {
            this.m_userFilter_tv.resetFilters();
        } else {
            UserRoleTableFilter filter = this.m_userRoleFilters.get(0);
            ViewerFilter[] filters = new ViewerFilter[]{filter};
            this.m_userFilter_tv.resetFilters();
            this.m_userFilter_tv.setFilters(filters);
        }
    }

    public void refreshUserFilterTab(boolean loadPolicies, ForwardPolicy fp, boolean updatePolList, Integer selIndex, boolean refreshGraph) {
        ForwardPolicy unsavedUserFilter = null;
        if (this.isDirty() && this.m_currentPolicy != null) {
            unsavedUserFilter = ForwardPolicy.getDuplicate(this.m_currentPolicy);
        }
        if (loadPolicies) {
            this.m_sfv.loadFPolicies();
        }
        this.m_sfv.getOverviewTab().refreshTables();
        ArrayList<ForwardPolicy> fPolicies = this.m_fPolicyManager.getUserPolicies();
        if (fPolicies != null && fPolicies.size() > 0) {
            if (fp != null && fp.isUserPolicyValid() && fPolicies.contains(fp)) {
                this.m_currentPolicy = this.m_fPolicyManager.getFPolicyByName(fp.getPolicyName());
                this.m_origPolicyName = fp.getPolicyName();
            } else if (this.m_currentPolicy != null) {
                this.m_currentPolicy = this.m_fPolicyManager.getFPolicyByName(this.m_origPolicyName);
            }
            if (updatePolList) {
                this.updateUserFilterList();
            }
            if (this.m_currentPolicy != null && selIndex != null) {
                this.m_currentPolicy = (ForwardPolicy)this.m_userFilter_tv.getElementAt(selIndex.intValue());
                this.m_origPolicyName = this.m_currentPolicy.getPolicyName();
            } else if (this.m_currentPolicy == null) {
                this.m_currentPolicy = this.m_userFilter_tblProvider.getFirstElement();
                this.m_origPolicyName = this.m_currentPolicy.getPolicyName();
            }
            if (this.isDirty()) {
                this.m_currentPolicy = unsavedUserFilter;
            }
            this.setUserFilterSelection(this.m_currentPolicy);
            this.updateUserFilterDetails(this.m_currentPolicy);
            if (unsavedUserFilter != null) {
                this.setDirty(true);
            } else {
                this.setDirty(false);
            }
        } else {
            this.activatePolicySection(false);
        }
        if (refreshGraph) {
            this.refreshGraph();
        }
    }

    public void refreshGraph() {
        this.m_gcube.clear();
        this.m_graph.clean();
        this.m_gcube = this.m_fPolicyManager.getCube();
        GraphUtils.initGraphOrig(this.m_graph, this.m_gcube);
        this.m_graph.applyLayout();
    }

    public String getOriginalPolName() {
        return this.m_origPolicyName;
    }

    public void checkAttrFilter_btnStatus() {
        if (this.m_attrFilterList.getSelectionCount() > 0) {
            this.m_gui.enableField(this.m_unlink_attrFilter_btn, true);
        } else {
            this.m_gui.enableField(this.m_unlink_attrFilter_btn, false);
        }
    }

    public void checkUserFilter_btnStatus() {
        if (this.isDirty()) {
            this.m_gui.enableField(this.m_save_btn, this.m_isValidPolName);
            if (this.isNew()) {
                this.m_gui.enableField(this.m_undo_btn, false);
            } else {
                this.m_gui.enableField(this.m_undo_btn, this.isDirty());
            }
        } else {
            this.m_gui.enableField(this.m_save_btn, false);
            this.m_gui.enableField(this.m_undo_btn, false);
        }
    }

    public void updateUserFilterList() {
        this.m_userFilter_tblProvider.loadFwdPolicies();
        this.m_userFilter_tv.setInput((Object)this.m_userFilter_tblProvider.getElements(null));
        this.m_userFilter_tv.refresh(true);
        if (this.isNew() && this.m_userFilter_tbl.getItemCount() > 0) {
            this.m_userFilter_tbl.select(0);
            this.m_currentPolicy = (ForwardPolicy)this.m_userFilter_tv.getElementAt(0);
        }
        this.updateCounter();
    }

    public void updateCounter() {
        if (this.m_polCounter_label != null && !this.m_polCounter_label.isDisposed()) {
            this.m_polCounter_label.setText("" + this.m_userFilter_tblProvider.getNumOfFwdPolicies());
            this.m_counter_comp.layout(true);
        }
    }

    public void setUserFilterSelection(ForwardPolicy fp2Select) {
        this.m_userFilter_tv.setSelection((ISelection)new StructuredSelection((Object)fp2Select));
        int i = 0;
        while (i < this.m_userFilter_tbl.getItemCount()) {
            TableItem item = this.m_userFilter_tbl.getItem(i);
            ForwardPolicy fp_exist = (ForwardPolicy)item.getData();
            if (fp_exist != null && fp_exist.policyName.equals(fp2Select.getPolicyName())) {
                this.m_userFilter_tbl.select(i);
                return;
            }
            ++i;
        }
    }

    public void updateUserFilterDetails(ForwardPolicy fp) {
        this.m_tabPolDetails.setText(fp.policyName);
        if (fp.isActive()) {
            this.m_tabPolDetails.setImage(BMUI.IMAGE_ACCEPT_GREEN);
        } else {
            this.m_tabPolDetails.setImage(BMUI.IMAGE_CANCEL_ROUND);
        }
        this.updateAttrFilterList(fp);
        this.m_polName_field.setText(fp.policyName);
        this.m_polName_field.setBackground(BMUI.defaultBackground);
        if (this.isNew()) {
            this.m_gui.setEditable(this.m_polName_field, true);
            this.m_gui.enableField(this.m_polName_field, true);
        } else {
            this.m_gui.setEditable(this.m_polName_field, false);
            this.m_gui.enableField(this.m_polName_field, false);
        }
        this.m_active_chk.setSelection(fp.isActive());
        this.m_desc_field.setText(fp.description);
        ForwardCondition fc = null;
        try {
            fc = fp.getConditions().getConditionList().get(0);
            this.m_activate_field.setText(fc.activation_time);
            this.m_deactivate_field.setText(fc.deactivation_time);
            this.updateUserRoleList(fp);
            this.m_typeA_chk.setSelection(false);
            if (fc.type_a == 1) {
                this.m_typeA_chk.setSelection(true);
            }
            this.m_typeK_chk.setSelection(false);
            if (fc.type_k == 1) {
                this.m_typeK_chk.setSelection(true);
            }
            String sevText = fc.severity;
            boolean isAll = sevText.equals("<*>");
            this.m_unknown_chk.setSelection(sevText.indexOf("0") != -1 | isAll);
            this.m_normal_chk.setSelection(sevText.indexOf("1") != -1 | isAll);
            this.m_warn_chk.setSelection(sevText.indexOf("2") != -1 | isAll);
            this.m_minor_chk.setSelection(sevText.indexOf("3") != -1 | isAll);
            this.m_major_chk.setSelection(sevText.indexOf("4") != -1 | isAll);
            this.m_critical_chk.setSelection(sevText.indexOf("5") != -1 | isAll);
        }
        catch (Exception exception) {
            fc = fp.addNewCondition();
            fc.type = USERS;
            this.m_activate_field.setText("");
            this.m_deactivate_field.setText("");
            this.m_userRoleList.removeAll();
            this.m_typeA_chk.setSelection(false);
            this.m_typeK_chk.setSelection(false);
            this.m_unknown_chk.setSelection(false);
            this.m_normal_chk.setSelection(false);
            this.m_warn_chk.setSelection(false);
            this.m_minor_chk.setSelection(false);
            this.m_major_chk.setSelection(false);
            this.m_critical_chk.setSelection(false);
        }
    }

    public void updateAttrFilterList(ForwardPolicy fp) {
        this.m_attrFilterList.removeAll();
        List<ForwardFilter> filters = ServerFilterView.getCurrentAttrFilters_SortedByNumber(fp);
        int i = 0;
        while (i < filters.size()) {
            ForwardFilter ff = filters.get(i);
            Properties p = ff.getProperties();
            this.m_attrFilterList.add("(" + ff.getNumber() + ") " + p.getProperty(NAME));
            ++i;
        }
    }

    public void updateUserRoleList(ForwardPolicy fp) {
        this.m_userRoleList.removeAll();
        if (fp != null) {
            List<String> userRoles = fp.getConditions().getConditionList().get(0).getUsersAssociated();
            Collections.sort(userRoles);
            for (String userRole : userRoles) {
                String ur = ServerFilterView.getSimplifiedUserString(userRole.trim());
                if (ur == null || ur.length() <= 0 || ur.equals(UserManager.DUMMY_USERROLE)) continue;
                this.m_userRoleList.add(ur);
            }
        }
    }

    public void updateUserRoleList(String userRolesAsString) {
        this.m_userRoleList.removeAll();
        String[] split = userRolesAsString.split(",");
        List<String> currentUserRoles = Arrays.asList(split);
        Collections.sort(currentUserRoles);
        for (String userRole : currentUserRoles) {
            String ur = ServerFilterView.getSimplifiedUserString(userRole.trim());
            if (ur == null || ur.length() <= 0 || ur.equals(UserManager.DUMMY_USERROLE)) continue;
            this.m_userRoleList.add(ur);
        }
        if (this.m_userRoleList.getItemCount() == 0) {
            this.m_userRoleList.setBackground(BMUI.color_critical);
        } else {
            this.m_userRoleList.setBackground(BMUI.color_white);
        }
    }

    public void setDirty(boolean b) {
        this.m_isDirty = b;
        if (!b) {
            this.setNew(false);
        }
        this.checkUserFilter_btnStatus();
        if (!this.m_tabPolDetails.getText().startsWith("*") && b) {
            this.m_tabPolDetails.setText("* " + this.m_tabPolDetails.getText());
        } else if (this.m_tabPolDetails.getText().startsWith("*") && !b) {
            this.m_tabPolDetails.setText(this.m_currentPolicy.policyName);
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setNew(boolean b) {
        this.m_isNew = b;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public boolean isPolSectionEnabled() {
        return this.m_isPolSectionEnabled;
    }

    public void changeFPolicySelection(String selPolName) {
        ForwardPolicy newSelectedPolicy = this.m_fPolicyManager.getFPolicyByName(selPolName);
        if (newSelectedPolicy == null) {
            this.m_currentPolicy = null;
            this.m_origPolicyName = null;
            this.refreshUserFilterTab(true, null, true, null, false);
            return;
        }
        if (this.isDirty()) {
            NotificationSaveDialog dialog = new NotificationSaveDialog(this.m_folder.getShell(), this.m_currentPolicy);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getActionType().equals(NotificationSaveDialog.YES)) {
                boolean saved = this.saveFPolicy();
                if (saved) {
                    this.refreshUserFilterTab(true, newSelectedPolicy, true, null, true);
                }
            } else if (dialog.getActionType().equals(NotificationSaveDialog.NO)) {
                ForwardPolicy pol2select = this.m_fPolicyManager.getFPolicyByName(selPolName);
                this.refreshUserFilterTab(false, pol2select, false, null, true);
            } else if (dialog.getActionType().equals(NotificationSaveDialog.CANCEL)) {
                int i = 0;
                while (i < this.m_userFilter_tbl.getItemCount()) {
                    TableItem item = this.m_userFilter_tbl.getItem(i);
                    ForwardPolicy fp = (ForwardPolicy)item.getData();
                    if (fp != null && (fp.policyName.equals(this.m_currentPolicy.getPolicyName()) || fp.policyName.equals(this.m_origPolicyName))) {
                        this.m_userFilter_tbl.select(i);
                        return;
                    }
                    ++i;
                }
            }
        } else {
            this.refreshUserFilterTab(false, newSelectedPolicy, false, null, false);
        }
        this.m_unlink_attrFilter_btn.setEnabled(false);
    }

    public ForwardPolicy getCurrentPolicy() {
        return this.m_currentPolicy;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_gui.setEditable(this.m_desc_field, !readOnly);
        this.m_gui.setEditable(this.m_active_chk, !readOnly);
        this.m_gui.setEditable(this.m_activate_field, !readOnly);
        this.m_gui.setEditable(this.m_typeA_chk, !readOnly);
        this.m_gui.setEditable(this.m_deactivate_field, !readOnly);
        this.m_gui.setEditable(this.m_typeK_chk, !readOnly);
        this.m_gui.enableField(this.m_selectUser_button, !readOnly);
        this.m_gui.setEditable(this.m_unknown_chk, !readOnly);
        this.m_gui.setEditable(this.m_normal_chk, !readOnly);
        this.m_gui.setEditable(this.m_warn_chk, !readOnly);
        this.m_gui.setEditable(this.m_minor_chk, !readOnly);
        this.m_gui.setEditable(this.m_major_chk, !readOnly);
        this.m_gui.setEditable(this.m_critical_chk, !readOnly);
        this.m_gui.enableField(this.m_addLink_attrFilter_btn, !readOnly);
        this.m_gui.enableField(this.m_unlink_attrFilter_btn, !readOnly);
        this.m_gui.enableField(this.m_save_btn, !readOnly);
        this.m_gui.enableField(this.m_undo_btn, !readOnly);
        this.m_gui.enableField(this.m_del_btn, !readOnly);
    }

    public void activatePolicySection(boolean activate) {
        this.m_isPolSectionEnabled = activate;
        this.m_gui.enableField(this.m_attrFilterList, activate);
        this.m_gui.enableField(this.m_userFilter_tv, activate);
        this.m_gui.enableField(this.m_userFilter_tbl, activate);
        this.m_gui.enableField(this.m_polName_field, activate);
        this.m_gui.enableField(this.m_userRoleList, activate);
        this.setReadOnly(activate);
        if (!activate) {
            this.setDirty(false);
        }
    }

    public void newFPolicy(String userRoleName) {
        NewUserPolicyAction newPolAction = new NewUserPolicyAction(userRoleName);
        newPolAction.run();
    }

    public void deleteFPolicy() {
        this.m_currentPolicy.setPolicyName(this.m_origPolicyName);
        ArrayList<ForwardPolicy> selItems = new ArrayList<ForwardPolicy>();
        selItems.add(this.m_currentPolicy);
        DeleteServerFilterAction delAction = new DeleteServerFilterAction(this.m_userFilter_tv, selItems, USERS);
        delAction.run();
    }

    public boolean saveFPolicy() {
        SaveFPolicyAction saveAction = new SaveFPolicyAction();
        saveAction.run();
        boolean hasSaved = saveAction.hasSaved();
        if (hasSaved) {
            this.setDirty(false);
        }
        return hasSaved;
    }

    public void undoChanges() {
        this.m_sfv.loadFPolicies();
        ForwardPolicy fp_orig = this.m_fPolicyManager.getFPolicyByName(this.m_origPolicyName);
        if (fp_orig != null) {
            this.setDirty(false);
            this.changeFPolicySelection(this.m_origPolicyName);
        } else {
            this.m_currentPolicy = null;
            this.m_origPolicyName = null;
            this.refreshUserFilterTab(false, null, true, null, true);
            if (this.m_currentPolicy.getPolicyName().length() == 0 || new NameValidatorFile().isValid(this.m_currentPolicy.getPolicyName()) != null || this.m_sfv.isDuplicate(FP, this.m_currentPolicy, this.m_currentPolicy.getPolicyName())) {
                this.m_isValidPolName = false;
                this.m_polName_field.setBackground(BMUI.color_critical);
            } else {
                this.m_polName_field.setBackground(BMUI.defaultBackground);
                this.m_isValidPolName = true;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            String name = (String)field.getData();
            String value = field.getText().trim();
            ForwardCondition currCondition = this.m_currentPolicy.getConditions().getConditionList().get(0);
            if (name.equals(NAME)) {
                String newName = this.m_polName_field.getText().trim();
                if (newName.length() == 0 || new NameValidatorFile().isValid(newName) != null || this.m_sfv.isDuplicate(FP, this.m_currentPolicy, newName)) {
                    this.m_isValidPolName = false;
                    this.m_polName_field.setBackground(BMUI.color_critical);
                } else {
                    this.m_polName_field.setBackground(BMUI.defaultBackground);
                    this.m_currentPolicy.policyName = newName;
                    this.m_isValidPolName = true;
                }
            } else if (name.equals(DESCRIPTION)) {
                this.m_currentPolicy.description = this.m_desc_field.getText().trim();
            } else if (name.equals(ACTIVATION_TIME)) {
                String timeStr = value;
                boolean isValid = ServerFilterView.validTimeFormat(timeStr);
                if (isValid) {
                    this.m_activate_field.setBackground(BMUI.defaultBackground);
                    currCondition.activation_time = timeStr;
                } else {
                    this.m_activate_field.setBackground(BMUI.color_critical);
                }
            } else if (name.equals(DEACTIVATION_TIME)) {
                String timeStr = value;
                boolean isValid = ServerFilterView.validTimeFormat(timeStr);
                if (isValid) {
                    this.m_deactivate_field.setBackground(BMUI.defaultBackground);
                    currCondition.deactivation_time = timeStr;
                } else {
                    this.m_deactivate_field.setBackground(BMUI.color_critical);
                }
            }
            this.setDirty(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        block27: {
            block29: {
                String name;
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        ForwardCondition current_fc;
                                        block32: {
                                            block31: {
                                                block30: {
                                                    Object obj;
                                                    block28: {
                                                        block26: {
                                                            ForwardPolicy fp;
                                                            StructuredSelection sel;
                                                            obj = e.getSource();
                                                            if (!(obj instanceof Table)) break block26;
                                                            Table tbl = (Table)e.getSource();
                                                            String name2 = (String)tbl.getData();
                                                            if (name2.equals(USER_FILTER_TABLE) && !(sel = (StructuredSelection)this.m_userFilter_tv.getSelection()).isEmpty() && (fp = (ForwardPolicy)sel.getFirstElement()) != this.m_currentPolicy) {
                                                                this.changeFPolicySelection(fp.getPolicyName());
                                                            }
                                                            break block27;
                                                        }
                                                        if (!(obj instanceof org.eclipse.swt.widgets.List)) break block28;
                                                        org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                                                        String fieldName = (String)list.getData();
                                                        if (fieldName.equals("ATTR_FILTER_LIST")) {
                                                            String[] selection = this.m_attrFilterList.getSelection();
                                                            if (selection.length > 0) {
                                                                this.m_gui.enableField(this.m_unlink_attrFilter_btn, true);
                                                            } else {
                                                                this.m_gui.enableField(this.m_unlink_attrFilter_btn, false);
                                                            }
                                                        }
                                                        break block27;
                                                    }
                                                    if (!(obj instanceof Button)) break block29;
                                                    Button b = (Button)e.getSource();
                                                    name = (String)b.getData();
                                                    if (name.equals(ServerFilterView.RELOAD_VIEW_BUTTON)) {
                                                        this.refreshUserFilterTab(true, null, true, null, true);
                                                    }
                                                    if (name.equals(SELECT_USER_BUTTON)) {
                                                        SelectUsersAction selectUserAction = new SelectUsersAction(this.m_folder.getShell(), this.m_userRoleList.getItems());
                                                        selectUserAction.run();
                                                        if (selectUserAction.getSelectedUsers() != null) {
                                                            String selectedUserRoles = selectUserAction.getSelectedUsers();
                                                            selectedUserRoles = ServerFilterView.getSimplifiedUserString(selectedUserRoles);
                                                            ForwardCondition fc = this.m_currentPolicy.getConditions().getConditionList().get(0);
                                                            fc.to = selectedUserRoles;
                                                            this.updateUserRoleList(selectedUserRoles);
                                                            this.setDirty(true);
                                                        }
                                                    }
                                                    if (!name.equals(ACTIVE)) break block30;
                                                    boolean setActive = this.m_active_chk.getSelection();
                                                    this.m_currentPolicy.setActive(setActive);
                                                    if (setActive) {
                                                        this.m_tabPolDetails.setImage(BMUI.IMAGE_ACCEPT_GREEN);
                                                    } else {
                                                        this.m_tabPolDetails.setImage(BMUI.IMAGE_CANCEL_ROUND);
                                                    }
                                                    this.setDirty(true);
                                                    break block27;
                                                }
                                                if (name != "SELECT_UNKNOWN" && name != "SELECT_NORMAL" && name != "SELECT_WARNING" && name != "SELECT_MINOR" && name != "SELECT_MAJOR" && name != "SELECT_CRITICAL") break block31;
                                                StringBuffer sb = new StringBuffer();
                                                if (this.m_unknown_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(0);
                                                }
                                                if (this.m_normal_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(1);
                                                }
                                                if (this.m_warn_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(2);
                                                }
                                                if (this.m_minor_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(3);
                                                }
                                                if (this.m_major_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(4);
                                                }
                                                if (this.m_critical_chk.getSelection()) {
                                                    if (sb.length() != 0) {
                                                        sb.append(",");
                                                    }
                                                    sb.append(5);
                                                }
                                                ForwardCondition current_fc2 = this.m_currentPolicy.getConditions().getConditionList().get(0);
                                                current_fc2.severity = sb.toString();
                                                this.setDirty(true);
                                                break block27;
                                            }
                                            if (!name.equals(TYPE_K)) break block32;
                                            current_fc = this.m_currentPolicy.getConditions().getConditionList().get(0);
                                            current_fc.type_k = this.m_typeK_chk.getSelection() ? 1 : 0;
                                            this.setDirty(true);
                                            break block27;
                                        }
                                        if (!name.equals(TYPE_A)) break block33;
                                        current_fc = this.m_currentPolicy.getConditions().getConditionList().get(0);
                                        current_fc.type_a = this.m_typeA_chk.getSelection() ? 1 : 0;
                                        this.setDirty(true);
                                        break block27;
                                    }
                                    if (!name.equals("ADDLINK_ATTR_FILTER_BTN")) break block34;
                                    LinkAttributeFilterAction linkAction = new LinkAttributeFilterAction((Object)m_instance, USERS);
                                    linkAction.run();
                                    break block27;
                                }
                                if (!name.equals("UNLINK_ATTR_FILTER_BTN")) break block35;
                                UnlinkAttributeFilterAction action = new UnlinkAttributeFilterAction((Object)m_instance, this.m_attrFilterList.getSelection(), USERS);
                                action.run();
                                break block27;
                            }
                            if (!name.equals(SAVE_BUTTON)) break block36;
                            if (this.saveFPolicy()) {
                                this.setDirty(false);
                            }
                            break block27;
                        }
                        if (!name.equals(DELETE_BUTTON)) break block37;
                        this.deleteFPolicy();
                        break block27;
                    }
                    if (!name.equals(NEW_BUTTON)) break block38;
                    this.newFPolicy(null);
                    break block27;
                }
                if (!name.equals(UNDO_BUTTON)) break block27;
                this.undoChanges();
                break block27;
            }
            if (e.widget instanceof Graph) {
                ArrayList connections = new ArrayList();
                for (Object o : this.m_graph.getSelection()) {
                    if (!(o instanceof GraphNode)) continue;
                    GraphNode gnode = (GraphNode)((Object)o);
                    connections.addAll(gnode.getSourceConnections().keySet());
                    connections.addAll(gnode.getTargetConnections().keySet());
                }
                for (GraphConnection gconn : this.m_graph.getConnections().keySet()) {
                    if (connections.contains((Object)gconn)) {
                        gconn.highlight();
                        continue;
                    }
                    gconn.unhighlight();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void dispose() {
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.m_graph.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    private class NewUserPolicyAction
    extends Action {
        private String m_userRoleName;

        public NewUserPolicyAction(String userRoleName) {
            super("NewUserPolicy");
            this.m_userRoleName = null;
            this.setId("NewUserPolicy");
            this.setText("New User Policy");
            this.m_userRoleName = userRoleName;
            if (Repository.getInstance().getRights(1004) < 3) {
                this.setEnabled(false);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (ServerFilterUsersTab.this.isPolSectionEnabled() && ServerFilterUsersTab.this.isDirty()) {
                NotificationSaveDialog dialog = new NotificationSaveDialog(ServerFilterUsersTab.this.m_parent.getShell(), ServerFilterUsersTab.this.getCurrentPolicy());
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getActionType().equals(NotificationSaveDialog.YES)) {
                    boolean saved = ServerFilterUsersTab.this.saveFPolicy();
                    if (!saved) return;
                    ServerFilterUsersTab.this.refreshUserFilterTab(true, ServerFilterUsersTab.this.m_currentPolicy, true, null, false);
                } else if (dialog.getActionType().equals(NotificationSaveDialog.NO)) {
                    if (ServerFilterUsersTab.this.isNew()) {
                        ServerFilterUsersTab.this.m_fPolicyManager.deleteForwardPolicy(ServerFilterUsersTab.this.getCurrentPolicy(), ServerFilterUsersTab.this.m_origPolicyName);
                    } else {
                        ServerFilterUsersTab.this.m_sfv.loadFPolicies();
                    }
                } else if (dialog.getActionType().equals(NotificationSaveDialog.CANCEL)) {
                    return;
                }
            }
            if (!ServerFilterUsersTab.this.isPolSectionEnabled()) {
                ServerFilterUsersTab.this.activatePolicySection(true);
            }
            ForwardPolicy fpNew = ForwardPolicy.createNewForwardPolicy("UserFilter_");
            ForwardCondition fc = fpNew.addNewCondition();
            fc.type = ServerFilterUsersTab.USERS;
            if (this.m_userRoleName != null) {
                String userRole = Repository.getInstance().getUserManager().getCorrectRoleName(this.m_userRoleName);
                fc.m_users.add("[" + userRole + "]");
                fc.to = ServerFilterView.getSimplifiedUserString(fc.m_users.toString());
            }
            ServerFilterUsersTab.this.m_fPolicyManager.addForwardPolicy(fpNew);
            ServerFilterUsersTab.this.refreshUserFilterTab(false, fpNew, true, null, false);
            ServerFilterUsersTab.this.setNew(true);
            ServerFilterUsersTab.this.setDirty(true);
            ServerFilterUsersTab.this.m_gui.setEditable(ServerFilterUsersTab.this.m_polName_field, true);
            ServerFilterUsersTab.this.m_gui.enableField(ServerFilterUsersTab.this.m_polName_field, true);
        }
    }

    private class SaveFPolicyAction
    extends Action {
        boolean m_saved;

        public SaveFPolicyAction() {
            super("saveUPolicy");
            this.m_saved = true;
            this.setId("saveUPolicy");
            this.setText("Save Policy");
            if (Repository.getInstance().getRights(1004) < 3 || !ServerFilterUsersTab.this.isDirty()) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            String userRoles;
            if (!this.isEnabled()) {
                return;
            }
            if (!ServerFilterUsersTab.this.m_isValidPolName) {
                new ShowMessageBox("Error saving User Policy", "Invalid User Policy Name!", 1);
                this.m_saved = false;
                return;
            }
            if (ServerFilterUsersTab.this.m_userRoleList.getItemCount() == 0) {
                new ShowMessageBox("Error saving User Policy", "Invalid or empty User Role!", 1);
                this.m_saved = false;
                return;
            }
            ForwardCondition fc = ServerFilterUsersTab.this.m_currentPolicy.getConditions().getConditionList().get(0);
            fc.to = userRoles = ServerFilterView.getSimplifiedUserString(fc.to);
            ServerFilterUsersTab.this.setNew(false);
            if (ServerFilterUsersTab.this.m_fPolicyManager.saveForwardPolicy(ServerFilterUsersTab.this.m_currentPolicy, ServerFilterUsersTab.this.m_origPolicyName, true)) {
                ServerFilterUsersTab.this.m_origPolicyName = ServerFilterUsersTab.this.m_currentPolicy.getPolicyName();
            } else {
                this.m_saved = false;
            }
        }

        public boolean hasSaved() {
            return this.m_saved;
        }
    }
}

