/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.IntervalHelpListener;
import com.blixx.boom.gui.utils.ServerJobTabComposite;
import com.blixx.boom.gui.views.ServerJobsView;
import com.blixx.boom.gui.views.actions.ServerJobTriggerOnceAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.in.ScSrvJobGetConfig;
import com.blixx.log.RTLogger;
import com.blixx.shared.Interval;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.JobConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ServerJobTab
extends CTabItem
implements IDoubleClickListener,
SelectionListener,
ModifyListener,
IExpansionListener,
DisposeListener,
ICmdPostProcess<ScSrvJobGetConfig> {
    private static final String REFRESH = "Refresh";
    public static final String LAST_RESULT = "LastResult";
    private ServerJobsView m_admCfgView = null;
    private CTabFolder m_folder = null;
    private JobConfig m_jobConfig = null;
    private Group m_config = null;
    private String m_jobName = null;
    private boolean m_isDirty = false;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private ScrolledComposite m_sc = null;
    private Composite m_compInView = null;
    private Composite m_compMain = null;
    private ServerJobTabComposite lastResultComposite = null;
    private Button m_save_btn = null;
    private Button m_cancel_btn = null;
    private Button m_expandCollapseAll_btn = null;
    public static String TYPE = "TYPE";
    public static String EXPANDABLE = "EXPANDABLE";
    public static String EXPANDABLE_SUB = "EXPANDABLE_SUB";
    public static String EXPAND_COLLAPSE_BTN = "EXPAND_ALL";
    public static String EXPAND_ALL = "Expand all";
    public static String COLLAPSE_ALL = "Collapse all";
    public static String RUN_ONCE = "Run once";
    public static String EXPORT_DIR = "EXPORT_DIR";
    public static String START_STOP_BTN = "START_STOP_BTN";
    public static String SAVE_BTN = "SAVE_BTN";
    public static String CANCEL_BTN = "CANCEL_BTN";
    public static String JOB_SECTION_TITLE = "Job Configuration";
    private List<Section> m_sections = null;

    public ServerJobTab(ServerJobsView admCfgView, CTabFolder parent, JobConfig jc, String jobName) {
        super(parent, 0, 1);
        this.setText(jobName);
        this.setData(jobName);
        this.addDisposeListener(this);
        this.setShowClose(true);
        this.m_admCfgView = admCfgView;
        this.m_folder = parent;
        this.m_jobConfig = jc;
        this.m_config = this.m_jobConfig.getConfig();
        this.m_jobName = jobName;
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_sections = new ArrayList<Section>();
        this.m_compInView = new Composite((Composite)this.m_folder, 0);
        this.m_compInView.setLayout((Layout)new GridLayout());
        Composite buttons = new Composite(this.m_compInView, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(131072, 128, true, false));
        Button runOnce_btn = this.m_gui.addButton(buttons, RUN_ONCE, RUN_ONCE, true, 50, -1, 5, 0, this);
        runOnce_btn.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_expandCollapseAll_btn = this.m_gui.addButton(buttons, EXPAND_ALL, EXPAND_ALL, true, 50, -1, 5, 0, this);
        this.m_expandCollapseAll_btn.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_expandCollapseAll_btn.setImage(BMUI.IMAGE_EXPAND_ALL_ARROW);
        Button refresh = this.m_gui.addButton(buttons, REFRESH, REFRESH, true, 50, -1, 5, 0, this);
        refresh.setLayoutData((Object)new GridData(131072, 128, false, false));
        refresh.setImage(BMUI.IMAGE_REFRESH);
        this.m_sc = new ScrolledComposite(this.m_compInView, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout());
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain = new Composite((Composite)this.m_sc, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 20;
        gl.marginBottom = 15;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, false, false));
        Section jobSection = null;
        Map<String, Group> groups = this.m_config.getGroups();
        for (String name : groups.keySet()) {
            Group group = groups.get(name);
            Section section = this.createExpandableSection(this.m_compMain, group);
            if (!group.getName().equals("JOB")) continue;
            jobSection = section;
        }
        if (jobSection != null) {
            jobSection.setExpanded(true);
        }
        Composite compLine = new Composite(this.m_compInView, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compBtn = new Composite(this.m_compInView, 0);
        gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.marginBottom = 5;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_save_btn = this.m_gui.addButton(compBtn, SAVE_BTN, "&Save Configuration", false, 90, 30, 0, null);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        if (this.m_admCfgView.m_rights == 3) {
            this.m_save_btn.addSelectionListener((SelectionListener)this);
        } else {
            this.m_gui.enableField(this.m_save_btn, false);
        }
        this.m_cancel_btn = this.m_gui.addButton(compBtn, CANCEL_BTN, "&Cancel", true, 90, 30, 0, this);
        this.m_cancel_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_sc.setContent((Control)this.m_compMain);
        this.m_sc.setMinSize(this.m_compMain.computeSize(-1, -1, true));
        this.setControl((Control)this.m_compInView);
    }

    public Section createExpandableSection(Composite parent, Group group) {
        boolean hasSubGroups;
        int style = 514;
        String title = group.getName();
        if (group.getName().equals("JOB")) {
            style = 578;
            title = "Job Configuration";
        }
        Section section = this.m_toolkit.createSection(parent, style);
        section.setData(TYPE, (Object)EXPANDABLE);
        section.setLayoutData((Object)new GridData(4, 128, true, false));
        section.setText(title);
        section.addExpansionListener((IExpansionListener)this);
        this.m_sections.add(section);
        Composite sectionComp = this.m_toolkit.createComposite((Composite)section, 0);
        sectionComp.setLayout((Layout)new GridLayout(1, false));
        sectionComp.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean bl = hasSubGroups = group.m_mapGroups.size() > 0;
        if (hasSubGroups) {
            Map<String, Group> subGroups = group.m_mapGroups;
            for (String name : subGroups.keySet()) {
                Group subGrp = subGroups.get(name);
                this.createExpandableSubSection(sectionComp, subGrp);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(sectionComp);
                list.add(subGrp);
                Text t = this.m_gui.addTextReadOnlyNoBorder(sectionComp, null, "", 1, 1, 0, 0, null);
                ((GridData)t.getLayoutData()).heightHint = 5;
            }
        } else {
            this.createSubSection(sectionComp, group);
        }
        section.setClient((Control)sectionComp);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    public void createSubSection(Composite sectionComp, Group group) {
        Map<String, AbstractAttribute> attributes = group.getAttributes();
        for (String name : attributes.keySet()) {
            AbstractAttribute attr = attributes.get(name);
            if (!attr.isEnabled() || group.getName().equals("JOB") && attr.getName().equals("active")) continue;
            ServerJobTabComposite pmsComp = new ServerJobTabComposite(sectionComp, attr, this);
            if (!group.getName().equals("JOB") || !attr.getName().equals(LAST_RESULT)) continue;
            this.lastResultComposite = pmsComp;
        }
        group.getName().equals("JOB");
    }

    public Section createExpandableSubSection(Composite sectionComp, Group group) {
        Section subSection = this.m_toolkit.createSection(sectionComp, 2);
        subSection.setData(TYPE, (Object)EXPANDABLE_SUB);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalIndent = 100;
        subSection.setLayoutData((Object)gd);
        subSection.addExpansionListener((IExpansionListener)this);
        subSection.setText(group.getName());
        this.m_sections.add(subSection);
        Composite subSectionComp = this.m_toolkit.createComposite((Composite)subSection, 0);
        subSectionComp.setLayout((Layout)new GridLayout(1, false));
        subSectionComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Map<String, AbstractAttribute> attributes = group.getAttributes();
        for (String name : attributes.keySet()) {
            AbstractAttribute attr = attributes.get(name);
            if (!attr.isEnabled()) continue;
            new ServerJobTabComposite(subSectionComp, attr, this);
        }
        subSection.setClient((Control)subSectionComp);
        subSection.setLayoutData((Object)new GridData(768));
        return subSection;
    }

    public Composite createCheckBoxComposite(Composite parent) {
        Composite checkBoxComp = new Composite(parent, 0);
        checkBoxComp.setLayout((Layout)new GridLayout(1, false));
        checkBoxComp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addTextField(checkBoxComp, null, "Delete", 1, 1, 1, 1, null);
        Button chkBox = this.m_gui.addCheckbox(checkBoxComp, "", "", false, 1, 1, 0, this);
        ((GridData)chkBox.getLayoutData()).horizontalAlignment = 0x1000000;
        return checkBoxComp;
    }

    public void setDirty(boolean dirty) {
        this.m_isDirty = dirty;
        if (this.m_admCfgView.m_rights == 3) {
            this.m_gui.enableField(this.m_save_btn, dirty);
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void save() {
        try {
            this.m_jobConfig.setConfig(this.m_config);
            String interval = this.m_jobConfig.getSchedulingInterval();
            if (!Interval.checkInterval(interval, 60)) {
                IntervalHelpListener.showDialog();
                return;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.m_jobConfig.storeXML(bos);
            ServerClient sc = new ServerClient("SJOBS_SETCONFIG", bos.toString(), new String[0]);
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                sc.getResultObject();
                this.setDirty(false);
            } else {
                String error = (String)sc.getResultObject();
                new ShowMessageBox("Error sending configuration to the server ", error, 33);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        try {
            this.m_compInView.dispose();
        }
        catch (Throwable throwable) {}
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String btnName = "";
        if (e.getSource() instanceof Button) {
            Button btn = (Button)e.getSource();
            btnName = (String)btn.getData();
            if (btnName.equals(RUN_ONCE)) {
                ServerJobTriggerOnceAction runOnceAction = new ServerJobTriggerOnceAction(this.m_admCfgView, this.m_jobName);
                runOnceAction.run();
            } else if (btnName.equals(SAVE_BTN)) {
                this.save();
            } else if (btnName.equals(CANCEL_BTN)) {
                ServerJobsView.closeTab(this.getText());
            } else if (btnName.equals(EXPAND_ALL)) {
                for (Section s : this.m_sections) {
                    if (s.isExpanded()) continue;
                    s.setExpanded(true);
                }
                this.m_expandCollapseAll_btn.setImage(BMUI.IMAGE_COLLAPSE_ALL_ARROW);
                this.m_expandCollapseAll_btn.setData((Object)COLLAPSE_ALL);
                this.m_expandCollapseAll_btn.setText(COLLAPSE_ALL);
                this.m_expandCollapseAll_btn.computeSize(-1, -1, true);
                this.m_sc.setContent((Control)this.m_compMain);
                this.m_sc.setMinSize(this.m_compMain.computeSize(-1, -1, true));
            } else if (btnName.equals(COLLAPSE_ALL)) {
                for (Section s : this.m_sections) {
                    if (s.getText().equals(JOB_SECTION_TITLE) || !s.isExpanded()) continue;
                    s.setExpanded(false);
                }
                this.m_expandCollapseAll_btn.setImage(BMUI.IMAGE_EXPAND_ALL_ARROW);
                this.m_expandCollapseAll_btn.setData((Object)EXPAND_ALL);
                this.m_expandCollapseAll_btn.setText(EXPAND_ALL);
                this.m_expandCollapseAll_btn.computeSize(-1, -1, true);
                this.m_sc.setContent((Control)this.m_compMain);
                this.m_sc.setMinSize(this.m_compMain.computeSize(-1, -1, true));
            } else if (btnName.equals(REFRESH)) {
                this.refresh();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void modifyText(ModifyEvent e) {
    }

    public void expansionStateChanged(ExpansionEvent e) {
        this.m_sc.setContent((Control)this.m_compMain);
        this.m_sc.setMinSize(this.m_compMain.computeSize(-1, -1, true));
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        CTabItem cti = (CTabItem)e.getSource();
        this.m_sections.clear();
        this.m_admCfgView.getTabList().remove(cti.getText());
        try {
            this.getControl().dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void refresh() {
        this.getLastResult(0L);
    }

    private void getLastResult(long delayMillis) {
        if (!this.isDisposed()) {
            ScSrvJobGetConfig sc = new ScSrvJobGetConfig(Repository.getInstance(), this.m_jobConfig.getJobName());
            sc.addCmdPostProcess(this);
            JobManager.getInstance().schedule(sc, delayMillis);
        }
    }

    @Override
    public void postProcess(ScSrvJobGetConfig sc) {
        if (sc.isSuccess()) {
            try {
                String xml = sc.getResultObject();
                final JobConfig jc = new JobConfig();
                ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
                jc.loadXML(bis);
                UIJob uiJob = new UIJob(String.valueOf(this.m_jobConfig.getJobName()) + "-refreshLastResult"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ServerJobTab.this.m_compInView.dispose();
                        ServerJobTab.this.m_jobConfig = jc;
                        ServerJobTab.this.m_config = ServerJobTab.this.m_jobConfig.getConfig();
                        ServerJobTab.this.createMainArea();
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(uiJob);
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
        } else {
            new ShowMessageBox(REFRESH, "Error getting job configuration from the server", 33);
        }
    }
}

