/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.TableComparator;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ServerJobTab;
import com.blixx.boom.gui.views.ServerJobsView;
import com.blixx.boom.gui.views.SimpleTableProvider;
import com.blixx.boom.gui.views.actions.ServerJobTriggerOnceAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScSrvJobList;
import com.blixx.ctrl.sc.in.ScSrvJobReload;
import com.blixx.log.RTLogger;
import com.blixx.shared.jobs.JobConfig;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ServerJobsStatusTab
extends CTabItem
implements IDoubleClickListener,
SelectionListener,
ModifyListener,
ICommandListener,
ICmdPostProcess {
    public static final String REFRESH = "REFRESH";
    public static final String RELOAD = "RELOAD";
    public static final String SERVER_JOBS = "Server Jobs ";
    public static final String TYPE = "TYPE";
    public static final String SJOBS_OVERVIEW_TABLE = "SJOBS_OVERVIEW_TABLE";
    private ServerJobsView m_admCfgView = null;
    private CTabFolder m_folder = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_compInView = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private Button m_refresh_btn = null;
    private Button m_reload_btn = null;
    private static boolean m_isReadOnly = false;
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = ServerJobsStatusTab.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = ServerJobsStatusTab.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ServerJobsStatusTab.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                ServerJobsStatusTab.this.m_tableViewer.getTable().setSortDirection(dir);
                ServerJobsStatusTab.this.m_tableViewer.refresh(true, false);
            }
        }
    };

    public ServerJobsStatusTab(ServerJobsView admCfgView, CTabFolder parent) {
        super(parent, 0, 0);
        this.m_admCfgView = admCfgView;
        this.m_folder = parent;
        this.setText(SERVER_JOBS);
        this.setData(SERVER_JOBS);
        this.setShowClose(false);
        this.setImage(BMUI.IMAGE_SERVERJOBS);
        m_isReadOnly = this.m_admCfgView.m_rights == 2;
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compInView = new Composite((Composite)this.m_folder, 0);
        this.m_compInView.setLayout((Layout)new GridLayout());
        this.createTable(this.m_compInView);
        Composite compFooter = new Composite(this.m_compInView, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compFooter.setLayout((Layout)gl);
        compFooter.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite compLine = new Composite(compFooter, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compBtn = new Composite(compFooter, 0);
        gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 2;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.m_refresh_btn = this.m_gui.addButton(compBtn, REFRESH, "&Refresh Status", true, 60, 0, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        this.m_reload_btn = this.m_gui.addButton(compBtn, RELOAD, "&Reload Config", true, 60, 0, 0, this);
        ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_reload_btn.getLayoutData()).verticalAlignment = 4;
        if (this.m_admCfgView.m_rights != 3) {
            this.m_reload_btn.setEnabled(false);
        }
        this.setControl((Control)this.m_compInView);
        Repository.getInstance().getCmdRouter().addCmdListener("SJOBS_LIST", this);
        Repository.getInstance().getCmdRouter().addCmdListener("SJOBS_RELOAD", this);
        this.onCommand("SJOBS_LIST", null);
    }

    public void createTable(Composite parent) {
        Composite table_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        table_comp.setLayout((Layout)gl);
        table_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_table = new Table(table_comp, 268503812);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        try {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        catch (Throwable throwable) {}
        this.m_table.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.m_table, 16384);
        col1.setText("Name");
        col1.setWidth(160);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(this.m_table, 16384);
        col2.setText("Interval");
        col2.setWidth(75);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(this.m_table, 16384);
        col3.setText("Active");
        col3.setWidth(60);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(this.m_table, 16384);
        col4.setText("Status");
        col4.setWidth(60);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(this.m_table, 16384);
        col5.setText("Last Run");
        col5.setWidth(120);
        col5.addListener(13, this.sortListener);
        TableColumn col6 = new TableColumn(this.m_table, 16384);
        col6.setText("Time spent (ms)");
        col6.setWidth(50);
        col6.addListener(13, this.sortListener);
        TableColumn col7 = new TableColumn(this.m_table, 16384);
        col7.setText("Last Result");
        col7.setWidth(240);
        col7.addListener(13, this.sortListener);
        TableColumn col8 = new TableColumn(this.m_table, 16384);
        col8.setText("Next Run");
        col8.setWidth(120);
        col8.addListener(13, this.sortListener);
        TableColumn col9 = new TableColumn(this.m_table, 16384);
        col9.setText("Description");
        col9.setWidth(250);
        col9.addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        table_comp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(0, col5.getWidth()));
        tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(0, col6.getWidth()));
        tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(0, col7.getWidth()));
        tableLayout.setColumnData((Widget)col8, (ColumnLayoutData)new ColumnWeightData(0, col8.getWidth()));
        tableLayout.setColumnData((Widget)col9, (ColumnLayoutData)new ColumnWeightData(100, col8.getWidth()));
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(TYPE, (Object)SJOBS_OVERVIEW_TABLE);
        SimpleTableProvider provider = new SimpleTableProvider(this.m_tableViewer);
        this.m_tableViewer.setContentProvider((IContentProvider)provider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.m_tableViewer.setInput(null);
        this.m_tableViewer.setComparator((ViewerComparator)new TableComparator(this.m_table));
        if (this.m_admCfgView.m_rights >= 2) {
            this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        }
        this.m_table.setToolTipText("");
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        if (this.m_admCfgView.m_rights > 1) {
            this.createContentMenu();
        }
    }

    private void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshStatus());
                    manager.add((IContributionItem)new Separator());
                    if (!ServerJobsStatusTab.this.m_tableViewer.getSelection().isEmpty()) {
                        manager.add((IAction)new GetConfigAction());
                        manager.add((IAction)new ServerJobTriggerOnceAction(ServerJobsStatusTab.this.m_admCfgView, ServerJobsStatusTab.this.m_tableViewer));
                        manager.add((IAction)new SetActiveAction());
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public static boolean isReadOnly() {
        return m_isReadOnly;
    }

    public void dispose() {
        Repository.getInstance().getCmdRouter().removeCmdListener("SJOBS_LIST", this);
        Repository.getInstance().getCmdRouter().removeCmdListener("SJOBS_RELOAD", this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String btnName = "";
        if (e.getSource() instanceof Button) {
            Button btn = (Button)e.getSource();
            btnName = (String)btn.getData();
            if (btnName.equals(REFRESH)) {
                try {
                    btn.setEnabled(false);
                    this.onCommand("SJOBS_LIST", null);
                }
                finally {
                    btn.setEnabled(true);
                }
            }
            if (btnName.equals(RELOAD)) {
                try {
                    btn.setEnabled(false);
                    this.onCommand("SJOBS_RELOAD", null);
                }
                finally {
                    btn.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void onCommand(String command, String action) {
        if ("SJOBS_LIST".equals(command)) {
            ScSrvJobList sc = new ScSrvJobList(Repository.getInstance());
            sc.addCmdPostProcess(this);
            sc.start();
        } else if ("SJOBS_RELOAD".equals(command)) {
            ScSrvJobReload sc = new ScSrvJobReload(Repository.getInstance());
            sc.addCmdPostProcess(this);
            sc.start();
        }
    }

    public void postProcess(ServerClient sc) {
        if (sc instanceof ScSrvJobList) {
            ScSrvJobList scl = (ScSrvJobList)sc;
            if (scl.isSuccess()) {
                RTLogger.print(5, "ScSrvJobList process results");
                String res = scl.getResultObject();
                String[] lines = res.split("\r*\n");
                ArrayList<String[]> rows = new ArrayList<String[]>();
                int i = 0;
                while (i < lines.length) {
                    if (!lines[i].startsWith("#")) {
                        String[] elRow = lines[i].split("\\Q\u25ba\\E");
                        rows.add(elRow);
                    }
                    ++i;
                }
                final ArrayList<String[]> rr = rows;
                UIJob uj = new UIJob("ServerJobsRefersh"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            ServerJobsStatusTab.this.m_tableViewer.setInput((Object)rr);
                        }
                        catch (Throwable throwable) {}
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            }
        } else if ("SJOBS_RELOAD".equals(sc.m_command)) {
            if (sc.isSuccess()) {
                ScSrvJobList sc1 = new ScSrvJobList(Repository.getInstance());
                sc1.addCmdPostProcess(this);
                sc1.start();
            } else {
                new ShowMessageBox(" Reload Configuration", "Error loading configuration!", 33);
                RTLogger.print(6, "Error loading sjob configuration from server");
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        GetConfigAction openConfigAction = new GetConfigAction();
        openConfigAction.run();
    }

    public void modifyText(ModifyEvent e) {
    }

    public class GetConfigAction
    extends Action {
        public GetConfigAction() {
            super("openconfiguration");
            this.setId("openconfiguration");
            this.setText("Open Configuration");
            if (((ServerJobsStatusTab)ServerJobsStatusTab.this).m_admCfgView.m_rights < 2) {
                this.setEnabled(false);
            }
        }

        public void run() {
            StructuredSelection sel = (StructuredSelection)ServerJobsStatusTab.this.m_tableViewer.getSelection();
            if (!sel.isEmpty()) {
                String[] row = (String[])sel.getFirstElement();
                String jobName = row[0];
                if (ServerJobsView.isTabOpen(jobName)) {
                    CTabItem tab = ServerJobsView.getTab(jobName);
                    if (tab instanceof ServerJobTab) {
                        ServerJobTab pmsTab = (ServerJobTab)tab;
                        ServerJobsStatusTab.this.m_folder.setSelection((CTabItem)pmsTab);
                    }
                } else {
                    try {
                        com.blixx.boom.engine.ServerClient sc = new com.blixx.boom.engine.ServerClient("SJOBS_GETCONFIG", jobName, new String[0]);
                        sc.runInUIThread(null);
                        if (sc.isSuccess()) {
                            String res = (String)sc.getResultObject();
                            JobConfig jc = new JobConfig();
                            ByteArrayInputStream bis = new ByteArrayInputStream(res.getBytes());
                            jc.loadXML(bis);
                            jc.getClassName();
                            ServerJobTab pmsTab = new ServerJobTab(ServerJobsStatusTab.this.m_admCfgView, ServerJobsStatusTab.this.m_folder, jc, jobName);
                            ServerJobsView.addTab(pmsTab);
                            ServerJobsStatusTab.this.m_folder.setSelection((CTabItem)pmsTab);
                        } else {
                            String error = (String)sc.getResultObject();
                            new ShowMessageBox("Error getting configuration", error, 33);
                        }
                    }
                    catch (Throwable e) {
                        new ShowMessageBox("Error parsing configuration", e.getMessage(), 33);
                        RTLogger.print(6, "Error parsing sjob configuration ", e);
                    }
                }
            }
        }
    }

    public class RefreshStatus
    extends Action {
        public RefreshStatus() {
            this.setText("Refresh status");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            this.setId("RfershStatusServerJobs");
        }

        public void run() {
            CTabItem tab;
            String[] row;
            String jobName;
            ServerJobsStatusTab.this.onCommand("SJOBS_LIST", null);
            StructuredSelection sel = (StructuredSelection)ServerJobsStatusTab.this.m_tableViewer.getSelection();
            if (!sel.isEmpty() && ServerJobsView.isTabOpen(jobName = (row = (String[])sel.getFirstElement())[0]) && (tab = ServerJobsView.getTab(jobName)) instanceof ServerJobTab) {
                ((ServerJobTab)tab).refresh();
            }
        }
    }

    public class SetActiveAction
    extends Action {
        private String AUTO_DELETE_JOB = "Auto Delete indications";
        private String AUTO_CLOSE_JOB = "Auto Close indications";
        private String AUTO_ARCHIVE_JOB = "Auto Archive indications";
        private boolean m_setActive = true;

        public SetActiveAction() {
            boolean isActive = false;
            StructuredSelection sel = (StructuredSelection)ServerJobsStatusTab.this.m_tableViewer.getSelection();
            if (sel.isEmpty() || ((ServerJobsStatusTab)ServerJobsStatusTab.this).m_admCfgView.m_rights < 3) {
                this.setEnabled(false);
            } else {
                String[] row = (String[])sel.getFirstElement();
                isActive = Boolean.valueOf(row[2]);
                String jobName = String.valueOf(row[0]);
                if (jobName.equals(this.AUTO_DELETE_JOB) || jobName.equals(this.AUTO_CLOSE_JOB) || jobName.equals(this.AUTO_ARCHIVE_JOB)) {
                    this.setEnabled(false);
                }
            }
            this.m_setActive = !isActive;
        }

        public String getText() {
            if (this.m_setActive) {
                return "Set Active";
            }
            return "Set Inactive";
        }

        public void run() {
            StructuredSelection sel = (StructuredSelection)ServerJobsStatusTab.this.m_tableViewer.getSelection();
            String[] row = (String[])sel.getFirstElement();
            com.blixx.boom.engine.ServerClient sc = new com.blixx.boom.engine.ServerClient("SJOBS_SETACTIVE", row[0], new String[]{"" + this.m_setActive});
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                ServerJobsStatusTab.this.onCommand("SJOBS_LIST", null);
            } else {
                String error = (String)sc.getResultObject();
                new ShowMessageBox("Error getting configuration", error, 33);
                RTLogger.print(6, "Error getting sjob configuration " + error);
            }
        }
    }
}

