/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.widgets.TypedListener;

public class SshConsoleContent
implements StyledTextContent {
    private StringBuffer m_content = new StringBuffer();
    Vector textListeners = new Vector();
    private int m_width = 0;
    private int m_height = 0;
    private boolean m_REDRAW = true;

    public SshConsoleContent(int width, int height) {
        this.m_width = width;
        this.m_height = height;
    }

    public void setRedraw(boolean redraw) {
        this.m_REDRAW = redraw;
        if (this.m_REDRAW) {
            TextChangingEvent tce = new TextChangingEvent((StyledTextContent)this);
            tce.newCharCount = this.getCharCount();
            tce.newLineCount = this.getLineCount();
            tce.newText = this.m_content.toString();
            tce.start = 0;
            this.sendTextEvent(tce);
            TextChangedEvent tcd = new TextChangedEvent((StyledTextContent)this);
            this.sendTextEvent(tcd);
        }
    }

    public void addTextChangeListener(TextChangeListener listener) {
        if (listener == null) {
            this.error(4);
        }
        this.textListeners.addElement(listener);
    }

    public int getCharCount() {
        return this.m_content.length();
    }

    public String getLine(int lineIndex) {
        int offset = (this.m_width + 2) * lineIndex;
        if (offset >= this.m_content.length()) {
            return "";
        }
        int end = Math.min(offset + this.m_width, this.m_content.length());
        return this.m_content.substring(offset, end);
    }

    public int getLineAtOffset(int offset) {
        int line = offset / (this.m_width + 2);
        return line;
    }

    public int getLineCount() {
        int lineCount = 1 + this.m_content.length() / (this.m_width + 2);
        return lineCount;
    }

    public String getLineDelimiter() {
        return "\r\n";
    }

    public int getOffsetAtLine(int lineIndex) {
        return (this.m_width + 2) * lineIndex;
    }

    public String getTextRange(int start, int length) {
        return this.m_content.substring(start, start + length);
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        if (listener == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.textListeners.size()) {
            TypedListener typedListener = (TypedListener)this.textListeners.elementAt(i);
            if (typedListener.getEventListener() == listener) {
                this.textListeners.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        TextChangingEvent tce = new TextChangingEvent((StyledTextContent)this);
        tce.newCharCount = text.length();
        int cr = text.indexOf(13);
        cr = cr > 0 ? 1 : 0;
        tce.newLineCount = cr;
        tce.newText = text;
        tce.start = 0;
        this.sendTextEvent(tce);
        this.m_content.replace(start, start + replaceLength, text);
        if (this.m_REDRAW) {
            TextChangedEvent tcd = new TextChangedEvent((StyledTextContent)this);
            this.sendTextEvent(tcd);
        }
    }

    public void setText(String text) {
        this.m_content = new StringBuffer(text);
        TextChangingEvent tce = new TextChangingEvent((StyledTextContent)this);
        tce.newCharCount = this.getCharCount();
        tce.newLineCount = this.getLineCount();
        tce.newText = text;
        tce.start = 0;
        this.sendTextEvent(tce);
        if (this.m_REDRAW) {
            TextChangedEvent tcd = new TextChangedEvent((StyledTextContent)this);
            this.sendTextEvent(tcd);
        }
    }

    void sendTextEvent(TextChangingEvent event) {
        int i = 0;
        while (i < this.textListeners.size()) {
            ((TextChangeListener)this.textListeners.elementAt(i)).textChanging(event);
            ++i;
        }
    }

    void sendTextEvent(TextChangedEvent event) {
        int i = 0;
        while (i < this.textListeners.size()) {
            ((TextChangeListener)this.textListeners.elementAt(i)).textChanged(event);
            ++i;
        }
    }

    void error(int code) {
        SWT.error((int)code);
    }
}

