/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class SshText {
    int WIDTH = 0;
    int MAXLINES = 0;
    StringBuffer empty = new StringBuffer();
    ArrayList<StringBuffer> m_strings = new ArrayList();
    int m_pos = 0;
    int m_posLast = 0;
    int m_posFirst = 0;

    public SshText(int width, int height, int maxLines, int firstlinePosition) {
        int i = 0;
        while (i < width) {
            this.empty.append(" ");
            ++i;
        }
        this.m_strings.add(this.empty);
        this.WIDTH = width;
        this.MAXLINES = maxLines;
        this.m_pos = firstlinePosition;
        this.m_posFirst = firstlinePosition;
    }

    public void addString(CharSequence seq) {
        StringBuffer curr = this.m_strings.get(this.m_strings.size() - 1);
        if (seq.length() > 0) {
            seq.charAt(0);
            seq.charAt(1);
        }
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            switch (ch) {
                case '\u001b': {
                    throw new RuntimeException("ESC");
                }
                case '\n': {
                    curr = this.getNewLine();
                    this.m_strings.add(curr);
                    if (this.m_strings.size() > this.MAXLINES) {
                        this.m_strings.remove(0);
                    }
                    this.m_pos = 0;
                    break;
                }
                case '\r': {
                    this.m_pos = 0;
                    break;
                }
                case '\b': {
                    --this.m_pos;
                    break;
                }
                case '\t': {
                    int tabpos = this.m_pos / 8;
                    int spacesMissed = (tabpos + 1) * 8 - this.m_pos;
                    this.m_pos += spacesMissed;
                    if (this.m_pos <= this.WIDTH) break;
                    this.m_pos -= this.WIDTH;
                    curr = this.getNewLine();
                    this.m_strings.add(curr);
                    if (this.m_strings.size() <= this.MAXLINES) break;
                    this.m_strings.remove(0);
                    break;
                }
                case '\u0007': {
                    break;
                }
                default: {
                    if (this.m_pos == this.WIDTH) {
                        curr = this.getNewLine();
                        this.m_strings.add(curr);
                        if (this.m_strings.size() > this.MAXLINES) {
                            this.m_strings.remove(0);
                        }
                        this.m_pos = 0;
                    }
                    curr.setCharAt(this.m_pos, ch);
                    ++this.m_pos;
                }
            }
            ++i;
        }
        this.m_posLast = this.m_pos;
    }

    private StringBuffer getNewLine() {
        StringBuffer curr = new StringBuffer();
        int k = 0;
        while (k < this.WIDTH) {
            curr.append(" ");
            ++k;
        }
        return curr;
    }

    public int getLineCount() {
        return this.m_strings.size();
    }

    public int getLastPosition() {
        return this.m_posLast;
    }

    public String toString() {
        int start;
        StringBuffer result = new StringBuffer();
        int i = start = Math.max(0, this.m_strings.size() - this.MAXLINES);
        while (i < this.m_strings.size()) {
            result.append(this.m_strings.get(i));
            if (i < this.m_strings.size() - 1) {
                result.append("\r\n");
            }
            ++i;
        }
        return result.toString();
    }

    public void merge(StyledText console, int line, int pos, StyleRange sr) {
        int totallines = console.getLineCount() + this.getLineCount();
        String substring = this.toString().substring(pos);
        if (totallines > this.MAXLINES) {
            console.setSelectionRange(console.getCaretOffset(), console.getCharCount() - console.getCaretOffset());
            console.insert(substring);
            sr.length = substring.length();
            console.setStyleRange(sr);
            int delta = totallines - this.MAXLINES;
            console.setSelection(0, delta * (this.WIDTH + 2));
            console.insert("");
        } else {
            console.setSelectionRange(console.getCaretOffset(), console.getCharCount() - console.getCaretOffset());
            console.insert(substring);
            sr.length = substring.length();
            console.setStyleRange(sr);
        }
    }

    public static void main(String[] args) {
        SshText st = new SshText(100, 50, 500, 10);
        int i = 0;
        while (i < 300) {
            st.addString(i + " 123456789abcdef123456789abcdef 123456789abcdef123456789abcdef 123456789abcdef123456789abcdef\r\n");
            ++i;
        }
    }
}

