/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.SshText;
import com.blixx.boom.gui.views.SshView;
import com.blixx.boom.gui.views.TermViewTab;
import com.blixx.log.RTLogger;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class SshViewTab
extends CTabItem
implements KeyListener,
DisposeListener,
FocusListener,
TraverseListener,
ModifyListener {
    private static final String TERMINAL_TYPE = "xterm";
    public static Color COLOR_BLACK = BMUI.color_black;
    public static Color COLOR_RED = Display.getDefault().getSystemColor(3);
    public static Color COLOR_GREEN = Display.getDefault().getSystemColor(5);
    public static Color COLOR_YELLOW = Display.getDefault().getSystemColor(7);
    public static Color COLOR_BLUE = Display.getDefault().getSystemColor(9);
    public static Color COLOR_MAGENTA = Display.getDefault().getSystemColor(11);
    public static Color COLOR_CYAN = Display.getDefault().getSystemColor(13);
    public static Color COLOR_WHITE = BMUI.color_white;
    public static StyleRange NULL_STYLE = new StyleRange();
    public static String CRLF = "\r\n";
    public static String CRLF_NEWLINE = null;
    public static String NEWLINE_CRLF = null;
    static byte[] terminalModes;
    public IWorkbenchPartSite site;
    public SshViewTab m_sshTab = null;
    protected CTabFolder m_parent = null;
    protected Composite m_mainComp;
    protected Listener[] m_modifyListeners = null;
    protected static final int WIDTH = 110;
    protected static final int WIDTH_2 = 112;
    protected int HEIGHT = 40;
    protected static final String ENTER_HOSTNAME = "Enter hostname: ";
    protected static final String CONNECTING = "Connecting...";
    protected static final String ENTER_PASSWORD = "Enter password: ";
    protected static final String ENTER_USER = "Enter user: ";
    protected StyledText m_console;
    protected int m_line = 0;
    protected int m_pos = 0;
    protected int m_lineMstored = 0;
    protected int m_posMstored = 0;
    protected int m_scrollRegionStart = 0;
    protected int m_scrollRegionEnd = 0;
    protected int m_codeset = 0;
    protected StyleRange m_STYLE = new StyleRange();
    protected int m_lineStored = 0;
    protected int m_posStored = 0;
    protected String m_textStored = "";
    protected StyleRange[] m_stylesStored = null;
    protected boolean m_REDRAW = true;
    protected String m_command = "";
    protected InputStream m_in = null;
    protected OutputStream m_out = null;
    protected String m_host = null;
    protected String m_user = null;
    protected String m_password = null;
    protected int m_mode = 0;
    protected static String NEWLINE;
    protected static String NEWLINE_TEST;
    protected static int MAXLINES;
    boolean m_applicationKeys = true;
    static final char ESC = '\u001b';
    static Font m_font;
    static byte[] arrow_up;
    static byte[] arrow_right;
    static byte[] arrow_left;
    static byte[] arrow_down;
    static byte[] page_up;
    static byte[] page_down;
    static byte[] home;
    static byte[] end;
    static byte[] begin;
    static byte[] insert;
    static byte[] arrow_up_APP;
    static byte[] arrow_right_APP;
    static byte[] arrow_left_APP;
    static byte[] arrow_down_APP;
    static byte[] home_APP;
    static byte[] end_APP;
    static byte[] F1;
    static byte[] F2;
    static byte[] F3;
    static byte[] F4;
    static byte[] F5;
    static byte[] F6;
    static byte[] F7;
    static byte[] F8;
    static byte[] F9;
    static byte[] F10;
    static byte[] F11;
    static byte[] F12;
    static byte[] CTRL_C;
    static byte[] delchar;
    ArrayList<Integer> m_tabs = new ArrayList();
    final String knownHostPath = "sshaction.known_hosts";
    final String idDSAPath = "sshaction.dsa";
    final String idRSAPath = "sshaction.rsa";
    KnownHosts database = new KnownHosts();
    protected AdvancedVerifier VERIFIER = new AdvancedVerifier();
    Session sess = null;
    Connection conn = null;
    protected SshListener m_listener;
    Pattern CSI = Pattern.compile("([?>]?)([\\d;]*)(.)(.*)", 32);
    Pattern OSC = Pattern.compile("([\\d]*);(.*)[\\a~](.*)", 32);
    ConcurrentLinkedQueue<Byte> m_bytes = new ConcurrentLinkedQueue();
    public String m_lastUnprocessed = null;

    static {
        byte[] byArray = new byte[266];
        byArray[0] = 1;
        byArray[4] = 3;
        byArray[5] = 2;
        byArray[9] = 28;
        byArray[10] = 3;
        byArray[14] = 127;
        byArray[15] = 4;
        byArray[19] = 21;
        byArray[20] = 5;
        byArray[24] = 4;
        byArray[25] = 6;
        byArray[29] = -1;
        byArray[30] = 7;
        byArray[34] = -1;
        byArray[35] = 8;
        byArray[39] = 17;
        byArray[40] = 9;
        byArray[44] = 19;
        byArray[45] = 10;
        byArray[49] = 26;
        byArray[50] = 11;
        byArray[54] = 25;
        byArray[55] = 12;
        byArray[59] = 18;
        byArray[60] = 13;
        byArray[64] = 23;
        byArray[65] = 14;
        byArray[69] = 22;
        byArray[70] = 15;
        byArray[74] = 22;
        byArray[75] = 16;
        byArray[79] = 22;
        byArray[80] = 17;
        byArray[84] = 20;
        byArray[85] = 18;
        byArray[89] = 15;
        byArray[90] = 30;
        byArray[95] = 31;
        byArray[100] = 32;
        byArray[105] = 33;
        byArray[110] = 34;
        byArray[115] = 35;
        byArray[120] = 36;
        byArray[124] = 1;
        byArray[125] = 37;
        byArray[130] = 38;
        byArray[134] = 1;
        byArray[135] = 39;
        byArray[139] = 1;
        byArray[140] = 40;
        byArray[145] = 41;
        byArray[150] = 50;
        byArray[154] = 1;
        byArray[155] = 51;
        byArray[159] = 1;
        byArray[160] = 52;
        byArray[164] = 1;
        byArray[165] = 53;
        byArray[169] = 1;
        byArray[170] = 54;
        byArray[174] = 1;
        byArray[175] = 55;
        byArray[180] = 56;
        byArray[185] = 57;
        byArray[190] = 58;
        byArray[195] = 59;
        byArray[199] = 1;
        byArray[200] = 60;
        byArray[204] = 1;
        byArray[205] = 61;
        byArray[209] = 1;
        byArray[210] = 62;
        byArray[214] = 1;
        byArray[215] = 70;
        byArray[219] = 1;
        byArray[220] = 71;
        byArray[225] = 72;
        byArray[229] = 1;
        byArray[230] = 73;
        byArray[235] = 74;
        byArray[240] = 75;
        byArray[245] = 90;
        byArray[249] = 1;
        byArray[250] = 91;
        byArray[254] = 1;
        byArray[255] = 92;
        byArray[260] = 93;
        terminalModes = byArray;
        NEWLINE = "";
        NEWLINE_TEST = "";
        MAXLINES = 1000;
        m_font = null;
        int i = 0;
        while (i < 110) {
            NEWLINE = String.valueOf(NEWLINE) + " ";
            NEWLINE_TEST = String.valueOf(NEWLINE_TEST) + "*";
            CRLF_NEWLINE = String.valueOf(CRLF) + NEWLINE;
            NEWLINE_CRLF = String.valueOf(NEWLINE) + CRLF;
            ++i;
        }
        try {
            String name = "Terminal";
            BMUI.m_fontRegistry.put("code1", new FontData[]{new FontData(name, 10, 0)});
            m_font = BMUI.m_fontRegistry.get("code1");
            FontData[] fd = BMUI.m_fontRegistry.defaultFont().getFontData();
            if (!fd[0].getName().startsWith(name)) {
                m_font = null;
            }
        }
        catch (Throwable throwable) {}
        try {
            if (m_font == null) {
                BMUI.m_fontRegistry.put("code", new FontData[]{new FontData("Courier New", 10, 0)});
                m_font = BMUI.m_fontRegistry.get("code");
            }
        }
        catch (Throwable throwable) {}
        arrow_up = new byte[]{27, 91, 65};
        arrow_right = new byte[]{27, 91, 67};
        arrow_left = new byte[]{27, 91, 68};
        arrow_down = new byte[]{27, 91, 66};
        page_up = new byte[]{27, 91, 53, 126};
        page_down = new byte[]{27, 91, 54, 126};
        home = new byte[]{27, 91, 72};
        end = new byte[]{27, 91, 70};
        begin = new byte[]{27, 91, 69};
        insert = new byte[]{27, 91, 50, 126};
        arrow_up_APP = new byte[]{27, 79, 65};
        arrow_right_APP = new byte[]{27, 79, 67};
        arrow_left_APP = new byte[]{27, 79, 68};
        arrow_down_APP = new byte[]{27, 79, 66};
        home_APP = new byte[]{27, 79, 72};
        end_APP = new byte[]{27, 79, 70};
        F1 = new byte[]{27, 79, 80};
        F2 = new byte[]{27, 79, 81};
        F3 = new byte[]{27, 79, 82};
        F4 = new byte[]{27, 79, 83};
        F5 = new byte[]{27, 91, 49, 53, 126};
        F6 = new byte[]{27, 91, 49, 55, 126};
        F7 = new byte[]{27, 91, 49, 56, 126};
        F8 = new byte[]{27, 91, 49, 57, 126};
        F9 = new byte[]{27, 91, 50, 48, 126};
        F10 = new byte[]{27, 91, 50, 49, 126};
        F11 = new byte[]{27, 91, 50, 51, 126};
        F12 = new byte[]{27, 91, 50, 52, 126};
        CTRL_C = new byte[]{27, 67};
        delchar = new byte[]{27, 91, 51, 126};
    }

    public SshViewTab(IWorkbenchPartSite siteV, CTabFolder parent, int style, int position, String title, boolean isActive) {
        super(parent, style);
        if (title != null) {
            this.setText(title);
        } else {
            this.setText("Empty SSH Console");
        }
        this.setImage(BMUI.IMAGE_SSH);
        this.site = siteV;
        this.m_sshTab = this;
        this.m_parent = parent;
        this.m_mainComp = new Composite((Composite)parent, 2048);
        this.m_mainComp.setLayout((Layout)new GridLayout(1, false));
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createContent(this.m_mainComp);
        this.m_mainComp.addKeyListener((KeyListener)this);
        this.setControl((Control)this.m_mainComp);
    }

    public void createContent(Composite parent) {
        this.m_console = new StyledText(parent, 2818);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.m_console.setLayoutData((Object)gd);
        this.m_console.setEditable(false);
        this.m_console.setText(ENTER_HOSTNAME);
        Caret caret = new Caret((Canvas)this.m_console, 0);
        caret.setSize(8, this.m_console.getCaret().getBounds().height + 2);
        this.m_console.setCaret(caret);
        Listener[] arr = this.m_console.getListeners(1);
        int i = 0;
        while (i < arr.length) {
            this.m_console.removeListener(1, arr[i]);
            ++i;
        }
        arr = this.m_console.getListeners(2);
        i = 0;
        while (i < arr.length) {
            this.m_console.removeListener(2, arr[i]);
            ++i;
        }
        this.m_modifyListeners = this.m_console.getListeners(24);
        this.m_console.setSelectionRange(this.m_console.getCharCount(), 0);
        if (m_font != null) {
            this.m_console.setFont(m_font);
        }
        this.m_console.setBackground(BMUI.color_black);
        this.m_console.setForeground(BMUI.color_white);
        this.addContentMenu(this.m_console);
        this.m_console.addKeyListener((KeyListener)this);
    }

    public void addContentMenu(final StyledText field) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)field);
        field.setMenu(menu);
        SshView.getInstance().getSite().registerContextMenu(menuMgr, null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Copy";
                        }

                        public String getId() {
                            return "Copy";
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED");
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
                        }

                        public void run() {
                            field.copy();
                        }
                    });
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Paste";
                        }

                        public String getId() {
                            return "Paste";
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED");
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE");
                        }

                        public void run() {
                            Text t = new Text((Composite)Display.getCurrent().getActiveShell(), 0);
                            t.setVisible(false);
                            t.paste();
                            String clipboardContent = t.getText();
                            if ((this).SshViewTab.this.m_out != null) {
                                try {
                                    (this).SshViewTab.this.m_out.write(clipboardContent.getBytes());
                                }
                                catch (Throwable throwable) {}
                            } else {
                                (this).SshViewTab.this.m_console.append(clipboardContent);
                                (this).SshViewTab.this.m_console.setSelection((this).SshViewTab.this.m_console.getCharCount());
                                (this).SshViewTab.this.m_command = String.valueOf((this).SshViewTab.this.m_command) + clipboardContent;
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyTraversed(TraverseEvent e) {
        e.doit = false;
    }

    public void dispose() {
        super.dispose();
        try {
            this.m_mainComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_in.close();
        }
        catch (Throwable throwable) {}
        try {
            this.m_out.close();
        }
        catch (Throwable throwable) {}
        try {
            this.sess.close();
        }
        catch (Throwable throwable) {}
        try {
            this.conn.close();
        }
        catch (Throwable throwable) {}
        this.m_in = null;
    }

    public void keyPressed(KeyEvent e) {
        if (this.m_mode > 2) {
            this.ttyMode(e);
        } else {
            this.textMode(e);
        }
    }

    protected void textMode(KeyEvent e) {
        switch (e.keyCode) {
            case 9: 
            case 127: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: 
            case 0x100000A: {
                if (e.stateMask == 65536) {
                    TermViewTab sshTab = new TermViewTab(this.site, this.m_parent, 64, this.m_parent.getItemCount(), null, true);
                    this.m_parent.setSelection((CTabItem)sshTab);
                }
            }
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x100000B: 
            case 0x100000C: 
            case 0x100000D: 
            case 0x100000E: 
            case 0x100000F: 
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: 
            case 0x1000015: 
            case 0x1000016: 
            case 0x1000017: 
            case 0x1000018: 
            case 16777298: 
            case 16777299: {
                e.doit = false;
                break;
            }
            case 27: {
                this.m_command = "";
                this.m_mode = 0;
                this.m_console.setText(ENTER_HOSTNAME);
                this.m_console.setSelectionRange(this.m_console.getCharCount(), 0);
                e.doit = false;
                break;
            }
            case 8: {
                if (this.m_command.length() >= 1) {
                    this.m_command = this.m_command.substring(0, this.m_command.length() - 1);
                    this.m_console.setSelectionRange(this.m_console.getCharCount() - 1, 1);
                    this.m_console.insert("");
                    break;
                }
                e.doit = false;
                break;
            }
            case 13: {
                if (this.m_command.length() > 0) {
                    this.processCommand(this.m_command);
                }
                e.doit = false;
                break;
            }
            case 10: {
                e.doit = false;
                break;
            }
            default: {
                if (e.stateMask == 262144) break;
                this.m_command = String.valueOf(this.m_command) + e.character;
                if (this.m_mode == 2) {
                    this.m_console.append("*");
                } else {
                    this.m_console.append("" + e.character);
                }
                this.m_console.setSelectionRange(this.m_console.getCharCount(), 0);
                e.doit = false;
            }
        }
    }

    protected void ttyMode(KeyEvent e) {
        try {
            e.doit = false;
            switch (e.keyCode) {
                case 65536: 
                case 131072: 
                case 262144: {
                    break;
                }
                case 0x100000A: {
                    this.m_out.write(F1);
                    break;
                }
                case 0x100000B: {
                    this.m_out.write(F2);
                    break;
                }
                case 0x100000C: {
                    this.m_out.write(F3);
                    break;
                }
                case 0x100000D: {
                    this.m_out.write(F4);
                    break;
                }
                case 0x100000E: {
                    this.m_out.write(F5);
                    break;
                }
                case 0x100000F: {
                    this.m_out.write(F6);
                    break;
                }
                case 0x1000010: {
                    this.m_out.write(F7);
                    break;
                }
                case 0x1000011: {
                    this.m_out.write(F8);
                    break;
                }
                case 0x1000012: {
                    this.m_out.write(F9);
                    break;
                }
                case 0x1000013: {
                    this.m_out.write(F10);
                    break;
                }
                case 0x1000014: {
                    this.m_out.write(F11);
                    break;
                }
                case 0x1000015: {
                    this.m_out.write(F12);
                    break;
                }
                case 0x1000016: {
                    break;
                }
                case 0x1000017: {
                    break;
                }
                case 0x1000018: {
                    break;
                }
                case 0x1000001: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_up_APP);
                        break;
                    }
                    this.m_out.write(arrow_up);
                    break;
                }
                case 0x1000004: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_right_APP);
                        break;
                    }
                    this.m_out.write(arrow_right);
                    break;
                }
                case 0x1000003: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_left_APP);
                        break;
                    }
                    this.m_out.write(arrow_left);
                    break;
                }
                case 0x1000002: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_down_APP);
                        break;
                    }
                    this.m_out.write(arrow_down);
                    break;
                }
                case 0x1000005: {
                    this.m_out.write(page_up);
                    break;
                }
                case 0x1000006: {
                    this.m_out.write(page_down);
                    break;
                }
                case 0x1000009: {
                    this.m_out.write(insert);
                    break;
                }
                case 0x1000007: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(home_APP);
                        break;
                    }
                    this.m_out.write(home);
                    break;
                }
                case 0x1000008: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(end_APP);
                        break;
                    }
                    this.m_out.write(end);
                    break;
                }
                case 127: {
                    this.m_out.write(delchar);
                    break;
                }
                case 68: 
                case 100: {
                    if (e.stateMask == 262144) {
                        this.m_out.write(e.character);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.m_in.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.m_out.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.sess.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.conn.close();
                        }
                        catch (Throwable throwable) {}
                        this.m_in = null;
                        this.setText(String.valueOf(this.getText()) + "(terminated)");
                        break;
                    }
                }
                case 118: {
                    int cfr_ignored_0 = e.stateMask;
                }
                default: {
                    if (e.character > '\u0000') {
                        this.m_out.write(e.character);
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.m_mode > 2) {
            if (e.character > '\u0000' && e.stateMask == 262144) {
                try {
                    this.m_out.write(e.character);
                }
                catch (IOException iOException) {}
            }
            e.doit = false;
            return;
        }
        e.doit = false;
    }

    public void processCommand(String command) {
        switch (this.m_mode) {
            case 0: {
                this.m_host = command.trim();
                this.m_console.insert(String.valueOf(this.m_console.getLineDelimiter()) + ENTER_USER);
                this.m_console.setSelection(this.m_console.getCharCount());
                ++this.m_mode;
                break;
            }
            case 1: {
                this.m_user = command.trim();
                this.m_console.insert(String.valueOf(this.m_console.getLineDelimiter()) + ENTER_PASSWORD);
                this.m_console.setSelection(this.m_console.getCharCount());
                ++this.m_mode;
                break;
            }
            case 2: {
                this.m_password = command.trim();
                this.m_console.insert(String.valueOf(this.m_console.getLineDelimiter()) + CONNECTING);
                this.m_console.setSelection(this.m_console.getCharCount());
                try {
                    this.connect();
                    this.m_sshTab.setText(String.valueOf(this.m_user) + "@" + this.m_host + " (ssh)");
                    ++this.m_mode;
                    this.m_console.setEditable(false);
                    this.m_console.addFocusListener((FocusListener)this);
                    this.m_console.addTraverseListener((TraverseListener)this);
                    this.m_console.setText(NEWLINE);
                    this.m_console.setSelection(0);
                }
                catch (IOException e) {
                    this.m_mode = 0;
                    this.m_console.setText("Error: " + e.getMessage() + "\n\n" + ENTER_HOSTNAME);
                    this.m_console.setSelection(this.m_console.getCharCount());
                }
                break;
            }
            case 3: {
                try {
                    String full = String.valueOf(command) + CRLF;
                    this.m_out.write(full.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.m_command = "";
    }

    public void connect() throws IOException {
        block21: {
            File knownHostFile = new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "sshaction.known_hosts");
            if (!knownHostFile.exists()) {
                knownHostFile.createNewFile();
            }
            try {
                this.database.addHostkeys(knownHostFile);
            }
            catch (IOException iOException) {}
            this.conn = new Connection(this.m_host);
            String[] hostkeyAlgos = this.database.getPreferredServerHostkeyAlgorithmOrder(this.m_host);
            if (hostkeyAlgos != null) {
                this.conn.setServerHostKeyAlgorithms(hostkeyAlgos);
            }
            this.conn.connect((ServerHostKeyVerifier)this.VERIFIER);
            if (this.VERIFIER.message != null) {
                ShowMessageDialog smd;
                int res;
                String header = this.VERIFIER.message;
                String message = this.VERIFIER.message2;
                if (message == null) {
                    message = new String(this.VERIFIER._serverHostKey);
                }
                if ((res = (smd = new ShowMessageDialog(this.m_console.getShell(), "Ssh Authentication", header, message, "", true, "OK", 200)).open()) != 0) {
                    throw new IOException("Authentication canceled by user");
                }
                this.database.addHostkey(new String[]{this.VERIFIER.hashedHostname}, this.VERIFIER._serverHostKeyAlgorithm, this.VERIFIER._serverHostKey);
                try {
                    KnownHosts.addHostkeyToFile((File)new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "sshaction.known_hosts"), (String[])new String[]{this.VERIFIER.hashedHostname}, (String)this.VERIFIER._serverHostKeyAlgorithm, (byte[])this.VERIFIER._serverHostKey);
                }
                catch (IOException iOException) {}
            }
            boolean enableKeyboardInteractive = true;
            boolean enableDSA = true;
            boolean enableRSA = true;
            String lastError = null;
            while (true) {
                boolean res;
                if ((enableDSA || enableRSA) && this.conn.isAuthMethodAvailable(this.m_user, "publickey")) {
                    File key;
                    if (enableDSA) {
                        key = new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "sshaction.dsa");
                        if (key.exists()) {
                            res = this.conn.authenticateWithPublicKey(this.m_user, key, this.m_password);
                            if (res) break block21;
                            lastError = "DSA authentication failed.";
                        }
                        enableDSA = false;
                    }
                    if (!enableRSA) continue;
                    key = new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "sshaction.rsa");
                    if (key.exists()) {
                        res = this.conn.authenticateWithPublicKey(this.m_user, key, this.m_password);
                        if (res) break block21;
                        lastError = "RSA authentication failed.";
                    }
                    enableRSA = false;
                    continue;
                }
                if (enableKeyboardInteractive && this.conn.isAuthMethodAvailable(this.m_user, "keyboard-interactive")) {
                    InteractiveLogic il = new InteractiveLogic(lastError, this.m_password);
                    res = this.conn.authenticateWithKeyboardInteractive(this.m_user, (InteractiveCallback)il);
                    if (!res) {
                        if (il.getPromptCount() == 0) {
                            lastError = "Keyboard-interactive does not work.";
                            enableKeyboardInteractive = false;
                            continue;
                        }
                        lastError = "Keyboard-interactive auth failed.";
                        continue;
                    }
                } else {
                    if (!this.conn.isAuthMethodAvailable(this.m_user, "password")) break;
                    boolean res2 = this.conn.authenticateWithPassword(this.m_user, this.m_password);
                    if (!res2) {
                        lastError = "Password authentication failed.";
                        continue;
                    }
                }
                break block21;
                break;
            }
            throw new IOException("No supported authentication methods available.");
        }
        this.sess = this.conn.openSession();
        this.HEIGHT = this.m_console.getBounds().height / this.m_console.getLineHeight() - 1;
        this.m_STYLE.background = BMUI.color_black;
        this.m_STYLE.foreground = BMUI.color_white;
        this.m_STYLE.fontStyle = 0;
        this.m_scrollRegionStart = 1;
        this.m_scrollRegionEnd = this.HEIGHT;
        this.sess.requestPTY(TERMINAL_TYPE, 110, this.HEIGHT, 0, 0, null);
        this.sess.startShell();
        this.m_in = this.sess.getStdout();
        this.m_out = this.sess.getStdin();
        this.m_listener = new SshListener(this.m_in, this.m_bytes);
        this.m_listener.start();
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_in.close();
        }
        catch (Throwable throwable) {}
        try {
            this.m_out.close();
        }
        catch (Throwable throwable) {}
        try {
            this.sess.close();
        }
        catch (Throwable throwable) {}
        try {
            this.conn.close();
        }
        catch (Throwable throwable) {}
        this.m_in = null;
    }

    public void modifyText(ModifyEvent e) {
    }

    protected String getLine(int line) {
        int start = 112 * this.m_line;
        String text = this.m_console.getText(start, start + 110);
        return text;
    }

    public static char getPseudoGraphic(char in) {
        char out = '\u2500';
        switch (in) {
            case 'q': {
                out = '\u2500';
                break;
            }
            case 'l': {
                out = '\u250c';
                break;
            }
            case 'k': {
                out = '\u2510';
                break;
            }
            case 'x': {
                out = '\u2502';
                break;
            }
            case 'j': {
                out = '\u2518';
                break;
            }
            case 'm': {
                out = '\u2514';
                break;
            }
            case 't': {
                out = '\u251c';
                break;
            }
            case 'u': {
                out = '\u2524';
                break;
            }
            case 'w': {
                out = '\u252c';
                break;
            }
            case 'v': {
                out = '\u2534';
                break;
            }
            case 'a': {
                out = '\u2591';
                break;
            }
            default: {
                out = in;
            }
        }
        return out;
    }

    class AdvancedVerifier
    implements ServerHostKeyVerifier {
        String message = null;
        String message2 = null;
        String hashedHostname = "";
        String _serverHostKeyAlgorithm;
        byte[] _serverHostKey = null;

        AdvancedVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String host = hostname;
            this.message2 = null;
            this._serverHostKeyAlgorithm = serverHostKeyAlgorithm;
            this._serverHostKey = serverHostKey;
            int result = SshViewTab.this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    this.message = "Do you want to accept the hostkey (type " + this._serverHostKeyAlgorithm + ") from " + host + " ?\n";
                    break;
                }
                case 2: {
                    this.message = "WARNING! Hostkey for " + host + " has changed!\nAccept anyway?\n";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            this.message2 = "Hex Fingerprint: " + hexFingerprint + "\n" + "Bubblebabble Fingerprint: " + bubblebabbleFingerprint;
            this.hashedHostname = KnownHosts.createHashedHostname((String)hostname);
            return true;
        }
    }

    static class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        String lastError;
        String m_password;

        public InteractiveLogic(String lastError, String password) {
            this.lastError = lastError;
            this.m_password = password;
        }

        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            int i = 0;
            while (i < numPrompts) {
                String[] stringArray = new String[]{this.lastError, name, instruction, prompt[i]};
                if (this.lastError != null) {
                    this.lastError = null;
                }
                result[i] = this.m_password;
                ++this.promptCount;
                ++i;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    public class SshListener
    extends Thread {
        InputStream m_input = null;
        ConcurrentLinkedQueue<Byte> m_parentBytes = null;

        public SshListener(InputStream in, ConcurrentLinkedQueue<Byte> bytes) {
            this.m_input = in;
            this.m_parentBytes = bytes;
        }

        @Override
        public void run() {
            try {
                byte[] arr = new byte[65536];
                int screen = 112 * SshViewTab.this.HEIGHT;
                while (this.m_input != null) {
                    int chars = -1;
                    chars = this.m_input.read(arr);
                    if (chars > 0) {
                        int i = 0;
                        while (i < chars) {
                            this.m_parentBytes.add(arr[i]);
                            ++i;
                        }
                        if (this.m_input.available() != 0 && this.m_parentBytes.size() <= screen * 2) continue;
                        Update upd = new Update(this.m_parentBytes.size());
                        Repository.getUIJobManager().schedule(upd);
                        continue;
                    }
                    if (chars != -1) continue;
                    return;
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public class Update
    extends UIJob {
        int m_count;

        public Update(int count) {
            super("upd" + System.currentTimeMillis());
            this.m_count = 0;
            this.m_count = count;
        }

        @Override
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList<StringBuffer> m_lines = new ArrayList<StringBuffer>();
            StringBuffer sb = new StringBuffer();
            if (SshViewTab.this.m_lastUnprocessed != null) {
                sb.append(SshViewTab.this.m_lastUnprocessed.substring(1));
                m_lines.add(new StringBuffer(0));
                SshViewTab.this.m_lastUnprocessed = null;
            }
            Byte lb = null;
            int ic = 0;
            while ((lb = SshViewTab.this.m_bytes.peek()) != null) {
                if (ic > this.m_count && lb != null && (lb == 27 || lb == 10 || lb == 13)) break;
                ++ic;
                Byte b = SshViewTab.this.m_bytes.poll();
                if (b == null) break;
                int ch = b.intValue();
                if (ch >= 0) {
                    if (ch == 27) {
                        m_lines.add(sb);
                        sb = new StringBuffer();
                        continue;
                    }
                    sb.append((char)ch);
                    continue;
                }
                int extCh = 256 + b;
                if (extCh <= 159) {
                    extCh -= 127;
                    continue;
                }
                sb.append((char)extCh);
            }
            if (sb.length() > 0) {
                m_lines.add(sb);
            }
            if (m_lines.size() == 0) {
                return Status.OK_STATUS;
            }
            this.onStart();
            if (m_lines.size() > 1) {
                m_lines.set(0, this.INSERT((StringBuffer)m_lines.get(0)));
                int i = 0;
                while (i < m_lines.size()) {
                    StringBuffer current = (StringBuffer)m_lines.get(i);
                    if (current.length() != 0) {
                        char charAt0 = current.charAt(0);
                        if (charAt0 == '[') {
                            if (this.CSI(current = current.deleteCharAt(0), i) && i > 0 && i == m_lines.size() - 1) {
                                SshViewTab.this.m_lastUnprocessed = "\u001b[" + current;
                                SshViewTab.this.m_console.setRedraw(true);
                                SshViewTab.this.m_console.update();
                                return Status.OK_STATUS;
                            }
                        } else if (charAt0 == ']') {
                            Matcher m = SshViewTab.this.OSC.matcher(current = current.deleteCharAt(0));
                            if (m.matches() && m.group(3) != null && m.group(3).length() > 0) {
                                StringBuffer gr3 = new StringBuffer(m.group(3));
                                this.INSERT(gr3);
                            }
                        } else if (charAt0 == '(' || charAt0 == ')' || charAt0 == '*' || charAt0 == '+' || charAt0 == ' ' || charAt0 == '%') {
                            if (i > 0 && i == m_lines.size() - 1 && current.length() < 2) {
                                SshViewTab.this.m_lastUnprocessed = "\u001b" + current;
                                SshViewTab.this.m_console.setRedraw(true);
                                SshViewTab.this.m_console.update();
                                return Status.OK_STATUS;
                            }
                            if (charAt0 == '(') {
                                SshViewTab.this.m_codeset = 0;
                                if (current.charAt(1) == '0') {
                                    SshViewTab.this.m_codeset = 1;
                                }
                            }
                            if (current.length() > 2) {
                                current = current.deleteCharAt(0);
                                current = current.deleteCharAt(0);
                                this.INSERT(current);
                            }
                        } else {
                            switch (charAt0) {
                                case 'H': {
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case '7': {
                                    SshViewTab.this.m_lineMstored = SshViewTab.this.m_line;
                                    SshViewTab.this.m_posMstored = SshViewTab.this.m_pos;
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case '8': {
                                    this.MOVECURSOR(SshViewTab.this.m_lineMstored + 1, SshViewTab.this.m_posMstored + 1);
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case '=': {
                                    SshViewTab.this.m_applicationKeys = true;
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case '>': {
                                    SshViewTab.this.m_applicationKeys = false;
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case 'M': {
                                    int l = SshViewTab.this.m_line;
                                    StyleRange sr = new StyleRange();
                                    sr.background = SshViewTab.this.m_STYLE.background;
                                    sr.foreground = SshViewTab.this.m_STYLE.foreground;
                                    sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                                    sr.start = SshViewTab.this.m_console.getCaretOffset();
                                    SshViewTab.this.m_console.insert(NEWLINE_CRLF);
                                    this.applyColors(sr, 112);
                                    int begin = (this.getFirstVisibleLine() + SshViewTab.this.m_scrollRegionEnd) * 112;
                                    SshViewTab.this.m_console.setSelectionRange(begin - 112, 112);
                                    SshViewTab.this.m_console.insert("");
                                    this.MOVECURSOR(l + 1, 1);
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case 'D': {
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                case 'E': 
                                case 'F': 
                                case 'N': 
                                case 'O': 
                                case 'P': 
                                case 'V': 
                                case 'W': 
                                case 'X': 
                                case 'Z': 
                                case '\\': 
                                case '^': 
                                case '_': 
                                case 'c': 
                                case 'l': 
                                case 'm': 
                                case 'n': 
                                case 'o': 
                                case '|': 
                                case '}': 
                                case '~': {
                                    current = current.deleteCharAt(0);
                                    break;
                                }
                                default: {
                                    current = current.deleteCharAt(0);
                                }
                            }
                            this.INSERT(current);
                        }
                    }
                    ++i;
                }
            } else if (m_lines.size() == 1) {
                this.INSERT((StringBuffer)m_lines.get(0));
            }
            this.onStop();
            return Status.OK_STATUS;
        }

        protected void onStart() {
            SshViewTab.this.m_REDRAW = false;
            SshViewTab.this.m_console.setRedraw(false);
            if (SshViewTab.this.m_console.getTopIndex() != this.getFirstVisibleLine()) {
                SshViewTab.this.m_console.setTopIndex(this.getFirstVisibleLine());
            }
            this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
        }

        protected void onStop() {
            SshViewTab.this.m_REDRAW = true;
            if (SshViewTab.this.m_console.getTopIndex() != this.getFirstVisibleLine()) {
                SshViewTab.this.m_console.setTopIndex(this.getFirstVisibleLine());
            }
            SshViewTab.this.m_console.setRedraw(true);
        }

        /*
         * Unable to fully structure code
         */
        protected StringBuffer INSERT(StringBuffer m_addChars) {
            processed = 0;
            sr = new StyleRange();
            sr.background = SshViewTab.this.m_STYLE.background;
            sr.foreground = SshViewTab.this.m_STYLE.foreground;
            sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
            sr.start = SshViewTab.this.m_console.getCaretOffset();
            try {
                if (m_addChars.length() > 112 * SshViewTab.this.HEIGHT) {
                    st = new SshText(110, SshViewTab.this.HEIGHT, SshViewTab.MAXLINES, SshViewTab.this.m_pos);
                    st.addString(m_addChars);
                    m_addChars = null;
                    st.merge(SshViewTab.this.m_console, SshViewTab.this.m_line, SshViewTab.this.m_pos, sr);
                    SshViewTab.this.m_pos = st.getLastPosition();
                    SshViewTab.this.m_line = SshViewTab.this.m_console.getLineCount() - 1;
                    this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
                    return new StringBuffer(0);
                }
            }
            catch (RuntimeException v0) {}
            try {
                toColor = 0;
                currPosition = 0;
                selectedToInsert = 0;
                while (currPosition < m_addChars.length()) {
                    if (SshViewTab.this.m_pos < 110) {
                        restSpaceToEOL = 110 - SshViewTab.this.m_pos;
                        maxToEOL = Math.min(restSpaceToEOL, m_addChars.length() - currPosition);
                        curr = SshViewTab.this.m_console.getCaretOffset();
                        selectedToInsert = 0;
                        while (selectedToInsert < maxToEOL) {
                            ch0 = m_addChars.charAt(currPosition + selectedToInsert);
                            if (ch0 < '\u001f' || ch0 > '~' && ch0 <= '\u009f') {
                                if (selectedToInsert <= 0) break;
                                SshViewTab.this.m_console.setSelectionRange(curr, selectedToInsert);
                                SshViewTab.this.m_console.insert(m_addChars.substring(currPosition, currPosition + selectedToInsert));
                                this.MOVECURSOR(selectedToInsert);
                                currPosition += selectedToInsert;
                                selectedToInsert = 0;
                                break;
                            }
                            if (SshViewTab.this.m_codeset != 0) {
                                ch0 = SshViewTab.getPseudoGraphic(ch0);
                                m_addChars.setCharAt(currPosition + selectedToInsert, ch0);
                            }
                            ++toColor;
                            ++processed;
                            ++selectedToInsert;
                        }
                        if (selectedToInsert > 0) {
                            lenMax = Math.min(selectedToInsert, SshViewTab.this.m_console.getCharCount());
                            SshViewTab.this.m_console.setSelectionRange(curr, lenMax);
                            SshViewTab.this.m_console.insert(m_addChars.substring(currPosition, currPosition + selectedToInsert));
                            this.MOVECURSOR(selectedToInsert);
                            if ((currPosition += selectedToInsert) >= m_addChars.length()) {
                                try {
                                    this.applyColors(sr, selectedToInsert);
                                }
                                catch (Throwable v1) {}
                                m_addChars.setLength(0);
                                var14_14 = m_addChars;
                                return var14_14;
                            }
                        }
                    }
                    ch = m_addChars.charAt(currPosition);
                    switch (ch) {
                        case '\u000e': {
                            SshViewTab.this.m_codeset = 1;
                            break;
                        }
                        case '\u000f': {
                            SshViewTab.this.m_codeset = 0;
                            break;
                        }
                        case '\b': {
                            this.MOVECURSOR(-1);
                            --sr.start;
                            break;
                        }
                        case '\r': {
                            this.MOVECURSOR(SshViewTab.this.m_line + 1, 1);
                            break;
                        }
                        case '\n': {
                            this.applyColors(sr, toColor);
                            this.NEWLINE(false);
                            sr = new StyleRange();
                            sr.background = SshViewTab.this.m_STYLE.background;
                            sr.foreground = SshViewTab.this.m_STYLE.foreground;
                            sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                            sr.start = SshViewTab.this.m_console.getCaretOffset();
                            toColor = 0;
                            break;
                        }
                        case '\t': {
                            tabpos = SshViewTab.this.m_pos / 8;
                            spacesMissed = (tabpos + 1) * 8 - SshViewTab.this.m_pos;
                            this.MOVECURSOR(spacesMissed);
                            break;
                        }
                        case '\u0007': {
                            break;
                        }
                        case '\u001b': {
                            this.applyColors(sr, toColor);
                            m_addChars.delete(0, processed);
                            var14_15 = m_addChars;
                            return var14_15;
                        }
                        default: {
                            if (SshViewTab.this.m_codeset != 0) {
                                ch = SshViewTab.getPseudoGraphic(ch);
                            }
                            if (SshViewTab.this.m_pos >= 110) ** GOTO lbl121
                            sum = SshViewTab.this.m_console.getCaretOffset();
                            try {
                                SshViewTab.this.m_console.setSelectionRange(sum, 1);
                                SshViewTab.this.m_console.insert("" + ch);
                                this.MOVECURSOR(1);
                            }
                            catch (Exception v2) {
                                try {
                                    this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
                                    sum = SshViewTab.this.m_console.getCaretOffset();
                                    SshViewTab.this.m_console.setSelectionRange(sum, 1);
                                    SshViewTab.this.m_console.insert("" + ch);
                                    this.MOVECURSOR(1);
                                    ** GOTO lbl143
                                }
                                catch (Throwable v3) {}
                            }
                            ** GOTO lbl143
lbl121:
                            // 1 sources

                            if (SshViewTab.this.m_pos >= 110 && (ch != '\r' || ch != '\n')) {
                                this.applyColors(sr, toColor - 1);
                                stored = SshViewTab.this.m_console.getCaretOffset();
                                if (this.NEWLINE(false) < 0) {
                                    sr.start -= 112;
                                    stored -= 112;
                                }
                                SshViewTab.this.m_pos = 0;
                                SshViewTab.this.m_console.setSelectionRange(stored + 2, 0);
                                sr = new StyleRange();
                                sr.background = SshViewTab.this.m_STYLE.background;
                                sr.foreground = SshViewTab.this.m_STYLE.foreground;
                                sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                                sr.start = SshViewTab.this.m_console.getCaretOffset();
                                toColor = 0;
                                sum = SshViewTab.this.m_console.getCaretOffset();
                                try {
                                    SshViewTab.this.m_console.setSelectionRange(sum, 1);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                SshViewTab.this.m_console.insert("" + ch);
                                this.MOVECURSOR(1);
                            }
lbl143:
                            // 6 sources

                            ++toColor;
                        }
                    }
                    ++processed;
                    ++currPosition;
                }
                this.applyColors(sr, toColor);
                if (processed < m_addChars.length()) {
                    m_addChars.delete(0, processed);
                    var14_16 = m_addChars;
                    return var14_16;
                }
                m_addChars.setLength(0);
                var14_17 = m_addChars;
                return var14_17;
            }
            finally {
                if (SshViewTab.this.m_console.getLineCount() > SshViewTab.MAXLINES) {
                    linesToDelete = SshViewTab.this.m_console.getLineCount() - SshViewTab.MAXLINES;
                    SshViewTab.this.m_console.setSelectionRange(0, linesToDelete * 112);
                    SshViewTab.this.m_console.insert("");
                    SshViewTab.this.m_line -= linesToDelete;
                    this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
                }
            }
        }

        protected void applyColors(StyleRange sr, int toColor) {
            if (toColor > 0) {
                sr.length = toColor;
                try {
                    if (sr.background == COLOR_BLACK && sr.foreground == COLOR_WHITE && sr.fontStyle == 1) {
                        sr = NULL_STYLE;
                    }
                    SshViewTab.this.m_console.setStyleRange(sr);
                }
                catch (Throwable throwable) {}
            }
        }

        protected int NEWLINE(boolean force) {
            int lastR;
            int toColor = 0;
            ++SshViewTab.this.m_line;
            int posintext = SshViewTab.this.m_console.getCaretOffset();
            if (posintext == 0) {
                posintext = 1;
            }
            if ((lastR = this.getEOL(posintext - 1, '\r')) == -1 && SshViewTab.this.m_pos != 110) {
                SshViewTab.this.m_console.append(CRLF_NEWLINE);
            } else {
                if ((SshViewTab.this.m_pos == 110 || force || SshViewTab.this.m_line > SshViewTab.this.m_console.getLineCount()) && lastR == -1) {
                    SshViewTab.this.m_console.append(CRLF_NEWLINE);
                }
                if (SshViewTab.this.m_line == this.getFirstVisibleLine() + SshViewTab.this.m_scrollRegionEnd) {
                    SshViewTab.this.m_console.setSelectionRange(lastR, 0);
                    StyleRange sr = new StyleRange();
                    sr.background = SshViewTab.this.m_STYLE.background;
                    sr.foreground = SshViewTab.this.m_STYLE.foreground;
                    sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                    sr.start = SshViewTab.this.m_console.getCaretOffset();
                    SshViewTab.this.m_console.insert(CRLF_NEWLINE);
                    this.applyColors(sr, 112);
                    ++SshViewTab.this.m_line;
                    if (SshViewTab.this.m_scrollRegionStart != 1) {
                        int begin = (this.getFirstVisibleLine() + SshViewTab.this.m_scrollRegionStart) * 112;
                        SshViewTab.this.m_console.setSelectionRange((begin -= 112) - 112, 112);
                        SshViewTab.this.m_console.insert("");
                        --SshViewTab.this.m_line;
                    }
                }
            }
            this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
            return toColor;
        }

        public int getEOL(int startPos, char tosearch) {
            int eol = startPos;
            int max = SshViewTab.this.m_console.getCharCount();
            if (startPos < 0 || max <= startPos) {
                return -1;
            }
            String t = SshViewTab.this.m_console.getText(startPos, max - 1);
            int r = t.indexOf(tosearch);
            if (r == -1) {
                return r;
            }
            return eol += r;
        }

        public int getFirstVisibleLine() {
            int fv = SshViewTab.this.m_console.getLineCount() - SshViewTab.this.HEIGHT;
            if (fv < 0) {
                fv = 0;
            }
            return fv;
        }

        public void ERASE_RIGHT() {
            int l = SshViewTab.this.m_line;
            int p = SshViewTab.this.m_pos;
            int rest = 110 - SshViewTab.this.m_pos;
            if (rest <= 0) {
                return;
            }
            this.INSERT_BLANKS(rest);
            this.MOVECURSOR(l + 1, p + 1);
        }

        public void ERASE_DOWN() {
            int l = SshViewTab.this.m_line;
            int p = SshViewTab.this.m_pos;
            this.ERASE_RIGHT();
            int cc = SshViewTab.this.HEIGHT - (SshViewTab.this.m_line - this.getFirstVisibleLine() + 1);
            int i = 1;
            while (i <= cc) {
                this.MOVECURSOR(l + 1 + i, 1);
                this.INSERT_BLANKS(110);
                ++i;
            }
            this.MOVECURSOR(l + 1, p + 1);
        }

        public void MOVECURSOR(int delta) {
            if (delta == 0) {
                return;
            }
            if (delta > 0) {
                int i = 1;
                while (i <= delta) {
                    ++SshViewTab.this.m_pos;
                    if (SshViewTab.this.m_pos == 111) {
                        SshViewTab.this.m_pos = 0;
                        ++SshViewTab.this.m_line;
                    }
                    ++i;
                }
            } else {
                delta *= -1;
                int i = 1;
                while (i <= delta) {
                    --SshViewTab.this.m_pos;
                    if (SshViewTab.this.m_pos == -1) {
                        SshViewTab.this.m_pos = 110;
                        --SshViewTab.this.m_line;
                    }
                    ++i;
                }
            }
            if (SshViewTab.this.m_line < 0) {
                SshViewTab.this.m_line = 0;
            }
            if (SshViewTab.this.m_pos < 0) {
                SshViewTab.this.m_pos = 0;
            }
            if (SshViewTab.this.m_line == 0) {
                SshViewTab.this.m_console.setSelectionRange(SshViewTab.this.m_pos, 0);
            } else {
                SshViewTab.this.m_console.setSelectionRange(112 * SshViewTab.this.m_line + SshViewTab.this.m_pos, 0);
            }
        }

        /*
         * Unable to fully structure code
         */
        public boolean MOVECURSOR(int line, int pos) {
            isNewLineCreated = false;
            try {
                block6: {
                    block7: {
                        block5: {
                            SshViewTab.this.m_line = line - 1;
                            SshViewTab.this.m_pos = pos - 1;
                            if (SshViewTab.this.m_line != 0) break block5;
                            SshViewTab.this.m_console.setSelectionRange(SshViewTab.this.m_pos, 0);
                            break block6;
                        }
                        start = 112 * SshViewTab.this.m_line + SshViewTab.this.m_pos;
                        max = SshViewTab.this.m_console.getCharCount();
                        if (start <= max) break block7;
                        if (start - max != 2) ** GOTO lbl24
                        SshViewTab.this.m_console.setSelectionRange(max, 0);
                        SshViewTab.this.m_console.append(SshViewTab.CRLF_NEWLINE);
                        SshViewTab.this.m_console.setSelectionRange(start, 0);
                        if (SshViewTab.this.HEIGHT < SshViewTab.this.m_scrollRegionEnd) {
                            ++SshViewTab.this.HEIGHT;
                        }
                        isNewLineCreated = true;
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            SshViewTab.this.m_console.append(SshViewTab.CRLF_NEWLINE);
                            max += 112;
                            if (SshViewTab.this.HEIGHT >= SshViewTab.this.m_scrollRegionEnd) continue;
                            ++SshViewTab.this.HEIGHT;
lbl24:
                            // 3 sources

                            ** while (start >= max)
                        }
lbl25:
                        // 1 sources

                        SshViewTab.this.m_console.setSelectionRange(start, 0);
                        break block6;
                    }
                    SshViewTab.this.m_console.setSelectionRange(start, 0);
                }
                if (SshViewTab.this.m_console.getTopIndex() != this.getFirstVisibleLine()) {
                    SshViewTab.this.m_console.setTopIndex(this.getFirstVisibleLine());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return isNewLineCreated;
        }

        protected boolean CSI(StringBuffer current, int counter) {
            boolean isPartOfNextTransmittion = false;
            int def = -1;
            int[] defa = null;
            Matcher m = SshViewTab.this.CSI.matcher(current);
            if (!m.matches()) {
                if (counter == 0) {
                    this.INSERT(current);
                } else {
                    isPartOfNextTransmittion = true;
                }
                return isPartOfNextTransmittion;
            }
            if (m.group(2) != null && m.group(2).length() > 0) {
                if (m.group(2).indexOf(";") != -1) {
                    String[] iii = m.group(2).split(";");
                    defa = new int[iii.length];
                    int j = 0;
                    while (j < iii.length) {
                        try {
                            defa[j] = Integer.parseInt(iii[j]);
                        }
                        catch (Throwable throwable) {}
                        ++j;
                    }
                } else {
                    try {
                        String number = m.group(2);
                        def = Integer.parseInt(number);
                    }
                    catch (Throwable throwable) {}
                }
            }
            char char_0 = m.group(3).charAt(0);
            boolean known = false;
            known = m.group(1) == null || m.group(1).length() == 0 ? this.processCSI(def, defa, char_0) : this.processMCSI(def, defa, m, char_0);
            if (!(known || char_0 >= '<' && char_0 <= '/')) {
                isPartOfNextTransmittion = true;
                return isPartOfNextTransmittion;
            }
            if (m.group(4) != null && m.group(4).length() > 0) {
                StringBuffer text = new StringBuffer(m.group(4));
                this.INSERT(text);
            }
            return isPartOfNextTransmittion;
        }

        protected boolean processMCSI(int def, int[] defa, Matcher m, char char_0) {
            boolean known = true;
            block0 : switch (char_0) {
                case 'h': {
                    if (defa != null) break;
                    switch (def) {
                        case 1: {
                            SshViewTab.this.m_applicationKeys = true;
                            break block0;
                        }
                        case 25: {
                            SshViewTab.this.m_console.getCaret().setVisible(true);
                            break block0;
                        }
                        case 1047: 
                        case 1049: {
                            SshViewTab.this.m_lineStored = SshViewTab.this.m_line;
                            SshViewTab.this.m_posStored = SshViewTab.this.m_pos;
                            SshViewTab.this.m_lineMstored = SshViewTab.this.m_line;
                            SshViewTab.this.m_posMstored = SshViewTab.this.m_pos;
                            SshViewTab.this.m_textStored = SshViewTab.this.m_console.getText();
                            SshViewTab.this.m_stylesStored = SshViewTab.this.m_console.getStyleRanges();
                            SshViewTab.this.m_console.setText(NEWLINE);
                            int i = 1;
                            while (i < SshViewTab.this.HEIGHT) {
                                SshViewTab.this.m_console.setSelectionRange(SshViewTab.this.m_console.getCharCount(), 0);
                                SshViewTab.this.m_console.insert(CRLF_NEWLINE);
                                ++i;
                            }
                            this.MOVECURSOR(1, 1);
                            break block0;
                        }
                        case 1034: {
                            break block0;
                        }
                    }
                    known = false;
                    break;
                }
                case 'l': {
                    switch (def) {
                        case 1: {
                            SshViewTab.this.m_applicationKeys = false;
                            break block0;
                        }
                        case 25: {
                            SshViewTab.this.m_console.getCaret().setVisible(false);
                            break block0;
                        }
                        case 47: 
                        case 1047: 
                        case 1049: {
                            SshViewTab.this.m_line = SshViewTab.this.m_lineStored;
                            SshViewTab.this.m_pos = SshViewTab.this.m_posStored;
                            SshViewTab.this.m_console.setText(SshViewTab.this.m_textStored);
                            if (SshViewTab.this.m_stylesStored != null) {
                                SshViewTab.this.m_console.setStyleRanges(SshViewTab.this.m_stylesStored);
                            }
                            this.MOVECURSOR(SshViewTab.this.m_line + 1, SshViewTab.this.m_pos + 1);
                            break block0;
                        }
                        case 12: {
                            break block0;
                        }
                    }
                    known = false;
                    break;
                }
                default: {
                    known = false;
                }
            }
            return known;
        }

        protected boolean processCSI(int def, int[] defa, char char_0) {
            boolean known = true;
            int lstored = SshViewTab.this.m_line;
            int pstored = SshViewTab.this.m_pos;
            block0 : switch (char_0) {
                case 'n': {
                    break;
                }
                case 'd': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(this.getFirstVisibleLine() + def, SshViewTab.this.m_pos + 1);
                    break;
                }
                case 'G': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(SshViewTab.this.m_line + 1, def);
                    break;
                }
                case 'A': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(SshViewTab.this.m_line + 1 - def, SshViewTab.this.m_pos + 1);
                    break;
                }
                case 'B': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(SshViewTab.this.m_line + 1 + def, SshViewTab.this.m_pos + 1);
                    break;
                }
                case 'C': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(def);
                    break;
                }
                case 'X': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.INSERT_BLANKS(def);
                    this.MOVECURSOR(lstored + 1, pstored + 1);
                    break;
                }
                case 'K': {
                    if (def < 0) {
                        def = 0;
                    }
                    switch (def) {
                        case 0: {
                            this.ERASE_RIGHT();
                            break block0;
                        }
                        case 1: {
                            int blanks = SshViewTab.this.m_pos;
                            this.MOVECURSOR(SshViewTab.this.m_line + 1, 1);
                            this.INSERT_BLANKS(blanks);
                            break block0;
                        }
                        case 2: {
                            this.MOVECURSOR(SshViewTab.this.m_line + 1, 1);
                            this.ERASE_RIGHT();
                            break block0;
                        }
                    }
                    break;
                }
                case 'P': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.DELETE(def);
                    this.MOVECURSOR(lstored + 1, pstored + 1);
                    break;
                }
                case 'D': {
                    if (def < 0) {
                        def = 1;
                    }
                    this.MOVECURSOR(-1 * def);
                    break;
                }
                case 'H': {
                    if (defa == null) {
                        defa = new int[]{1, 1};
                    }
                    this.MOVECURSOR(this.getFirstVisibleLine() + defa[0], defa[1]);
                    break;
                }
                case 'J': {
                    if (def < 0) {
                        def = 0;
                    }
                    switch (def) {
                        case 0: {
                            this.ERASE_DOWN();
                            break;
                        }
                        case 2: {
                            this.MOVECURSOR(this.getFirstVisibleLine() + 1, 1);
                            this.ERASE_DOWN();
                            break;
                        }
                        case 1: {
                            int start = 112 * SshViewTab.this.m_line + SshViewTab.this.m_pos;
                            int chars = 110 * SshViewTab.this.m_line + SshViewTab.this.m_pos;
                            SshViewTab.this.m_console.setSelectionRange(start, 0);
                            int i = 0;
                            while (i < chars) {
                                this.INSERT(new StringBuffer(" "));
                                ++i;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 'm': {
                    if (defa != null) {
                        int i = 0;
                        while (i < defa.length) {
                            this.setColorRange(defa[i]);
                            ++i;
                        }
                        break;
                    }
                    if (def == -1) {
                        def = 0;
                    }
                    this.setColorRange(def);
                    break;
                }
                case 'r': {
                    if (defa == null) break;
                    SshViewTab.this.m_scrollRegionStart = defa[0];
                    SshViewTab.this.m_scrollRegionEnd = defa[1];
                    break;
                }
                case 'g': {
                    if (def < 0) {
                        def = 0;
                    }
                    if (def != 3) break;
                    int posS = SshViewTab.this.m_pos;
                    this.MOVECURSOR(SshViewTab.this.m_line + 1, 1);
                    this.ERASE_RIGHT();
                    this.MOVECURSOR(SshViewTab.this.m_line + 1, posS + 1);
                    break;
                }
                case '@': {
                    if (def < 0) {
                        def = 1;
                    }
                    int caretPosition = SshViewTab.this.m_console.getCaretOffset();
                    StyleRange sr = new StyleRange();
                    sr.background = SshViewTab.this.m_STYLE.background;
                    sr.foreground = SshViewTab.this.m_STYLE.foreground;
                    sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                    sr.start = caretPosition;
                    int i = 0;
                    while (i < def) {
                        SshViewTab.this.m_console.insert(" ");
                        int lastR = this.getEOL(caretPosition, '\r');
                        if (lastR == -1) {
                            lastR = SshViewTab.this.m_console.getCharCount();
                        }
                        SshViewTab.this.m_console.setSelectionRange(lastR - 1, 1);
                        SshViewTab.this.m_console.insert("");
                        SshViewTab.this.m_console.setSelectionRange(caretPosition, 0);
                        ++i;
                    }
                    this.applyColors(sr, def);
                    break;
                }
                case 'M': {
                    if (def < 1) {
                        def = 1;
                    }
                    int i = 0;
                    while (i < def) {
                        this.DELETE_LINE();
                        ++i;
                    }
                    break;
                }
                case 'L': {
                    if (def < 1) {
                        def = 1;
                    }
                    int i = 0;
                    while (i < def) {
                        this.INSERT_LINE();
                        ++i;
                    }
                    break;
                }
                default: {
                    known = false;
                }
            }
            return known;
        }

        protected void setColorRange(int def) {
            try {
                switch (def) {
                    case 1: 
                    case 5: {
                        SshViewTab.this.m_STYLE.fontStyle = 1;
                        break;
                    }
                    case 4: {
                        SshViewTab.this.m_STYLE.fontStyle = 0;
                        break;
                    }
                    case 30: {
                        this.setForeground(COLOR_BLACK);
                        break;
                    }
                    case 31: {
                        this.setForeground(COLOR_RED);
                        break;
                    }
                    case 32: {
                        this.setForeground(COLOR_GREEN);
                        break;
                    }
                    case 33: {
                        this.setForeground(COLOR_YELLOW);
                        break;
                    }
                    case 34: {
                        this.setForeground(COLOR_BLUE);
                        break;
                    }
                    case 35: {
                        this.setForeground(COLOR_MAGENTA);
                        break;
                    }
                    case 36: {
                        this.setForeground(COLOR_CYAN);
                        break;
                    }
                    case 37: {
                        this.setForeground(COLOR_WHITE);
                        break;
                    }
                    case 39: {
                        this.setForeground(COLOR_WHITE);
                        break;
                    }
                    case 40: {
                        this.setBackground(COLOR_BLACK);
                        break;
                    }
                    case 41: {
                        this.setBackground(COLOR_RED);
                        break;
                    }
                    case 42: {
                        this.setBackground(COLOR_GREEN);
                        break;
                    }
                    case 43: {
                        this.setBackground(COLOR_YELLOW);
                        break;
                    }
                    case 44: {
                        this.setBackground(COLOR_BLUE);
                        break;
                    }
                    case 45: {
                        this.setBackground(COLOR_MAGENTA);
                        break;
                    }
                    case 46: {
                        this.setBackground(COLOR_CYAN);
                        break;
                    }
                    case 47: {
                        this.setBackground(COLOR_WHITE);
                        break;
                    }
                    case 49: {
                        this.setBackground(COLOR_BLACK);
                        break;
                    }
                    case 7: {
                        Color fg = SshViewTab.this.m_STYLE.foreground;
                        Color bg = SshViewTab.this.m_STYLE.background;
                        SshViewTab.this.m_STYLE.background = fg;
                        SshViewTab.this.m_STYLE.foreground = bg;
                        break;
                    }
                    case 27: {
                        Color fgP = SshViewTab.this.m_STYLE.foreground;
                        Color bgP = SshViewTab.this.m_STYLE.background;
                        SshViewTab.this.m_STYLE.background = fgP;
                        SshViewTab.this.m_STYLE.foreground = bgP;
                        break;
                    }
                    case 0: {
                        this.setForeground(COLOR_WHITE);
                        this.setBackground(COLOR_BLACK);
                        SshViewTab.this.m_STYLE.fontStyle = 0;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {}
        }

        protected void setForeground(Color newFG) {
            SshViewTab.this.m_STYLE.foreground = newFG;
        }

        protected void setBackground(Color newFG) {
            SshViewTab.this.m_STYLE.background = newFG;
        }

        protected void INSERT_BLANKS(int number) {
            StringBuffer blanks = new StringBuffer();
            int i = 0;
            while (i < number) {
                blanks.append(" ");
                ++i;
            }
            this.INSERT(blanks);
        }

        protected void DELETE(int number) {
            if (SshViewTab.this.m_pos < 110) {
                int caretPosition = SshViewTab.this.m_console.getCaretOffset();
                SshViewTab.this.m_console.setSelectionRange(caretPosition, number);
                SshViewTab.this.m_console.insert("");
                int lastR = this.getEOL(caretPosition, '\r');
                if (lastR == -1) {
                    lastR = SshViewTab.this.m_console.getCharCount();
                }
                SshViewTab.this.m_console.setSelectionRange(lastR, 0);
                StyleRange sr = new StyleRange();
                sr.background = SshViewTab.this.m_STYLE.background;
                sr.foreground = SshViewTab.this.m_STYLE.foreground;
                sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                sr.start = lastR;
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < number) {
                    sb.append(" ");
                    ++i;
                }
                SshViewTab.this.m_console.insert(sb.toString());
                this.applyColors(sr, number);
            }
        }

        protected void DELETE_LINE() {
            int caretPosition = SshViewTab.this.m_console.getCaretOffset();
            int lastR = this.getEOL(caretPosition, '\n');
            lastR = lastR - 110 - 1;
            SshViewTab.this.m_console.setSelectionRange(lastR, 112);
            SshViewTab.this.m_console.insert("");
            if (SshViewTab.this.m_scrollRegionEnd < SshViewTab.this.HEIGHT) {
                this.MOVECURSOR(this.getFirstVisibleLine() + SshViewTab.this.m_scrollRegionEnd, 1);
                StyleRange sr = new StyleRange();
                sr.background = SshViewTab.this.m_STYLE.background;
                sr.foreground = SshViewTab.this.m_STYLE.foreground;
                sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
                sr.start = SshViewTab.this.m_console.getCaretOffset();
                SshViewTab.this.m_console.insert(NEWLINE_CRLF);
                SshViewTab.this.m_console.setSelectionRange(lastR + 1, 0);
                sr.length = 112;
                SshViewTab.this.m_console.setStyleRange(sr);
            } else {
                --SshViewTab.this.HEIGHT;
                SshViewTab.this.m_console.setSelectionRange(caretPosition, 0);
            }
        }

        protected void INSERT_LINE() {
            int caretPosition = SshViewTab.this.m_console.getCaretOffset();
            int lastR = this.getEOL(caretPosition - 110, '\n');
            SshViewTab.this.m_console.setSelectionRange(lastR + 1, 0);
            StyleRange sr = new StyleRange();
            sr.background = SshViewTab.this.m_STYLE.background;
            sr.foreground = SshViewTab.this.m_STYLE.foreground;
            sr.fontStyle = SshViewTab.this.m_STYLE.fontStyle;
            sr.start = SshViewTab.this.m_console.getCaretOffset();
            SshViewTab.this.m_console.insert(NEWLINE_CRLF);
            sr.length = 112;
            SshViewTab.this.m_console.setStyleRange(sr);
            if (SshViewTab.this.m_scrollRegionEnd >= SshViewTab.this.HEIGHT || this.getFirstVisibleLine() + SshViewTab.this.m_scrollRegionStart - 1 == SshViewTab.this.m_line + 1) {
                int lastLine = SshViewTab.this.m_console.getCharCount() - 112;
                SshViewTab.this.m_console.setSelectionRange(lastLine -= (SshViewTab.this.HEIGHT - SshViewTab.this.m_scrollRegionEnd) * 112, 112);
                SshViewTab.this.m_console.insert("");
                if (SshViewTab.this.m_scrollRegionEnd > SshViewTab.this.HEIGHT) {
                    ++SshViewTab.this.HEIGHT;
                }
            }
            SshViewTab.this.m_console.setSelectionRange(lastR + 1, 0);
        }
    }
}

