/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class StyledTreeLabelProvider
extends StyledCellLabelProvider {
    private String m_type = null;
    public static String UserTreeDialog = "UserTreeDialog";
    public static String AsnTable = "AsnTable";
    private static String COLOR_GREY = "COLOR_GREY";
    private static String COLOR_BLUE = "COLOR_BLUE";
    private static String COLOR_RED = "COLOR_RED";
    private static String PROXY = "PROXY";
    private static String FWD_CONTROL = "FWD&CONTROL";
    private static String READ_ONLY = "MASTER";
    private static String BACKUP = "BACKUP";
    public static final String GTOLABEL = "GTOLABEL";
    public static final String GTOICON = "GTOICON";
    private StyledString.Styler stylerDisabledAgent = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = new Color((Device)Display.getDefault(), new RGB(193, 156, 48));
            textStyle.font = BMUI.font_arial7_bold;
        }
    };
    private StyledString.Styler stylerGrey = StyledString.createColorRegistryStyler((String)COLOR_GREY, null);
    private StyledString.Styler stylerRed = StyledString.createColorRegistryStyler((String)COLOR_RED, null);
    private StyledString.Styler stylerBlue = StyledString.createColorRegistryStyler((String)COLOR_BLUE, null);
    public static LinkedHashMap<String, Integer> m_maintenanceAdhocHosts = null;
    public static LinkedHashMap<String, Integer> m_maintenanceSchedHosts = null;

    static {
        JFaceResources.getColorRegistry().put(COLOR_GREY, BMUI.color_darkGrey2.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_RED, BMUI.color_major.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_BLUE, BMUI.color_blue.getRGB());
    }

    public StyledTreeLabelProvider() {
    }

    public StyledTreeLabelProvider(String type) {
        this();
        this.m_type = type;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString styledString = null;
        String decoration = "";
        if (element instanceof GroupTreeObject && !(element instanceof GroupTreeObjectLast)) {
            Image icon;
            StyleRange range;
            AgentCard ac;
            GroupTreeObject gto = (GroupTreeObject)element;
            Object obj = gto.getTreeObject().getObject();
            String type = gto.getTreeObject().getType();
            String name = gto.getName();
            String label = gto.getAttribute(GTOLABEL);
            if (label != null) {
                name = label;
            }
            if (obj != null && obj instanceof AgentCard) {
                String host;
                ac = (AgentCard)obj;
                styledString = new StyledString();
                if (ac.isDisabled()) {
                    decoration = MessageFormat.format("({0}) ", "X");
                    styledString.append(decoration, this.stylerDisabledAgent);
                }
                styledString.append(ac.getLabel());
                if (!(ac.getLabel() != null && ac.getLabel().length() != 0 || (host = ac.getAgentHost()) == null || host.length() <= 0 || host.equals(ac.getAgentIP()))) {
                    styledString.append(host);
                }
                decoration = MessageFormat.format("  ({0})", ac.getAgentIP());
                styledString.append(decoration, this.stylerGrey);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else if (type != null && (type.equals(BMUI.type_assignment_pol) || type.equals(BMUI.type_assignment_bin))) {
                if (name.endsWith("(DELETED)")) {
                    String[] split = name.split("\\(DELETED\\)");
                    styledString = new StyledString();
                    styledString.append(split[0]);
                    decoration = MessageFormat.format(" ({0})", "DELETED");
                    styledString.append(decoration, this.stylerRed);
                    cell.setText(styledString.toString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                } else if (AsnTable.equals(this.m_type)) {
                    styledString = new StyledString();
                    styledString.append(name).append(" [").append("" + gto.getElements().size()).append("]");
                    range = new StyleRange();
                    range.foreground = BMUI.color_black;
                    range.start = 0;
                    range.length = name.length();
                    cell.setStyleRanges(new StyleRange[]{range});
                    cell.setText(styledString.toString());
                } else {
                    styledString = new StyledString();
                    styledString.append(name);
                    range = new StyleRange();
                    range.foreground = BMUI.color_black;
                    range.start = 0;
                    range.length = name.length();
                    cell.setStyleRanges(new StyleRange[]{range});
                    cell.setText(styledString.toString());
                }
            } else if (type != null && type.equalsIgnoreCase("IMAGE_FOLDER_SLAVE")) {
                styledString = new StyledString();
                styledString.append(name);
                if (obj instanceof Integer) {
                    Integer cfr_ignored_0 = (Integer)obj;
                    Integer scenario = Integer.parseInt(obj.toString());
                    decoration = MessageFormat.format("  ({0})", this.getSName(scenario));
                    styledString.append(decoration, this.stylerGrey);
                }
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else {
                styledString = new StyledString();
                styledString.append(String.valueOf(name) + " [" + gto.getElements().size() + "]");
                range = new StyleRange();
                range.foreground = BMUI.color_black;
                range.start = 0;
                range.length = name.length();
                cell.setStyleRanges(new StyleRange[]{range});
                cell.setText(styledString.toString());
            }
            if (obj != null && obj instanceof AgentCard) {
                ac = (AgentCard)obj;
                cell.setImage(AgentCard.getOSIcon(ac.getOSName()));
            } else if (type != null && type.equalsIgnoreCase("IMAGE_FOLDER_SLAVE")) {
                icon = BMUI.IMAGE_FOLDER_SLAVE;
                for (GroupTreeObject sgto : gto.getElements()) {
                    if (!sgto.getTreeObject().getName().contains("Requesting Agents")) continue;
                    icon = BMUI.IMAGE_FOLDER_SLAVE_OFFLINE;
                    break;
                }
                cell.setImage(icon);
            } else if (type != null && !type.equals("")) {
                icon = BMUI.IMAGE_MAP.get(type);
                if (icon != null) {
                    cell.setImage(icon);
                } else {
                    cell.setImage(BMUI.IMAGE_FOLDER);
                }
            } else if (this.m_type != null && this.m_type.equals(UserTreeDialog)) {
                cell.setImage(BMUI.IMAGE_USERS);
            } else if (Repository.getInstance().isPermittedNodeGroupModify(gto)) {
                cell.setImage(BMUI.IMAGE_FOLDER);
            } else {
                cell.setImage(BMUI.IMAGE_FOLDER_LOCK);
            }
        } else if (element instanceof GroupTreeObjectLast) {
            String icon;
            String type;
            Object obj;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            AgentCard ac = null;
            String name = gtol.getName();
            String label = gtol.getAttribute(GTOLABEL);
            if (label != null) {
                name = label;
            }
            if ((obj = gtol.getTreeObject().getObject()) instanceof AgentCard && (ac = Repository.getInstance().getAgentCard(((AgentCard)obj).getAgentID())) != null) {
                String host;
                styledString = new StyledString();
                if (ac.isDisabled()) {
                    decoration = MessageFormat.format("({0}) ", "X");
                    styledString.append(decoration, this.stylerDisabledAgent);
                }
                if (ac.getAgentOutage()) {
                    String symb = new String(Character.toChars(Integer.parseInt("1F6C7", 16)));
                    decoration = MessageFormat.format("{0} ", symb);
                    styledString.append(decoration, this.stylerDisabledAgent);
                }
                styledString.append(ac.getLabel());
                if (!(ac.getLabel() != null && ac.getLabel().length() != 0 || (host = ac.getAgentHost()) == null || host.length() <= 0 || host.equals(ac.getAgentIP()))) {
                    styledString.append(host);
                }
                if (ac.isTlsAgent()) {
                    decoration = MessageFormat.format("  {0}", "TLS");
                    styledString.append(decoration, this.stylerBlue);
                } else if (ac.isHttpAgent()) {
                    decoration = MessageFormat.format("  {0}", BMUI.HTTP_PROTOCOL.toUpperCase());
                    styledString.append(decoration, this.stylerBlue);
                }
                String ip = ac.getAgentIP();
                if (ip == null || ip.isEmpty()) {
                    ip = ac.getAgentHost();
                }
                decoration = MessageFormat.format("  ({0})", ip);
                styledString.append(decoration, this.stylerGrey);
                cell.setText(styledString.toString().intern());
                cell.setStyleRanges(styledString.getStyleRanges());
                if (ac.getMode() != 2 || cell.getImage() == null) {
                    String iii = ac.getIconnameForAgent();
                    gtol.setIcon(iii);
                    cell.setImage(BMUI.IMAGE_MAP.get(iii));
                }
            } else if (obj instanceof UserTreeObject) {
                UserTreeObject uto = (UserTreeObject)gtol.getTreeObject().getObject();
                styledString = new StyledString(String.valueOf(uto.m_user.m_lastName) + " " + uto.m_user.m_firstName);
                decoration = MessageFormat.format(" ({0})", uto.m_user.m_loginName);
                styledString.append(decoration, this.stylerGrey);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else {
                styledString = new StyledString();
                styledString.append(name);
                StyleRange range = new StyleRange();
                range.foreground = BMUI.color_black;
                range.start = 0;
                range.length = name.length();
                cell.setStyleRanges(new StyleRange[]{range});
                cell.setText(styledString.toString());
            }
            if ((type = gtol.getType()) != null) {
                if (gtol.isLinkOK()) {
                    if (type.equals(BMUI.type_assignment_bin)) {
                        gtol.setIcon("IMAGE_PKG_LNK");
                    } else if (type.equals(BMUI.type_mon)) {
                        gtol.setIcon("IMAGE_MON_LNK");
                    } else if (type.equals(BMUI.type_msg)) {
                        gtol.setIcon("IMAGE_MSG_LNK");
                    }
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    gtol.setIcon("IMAGE_PKG_LNK_BROKEN");
                } else if (type.equals(BMUI.type_mon)) {
                    gtol.setIcon("IMAGE_MON_LNK_BROKEN");
                } else if (type.equals(BMUI.type_msg)) {
                    gtol.setIcon("IMAGE_MSG_LNK__BROKEN");
                }
            }
            if ((icon = gtol.getAttribute(GTOICON)) != null && icon.length() > 0) {
                cell.setImage(BMUI.IMAGE_MAP.get(icon));
            } else {
                cell.setImage(BMUI.IMAGE_MAP.get(gtol.getIcon()));
            }
        }
        super.update(cell);
    }

    protected void setFolderImage(ViewerCell cell) {
        cell.setImage(BMUI.IMAGE_FOLDER_DEFAULT);
    }

    public String getSName(Integer scenario) {
        String name = null;
        switch (scenario) {
            case 1: {
                name = PROXY;
                break;
            }
            case 2: {
                name = FWD_CONTROL;
                break;
            }
            case 3: {
                name = READ_ONLY;
                break;
            }
            case 8: {
                name = BACKUP;
            }
        }
        return name;
    }
}

