/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.TlsUtils;
import com.blixx.boom.exception.ConnectionException;
import com.blixx.boom.gui.views.SshViewTab;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.ui.IWorkbenchPartSite;

public class TermViewTab
extends SshViewTab {
    protected Socket m_sock;
    protected SDataInputStream m_is;
    protected SDataOutputStream m_os;

    public TermViewTab(IWorkbenchPartSite siteV, CTabFolder parent, int style, int position, String title, boolean isActive) {
        super(siteV, parent, style, position, "Console", isActive);
    }

    @Override
    public void connect() throws IOException {
        try {
            this.establishServerSocket();
            this.m_listener = new TermListener(this.m_in, (ConcurrentLinkedQueue<Byte>)this.m_bytes);
            this.m_listener.start();
        }
        catch (Exception exception) {
            this.dispose();
        }
    }

    @Override
    public void processCommand(String command) {
        switch (this.m_mode) {
            case 0: {
                this.m_host = command.trim();
                this.m_user = "";
                this.m_password = "";
                this.m_console.insert(String.valueOf(this.m_console.getLineDelimiter()) + "Connecting...");
                this.m_console.setSelection(this.m_console.getCharCount());
                try {
                    this.connect();
                    this.m_sshTab.setText(String.valueOf(this.m_host) + " (console)");
                    this.m_mode = 3;
                    this.m_console.setEditable(false);
                    this.m_console.addFocusListener((FocusListener)this);
                    this.m_console.addTraverseListener((TraverseListener)this);
                    this.m_console.setText(NEWLINE);
                    this.m_console.setSelection(0);
                }
                catch (IOException e) {
                    this.m_mode = 0;
                    this.m_console.setText("Error: " + e.getMessage() + "\n\n" + "Enter hostname: ");
                    this.m_console.setSelection(this.m_console.getCharCount());
                }
                break;
            }
            case 3: {
                try {
                    String full = String.valueOf(command) + CRLF;
                    this.m_out.write(full.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.m_command = "";
    }

    @Override
    protected void ttyMode(KeyEvent e) {
        try {
            e.doit = false;
            switch (e.keyCode) {
                case 65536: 
                case 131072: 
                case 262144: {
                    break;
                }
                case 0x100000A: {
                    this.m_out.write(F1);
                    break;
                }
                case 0x100000B: {
                    this.m_out.write(F2);
                    break;
                }
                case 0x100000C: {
                    this.m_out.write(F3);
                    break;
                }
                case 0x100000D: {
                    this.m_out.write(F4);
                    break;
                }
                case 0x100000E: {
                    this.m_out.write(F5);
                    break;
                }
                case 0x100000F: {
                    this.m_out.write(F6);
                    break;
                }
                case 0x1000010: {
                    this.m_out.write(F7);
                    break;
                }
                case 0x1000011: {
                    this.m_out.write(F8);
                    break;
                }
                case 0x1000012: {
                    this.m_out.write(F9);
                    break;
                }
                case 0x1000013: {
                    this.m_out.write(F10);
                    break;
                }
                case 0x1000014: {
                    this.m_out.write(F11);
                    break;
                }
                case 0x1000015: {
                    this.m_out.write(F12);
                    break;
                }
                case 0x1000016: {
                    break;
                }
                case 0x1000017: {
                    break;
                }
                case 0x1000018: {
                    break;
                }
                case 0x1000001: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_up_APP);
                        break;
                    }
                    this.m_out.write(arrow_up);
                    break;
                }
                case 0x1000004: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_right_APP);
                        break;
                    }
                    this.m_out.write(arrow_right);
                    break;
                }
                case 0x1000003: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_left_APP);
                        break;
                    }
                    this.m_out.write(arrow_left);
                    break;
                }
                case 0x1000002: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(arrow_down_APP);
                        break;
                    }
                    this.m_out.write(arrow_down);
                    break;
                }
                case 0x1000005: {
                    this.m_out.write(page_up);
                    break;
                }
                case 0x1000006: {
                    this.m_out.write(page_down);
                    break;
                }
                case 0x1000009: {
                    this.m_out.write(insert);
                    break;
                }
                case 0x1000007: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(home_APP);
                        break;
                    }
                    this.m_out.write(home);
                    break;
                }
                case 0x1000008: {
                    if (this.m_applicationKeys) {
                        this.m_out.write(end_APP);
                        break;
                    }
                    this.m_out.write(end);
                    break;
                }
                case 127: {
                    this.m_out.write(delchar);
                    break;
                }
                case 68: 
                case 100: {
                    if (e.stateMask == 262144) {
                        this.m_out.write(e.character);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.m_in.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.m_out.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.sess.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            this.conn.close();
                        }
                        catch (Throwable throwable) {}
                        this.m_in = null;
                        this.setText(String.valueOf(this.getText()) + "(terminated)");
                        break;
                    }
                    this.m_out.write(e.character);
                    this.m_bytes.add(new Byte((byte)e.character));
                    SshViewTab.Update u = new SshViewTab.Update(1);
                    u.run();
                    break;
                }
                case 13: {
                    this.m_out.write(e.character);
                    this.m_out.write(10);
                    this.m_bytes.add(new Byte(13));
                    this.m_bytes.add(new Byte(10));
                    break;
                }
                default: {
                    if (e.character > '\u0000') {
                        this.m_out.write(e.character);
                        this.m_bytes.add(new Byte((byte)e.character));
                        SshViewTab.Update u = new SshViewTab.Update(1);
                        u.run();
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.m_mode > 2) {
            if (e.character > '\u0000' && e.stateMask == 262144) {
                try {
                    this.m_out.write(e.character);
                }
                catch (IOException iOException) {}
            }
            e.doit = false;
            return;
        }
        e.doit = false;
    }

    public void establishServerSocket() throws Exception {
        String str;
        int res;
        this.m_sock = null;
        this.m_is = null;
        this.m_os = null;
        this.m_sock = new Socket();
        this.m_sock.bind(null);
        this.m_sock.setSoTimeout(300000);
        this.m_sock.setTcpNoDelay(true);
        this.m_sock.setSoLinger(true, 1);
        this.m_sock.connect(new InetSocketAddress(BMUI.localhost, (int)BMUI.port), 10000);
        this.m_is = new SDataInputStream(this.m_sock.getInputStream());
        this.m_os = new SDataOutputStream(this.m_sock.getOutputStream(), ServerClient.getDetectedServerProtocolVersion());
        if (BMUI.m_activateTls) {
            this.m_sock = TlsUtils.upgradeToTLS(this.m_sock);
        }
        if ((res = this.processServerQuestion(str = this.m_is.readUTF(), this.m_os, this.m_is)) == 0) {
            this.m_os.writeUTF("ACTION");
            this.m_os.writeUTF("@@SHT " + this.m_host);
            this.m_os.writeUTF("BOOM_SERVER");
            this.m_os.writeInt(300000);
            this.m_in = this.m_sock.getInputStream();
            this.m_out = this.m_sock.getOutputStream();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException, ConnectionException {
        int res = 0;
        if (question.equalsIgnoreCase("login")) {
            os.writeUTF(String.valueOf(Repository.m_user) + '\u25ba' + Repository.m_sessionUUID);
            String nextToken = is.readUTF();
            if (!nextToken.equalsIgnoreCase("password")) throw new ConnectionException("login name unknown");
            os.writeUTF(Repository.m_pass);
            String response = is.readUTF();
            if (response.equals("OK")) return res;
            throw new ConnectionException(response);
        }
        if (!question.equalsIgnoreCase("valid")) return res;
        RTLogger.print(2, "Login is still valid");
        return 7;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.m_os.write(0);
            this.m_os.close();
        }
        catch (Throwable throwable) {}
        try {
            this.m_is.close();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sock.close();
        }
        catch (Throwable throwable) {}
    }

    public class TermListener
    extends SshViewTab.SshListener {
        public TermListener(InputStream in, ConcurrentLinkedQueue<Byte> bytes) {
            super(in, bytes);
        }

        @Override
        public void run() {
            try {
                byte[] arr = new byte[65536];
                int screen = 112 * TermViewTab.this.HEIGHT;
                int prev = -1;
                while (this.m_input != null) {
                    int chars = -1;
                    chars = this.m_input.read(arr);
                    if (chars > 0) {
                        int i = 0;
                        while (i < chars) {
                            if (arr[i] == 10 && prev != 13) {
                                this.m_parentBytes.add(new Byte(13));
                            }
                            prev = arr[i];
                            this.m_parentBytes.add(arr[i]);
                            ++i;
                        }
                        if (this.m_input.available() != 0 && this.m_parentBytes.size() <= screen * 2) continue;
                        SshViewTab.Update upd = new SshViewTab.Update(this.m_parentBytes.size());
                        Repository.getUIJobManager().schedule(upd);
                        continue;
                    }
                    if (chars != -1) continue;
                    return;
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

