/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.User;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class UserDialogTableProvider
extends StyledCellLabelProvider
implements IStructuredContentProvider {
    private static UserDialogTableProvider m_instance = null;
    private ArrayList<GroupTreeObject> m_elements = new ArrayList();
    private static String COLOR_GREY = "COLOR_GREY";

    static {
        JFaceResources.getColorRegistry().put(COLOR_GREY, BMUI.color_darkGrey2.getRGB());
    }

    public UserDialogTableProvider(TableViewer tv) {
        this.setOwnerDrawEnabled((ColumnViewer)tv, null, false);
    }

    public static UserDialogTableProvider getInstance(TableViewer tv) {
        if (m_instance == null) {
            m_instance = new UserDialogTableProvider(tv);
        }
        return m_instance;
    }

    public void init(GroupTreeObject root, String[] currentUsers) {
        int i = 0;
        while (i < currentUsers.length) {
            String name = currentUsers[i].trim();
            if (name.startsWith("[")) {
                name = name.replace("[", "");
                GroupTreeObject gto = this.findUserRole(root, name = name.replace("]", ""));
                if (gto != null) {
                    this.m_elements.add(gto);
                }
            } else {
                GroupTreeObjectLast gtol = UserDialogTableProvider.findUserByLoginName(root, currentUsers[i]);
                if (gtol != null) {
                    this.m_elements.add(gtol);
                }
            }
            ++i;
        }
        Collections.sort(this.m_elements);
    }

    public GroupTreeObject findUserRole(GroupTreeObject treeElement, String name) {
        GroupTreeObject res = null;
        List<GroupTreeObject> elements = treeElement.getElements();
        for (GroupTreeObject o : elements) {
            GroupTreeObject gto;
            if (!(o instanceof GroupTreeObject) || o instanceof GroupTreeObjectLast || !(gto = o).getTreeObject().getName().equals(name)) continue;
            res = gto;
            break;
        }
        return res;
    }

    public static GroupTreeObjectLast findUserByLoginName(GroupTreeObject treeElement, String name) {
        List<GroupTreeObject> elements = treeElement.getAllElements();
        GroupTreeObjectLast res = null;
        for (GroupTreeObject o : elements) {
            if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                if (!gtol.getName().equals(name) && !gtol.getName().endsWith("(" + name + ")")) continue;
                res = gtol;
                break;
            }
            GroupTreeObject gto = o;
            GroupTreeObjectLast gtoRecursive = UserDialogTableProvider.findUserByLoginName(gto, name);
            if (gtoRecursive == null) continue;
            res = gtoRecursive;
            break;
        }
        return res;
    }

    public void addUsers(ArrayList<GroupTreeObject> list) {
        GroupTreeObjectLast user_gtol;
        GroupTreeObject gto;
        ArrayList<GroupTreeObject> new_elements = new ArrayList<GroupTreeObject>();
        int i = 0;
        while (i < this.m_elements.size()) {
            gto = this.m_elements.get(i);
            if (!(gto instanceof GroupTreeObjectLast) && !new_elements.contains(gto)) {
                new_elements.add(gto);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            gto = list.get(i);
            if (!(gto instanceof GroupTreeObjectLast) && !new_elements.contains(gto)) {
                new_elements.add(gto);
            }
            ++i;
        }
        i = 0;
        while (i < this.m_elements.size()) {
            gto = this.m_elements.get(i);
            if (gto instanceof GroupTreeObjectLast && !this.isRoleSelected(new_elements, user_gtol = (GroupTreeObjectLast)gto) && !new_elements.contains(user_gtol)) {
                new_elements.add(user_gtol);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            gto = list.get(i);
            if (gto instanceof GroupTreeObjectLast && !this.isRoleSelected(new_elements, user_gtol = (GroupTreeObjectLast)gto) && !new_elements.contains(user_gtol)) {
                new_elements.add(user_gtol);
            }
            ++i;
        }
        this.m_elements = new_elements;
    }

    public void removeUsers(ArrayList<GroupTreeObject> list) {
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject gto = list.get(i);
            if (gto != null && this.m_elements.contains(gto)) {
                this.m_elements.remove(gto);
            }
            ++i;
        }
    }

    public ArrayList<GroupTreeObject> getUsers() {
        Collections.sort(this.m_elements);
        return this.m_elements;
    }

    public boolean isRoleSelected(ArrayList<GroupTreeObject> new_elements, GroupTreeObjectLast gtol) {
        User user = ((UserTreeObject)gtol.getTreeObject()).m_user;
        return this.isRoleSelected(new_elements, user.m_roleName);
    }

    public boolean isRoleSelected(ArrayList<GroupTreeObject> new_elements, String roleName) {
        int i = 0;
        while (i < new_elements.size()) {
            GroupTreeObject gto = new_elements.get(i);
            if (!(gto instanceof GroupTreeObjectLast) && gto.getName().equals(roleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Collections.sort(this.m_elements);
        return this.m_elements.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String displayName = "";
                if (element instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                    displayName = ((UserTreeObject)gtol.getTreeObject()).m_displayName;
                } else if (element instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)element;
                    displayName = gto.getName();
                }
                return displayName;
            }
        }
        return "";
    }

    public void dispose() {
    }

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        StyledString styledString = null;
        String decoration = "";
        String displayName = "";
        String userName = "";
        String loginName = "";
        if (o instanceof String) {
            displayName = (String)o;
            cell.setText(displayName);
        } else if (o instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            displayName = ((UserTreeObject)gtol.getTreeObject()).m_displayName;
            int li = displayName.lastIndexOf("(");
            if (li == -1) {
                userName = displayName;
            } else {
                userName = displayName.substring(0, li - 1).trim();
                loginName = displayName.substring(li + 1).trim();
                if (loginName.endsWith(")")) {
                    loginName = loginName.substring(0, loginName.length() - 1);
                }
            }
            styledString = new StyledString(userName);
            decoration = MessageFormat.format(" ({0})", loginName);
            StyledString.Styler styler = StyledString.createColorRegistryStyler((String)COLOR_GREY, null);
            styledString.append(decoration, styler);
            cell.setText(styledString.toString());
            User user = ((UserTreeObject)gtol.getTreeObject()).getUserObject();
            cell.setImage(Repository.getInstance().getUserManager().getUserImage(user));
        } else if (o instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)o;
            displayName = gto.getName();
            cell.setText(displayName);
            cell.setImage(BMUI.IMAGE_USERS);
        }
        super.update(cell);
    }
}

