/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.views.ServerFilterOverviewTab;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.List;
import org.eclipse.jface.action.Action;

public class ActivateServerFilterAction
extends Action {
    private ServerFilterOverviewTab m_sFilterOverviewTab = null;
    private ForwardPolicy m_fPolicy = null;

    public ActivateServerFilterAction(ServerFilterOverviewTab sFilterOverviewTab, List<ForwardPolicy> selection) {
        super("ActivateServerFilter");
        this.setId("activateserverfilter");
        this.setText("Deactivate Server Filter");
        if (sFilterOverviewTab == null || selection == null || selection.isEmpty() || selection.size() > 1) {
            this.setEnabled(false);
            return;
        }
        this.m_sFilterOverviewTab = sFilterOverviewTab;
        this.m_fPolicy = selection.get(0);
        StringBuilder sb = new StringBuilder();
        if (this.m_fPolicy.isUserPolicyValid()) {
            sb.append(this.m_fPolicy.isActive() ? "Deactivate " : "Activate ").append("User Filter");
            this.setText(sb.toString());
            if (Repository.getInstance().getRights(1004) < 3) {
                this.setEnabled(false);
                return;
            }
        } else {
            sb.append(this.m_fPolicy.isActive() ? "Deactivate " : "Activate ").append("Notification Filter");
            this.setText(sb.toString());
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
                return;
            }
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        this.m_fPolicy.setActive(!this.m_fPolicy.isActive());
        FPolicyManager.getInstance().saveForwardPolicy(this.m_fPolicy, this.m_fPolicy.getPolicyName(), false);
        ServerFilterView.getInstance().loadFPolicies();
        this.m_sFilterOverviewTab.refreshTables();
        if (this.m_fPolicy.isUserPolicyValid()) {
            ServerFilterUsersTab.getInstance().refreshUserFilterTab(false, null, true, null, false);
        } else {
            ServerFilterView.getInstance().refreshNotificationFilterTab(false, null, true, null);
        }
    }
}

