/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.utils.ImageCombo;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class AddDefaultContentMenuAction
extends Action {
    private static final String REDO = "Redo";
    private static final String UNDO = "Undo";
    private static final String SELECT_ALL = "Select All";
    private static final String DELETE = "Delete";
    private static final String PASTE = "Paste";
    private static final String COPY = "Copy";
    private static final String CUT = "Cut";
    private StyledText m_field_styled = null;
    private Text m_field = null;
    private CCombo m_combo = null;
    private ImageCombo m_iCombo = null;
    private int m_actionType = -1;

    public AddDefaultContentMenuAction(Object o, int actionType, boolean setEnabled) {
        super("CopyPasteAction");
        if (o instanceof StyledText) {
            this.m_field_styled = (StyledText)o;
        } else if (o instanceof Text) {
            this.m_field = (Text)o;
        } else if (o instanceof CCombo) {
            this.m_combo = (CCombo)o;
        } else if (o instanceof ImageCombo) {
            this.m_iCombo = (ImageCombo)((Object)o);
        } else {
            return;
        }
        this.m_actionType = actionType;
        ISharedImages sharedImages = null;
        try {
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            sharedImages = window.getWorkbench().getSharedImages();
        }
        catch (Exception exception) {}
        switch (this.m_actionType) {
            case 1: {
                this.setText(CUT);
                this.setId(CUT);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
                    this.setAccelerator(262232);
                }
                if (this.m_field != null) {
                    if (setEnabled && this.m_field.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_field_styled != null) {
                    if (setEnabled && this.m_field_styled.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo != null) {
                    if (this.m_combo.getEditable()) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 2: {
                this.setText(COPY);
                this.setId(COPY);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
                    this.setAccelerator(262211);
                }
                if (this.m_field != null) {
                    if (this.m_field.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_field_styled != null) {
                    if (this.m_field_styled.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo != null) {
                    Point pt = this.m_combo.getSelection();
                    if (pt.x != pt.y) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 3: {
                this.setText(PASTE);
                this.setId(PASTE);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
                    this.setAccelerator(262230);
                }
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                String contents = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                if (this.m_field != null || this.m_field_styled != null) {
                    if (setEnabled && contents != null) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo != null) {
                    if (this.m_combo.getEditable() && setEnabled && contents != null) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 4: {
                this.setText(DELETE);
                this.setId(DELETE);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
                }
                if (this.m_field_styled != null) {
                    if (setEnabled && this.m_field_styled.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_field != null) {
                    if (setEnabled && this.m_field.getSelectionCount() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo != null) {
                    if (this.m_combo.getEditable()) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 5: {
                this.setText(SELECT_ALL);
                this.setId(SELECT_ALL);
                if (this.m_field_styled != null) {
                    if (this.m_field_styled.getText().trim().length() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_field != null) {
                    if (this.m_field.getText().trim().length() >= 1) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo == null && this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 6: {
                this.setText(UNDO);
                this.setId(UNDO);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
                    this.setAccelerator(262234);
                }
                if (this.m_field != null || this.m_field_styled != null) {
                    if (setEnabled) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo == null && this.m_iCombo == null) break;
                this.setEnabled(false);
                break;
            }
            case 7: {
                this.setText(REDO);
                this.setId(REDO);
                if (sharedImages != null) {
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
                    this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
                    this.setAccelerator(262233);
                }
                if (this.m_field != null || this.m_field_styled != null) {
                    if (setEnabled) break;
                    this.setEnabled(false);
                    break;
                }
                if (this.m_combo == null && this.m_iCombo == null) break;
                this.setEnabled(false);
            }
        }
    }

    public void run() {
        switch (this.m_actionType) {
            case 1: {
                if (this.m_field_styled != null) {
                    this.m_field_styled.cut();
                    break;
                }
                if (this.m_field != null) {
                    this.m_field.cut();
                    break;
                }
                if (this.m_combo == null) break;
                this.m_combo.cut();
                break;
            }
            case 2: {
                if (this.m_field_styled != null) {
                    this.m_field_styled.copy();
                    break;
                }
                if (this.m_field != null) {
                    this.m_field.copy();
                    break;
                }
                if (this.m_combo != null) {
                    this.m_combo.copy();
                    break;
                }
                if (this.m_iCombo == null) break;
                this.m_iCombo.copy();
                break;
            }
            case 3: {
                if (this.m_field_styled != null) {
                    this.m_field_styled.paste();
                    break;
                }
                if (this.m_field != null) {
                    this.m_field.paste();
                    break;
                }
                if (this.m_combo == null) break;
                this.m_combo.paste();
                break;
            }
            case 4: {
                if (this.m_field != null || this.m_field_styled != null) {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    String textData = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (this.m_field_styled != null) {
                        this.m_field_styled.cut();
                    } else if (this.m_field != null) {
                        this.m_field.cut();
                    }
                    clipboard.clearContents();
                    String rtfData = "{\\rtf1\\b\\i " + textData + "}";
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    RTFTransfer rtfTransfer = RTFTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer, rtfTransfer};
                    Object[] data = new Object[]{textData, rtfData};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                    break;
                }
                if (this.m_combo == null) break;
                this.m_combo.setText("");
                break;
            }
            case 5: {
                if (this.m_field_styled != null) {
                    this.m_field_styled.selectAll();
                    break;
                }
                if (this.m_field != null) {
                    this.m_field.selectAll();
                    break;
                }
                if (this.m_combo != null) break;
                break;
            }
            case 6: {
                break;
            }
        }
    }
}

