/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.NameValidatorHostGroup;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class AddGroupTreeObjectAction
extends Action {
    private GroupTreeObject m_gto = null;
    private TreeViewer m_treeViewer = null;
    private String m_treeType = null;
    private String m_title = null;
    private String m_expectedType = null;
    private String m_value = "";

    public AddGroupTreeObjectAction(TreeViewer treeViewer, GroupTreeObject gto, String treeType, String folderType) {
        super("AddGroup");
        this.setId("add_GroupTreeObject");
        if (folderType != null && folderType.equals(BMUI.type_toplevel)) {
            this.m_title = "Add Assignment Group";
            this.setImageDescriptor(BMUI.IMAGE_DESCR_ASN);
            this.m_expectedType = BMUI.type_assignment_pol;
        } else {
            this.m_title = "Add Group";
            this.m_expectedType = BMUI.type_folder;
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FOLDER_DEFAULT);
        }
        this.setText(this.m_title);
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_treeType = treeType;
        if (this.m_gto == null || this.m_treeViewer == null || this.m_treeType == null) {
            this.setEnabled(false);
            return;
        }
        if (this.m_treeType.equals(BMUI.type_tree_policy) || this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            } else if (!PolicyManager.getInstance().isPermittedPolicyModify(this.m_gto)) {
                this.setEnabled(false);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            if (!PolicyManager.getInstance().isPermittedPGAModify(this.m_gto)) {
                this.setEnabled(false);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_action)) {
            if (Repository.getInstance().getRights(1007) < 3) {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private void run(String value) {
        this.m_value = value;
        this.run();
    }

    public void run() {
        boolean isSuccess = false;
        InputDialog id = new InputDialog(this.m_treeViewer.getControl().getShell(), "   " + this.m_title, "Please enter a Group Name", this.m_value, (IInputValidator)new NameValidatorHostGroup());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            String newName = id.getValue().trim();
            if (this.m_gto.getChild(newName, this.m_expectedType) != null) {
                MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"Another Group with this name already exists!\nPlease enter a different name.");
                this.run(newName);
            } else {
                GroupTreeObject target_gto = this.m_gto;
                String treePath = this.m_gto.getPath();
                UpdateServer usrv = new UpdateServer();
                if (this.m_treeType.equals(BMUI.type_tree_policy) || this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
                    isSuccess = usrv.syncWithServer(treePath, newName, CMDS.ACTION_ADD, "");
                } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
                    isSuccess = usrv.syncAsnWithServer(treePath, newName, CMDS.ACTION_ADD, this.m_expectedType);
                } else if (this.m_treeType.equals(BMUI.type_tree_action)) {
                    target_gto = this.m_gto.getParent();
                    NameValidatorFile validator = new NameValidatorFile();
                    if (validator.isValid(newName) == null) {
                        String[] arr = new String[]{newName};
                        isSuccess = usrv.syncWithActionServer(CMDS.ACTION_ADD, arr);
                    } else {
                        if (newName.length() == 0) {
                            new ShowMessageBox("  Invalid Action Group Name", "Action Group Name is empty!", 1);
                            this.run();
                            return;
                        }
                        new ShowMessageBox("  Invalid Action Group Name", validator.isValid(newName), 1);
                        this.run(newName);
                        return;
                    }
                }
                if (isSuccess) {
                    GroupTreeObject gtoNew = new GroupTreeObject(new TreeObject(newName, this.m_expectedType, null));
                    try {
                        target_gto.addElement(gtoNew);
                        Object[] expanded = this.m_treeViewer.getExpandedElements();
                        this.m_treeViewer.refresh();
                        int index = 0;
                        while (index < expanded.length) {
                            this.m_treeViewer.setExpandedState(expanded[index], true);
                            ++index;
                        }
                        if (this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
                            PolicyListView.getInstance().getTreeViewer().refresh();
                        }
                        this.m_treeViewer.setExpandedState((Object)target_gto, true);
                    }
                    catch (Throwable throwable) {}
                } else {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                }
            }
        }
    }
}

