/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ActionAndHostGroupDialog;
import com.blixx.boom.gui.dialogs.NameValidatorHostGroup;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.ScErrorShowMessage;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScAddNodeGroup;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.w3c.dom.Document;

public class AddHostGroupAction
extends Action {
    private Viewer m_viewer = null;
    private GroupTreeObject m_root = null;
    private String m_localPath = null;
    private String m_srvPath = null;
    private String m_filename = null;
    private String m_parentName = null;
    private String m_parentPath = null;
    private String m_parentType = null;
    private String m_hostGrpName = null;

    public AddHostGroupAction(Viewer viewer, String fname, String srvPath, String localpath, String parentName, String parentPath, String parentType, GroupTreeObject root) {
        this.setText("Add Group");
        this.setId("AddNewGTO");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_FOLDER_DEFAULT);
        this.m_viewer = viewer;
        this.m_parentName = parentName;
        this.m_parentPath = parentPath;
        this.m_parentType = parentType;
        this.m_root = root;
        this.m_localPath = localpath;
        this.m_srvPath = srvPath;
        this.m_filename = fname;
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
        GroupTreeObject folder = this.m_root.searchPath(this.m_parentPath, this.m_parentType);
        if (!Repository.getInstance().isPermittedNodeGroupModify(folder)) {
            this.setEnabled(false);
        }
    }

    private void run(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_hostGrpName = name;
        this.run();
    }

    public void run() {
        String name;
        ActionAndHostGroupDialog id = new ActionAndHostGroupDialog(this.m_viewer.getControl().getShell(), "  Add Host Group", "Please enter a Host Group Name:", null, this.m_hostGrpName, new NameValidatorHostGroup());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0 && (name = id.getValue()) != null && name.length() > 0) {
            GroupTreeObject parent = this.m_root.searchPath(this.m_parentPath, this.m_parentType);
            if (parent != null) {
                if (parent.getChild(name, BMUI.type_folder) != null) {
                    new ShowMessageBox(" Add Group", "A Group with this name does already exist!", 2);
                    this.run(name);
                } else {
                    ScAddNodeGroup sc_v4 = new ScAddNodeGroup(Repository.getInstance(), String.valueOf(this.m_parentPath) + "/" + name);
                    final String fname = name;
                    sc_v4.addCmdPostProcess(new ICmdPostProcess(){

                        public void postProcess(ServerClient cmd) {
                            if (!cmd.isSupported()) {
                                GroupTreeObject parent = AddHostGroupAction.this.m_root.searchPath(AddHostGroupAction.this.m_parentPath, AddHostGroupAction.this.m_parentType);
                                GroupTreeObject newGTO = new GroupTreeObject(new TreeObject(fname, BMUI.type_folder, null));
                                parent.addElement(newGTO);
                                GroupTreeObject rroot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                                rroot.addElement(AddHostGroupAction.this.m_root);
                                XMLTree xt = new XMLTree();
                                Document doc = xt.getXML(rroot);
                                XMLFactory.writeXml(doc, String.valueOf(AddHostGroupAction.this.m_localPath) + AddHostGroupAction.this.m_filename);
                                com.blixx.boom.engine.ServerClient scOld = com.blixx.boom.engine.ServerClient.putFile(String.valueOf(AddHostGroupAction.this.m_srvPath) + AddHostGroupAction.this.m_filename, String.valueOf(AddHostGroupAction.this.m_localPath) + AddHostGroupAction.this.m_filename);
                                Repository.getJobManager().schedule(scOld);
                            }
                        }
                    });
                    sc_v4.addCmdPostProcess(new ScErrorShowMessage("Error adding node group " + name));
                    Repository.getJobManager().schedule(sc_v4);
                }
            } else {
                new ShowMessageBox("  Missing Node Group", "Adding new Group failed. The parent Group '" + this.m_parentName + "' does not exist!", 2);
                return;
            }
        }
    }
}

