/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.AddAgentDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScJobCreateAgents;
import com.blixx.log.RTLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class AddNewAgent
extends Action {
    public Pattern m_pattern;
    public boolean m_external = false;

    public AddNewAgent() {
        this(false);
    }

    public AddNewAgent(boolean external) {
        this.m_external = external;
        if (external) {
            this.setText("Add Virtual Agent");
            this.setId("AddVirtualAgent");
        } else {
            this.setText("Add Agent");
            this.setId("AddNewAgent");
        }
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_external) {
            InputDialog idlg = new InputDialog(Display.getCurrent().getActiveShell(), "Add Virtual Agent", "Please enter IP or hostname", "", null);
            idlg.setBlockOnOpen(true);
            int res = idlg.open();
            if (res == 0) {
                Gson gson = new GsonBuilder().create();
                String newAgentJson = gson.toJson(new NewAgent(idlg.getValue(), 0, false));
                this.runServerCommand(newAgentJson);
            }
        } else {
            AddAgentDialog id = new AddAgentDialog(Display.getCurrent().getActiveShell());
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0) {
                String hostOrIp = id.getHostnameOrIp();
                int port = id.getPortInt();
                boolean isTls = id.isTls();
                Gson gson = new GsonBuilder().create();
                String newAgentJson = gson.toJson(new NewAgent(hostOrIp, port, isTls));
                this.runServerCommand(newAgentJson);
            }
        }
    }

    private void runServerCommand(String newAgentJson) {
        RTLogger.print(3, "AddNewAgent: " + newAgentJson);
        ScJobCreateAgents sc = new ScJobCreateAgents(Repository.getInstance(), new String[]{newAgentJson});
        sc.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(ServerClient s) {
                ScJobCreateAgents sc = (ScJobCreateAgents)s;
                if (!sc.isSuccess()) {
                    String error = sc.getResultObject();
                    if ("F".equals(error)) {
                        error = "Server failed to process the operation";
                    }
                    final String err = error;
                    UIJob uj = new UIJob(null){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            new ShowMessageBox("Error creating new Agent cards", err, 1);
                            return Status.OK_STATUS;
                        }
                    };
                    UIJobManager.getInstance().schedule(uj);
                }
            }
        });
        Repository.getJobManager().schedule(sc);
    }

    private class NewAgent {
        private String ip;
        private int port;
        private boolean isTLS = false;

        public NewAgent(String hostOrIp, int port, boolean isTls) {
            this.ip = hostOrIp;
            this.port = port;
            this.isTLS = isTls;
        }
    }
}

