/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.AddAgentDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScCreateAgentSlave;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.SSCLite;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class AddNewAgentActionSlave
extends Action {
    String m_serverName = null;
    public boolean m_external = false;

    public AddNewAgentActionSlave(String serverName) {
        this(serverName, false);
    }

    public AddNewAgentActionSlave(String serverName, boolean external) {
        SSCLite slave;
        this.m_external = external;
        if (external) {
            this.setText("Add Virtual Agent");
            this.setId("AddVirtualAgentSlave");
        } else {
            this.setText("Add Agent");
            this.setId("AddNewAgentSlave");
        }
        this.m_serverName = serverName;
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
        if ((slave = Repository.getInstance().getSlave(serverName)) == null || slave.getScenario() > 1) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_external) {
            InputDialog idlg = new InputDialog(Display.getCurrent().getActiveShell(), "Add Virtual Agent", "Please enter IP or hostname", "", null);
            idlg.setBlockOnOpen(true);
            int res = idlg.open();
            if (res == 0) {
                Gson gson = new GsonBuilder().create();
                String newAgentJson = gson.toJson(new NewAgent(idlg.getValue(), 0, false));
                this.runServerCommand(newAgentJson);
            }
        } else {
            AddAgentDialog id = new AddAgentDialog(Display.getCurrent().getActiveShell());
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0) {
                String hostOrIp = id.getHostnameOrIp();
                int port = id.getPortInt();
                boolean isTls = id.isTls();
                Gson gson = new GsonBuilder().create();
                String newAgentJson = gson.toJson(new NewAgent(hostOrIp, port, isTls));
                this.runServerCommand(newAgentJson);
            }
        }
    }

    private void runServerCommand(String newAgentJson) {
        RTLogger.print(3, "AddNewAgentToSlave " + newAgentJson);
        try {
            ScCreateAgentSlave sc = new ScCreateAgentSlave((IServerAuth)Repository.getInstance(), this.m_serverName, new String[]{newAgentJson});
            sc.addCmdPostProcess(new ICmdPostProcess(){

                public void postProcess(ServerClient s) {
                    ScCreateAgentSlave sc = (ScCreateAgentSlave)s;
                    if (!sc.isSuccess()) {
                        String error = sc.getResultObject();
                        if ("F".equals(error)) {
                            error = "Server failed to process the operation";
                        }
                        final String err = error;
                        UIJob uj = new UIJob(null){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                new ShowMessageBox("Error creating new Agent cards", err, 1);
                                return Status.OK_STATUS;
                            }
                        };
                        UIJobManager.getInstance().schedule(uj);
                    }
                }
            });
            Repository.getJobManager().schedule(sc);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class NewAgent {
        private final String ip;
        private final int port;
        private final boolean isTLS;

        public NewAgent(String hostOrIp, int port, boolean isTls) {
            this.ip = hostOrIp;
            this.port = port;
            this.isTLS = isTls;
        }
    }
}

