/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.utils.PolicyType;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;

public class AddPolicyAction
extends Action {
    private GroupTreeObject m_gto = null;
    TreeViewer m_treeViewer = null;
    private String m_type;
    private PolicyType m_subtype = null;

    public AddPolicyAction(TreeViewer treeViewer, GroupTreeObject gto, String type, PolicyType subtype) {
        super("addPolicy" + type);
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_type = type;
        this.m_subtype = subtype;
        if (this.m_subtype != null) {
            switch (this.m_subtype) {
                case MON_EXTERNAL: {
                    this.setText("External");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_EXEC: {
                    this.setText("Exec");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_OPM_LBL: {
                    this.setText("OPM LineByLine");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_OPM_TABLE: {
                    this.setText("OPM TableSummary");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_OPM_PUNCHCARD: {
                    this.setText("OPM PunchCard");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_SNMP_WALK: {
                    this.setText("SNMP Walk");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MON_JAVA: {
                    this.setText("General Java");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
                    break;
                }
                case MSG_INDI: {
                    this.setText("Indication");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                case MSG_LOGFIL: {
                    this.setText("Logfile");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                case MSG_TRANSACT_LOGFILE: {
                    this.setText("Transaction Logfile");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                case MSG_TRANSACT_LOGFILE_ML: {
                    this.setText("Transaction Logfile (muti-line)");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                case MSG_NAGIN: {
                    this.setText("Nagin");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                case MSG_SNMP_TRAP: {
                    this.setText("SNMP Traps");
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
                    break;
                }
                default: {
                    this.setEnabled(false);
                    break;
                }
            }
        } else if (type.equals(BMUI.type_mon)) {
            this.setText("Add New Monitor Policy");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_MON);
        } else {
            this.setText("Add New Indication Policy");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_MSG);
        }
        this.setId("Added_Policy" + type);
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        boolean isOk = false;
        GroupTreeObjectUnsubmitted gtol = null;
        Object[] expanded = this.m_treeViewer.getExpandedElements();
        try {
            if (this.m_type.equals(BMUI.type_mon)) {
                Policy pNew = Policy.createNewPolicy();
                if (this.m_subtype != null) {
                    switch (this.m_subtype) {
                        case MON_EXTERNAL: {
                            pNew.setCallType("EXTERNAL");
                            break;
                        }
                        case MON_EXEC: {
                            pNew.setCallType("EXEC");
                            break;
                        }
                        case MON_OPM_LBL: {
                            pNew.setCallType("JAVA");
                            pNew.setMonprog("com.blixx.agent.monitors.Opm\n\nLineByLine");
                            break;
                        }
                        case MON_OPM_TABLE: {
                            pNew.setCallType("JAVA");
                            pNew.setMonprog("com.blixx.agent.monitors.Opm\n\nTableSummary\n(.*)");
                            break;
                        }
                        case MON_OPM_PUNCHCARD: {
                            pNew.setCallType("JAVA");
                            pNew.setMonprog("com.blixx.agent.monitors.Opm\n\nPunchCard\n\n\n=");
                            break;
                        }
                        case MON_SNMP_WALK: {
                            pNew.setCallType("JAVA");
                            pNew.setMonprog("com.blixx.boom.snmp.SNMPWalkMonitor\n-h localhost\n-v 2c");
                            break;
                        }
                        case MON_JAVA: {
                            pNew.setCallType("JAVA");
                            pNew.setMonprog("");
                        }
                    }
                }
                gtol = new GroupTreeObjectUnsubmitted(new TreeObject(pNew.getName(), BMUI.type_mon, pNew), null, "IMAGE_MON");
                this.m_gto.addElement(gtol);
                PolicyView.showNewPolicyTab(pNew, this.m_treeViewer, gtol, true);
                PolicyManager.getInstance().addUnsubmitted(gtol, this.m_gto.getPath());
                isOk = true;
            } else if (this.m_type.equals(BMUI.type_msg)) {
                MsgPolicy mpNew = MsgPolicy.createNewPolicy();
                if (this.m_subtype != null) {
                    switch (this.m_subtype) {
                        case MSG_INDI: {
                            break;
                        }
                        case MSG_LOGFIL: {
                            mpNew.setCallType("JAVA");
                            mpNew.setIntervalStr("1m");
                            mpNew.setMonprog("com.blixx.agent.monitors.MPathLogFileMonitor\n\n.*\n.*\nFROM_LAST\n");
                            break;
                        }
                        case MSG_TRANSACT_LOGFILE: {
                            mpNew.setCallType("JAVA");
                            mpNew.setIntervalStr("1m");
                            mpNew.setMonprog("com.blixx.agent.monitors.MPathLogFileTransactionMonitor\n\n\n\n\n3600");
                            break;
                        }
                        case MSG_TRANSACT_LOGFILE_ML: {
                            mpNew.setCallType("JAVA");
                            mpNew.setIntervalStr("1m");
                            mpNew.setMonprog("com.blixx.agent.monitors.MPathLogFileTransactionMonitorML\n\n\n\n\n\n3600");
                            break;
                        }
                        case MSG_NAGIN: {
                            mpNew.setCallType("NAGIN");
                            break;
                        }
                        case MSG_SNMP_TRAP: {
                            MsgCondition mc = (MsgCondition)mpNew.getConditions().getCondition(0);
                            mc.setDescription("All Traps");
                            mc.setApplicationFilter("SNMPTrapd");
                            mc.setGroupFilter("SNMP");
                            mc.setObjectFilter(".1.3.6.<*>");
                        }
                    }
                }
                gtol = new GroupTreeObjectUnsubmitted(new TreeObject(mpNew.getName(), BMUI.type_msg, mpNew), null, "IMAGE_MSG");
                this.m_gto.addElement(gtol);
                PolicyView.showNewPolicyTab(mpNew, this.m_treeViewer, gtol, true);
                PolicyManager.getInstance().addUnsubmitted(gtol, this.m_gto.getPath());
                isOk = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            RTLogger.print(5, "error creation a new policy", e);
        }
        if (isOk) {
            this.m_treeViewer.refresh();
            int index = 0;
            while (index < expanded.length) {
                this.m_treeViewer.setExpandedState(expanded[index], true);
                ++index;
            }
            PolicyTreeProvider.getInstance().setTreeSelection(gtol.getName(), gtol.getTreeObject().getType());
            RTLogger.print(4, "New Policy has been added.");
        } else {
            RTLogger.print(4, "Error creating new Policy!");
            new ShowMessageBox("Add New Policy", "Error creating new Policy!", 1);
        }
    }
}

