/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ActionAndHostGroupDialog;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class AddRenameActionGroupAction
extends Action {
    private GroupTreeObject m_gto = null;
    private TreeViewer m_treeViewer = null;
    private String m_title = null;
    private String m_actionGrpName_initial = null;
    private String m_actionGrpName = null;
    private String m_type = null;
    public static String ADD = "ADD";
    public static String RENAME = "RENAME";

    public AddRenameActionGroupAction(TreeViewer treeViewer, GroupTreeObject gto, String type) {
        super("AddRenameActionGroup");
        this.setId("addrenameactiongroup");
        this.m_title = type.equals(ADD) ? "Add Action Group" : "Rename Action Group";
        this.setText(this.m_title);
        this.setImageDescriptor(BMUI.IMAGE_DESCR_FOLDER_DEFAULT);
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_type = type;
        if (Repository.getInstance().getRights(1007) < 3) {
            this.setEnabled(false);
            return;
        }
        if (this.m_type.equals(RENAME) && Repository.getInstance().getRights(gto.getName()) < 3) {
            this.setEnabled(false);
            return;
        }
        if (this.m_type.equals(RENAME)) {
            this.m_actionGrpName = this.m_gto.getName();
            this.m_actionGrpName_initial = this.m_gto.getName();
        }
    }

    private void run(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_actionGrpName = name;
        this.run();
    }

    public void run() {
        String name;
        if (!this.isEnabled()) {
            return;
        }
        String expectedType = BMUI.type_folder;
        ActionAndHostGroupDialog id = new ActionAndHostGroupDialog(this.m_treeViewer.getControl().getShell(), "   " + this.m_title, "Please enter an Action Group Name:", this.m_actionGrpName_initial, this.m_actionGrpName, new NameValidatorFile());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0 && (name = id.getValue().trim()) != null && name.length() > 0) {
            if (this.m_type.equals(ADD)) {
                if (this.m_gto.getChild(name, expectedType) != null) {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"Action Group with this name does already exists!\nPlease enter a different name.");
                    this.run(name);
                } else {
                    UpdateServer usrv = new UpdateServer();
                    String[] arr = new String[]{name};
                    boolean isSuccess = usrv.syncWithActionServer(CMDS.ACTION_ADD, arr);
                    if (isSuccess) {
                        GroupTreeObject gtoNew = new GroupTreeObject(new TreeObject(name, expectedType, null));
                        try {
                            this.m_gto.addElement(gtoNew);
                            Object[] expanded = this.m_treeViewer.getExpandedElements();
                            this.m_treeViewer.refresh();
                            int index = 0;
                            while (index < expanded.length) {
                                this.m_treeViewer.setExpandedState(expanded[index], true);
                                ++index;
                            }
                            this.m_treeViewer.setExpandedState((Object)this.m_gto, true);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                    }
                }
            } else if (this.m_type.equals(RENAME)) {
                if (name.equals(this.m_actionGrpName)) {
                    return;
                }
                if (this.m_gto.getParent().getChild(name, expectedType) != null) {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"Action Group with this name does already exists!\nPlease enter a different name.");
                    this.run(name);
                } else {
                    File newFile = null;
                    String oldFileName = String.valueOf(Repository.getInstance().getActionsDirectory()) + "\\" + this.m_gto.getName() + BMUI.file_extension_act;
                    File oldFile = new File(oldFileName);
                    if (oldFile.exists()) {
                        newFile = new File(String.valueOf(oldFileName) + ".tmp");
                        if (newFile.exists()) {
                            newFile.delete();
                        }
                        oldFile.renameTo(newFile);
                    } else {
                        RTLogger.print(5, "fileNofFound=" + oldFile.getName());
                    }
                    String[] arr = new String[]{this.m_gto.getName(), id.getValue()};
                    UpdateServer usrv = new UpdateServer();
                    boolean isSuccess = usrv.syncWithActionServer(CMDS.ACTION_RNM, arr);
                    if (isSuccess) {
                        this.m_gto.setName(id.getValue());
                        Object[] expanded1 = this.m_treeViewer.getExpandedElements();
                        this.m_treeViewer.refresh();
                        int index = 0;
                        while (index < expanded1.length) {
                            this.m_treeViewer.setExpandedState(expanded1[index], true);
                            ++index;
                        }
                    } else {
                        if (oldFile.exists()) {
                            oldFile.delete();
                        }
                        newFile.renameTo(oldFile);
                        MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error renaming Action Group", (String)usrv.m_resultString);
                    }
                }
            }
        }
    }
}

