/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.UItem;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class AddRoleAction
extends Action {
    private TreeViewer m_treeViewer = null;

    public AddRoleAction(TreeViewer treeViewer) {
        super("AddUserRole");
        this.setText("Add User Role");
        this.setId("AddUserRole");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_USERS);
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1004) < 3 || this.m_treeViewer == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        InputDialog id = new InputDialog(this.m_treeViewer.getControl().getShell(), "  New Role", "Please enter a new user role name", "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            boolean exist = Repository.getInstance().getUserManager().roleExist(id.getValue());
            if (exist) {
                MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Information", (String)"Role does already exist. Please choose a different name!");
            } else {
                ArrayList<UserRight> userRights = new ArrayList<UserRight>();
                List<UItem> items = Repository.getInstance().getUserManager().getUItems();
                UserRole newRole = UserRole.createNewRole();
                newRole.setName(id.getValue().trim());
                String newRoleID = newRole.getID();
                int i = 0;
                while (i < items.size()) {
                    UItem item = items.get(i);
                    UserRight ur = new UserRight(newRoleID, item.m_ID, 1);
                    userRights.add(ur);
                    ++i;
                }
                newRole.addRights(userRights);
                Repository.getInstance().getUserManager().saveRole(newRole);
            }
        }
    }
}

