/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.gui.dialogs.EventFilterServiceDialog;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.DashBoardServicesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class AddServiceAction
extends Action {
    private Shell m_shell = null;
    private ServiceDashBoardProvider m_serviceProvider = null;
    private IRefreshable m_dashBoardView = null;
    private IEventProvider m_esProvider = null;
    private IEventsSummary m_esSummary = null;

    public AddServiceAction(Shell shell, ServiceDashBoardProvider serviceProvider, IEventProvider esProvider, IEventsSummary esSummary) {
        super("addServiceAction");
        this.setText("Add Service");
        this.setId("addserviceaction");
        this.m_shell = shell;
        if (Repository.getInstance().getRights(1000) < 3) {
            this.setEnabled(false);
        }
        this.m_serviceProvider = serviceProvider;
        this.m_esProvider = esProvider;
        this.m_esSummary = esSummary;
    }

    public void run() {
        String serviceName;
        InputDialog id = new InputDialog(this.m_shell, " Add Service", "Please enter a Service Name:", "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0 && (serviceName = id.getValue()) != null && serviceName.length() > 0) {
            if (this.m_serviceProvider.getServiceByName(serviceName) != null) {
                new ShowMessageBox("Add Service", "Service name does already exist!", 8);
                this.run();
            } else {
                ServiceDashBoard service = new ServiceDashBoard(serviceName, this.m_esProvider);
                service.setMode(2);
                EventFilterServiceDialog efsd = new EventFilterServiceDialog("  Service: " + serviceName, service, this.m_serviceProvider, true, this.m_esProvider, this.m_esSummary);
                DashBoardServicesView.m_openEFSDialogs.put(service.getID(), efsd);
                efsd.open();
            }
        }
    }
}

