/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.TblFilter;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.TableColumn;

public class AddToPredefinedTabsActions
extends Action {
    private CTabFolder m_folder = null;
    private MessageBrowserTab m_mbt = null;
    private String m_msgViewType = null;
    public static final String ADD_TO_PREDEFINED_TABS_TITEL = "Add to Predefined Tabs";
    public static final String ADD_TO_PREDEFINED_TABS = "AddToPredefinedTabs";

    public AddToPredefinedTabsActions(CTabFolder folder, MessagesView msgView) {
        super("ADD_TO_PREDEFINED_TABS2");
        this.setId("ADD_TO_PREDEFINED_TABS2");
        this.setText(ADD_TO_PREDEFINED_TABS_TITEL);
        this.m_folder = folder;
        try {
            this.m_mbt = (MessageBrowserTab)this.m_folder.getSelection();
            String title = msgView.getTitle();
            if ("Indications".equals(title)) {
                this.m_msgViewType = UISettings.MSG_VIEW1;
            } else if ("Indications (2)".equals(title)) {
                this.m_msgViewType = UISettings.MSG_VIEW2;
            }
        }
        catch (Exception exception) {}
        if (this.m_folder == null || this.m_msgViewType == null || this.m_mbt == null || this.m_mbt.isPredefinedTab()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.addToPredefinedTab();
        this.removeFromUserTab();
    }

    private void addToPredefinedTab() {
        String currSorting = this.m_mbt.getEventSorter().getCurrentSorting();
        String sortCol = UISettings.getInstance().getDefaultSortCol();
        String sortDir = UISettings.getInstance().getDefaultSortDir();
        String[] sort = currSorting.split("\\|");
        if (sort.length == 2) {
            sortCol = sort[0];
            sortDir = sort[1];
        }
        PredefinedTab predTab = new PredefinedTab(this.m_msgViewType, this.m_mbt.getText(), this.m_mbt.getEventProvider().getType(), this.m_mbt.getEventProvider().isShowActive(), false, sortDir, sortCol);
        TableColumn[] cols = this.m_mbt.getTableViewer().getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            predTab.addColumn(new TblColumn(col.getText(), i, col.getWidth(), false));
            ++i;
        }
        Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(this.m_mbt.getTableViewer());
        while (it.hasNext()) {
            EventFilter ef = it.next();
            TblFilter tblFilter = new TblFilter(ef.getLabelOrName(), ef.getLabelOrName(), ef.m_column, ef.m_isActive, ef.m_isLocked, true, ef.m_Availability, ef.m_KPIs, ef.m_isNOT, ef.m_caseSensitive, ef.m_mode, ef.m_pattern);
            predTab.addFilter(tblFilter);
        }
        UISettings.getInstance().addIBPredefinedTabs(predTab);
        this.m_mbt.setPredefinedTab();
    }

    private void removeFromUserTab() {
    }
}

