/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScJobCreateAgents;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class AddVirtAgentAction
extends Action {
    public Pattern m_pattern;

    public AddVirtAgentAction() {
        this.setText("Add Virtual Agent(s)");
        this.setId("AddVirtualAgent");
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        InputDialog id = new InputDialog(Display.getCurrent().getActiveShell(), "Add Virtual Agent(s)", "Please enter IPs separated by comma or space", "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            String[] IPs = id.getValue().split("[, \t]");
            ArrayList<String> IPsArr = new ArrayList<String>();
            int i = 0;
            while (i < IPs.length) {
                String name = IPs[i];
                if (!name.endsWith(":0")) {
                    name = String.valueOf(name) + ":0";
                }
                IPsArr.add(name);
                ++i;
            }
            ScJobCreateAgents sc = new ScJobCreateAgents(Repository.getInstance(), IPsArr.toArray(new String[0]));
            sc.addCmdPostProcess(new ICmdPostProcess(){

                public void postProcess(ServerClient s) {
                    ScJobCreateAgents sc = (ScJobCreateAgents)s;
                    if (!sc.isSuccess()) {
                        String error = sc.getResultObject();
                        if ("F".equals(error)) {
                            error = "Server failed to process the operation";
                        }
                        final String err = error;
                        UIJob uj = new UIJob(null){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                new ShowMessageBox("Error creating new Agent cards", err, 1);
                                return Status.OK_STATUS;
                            }
                        };
                        UIJobManager.getInstance().schedule(uj);
                    }
                }
            });
            Repository.getJobManager().schedule(sc);
        }
    }
}

