/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.ctrl.sc.in.ScJobApproveAgents;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;

public class ApproveAgentAction
extends Action {
    AgentCard m_ac = null;
    List<String> m_selectedAgents = new ArrayList<String>();
    TreeViewer m_tv = null;
    GroupTreeObject m_parent = null;

    public ApproveAgentAction(List<AgentCard> selectedAgentCards) {
        super("ApproveAgent");
        this.setId("ApproveAgent");
        this.setText("Approve Agent");
        if (Repository.getInstance().getRights(1002) < 3 || selectedAgentCards == null || selectedAgentCards.size() == 0) {
            this.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < selectedAgentCards.size()) {
            AgentCard ac = selectedAgentCards.get(i);
            if (!ac.isApproved()) {
                this.m_selectedAgents.add(ac.getAgentID());
            }
            ++i;
        }
        if (this.m_selectedAgents.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_selectedAgents.size() > 0) {
            this.setText("Approve Agents");
        }
    }

    public ApproveAgentAction(GroupTreeObject parent) {
        super("ApproveAgent");
        this.setId("ApproveAgent");
        this.setText("Approve Agent");
        if (parent.getElements().size() > 1) {
            this.setText("Approve Agents");
        }
        this.m_parent = parent;
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_parent != null) {
            for (GroupTreeObjectLast acGtol : this.m_parent.getAllGTOLs()) {
                ITreeObject to = acGtol.getTreeObject();
                if (!(to instanceof AbstractAgentCard)) continue;
                this.m_selectedAgents.add(((AbstractAgentCard)((Object)to)).getAgentID());
            }
        }
        if (this.m_selectedAgents == null || this.m_selectedAgents.size() == 0) {
            return;
        }
        String[] IDs = new String[this.m_selectedAgents.size()];
        int i = 0;
        while (i < this.m_selectedAgents.size()) {
            String agentID = this.m_selectedAgents.get(i);
            RTLogger.print(5, "approve " + agentID);
            IDs[i] = agentID;
            ++i;
        }
        ScJobApproveAgents sc = new ScJobApproveAgents(Repository.getInstance(), IDs);
        Repository.getJobManager().schedule(sc);
    }
}

