/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.AgentTreeDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AssignToNodeAction
extends Action {
    protected List<GroupTreeObject> m_elements = new ArrayList<GroupTreeObject>();
    protected Shell m_shell = null;
    protected StructuredViewer m_treeViewer = null;
    protected StructuredViewer m_tableViewer = null;
    protected GroupTreeObject m_root = null;
    protected String m_action = null;
    protected String m_type = null;
    protected AgentCard m_ac = null;
    protected String m_title = null;
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static String AGENTS = "Agents";

    public AssignToNodeAction(TreeViewer treeViewer, String action) {
        super(action);
        this.m_treeViewer = treeViewer;
        if (this.m_treeViewer == null || action == null) {
            this.setText("Deploy");
            this.setEnabled(false);
            return;
        }
        this.m_shell = this.m_treeViewer.getControl().getShell();
        this.m_action = action;
        this.m_root = (GroupTreeObject)this.m_treeViewer.getInput();
        this.m_type = (String)this.m_treeViewer.getData(TREE_VIEWER_TYPE);
        this.setTitleAndID();
        if (Repository.getInstance().getRights(1002) < 2) {
            this.setEnabled(false);
        } else {
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (this.m_type.equals(PolicyListView.POLICY_LIST)) {
                for (Object selected : sel) {
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.isGroup()) {
                        this.m_elements.addAll(gto.getAllGTOLs());
                        continue;
                    }
                    this.m_elements.add((GroupTreeObjectLast)gto);
                }
            } else if (this.m_type.equals("Packages")) {
                for (Object selected : sel) {
                    GroupTreeObject pkg;
                    if (!(selected instanceof GroupTreeObject) || !BMUI.type_assignment_bin.equals((pkg = (GroupTreeObject)selected).getType())) continue;
                    this.m_elements.add(pkg);
                }
            } else if (this.m_type.equals(AssignmentListView.ASSIGNMENT_LIST)) {
                this.processAssignmentTreeSelection(sel);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public AssignToNodeAction(TableViewer tableViewer, String action) {
        super(action);
        this.m_action = action;
        this.m_type = null;
        this.m_tableViewer = tableViewer;
        this.setTitleAndID();
        if (this.m_tableViewer == null || Repository.getInstance().getRights(1002) < 2) {
            this.setEnabled(false);
            return;
        }
        this.m_shell = this.m_tableViewer.getControl().getShell();
        StructuredSelection sel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (sel.size() > 0) {
            HashMap<String, GroupTreeObjectLast> policyGTOLs = this.getAllPolicyGTOLs();
            Iterator it = sel.iterator();
            GroupTreeObject gto = null;
            while (it.hasNext()) {
                Object selected = it.next();
                if (selected instanceof String[]) {
                    String[] item = (String[])selected;
                    String polName = item[1];
                    gto = policyGTOLs.get(polName);
                } else if (selected instanceof Assignment) {
                    Assignment asn = (Assignment)selected;
                    String asnType = asn.getType();
                    if (asnType.equals(BMUI.type_mon) || asnType.equals(BMUI.type_msg)) {
                        gto = PolicyManager.getInstance().getPolicyTree().findElement(asn.getName(), asnType);
                    } else if (asnType.equals(BMUI.type_assignment_bin)) {
                        GroupTreeObject root_binary = Repository.getInstance().getBinaryTree();
                        gto = root_binary.findFirstGroupByName(asn.getName());
                    }
                }
                if (gto == null) continue;
                this.m_elements.add(gto);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        }
    }

    protected void processAssignmentTreeSelection(StructuredSelection sel) {
        for (GroupTreeObject selected : sel) {
            if (!selected.getTreeObject().getType().equals(BMUI.type_assignment_pol)) continue;
            this.m_elements.add(selected);
        }
    }

    public AssignToNodeAction(StructuredViewer treeViewer, String action, AgentCard ac) {
        super(action);
        this.m_treeViewer = treeViewer;
        this.m_action = action;
        this.m_ac = ac;
        this.m_type = AGENTS;
        if (this.m_treeViewer == null || this.m_action == null || this.m_ac == null) {
            this.setText("Deploy");
            this.setEnabled(false);
            return;
        }
        this.setTitleAndID();
        if (!Repository.getInstance().isPermittedAgentModify(this.m_ac)) {
            this.setEnabled(false);
            return;
        }
        this.m_shell = this.m_treeViewer.getControl().getShell();
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        Iterator it = sel.iterator();
        LinkedList<String> uniqueAdded = new LinkedList<String>();
        while (it.hasNext()) {
            Object selected = it.next();
            if (selected instanceof HashMap) {
                HashMap map = (HashMap)selected;
                map.get("POLICYNAME");
                GroupTreeObjectLast gtol = new GroupTreeObjectLast(new TreeObject((String)map.get("POLICYNAME"), (String)map.get("POLICYTYPE"), null), null, null);
                this.m_elements.add(gtol);
                continue;
            }
            if (selected instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gl = (GroupTreeObjectLast)selected;
                this.addGTOL(gl, uniqueAdded);
                continue;
            }
            if (!(selected instanceof GroupTreeObject)) continue;
            GroupTreeObject gto = (GroupTreeObject)selected;
            if (gto.getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                this.addGTO(gto, uniqueAdded);
            }
            List<GroupTreeObjectLast> gtols = GroupTreeObject.collectElements(gto);
            for (GroupTreeObjectLast gtol : gtols) {
                this.addGTOL(gtol, uniqueAdded);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        }
    }

    public AssignToNodeAction(String polName, String polType, String action) {
        super(action);
        this.m_action = action;
        this.m_type = null;
        if (this.m_action == null || polName == null || polType == null) {
            this.setText("Deploy");
            this.setEnabled(false);
            return;
        }
        this.setTitleAndID();
        GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
        GroupTreeObjectLast gtol = root.findElement(polName, polType);
        if (gtol != null && !(gtol instanceof GroupTreeObjectUnsubmitted)) {
            this.m_elements.add(gtol);
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        }
    }

    public AssignToNodeAction(List<GroupTreeObject> elements, String action, AgentCard ac) {
        super(action);
        this.m_action = action;
        this.m_type = null;
        this.m_ac = ac;
        if (this.m_action == null || this.m_ac == null || elements == null) {
            this.setText("Deploy");
            this.setEnabled(false);
            return;
        }
        this.setTitleAndID();
        if (!Repository.getInstance().isPermittedAgentModify(this.m_ac)) {
            this.setEnabled(false);
            return;
        }
        this.m_elements = elements;
        if (this.m_elements == null || this.m_elements.size() == 0) {
            this.setEnabled(false);
        }
    }

    protected void setTitleAndID() {
        if (this.m_action.equals("DEPLOY")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("Re-Deploy");
                this.setId("deploy");
                this.m_title = " Deploy";
            } else {
                this.setText("Deploy on ...");
                this.setId("deployon");
                this.m_title = " Deploy on ...";
            }
        } else if (this.m_action.equals("DEPLOY_DELAYED")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("Enqueue Deployment");
                this.setId("deployDelayed");
                this.m_title = " Enqueue Deployment";
            } else {
                this.setText("Enqueue Deployment on ...");
                this.setId("deployDelayed");
                this.m_title = " Enqueue Deployment on ...";
            }
        } else if (this.m_action.equals("UNDEPLOY")) {
            if (this.m_type != null && this.m_type.equals("Packages")) {
                this.setText("Mark as UnDeploy from ...");
                this.setId("undeployVirtual");
                this.m_title = " Mark as UnDeploy from ...";
            }
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("UnDeploy");
                this.setId("undeploy");
                this.m_title = " UnDeploy";
            } else {
                this.setText("UnDeploy from ...");
                this.setId("undeploy");
                this.m_title = " UnDeploy from ...";
            }
        } else if (this.m_action.equals("UNDEPLOY_DELAYED")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("Enqueue UnDeployment");
                this.setId("undeployDelayed");
                this.m_title = " Enqueue UnDeployment";
            } else {
                this.setText("Enqueue UnDeployment from ...");
                this.setId("undeployDelayed");
                this.m_title = " Enqueue UnDeployment from ...";
            }
        } else if (this.m_action.equals("DEPLOY_VIRTUAL")) {
            this.setText("Mark as Deployed on ...");
            this.setId("deployVirtual");
            this.m_title = " Mark as Deployed on ...";
        }
    }

    protected void addGTO(GroupTreeObject gl, List<String> uniqueadded) {
        String name = (String)gl.getTreeObject().getObject();
        if (!uniqueadded.contains(name)) {
            GroupTreeObject gto = new GroupTreeObject(new TreeObject(name, gl.getTreeObject().getType(), null));
            this.m_elements.add(gto);
            uniqueadded.add(name);
        }
    }

    protected void addGTOL(GroupTreeObjectLast gl, List<String> uniqueadded) {
        String name = (String)gl.getTreeObject().getObject();
        if (!uniqueadded.contains(name)) {
            GroupTreeObjectLast gtol = new GroupTreeObjectLast(new TreeObject(name, gl.getTreeObject().getType(), null), null, null);
            this.m_elements.add(gtol);
            uniqueadded.add(name);
        }
    }

    protected HashMap<String, GroupTreeObjectLast> getAllPolicyGTOLs() {
        HashMap<String, GroupTreeObjectLast> policies = new HashMap<String, GroupTreeObjectLast>();
        GroupTreeObjectLast gtol = null;
        List<GroupTreeObject> list = PolicyManager.getInstance().getPolicyTree().getAllElements();
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject o = list.get(i);
            if (!(o instanceof GroupTreeObjectUnsubmitted) && o instanceof GroupTreeObjectLast) {
                gtol = (GroupTreeObjectLast)o;
                policies.put(gtol.getName(), gtol);
            }
            ++i;
        }
        return policies;
    }

    public void run() {
        if (this.m_elements.size() == 0) {
            return;
        }
        if (this.m_shell == null) {
            this.m_shell = Display.getCurrent().getActiveShell();
        }
        List<Object> agents = new ArrayList<AgentCard>();
        if (this.m_ac == null) {
            AgentTreeDialog atd = new AgentTreeDialog(this.m_shell, this.m_title, true);
            atd.setBlockOnOpen(true);
            try {
                atd.open();
            }
            catch (RuntimeException runtimeException) {}
            agents = atd.getSelectedAgentCards(true);
            if (agents.size() == 0) {
                if (atd.getSelectedAgentCards(false).size() > 0) {
                    new ShowMessageBox("Error", "All selected Agents are read-only", 8);
                }
                return;
            }
            String title = "    Agent";
            String header = "Do you want to Trigger Deployments for following Agent:";
            String footer = String.valueOf(agents.size()) + " Agents selected";
            String noElementText = "No Agents selected";
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "OK", agents, noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() != 0) {
                return;
            }
        } else {
            agents.add(this.m_ac);
        }
        ArrayList<String> al = new ArrayList<String>(this.m_elements.size() * 2);
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObject gtol = this.m_elements.get(i);
            if (gtol != null) {
                String type = gtol.getTreeObject().getType();
                if (type == null || type.equals("")) {
                    RTLogger.print(5, "type is null for element" + gtol);
                } else {
                    al.add(type);
                    String name = gtol.getName();
                    if (name == null || name.equals("")) {
                        RTLogger.print(5, "name is null for element" + gtol);
                        al.remove(al.size() - 1);
                    } else {
                        al.add(name);
                    }
                }
            }
            ++i;
        }
        this.schedule(agents, al);
    }

    private void schedule(List<AgentCard> agents, List<String> al) {
        ServerClient sc = new ServerClient("VALIDATE_CMD", "CHECK_UPDATE", null);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            StringBuffer sb = new StringBuffer();
            Iterator<AgentCard> it = agents.iterator();
            while (it.hasNext()) {
                AgentCard ac = it.next();
                String agentID = ac.getAgentID();
                sb.append(agentID);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            ServerClient sc2 = new ServerClient(this.m_action, sb.toString(), al.toArray(new String[0]));
            Repository.getJobManager().schedule(sc2);
        } else {
            for (AgentCard ac : agents) {
                String agentID = ac.getAgentID();
                ServerClient sc2 = new ServerClient(this.m_action, agentID, al.toArray(new String[0]));
                Repository.getJobManager().schedule(sc2);
            }
        }
        if (this.m_treeViewer != null) {
            this.m_treeViewer.setSelection(null);
        }
    }
}

