/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.NodeGroupTreeDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AssignToNodeGroups
extends AssignToNodeAction {
    private static final String ASSIGN_TO_NODE_GROUP = " Assign to Node Group";

    @Override
    public void run() {
        String IDs = "";
        Shell shell = Display.getCurrent().getActiveShell();
        NodeGroupTreeDialog dialog = new NodeGroupTreeDialog(shell, "", false);
        dialog.setBlockOnOpen(true);
        try {
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                IDs = dialog.getSelectionOIDsSeparatedByComma();
            } else {
                dialog.getReturnCode();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObject gtol = (GroupTreeObject)this.m_elements.get(i);
            if (gtol != null) {
                String type = gtol.getTreeObject().getType();
                if (type == null || type.equals("")) {
                    RTLogger.print(5, "type is null for element" + gtol);
                } else {
                    al.add(type);
                    String name = gtol.getName();
                    if (name == null || name.equals("")) {
                        RTLogger.print(5, "name is null for element" + gtol);
                        al.remove(al.size() - 1);
                    } else {
                        al.add(name);
                    }
                }
            }
            ++i;
        }
        ServerClient sc = new ServerClient("VALIDATE_CMD", "CHECK_UPDATE", null);
        sc.runInUIThread(null);
        if (!sc.isSuccess()) {
            new ShowMessageBox("Error", "Old Server does not support Node Groups assignments!", 1);
            return;
        }
        ServerClient sc2 = new ServerClient(this.m_action, IDs, al.toArray(new String[0]));
        Repository.getJobManager().schedule(sc2);
        if (this.m_treeViewer != null) {
            this.m_treeViewer.setSelection(null);
        }
    }

    public AssignToNodeGroups(List<GroupTreeObject> elements, String action, AgentCard ac) {
        super(elements, action, ac);
    }

    public AssignToNodeGroups(String polName, String polType, String action) {
        super(polName, polType, action);
    }

    public AssignToNodeGroups(StructuredViewer treeViewer, String action, AgentCard ac) {
        super(treeViewer, action, ac);
    }

    public AssignToNodeGroups(TableViewer tableViewer, String action) {
        super(tableViewer, action);
    }

    public AssignToNodeGroups(TreeViewer treeViewer, String action) {
        super(treeViewer, action);
    }

    @Override
    protected void setTitleAndID() {
        if (this.m_action.equals("DEPLOY")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("(NG) Re-Deploy");
                this.setId("deployNG");
                this.m_title = " Deploy";
            } else {
                this.setText("(NG) Deploy on ...");
                this.setId("deployonNG");
                this.m_title = " Deploy on ...";
            }
        } else if (this.m_action.equals("DEPLOY_DELAYED")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("(NG) Enqueue Deployment");
                this.setId("deployDelayedNG");
                this.m_title = " Enqueue Deployment";
            } else {
                this.setText("(NG) Enqueue Deployment on ...");
                this.setId("deployDelayedNG");
                this.m_title = " Enqueue Deployment on ...";
            }
        } else if (this.m_action.equals("UNDEPLOY")) {
            if (this.m_type != null && this.m_type.equals("Packages")) {
                this.setText("(NG) Mark as UnDeploy from ...");
                this.setId("undeployVirtualNG");
                this.m_title = " Mark as UnDeploy from ...";
            }
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("(NG) UnDeploy");
                this.setId("undeployNG");
                this.m_title = " UnDeploy";
            } else {
                this.setText("(NG) UnDeploy from ...");
                this.setId("undeployNG");
                this.m_title = " UnDeploy from ...";
            }
        } else if (this.m_action.equals("UNDEPLOY_DELAYED")) {
            if (this.m_type != null && this.m_type.equals(AGENTS)) {
                this.setText("(NG) Enqueue UnDeployment");
                this.setId("undeployDelayedNG");
                this.m_title = " Enqueue UnDeployment";
            } else {
                this.setText("(NG) Enqueue UnDeployment from ...");
                this.setId("undeployDelayedNG");
                this.m_title = " Enqueue UnDeployment from ...";
            }
        } else if (this.m_action.equals("DEPLOY_VIRTUAL")) {
            this.setText("(NG) Mark as Deployed on ...");
            this.setId("deployVirtualNG");
            this.m_title = " Mark as Deployed on ...";
        }
    }
}

