/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.ctrl.sc.in.ScGetJson;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.ISharedImages;

public class CancelDeploymentAction
extends Action {
    private StructuredSelection m_sel = null;
    private String m_tableType = null;

    public CancelDeploymentAction(TableViewer tv) {
        super("cancelselecteddeploymentsAction");
        this.setId("CancelSelectedDeploymentsAction");
        this.setText("Cancel selected Deployment");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        if (Repository.getInstance().getRights(1008) < 3 || tv == null) {
            this.setEnabled(false);
            return;
        }
        this.m_tableType = (String)tv.getData(AssignmentsSummaryView.VIEWER_TYPE);
        this.m_sel = (StructuredSelection)tv.getSelection();
        if (this.m_sel == null || this.m_sel.isEmpty()) {
            this.setEnabled(false);
        } else if (this.m_sel.size() > 1) {
            this.setText("Cancel selected Deployments");
        }
    }

    public void run() {
        if (!this.isEnabled() || this.m_sel == null || this.m_sel.isEmpty() || this.m_tableType == null) {
            return;
        }
        if (this.m_tableType.equals(AssignmentsSummaryView.DEPLOYMENT_QUEUE_TABLE_VIEWER)) {
            LinkedList<String> selectedAssignments = new LinkedList<String>();
            for (Assignment asn : this.m_sel) {
                selectedAssignments.add(asn.getID());
            }
            if (selectedAssignments.size() > 0) {
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "cancel deployments for " + selectedAssignments);
                }
                ServerClient sc = ServerClient.cancelDelayedDeployments(selectedAssignments.toArray(new String[0]));
                Repository.getJobManager().schedule(sc);
            }
        } else if (this.m_tableType.equals(AssignmentsSummaryView.DEPLOYMENTS_RUNNING_TABLE_VIEWER)) {
            ConcurrentHashMapMap<String, String> ids = new ConcurrentHashMapMap<String, String>();
            List objects = this.m_sel.toList();
            for (Object o : objects) {
                if (!(o instanceof DeploymentStatus)) continue;
                ids.putV("id", ((DeploymentStatus)o).getID());
            }
            ScGetJson sc = new ScGetJson(Repository.getInstance(), "/json/canceldc", ids);
            sc.start();
        }
    }
}

