/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.User;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class ChangeUserStatus
extends Action {
    private TreeViewer m_treeViewer = null;
    private User m_user = null;
    private List<User> m_users = null;
    private int m_status = 0;
    private GroupTreeObjectLast m_gtoLast = null;

    public ChangeUserStatus(TreeViewer treeViewer, GroupTreeObjectLast gtoLast) {
        super("ChangeUserStatus");
        Object o;
        this.setId("ChangeUserStatus");
        this.m_treeViewer = treeViewer;
        this.m_gtoLast = gtoLast;
        if (gtoLast != null && (o = gtoLast.getTreeObject().getObject()) instanceof UserTreeObject) {
            this.m_user = ((UserTreeObject)o).getUserObject();
            if (this.m_user != null) {
                if (this.m_user.m_active == 1) {
                    this.setText("Disable User");
                } else {
                    this.setText("Enable User");
                }
            }
        }
        if (Repository.getInstance().getRights(1004) < 3 || this.m_treeViewer == null || this.m_gtoLast == null) {
            this.setEnabled(false);
        }
    }

    public ChangeUserStatus(TreeViewer treeViewer, List<User> users, int status) {
        super("ChangeUsersStatus");
        this.setId("ChangeUsersStatus");
        this.m_treeViewer = treeViewer;
        this.m_status = status;
        this.m_users = users;
        if (this.m_status == 0) {
            this.setText("Disable Users");
        } else {
            this.setText("Enable Users");
        }
        if (Repository.getInstance().getRights(1004) < 3 || this.m_treeViewer == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_gtoLast != null && this.m_gtoLast.getName().trim().equals(UserManager.ADMIN)) {
            MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"The Admin cannot be disabled!");
        } else if (this.m_users != null) {
            int i = 0;
            while (i < this.m_users.size()) {
                User u = this.m_users.get(i);
                u.m_active = this.m_status;
                ++i;
            }
            Repository.getInstance().getUserManager().saveUsers(this.m_users);
        } else {
            this.m_user.m_active = this.m_user.m_active == 1 ? 0 : 1;
            Repository.getInstance().getUserManager().saveUser(this.m_user);
        }
    }
}

