/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ui.PlatformUI;

public class CheckUpdateAction
extends Action {
    private Dialog m_w = null;

    public CheckUpdateAction(Dialog w) {
        super("CheckUpdate");
        this.setText("Check new version of the BOOM server");
        this.setId("CheckUpdateGUI");
        this.m_w = w;
    }

    public void run() {
        if (Repository.m_pluginFile == null) {
            Repository.m_pluginFile = new File(".");
        }
        if (Repository.m_pluginFile != null) {
            ServerClient sc = new ServerClient("PROCESS_UPDATE", null, null);
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                try {
                    if (!Repository.m_pluginFile.delete()) {
                        Repository.m_pluginFile.deleteOnExit();
                    }
                }
                catch (Throwable throwable) {
                    Repository.m_pluginFile.deleteOnExit();
                }
                new ShowMessageBox("Update OK", "Update successfuly finished. The UI will be now restarted", 32);
                if (this.m_w != null) {
                    this.m_w.close();
                }
                PlatformUI.getWorkbench().restart();
            } else {
                new ShowMessageBox("Update failed", "Update impossible. Failed to retrieve new GUI file", 1);
            }
        } else {
            new ShowMessageBox("Update failed", "Update impossible. Can't find BOOM GUI location", 1);
        }
    }
}

