/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class ClipboardAgents
extends Action {
    StructuredSelection m_sel = null;

    public ClipboardAgents(String name, StructuredSelection sel) {
        super(name);
        this.m_sel = sel;
        if (sel == null || sel.size() == 0) {
            this.setEnabled(false);
        } else {
            this.setAccelerator(262211);
        }
        try {
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }
        catch (Throwable throwable) {}
    }

    public void run() {
        StringBuilder sb = new StringBuilder();
        Object obj = this.m_sel.getFirstElement();
        if (obj instanceof AgentCard) {
            Iterator it = this.m_sel.iterator();
            while (it.hasNext()) {
                try {
                    AgentCard ac = (AgentCard)it.next();
                    if ("10000000-0000-0000-0000-000000000000".equals(ac.getAgentID()) || AgentOverviewTableProvider.getOS(ac).startsWith("Requesting Agents")) continue;
                    sb.append('\"').append(ac.isOnline() ? "Up" : "Down").append('\"').append('\t');
                    sb.append('\"').append(ac.getLabel()).append('\"').append('\t');
                    sb.append('\"').append(AgentOverviewTableProvider.getOS(ac)).append('\"').append('\t');
                    sb.append('\"').append(ac.isDisabled() ? "Disabled" : "Enabled").append('\"').append('\t');
                    sb.append('\"').append(BMUI.getMaxSeverityString(ac)).append('\"').append('\t');
                    sb.append('\"').append(Repository.getInstance().getAgentVersion(ac.getID())).append('\"').append('\t');
                    sb.append('\"').append(ac.getAgentIP()).append('\"').append('\t');
                    sb.append('\"').append(ac.getAgentPort()).append('\"').append('\t');
                    sb.append('\"').append(AgentOverviewTableProvider.getTransport(ac)).append('\"').append('\t');
                    sb.append('\"').append(ac.getAgentHost()).append('\"').append('\t');
                    sb.append('\"').append(ac.getRelatedNodeGroupsList().size()).append('\"').append('\t');
                    sb.append('\"').append(AgentOverviewTableProvider.getLastMessage(ac)).append('\"').append('\t');
                    sb.append('\"').append(ac.getRelatedServer() == null ? "" : ac.getRelatedServer()).append('\"').append('\t');
                    sb.append('\"').append(ac.getAgentID()).append('\"');
                    if (!it.hasNext()) continue;
                    sb.append(String.format("%n", null));
                }
                catch (Throwable throwable) {}
            }
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
            clipboard.dispose();
        }
    }
}

