/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class CopyGroupTreeObjectAction
extends Action {
    private GroupTreeObject m_gto = null;
    TreeViewer m_treeViewer = null;
    private String m_treeType = null;

    public CopyGroupTreeObjectAction(TreeViewer treeViewer, GroupTreeObject gto, String treeType) {
        super("CopyGroup");
        this.setId("copy_GroupTreeObject");
        this.setText("Copy Group");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_treeType = treeType;
        if (this.m_treeType.equals(BMUI.type_tree_policy) || this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            if (Repository.getInstance().getRights(1008) < 3) {
                this.setEnabled(false);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_action) && Repository.getInstance().getRights(1007) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        InputDialog id = new InputDialog(this.m_treeViewer.getControl().getShell(), "Copy Tree Group", "Please enter a Group Name", "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            if (this.m_gto.getParent().getChild(id.getValue(), this.m_gto.getType()) != null) {
                MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"A Group with this name already exists!\nPlease enter a different name.");
                this.run();
            } else {
                boolean isSuccess = false;
                String treePath = this.m_gto.getPath();
                UpdateServer usrv = new UpdateServer();
                if (!this.m_treeType.equals(BMUI.type_tree_policy) && !this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
                    if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
                        if (!this.m_gto.getType().equals(BMUI.type_toplevel) && !this.m_gto.getType().equals(BMUI.type_assignment_pol)) {
                            isSuccess = usrv.syncAsnWithServer(treePath, id.getValue(), CMDS.ACTION_COPY, this.m_gto.getType());
                        }
                    } else {
                        this.m_treeType.equals(BMUI.type_tree_action);
                    }
                }
                if (isSuccess) {
                    this.m_treeViewer.refresh();
                    this.m_treeViewer.setExpandedState((Object)this.m_gto.getParent(), true);
                } else {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                }
            }
        }
    }
}

