/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.editors.OpenFileAction;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.FileDialog;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;

public class CreateFileAction
extends Action {
    public String m_path = null;
    public BinariesListView m_v = null;
    private GroupTreeObject m_gto = null;
    public String m_fileName = null;

    public CreateFileAction(String path, GroupTreeObject gto) {
        this.setText("Create File");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJ_FILE"));
        this.m_path = "srv/packages" + path;
        this.m_gto = gto;
        if (Repository.getInstance().getRights(1006) < 3 || path == null || gto == null) {
            this.setEnabled(false);
        }
    }

    private void run(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_fileName = name;
        this.run();
    }

    public void run() {
        String name;
        FileDialog id = new FileDialog(Display.getCurrent().getActiveShell(), "Create new file", "Please enter a file name: ", null, this.m_fileName, new NameValidatorFile());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0 && (name = id.getValue()) != null && name.length() > 0) {
            GroupTreeObject gto = this.m_gto.getFirstChild(name);
            if (gto != null) {
                new ShowMessageBox(" Add File", "File name does already exist!", 2);
                this.run(name);
            } else {
                String path = String.valueOf(this.m_path) + "/" + name;
                ServerClient sc = ServerClient.createFile(path);
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    GroupTreeObjectLast gtol;
                    RTLogger.print(5, "File created. " + path);
                    BinariesListView.getInstance().refreshTree(true);
                    GroupTreeObject root = Repository.getInstance().getBinaryTree();
                    GroupTreeObject parent = root.searchPath(this.m_gto.getPath(), this.m_gto.getType());
                    if (parent != null && (gtol = parent.findElement(name, BMUI.type_file)) != null) {
                        OpenFileAction openFileAction = new OpenFileAction(BinariesListView.m_blv.getSite().getWorkbenchWindow(), gtol);
                        openFileAction.run();
                        Repository.getInstance().setBinariesTreeSelection(gtol);
                    }
                } else {
                    RTLogger.print(5, "Error creating file: " + path);
                }
            }
        }
    }
}

