/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CreateFolderAction
extends Action {
    public String m_path = null;
    public BinariesListView m_v = null;
    private String m_title = null;
    private GroupTreeObject m_gto = null;
    private String m_type = null;
    private static String PACKAGE = "PACKAGE";
    private static String FOLDER = "FOLDER";

    public CreateFolderAction(StructuredSelection ssel, String path, String text, GroupTreeObject gto) {
        this.m_path = "srv/packages" + path;
        this.m_title = text;
        this.m_gto = gto;
        this.setText(this.m_title);
        if (path.length() == 0) {
            this.m_type = PACKAGE;
            this.setImageDescriptor(BMUI.IMAGE_DESCR_PKG);
        } else {
            this.m_type = FOLDER;
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FOLDER_DEFAULT);
        }
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        } else if (ssel.size() > 1) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.run("");
    }

    public void run(String initValue) {
        InputDialog id = new InputDialog(Display.getCurrent().getActiveShell(), "   " + this.m_title, "Please enter a name:", initValue, (IInputValidator)new NameValidatorFile());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            NameValidatorFile validator = new NameValidatorFile();
            String newName = id.getValue().trim();
            if (newName.length() == 0) {
                new ShowMessageBox("Invalid Folder Name", "Invalid Folder Name!\nPlease enter a different name.", 1);
                this.run();
            } else if (this.m_type.equals(PACKAGE) && validator.isValid(newName) != null) {
                new ShowMessageBox("  Invalid Characters", validator.isValid(newName), 1);
                this.run(newName);
            } else if (this.m_type.equals(FOLDER) && validator.isValid(newName) != null) {
                new ShowMessageBox("  Invalid Characters", validator.isValid(newName), 1);
                this.run(newName);
            } else if (this.m_gto.getFirstChild(newName) != null) {
                new ShowMessageBox("Invalid Folder Name", "A folder with this name does already exist!\nPlease enter a different name.", 1);
                this.run(newName);
            } else {
                String path = String.valueOf(this.m_path) + "/" + newName;
                ServerClient sc = ServerClient.createFolder(path);
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    if (path.length() == 0) {
                        RTLogger.print(5, "Binary Package created: " + path);
                    } else {
                        RTLogger.print(5, "Folder created: " + path);
                    }
                    BinariesListView.getInstance().refreshTree(true);
                } else if (path.length() == 0) {
                    RTLogger.print(5, "Error creating Binary Package: " + path);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error creating Binary Package: " + path + "\n" + sc.getResultObject()));
                    this.run();
                } else {
                    RTLogger.print(5, "Error creating Folder: " + path);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error creating Folder: " + path + "\n" + sc.getResultObject()));
                    this.run();
                }
            }
        }
    }
}

