/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class CutGroupTreeObjectAction
extends Action {
    private GroupTreeObject m_gto = null;
    private TreeViewer m_treeViewer = null;
    private String m_treeType = null;
    private ArrayList<GroupTreeObject> m_elements = new ArrayList();

    public CutGroupTreeObjectAction(TreeViewer treeViewer, GroupTreeObject gto, String treeType) {
        super("CutGroup");
        this.setText("Delete Group");
        this.setId("cut_GroupTreeObject");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_treeType = treeType;
        if (this.m_treeType == null || this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
                return;
            }
            for (GroupTreeObject g : this.m_elements) {
                if (PolicyManager.getInstance().isPermittedPolicyModifyRecursive(g)) continue;
                this.setEnabled(false);
                return;
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            if (Repository.getInstance().getRights(1008) < 3) {
                this.setEnabled(false);
                return;
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_action) && (Repository.getInstance().getRights(1007) < 3 || Repository.getInstance().getRights(gto.getName()) < 3)) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (sel != null && !sel.isEmpty()) {
            this.m_elements.ensureCapacity(sel.size());
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObject) || selected instanceof GroupTreeObjectLast) continue;
                GroupTreeObject g = (GroupTreeObject)selected;
                this.m_elements.add(g);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Delete Groups");
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String title = "";
        String header = "";
        String footer = "";
        String noElementsText = "Nothing to delete!";
        if (this.m_treeType.equals(BMUI.type_tree_policy)) {
            header = "Please note: The deletion of a Policy Group will move all Group Elements \none level up. ";
            noElementsText = "No Policy Groups to delete!";
        } else if (this.m_treeType.equals(BMUI.type_tree_action)) {
            header = "Please note: The deletion of an Action Group will also delete all Group\nElements. ";
            noElementsText = "No Action Groups to delete!";
        }
        if (this.m_elements.size() == 1) {
            title = "  Delete Group";
            header = String.valueOf(header) + "Do you want to delete the following Group:";
            footer = "1 Group to delete!";
        } else {
            title = "  Delete Groups";
            header = String.valueOf(header) + "Do you want to delete the following Groups:";
            footer = String.valueOf(this.m_elements.size()) + " Groups to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            this.m_treeType.equals(BMUI.type_tree_action);
            if (this.m_elements.size() == 0) {
                this.processOnServer(this.m_gto);
            } else {
                int i = 0;
                while (i < this.m_elements.size()) {
                    GroupTreeObject gto = this.m_elements.get(i);
                    this.processOnServer(gto);
                    ++i;
                }
            }
            this.m_treeViewer.refresh();
            if (!this.m_treeType.equals(BMUI.type_tree_action) && !this.m_treeType.equals(BMUI.type_tree_action)) {
                Repository.getInstance().fetchAssignments(true);
            }
        }
    }

    private boolean processOnServer(GroupTreeObject gto) {
        boolean isSuccess = false;
        String treePath = gto.getPath();
        UpdateServer usrv = new UpdateServer();
        if (this.m_treeType.equals(BMUI.type_tree_policy)) {
            isSuccess = usrv.syncWithServer(treePath, "nonrecursive", CMDS.ACTION_DEL, gto.getType());
        } else if (this.m_treeType.equals(BMUI.type_tree_action)) {
            String[] arr = new String[]{gto.getName()};
            isSuccess = usrv.syncWithActionServer(CMDS.ACTION_DEL, arr);
        }
        if (isSuccess) {
            if (!this.m_treeType.equals(BMUI.type_tree_action)) {
                GroupTreeObject parent = gto.getParent();
                List<GroupTreeObject> children = gto.getElements();
                parent.addElements(children);
                parent.removeElement(gto);
            }
        } else {
            new ShowMessageBox("Delete Group", "The group '" + gto.getName() + "' has not been deleted! \nPossible name confict!", 1);
        }
        return isSuccess;
    }
}

