/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteActionAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();

    public DeleteActionAction(TreeViewer treeViewer) {
        super("DeleteActionAction");
        this.setText("Delete Action");
        this.setId("deleteAction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1007) < 3 || treeViewer == null) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (sel != null && !sel.isEmpty()) {
            this.m_elements.ensureCapacity(sel.size());
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                if (Repository.getInstance().getRights(gtol.getParent().getName()) != 3) continue;
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Delete Actions");
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String header = "";
        String footer = "";
        String actions = "";
        String title = "";
        String noElementsText = "No Actions to delete!";
        if (this.m_elements.size() == 1) {
            title = "   Delete Action";
            header = "Do you want to delete the following Action:";
            footer = "1 Action to delete!";
        } else if (this.m_elements.size() > 1) {
            title = "   Delete Actions";
            header = "Do you want to delete the following Actions:";
            footer = String.valueOf(this.m_elements.size()) + " Actions to delete!";
        }
        int i = 0;
        while (i < this.m_elements.size()) {
            actions = String.valueOf(actions) + this.m_elements.get(i).getName() + "\n";
            ++i;
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            try {
                this.processOnServer();
                Object[] expanded = this.m_treeViewer.getExpandedElements();
                this.m_treeViewer.refresh();
                int index = 0;
                while (index < expanded.length) {
                    this.m_treeViewer.setExpandedState(expanded[index], true);
                    ++index;
                }
            }
            catch (RuntimeException e) {
                RTLogger.print(5, "", e);
            }
        }
    }

    private boolean processOnServer() {
        boolean isSuccess = false;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        UpdateServer usrv = new UpdateServer();
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObjectLast gtol = this.m_elements.get(i);
            if (gtol instanceof GroupTreeObjectUnsubmitted) {
                this.removeUnsubmittedGTOL(gtol);
            } else {
                com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
                ActionView.closeActionTab(action);
                String[] arr = new String[]{action.m_ID};
                isSuccess = usrv.syncWithActionServer(scBatch, UpdateServer.ACTION_DELACTION, arr);
                if (isSuccess) {
                    gtol.getParent().removeElement(gtol);
                    ActionView.closeActionTab(action);
                } else {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error deleting Action", (String)usrv.m_resultString);
                }
            }
            ++i;
        }
        scBatch.close();
        return isSuccess;
    }

    private void removeUnsubmittedGTOL(GroupTreeObjectLast gtol) {
        com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
        CTabItem tab = ActionView.getTab(action.m_ID);
        if (tab != null && !tab.isDisposed() && tab instanceof ActionTab) {
            ActionTab aTab = (ActionTab)tab;
            aTab.setDirty(false);
            aTab.dispose();
        }
        gtol.getParent().removeElement(gtol);
    }
}

