/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AgentTab;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScJobDeleteAgents;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteAgentAction
extends Action {
    private AgentTab m_agentTab = null;
    private TreeViewer m_tv = null;
    private ArrayList<AbstractAgentCard> m_selectedAgents = null;
    private ArrayList<GroupTreeObjectLast> m_selected_gtol = null;
    private String m_agents = "";
    private static int MAX = 1000;

    public DeleteAgentAction(TreeViewer viewer, AgentCard ac, AgentTab aTab) {
        super("DeleteAgent");
        this.setText("Delete Agent");
        this.setId("DeleteAgent");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_tv = viewer;
        this.m_agentTab = aTab;
        if (this.m_tv == null || ac == null || !Repository.getInstance().isPermittedAgentModify(ac)) {
            this.setEnabled(false);
        } else {
            this.m_selectedAgents = new ArrayList();
            if (this.m_tv == null && ac != null) {
                if (this.isSelectable(ac)) {
                    this.m_selectedAgents.add(ac);
                }
            } else if (this.m_tv != null) {
                this.m_selectedAgents = this.collectSelectedAgent();
            }
            if (this.m_selectedAgents.size() > 1) {
                this.setText("Delete Agents");
            }
            if (this.m_selectedAgents.size() == 0 || this.m_selectedAgents.size() > MAX) {
                this.setEnabled(false);
            }
        }
    }

    public DeleteAgentAction(TableViewer viewer) {
        super("DeleteAgent");
        this.setText("Delete Agent");
        this.setId("DeleteAgent");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        if (viewer == null) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection ssel = (StructuredSelection)viewer.getSelection();
        this.m_selectedAgents = new ArrayList(ssel.size());
        if (!ssel.isEmpty()) {
            for (Object o : ssel) {
                AgentCard ac;
                if (!(o instanceof AgentCard) || !this.isSelectable(ac = (AgentCard)o) || !Repository.getInstance().isPermittedAgentModify(ac)) continue;
                this.m_selectedAgents.add(ac);
            }
        }
        if (this.m_selectedAgents.size() > 1) {
            this.setText("Delete Agents");
        }
        if (this.m_selectedAgents.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_selectedAgents == null) {
            return;
        }
        String header = "";
        String footer = "";
        String title = "";
        String noElementText = "No Agents to delete";
        if (this.m_selectedAgents.size() == 1) {
            title = "   Delete Agent";
            header = "Do you want to delete the following Agent:";
            footer = "1 Agent to delete!";
        } else if (this.m_selectedAgents.size() > 1) {
            title = "   Delete Agents";
            header = "Do you want to delete the following Agents:";
            footer = String.valueOf(this.m_selectedAgents.size()) + " Agents to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_selectedAgents, noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            String[] IDs = new String[this.m_selectedAgents.size()];
            int i = 0;
            while (i < this.m_selectedAgents.size()) {
                AgentCard ac = (AgentCard)this.m_selectedAgents.get(i);
                IDs[i] = ac.getAgentID();
                RTLogger.print(5, "delete " + ac.getAgentID());
                if (this.m_agentTab != null) {
                    this.m_agentTab.dispose();
                } else {
                    CTabItem[] items = AgentCardView.getInstance().getFolder().getItems();
                    int count = 0;
                    while (count < items.length) {
                        AgentTab aTab;
                        if (items[count] instanceof AgentTab && ((AgentCard)(aTab = (AgentTab)items[count]).getData()).equals(ac)) {
                            aTab.dispose();
                        }
                        ++count;
                    }
                }
                ++i;
            }
            ScJobDeleteAgents scv4 = new ScJobDeleteAgents(Repository.getInstance(), IDs);
            scv4.addCmdPostProcess(new ICmdPostProcess(){

                public void postProcess(final ServerClient sc) {
                    if (!sc.isSuccess()) {
                        UIJob uj = new UIJob("Error deleting Agents"){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                new ShowMessageBox("Error", "" + sc.getResultObject(), 1);
                                return null;
                            }
                        };
                        Repository.getUIJobManager().schedule(uj);
                    }
                }
            });
            Repository.getJobManager().schedule(scv4);
        }
    }

    public ArrayList<AbstractAgentCard> collectSelectedAgent() {
        ArrayList<AbstractAgentCard> selectedAgents = new ArrayList<AbstractAgentCard>();
        ArrayList<GroupTreeObject> parentList = new ArrayList<GroupTreeObject>();
        ArrayList<GroupTreeObject> selectedGTOs = new ArrayList<GroupTreeObject>();
        this.m_selected_gtol = new ArrayList();
        StructuredSelection sel = (StructuredSelection)this.m_tv.getSelection();
        for (Object o : sel) {
            if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                AgentCard ac = (AgentCard)gtoLast.getTreeObject().getObject();
                if (ac == null) {
                    ac = Repository.getInstance().getAgentCard(gtoLast.getLinkedPath());
                }
                if (ac == null || !this.isSelectable(ac)) continue;
                selectedAgents.add(ac);
                this.m_selected_gtol.add(gtoLast);
                if (ac.getLabel() != null && ac.getLabel().length() > 0) {
                    this.m_agents = String.valueOf(this.m_agents) + ac.getLabel() + " ";
                }
                this.m_agents = String.valueOf(this.m_agents) + "(" + ac.getAgentIP() + ")\n";
                if (selectedGTOs.contains(gtoLast.getParent())) continue;
                parentList.add(gtoLast.getParent());
                continue;
            }
            if (!(o instanceof GroupTreeObject)) continue;
            selectedGTOs.add((GroupTreeObject)o);
        }
        int i = 0;
        while (i < selectedGTOs.size()) {
            GroupTreeObject gto = (GroupTreeObject)selectedGTOs.get(i);
            if (!parentList.contains(gto)) {
                List<GroupTreeObjectLast> list = GroupTreeObject.collectElements(gto);
                int ii = 0;
                while (ii < list.size()) {
                    AgentCard ac = (AgentCard)list.get(ii).getTreeObject().getObject();
                    selectedAgents.add(ac);
                    this.m_selected_gtol.add(list.get(ii));
                    ++ii;
                }
            }
            ++i;
        }
        return selectedAgents;
    }

    private boolean isSelectable(AgentCard ac) {
        return !ac.isApproved() && ac.isExternal() || ac.isApproved();
    }
}

