/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.TriggerDeploymentDialog;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class DeleteBinaryAction
extends Action {
    private BinariesListView m_binListView = null;
    private TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObject> m_elements = new ArrayList();

    public DeleteBinaryAction(BinariesListView binListView, TreeViewer treeViewer) {
        super("deletebinary");
        this.setText("Delete Package");
        this.setId("deletebinary");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_binListView = binListView;
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        } else {
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (!sel.isEmpty()) {
                for (Object selected : sel) {
                    GroupTreeObject gto;
                    if (!(selected instanceof GroupTreeObject) || selected instanceof GroupTreeObjectLast || !(gto = (GroupTreeObject)selected).getType().equals(BMUI.type_assignment_bin)) continue;
                    this.m_elements.add(gto);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            } else if (this.m_elements.size() > 1) {
                this.setText("Delete Packages");
            }
        }
    }

    public void run() {
        String header = "";
        String footer = "";
        String title = "";
        String noElementsText = "No Packages to delete!";
        if (this.m_elements.size() == 1) {
            title = "   Delete Package";
            header = "Do you want to delete the following Packages:";
            footer = "1 Package to delete!";
        } else if (this.m_elements.size() > 1) {
            title = "   Delete Packages";
            header = "Do you want to delete the following Packages:";
            footer = String.valueOf(this.m_elements.size()) + " Packages to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            RTLogger.print(5, "Delete " + this.m_elements.size() + " Packages ...");
            int i = 0;
            while (i < this.m_elements.size()) {
                this.deleteBinary(this.m_elements.get(i));
                ++i;
            }
            this.m_treeViewer.refresh();
            Repository.getInstance().fetchAssignments(true);
            this.triggerUndeployment();
        }
    }

    public void deleteBinary(GroupTreeObject binaryGTO) {
        ServerClient sc = ServerClient.deleteFolder("./srv/packages/" + binaryGTO.getName());
        sc.start();
        sc.isSuccess();
        String filePath = "/srv/packages/" + binaryGTO.getName() + '/';
        IWorkbenchPage page = this.m_binListView.getViewSite().getWorkbenchWindow().getActivePage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorReference editorRef = editorRefs[i];
            try {
                IEditorInput input = editorRef.getEditorInput();
                String name = input.getName();
                if (name.contains(filePath)) {
                    page.closeEditor(editorRef.getEditor(false), false);
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
    }

    public void triggerUndeployment() {
        if (this.m_elements.size() > 0) {
            LinkedList<String> deletedBinaries = new LinkedList<String>();
            for (GroupTreeObject gto : this.m_elements) {
                StringBuffer sb = new StringBuffer();
                sb.append(gto.getName()).append('\u25ba').append(gto.getType());
                deletedBinaries.add(sb.toString());
            }
            TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Undeploy Deleted Packages");
            upd.setBlockOnOpen(true);
            upd.open();
            if (upd.getReturnCode() == 0) {
                ServerClient sc = null;
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "trigger deployments for " + deletedBinaries.size() + " binaries");
                }
                sc = ServerClient.triggerDelayedDeploymentsFiltered(deletedBinaries.toArray(new String[0]));
                Repository.getJobManager().schedule(sc);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }
}

