/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class DeleteFileAction
extends Action {
    private IWorkbenchWindow m_window = null;
    public ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();

    public DeleteFileAction(IWorkbenchWindow window, StructuredSelection ssel) {
        this.setText("Delete File");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_window = window;
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        } else {
            for (Object o : ssel) {
                if (!(o instanceof GroupTreeObjectLast)) continue;
                this.m_elements.add((GroupTreeObjectLast)o);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            } else if (this.m_elements.size() > 1) {
                this.setText("Delete Files");
            }
        }
    }

    public void run() {
        String title = "   Delete File";
        String header = "Do you want to delete the following file:";
        String footer = "1 file to delete!";
        String noElementsText = "No Files to delete!";
        if (this.m_elements.size() > 1) {
            title = "   Delete Files";
            header = "Do you want to delete the following files:";
            footer = String.valueOf(this.m_elements.size()) + " files to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            RTLogger.print(5, "Delete " + this.m_elements.size() + " files ...");
            int i = 0;
            while (i < this.m_elements.size()) {
                GroupTreeObjectLast gtol = this.m_elements.get(i);
                this.closeFileIfOpen(gtol);
                String path = gtol.getPath();
                path = path.replace("/root/Packages", "srv/packages");
                ServerClient sc = ServerClient.deleteFile(path);
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    RTLogger.print(5, "File deleted. " + path);
                } else {
                    RTLogger.print(5, "Error deleting file: " + path);
                }
                ++i;
            }
            BinariesListView.getInstance().refreshTree(true);
        }
    }

    private void closeFileIfOpen(GroupTreeObject gtol) {
        if (gtol == null) {
            return;
        }
        String treePath = gtol.getPath();
        treePath = treePath.replace("/root/Packages", "");
        String[] name_type_dir = new String[]{treePath, gtol.getTreeObject().getType(), Repository.getUserTmpDirectory()};
        ServerClient sc = ServerClient.getFile(name_type_dir);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            try {
                File file = (File)sc.getResultObject();
                String filePath = file.getCanonicalPath();
                filePath = filePath.replace("\\", "/");
                IWorkbenchPage page = this.m_window.getActivePage();
                IEditorReference[] editorRef = page.getEditorReferences();
                int i = 0;
                while (i < editorRef.length) {
                    IEditorReference ref = editorRef[i];
                    IEditorPart editor = ref.getEditor(false);
                    IEditorInput input = editor.getEditorInput();
                    if (input.getName().equals(filePath)) {
                        IEditorPart editor2Close = page.findEditor(input);
                        if (editor2Close != null) {
                            page.closeEditor(editor2Close, false);
                        }
                        return;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                RTLogger.print(5, "DeleteFileAction: error closing file in editor: ", e);
            }
        }
    }
}

