/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteFolderAction
extends Action {
    public BinariesListView m_v = null;
    private ArrayList<GroupTreeObject> m_elements = new ArrayList();

    public DeleteFolderAction(StructuredSelection ssel) {
        this.setText("Delete Folder");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        }
        for (Object o : ssel) {
            if (o instanceof GroupTreeObjectLast) {
                this.setEnabled(false);
                return;
            }
            GroupTreeObject folderGTO = (GroupTreeObject)o;
            if (folderGTO.getAllElements().size() > 0) {
                this.setEnabled(false);
                this.setText("Delete Folder (must be empty!)");
                return;
            }
            this.m_elements.add(folderGTO);
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.m_elements.size() > 1) {
            this.setText("Delete Folders");
        }
    }

    public void run() {
        String title = "  Delete Folder";
        String header = "Do you want to delete the following Folder:";
        String footer = "1 Folder to delete!";
        String noElementsText = "No Folders to delete!";
        if (this.m_elements.size() > 1) {
            title = "  Delete Folders";
            header = "Do you want to delete the following Folders:";
            footer = String.valueOf(this.m_elements.size()) + " Folders to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            RTLogger.print(5, "Delete " + this.m_elements.size() + " Binary Folders ...");
            int i = 0;
            while (i < this.m_elements.size()) {
                GroupTreeObject folderGTO = this.m_elements.get(i);
                String path = folderGTO.getPath();
                path = path.replace("/root/Packages", "srv/packages");
                ServerClient sc = ServerClient.deleteFolder(path);
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    RTLogger.print(5, "Binary Folder deleted: " + path);
                } else {
                    RTLogger.print(5, "Error deleting Binary Folder: " + path);
                }
                ++i;
            }
            BinariesListView.getInstance().refreshTree(true);
        }
    }
}

