/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.TriggerDeploymentDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteGroupTreeObjectAction
extends Action {
    TreeViewer m_treeViewer = null;
    private String m_treeType = null;
    private List<GroupTreeObject> m_elements = new ArrayList<GroupTreeObject>();
    private List<GroupTreeObject> m_elems4Deployment = new LinkedList<GroupTreeObject>();
    private List<String> m_assignmentsID = null;

    public DeleteGroupTreeObjectAction(TreeViewer treeViewer, String treeType) {
        super("DeleteGroup");
        this.setText("Delete Group Recursive");
        this.setId("delete_GroupTreeObject");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        this.m_treeType = treeType;
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (this.m_treeViewer == null || this.m_treeType == null || sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (this.m_treeType.equals(BMUI.type_tree_policy)) {
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObject) || selected instanceof GroupTreeObjectLast) continue;
                GroupTreeObject folder = (GroupTreeObject)selected;
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(folder);
                if (!permittedPolicyModify) continue;
                this.m_elements.add(folder);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObject) || selected instanceof GroupTreeObjectLast) continue;
                GroupTreeObject folder = (GroupTreeObject)selected;
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPGAModify(folder);
                if (!permittedPolicyModify) continue;
                this.m_elements.add(folder);
            }
        } else {
            this.setEnabled(false);
            return;
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Delete Groups Recursive");
        }
    }

    public void run() {
        String header = "Please note: The recursive deletion of a Group will also delete all elements \ninside that Group. ";
        String footer = "";
        String title = "";
        String noElementsText = "No Groups to delete!";
        if (this.m_elements.size() == 1) {
            title = "  Delete Group Recursive";
            header = String.valueOf(header) + "Do you want to delete the following Group:";
            footer = "1 Group to delete!";
        } else {
            title = "  Delete Groups Recursive";
            header = String.valueOf(header) + "Do you want to delete the following Groups:";
            footer = String.valueOf(this.m_elements.size()) + " Groups to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            HashMap<String, String> processed = new HashMap<String, String>();
            ServerClientBatch scBatch = new ServerClientBatch("BATCH");
            ProgressDialog pdTOP = new ProgressDialog(title, "", 0, this.m_elements.size() + 2);
            pdTOP.setBlockOnOpen(false);
            pdTOP.open();
            boolean isDeleteAndUndeploySupported = false;
            try {
                scBatch.openSocket();
                scBatch.setCommand("VALIDATE_CMD", CMDS.ACTION_DEL_and_UNDEPLOY, new String[0]);
                scBatch.runBatch();
                isDeleteAndUndeploySupported = scBatch.isSuccess();
                UpdateServer usrv = new UpdateServer();
                int i = 0;
                while (i < this.m_elements.size()) {
                    GroupTreeObject gto = this.m_elements.get(i);
                    pdTOP.setProgress("Delete " + gto.getName(), i + 1);
                    Iterator it = processed.keySet().iterator();
                    boolean skip = false;
                    while (it.hasNext()) {
                        String pathProcessed = (String)it.next();
                        if (!gto.getPath().startsWith(String.valueOf(pathProcessed) + "/")) continue;
                        skip = true;
                        break;
                    }
                    if (!skip) {
                        this.processOnServer(usrv, scBatch, gto, isDeleteAndUndeploySupported);
                        processed.put(gto.getPath(), "");
                    }
                    ++i;
                }
                Object[] expanded1 = this.m_treeViewer.getExpandedElements();
                this.m_treeViewer.refresh();
                int index = 0;
                while (index < expanded1.length) {
                    this.m_treeViewer.setExpandedState(expanded1[index], true);
                    ++index;
                }
                pdTOP.setProgress("Refresh ", this.m_elements.size());
                Repository.getInstance().fetchAssignments(true);
                if (!isDeleteAndUndeploySupported) {
                    this.triggerUndeployment();
                }
            }
            catch (Throwable throwable) {
                try {
                    scBatch.close();
                }
                catch (Throwable throwable2) {}
                try {
                    pdTOP.close();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                scBatch.close();
            }
            catch (Throwable throwable) {}
            try {
                pdTOP.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean processOnServer(UpdateServer usrv, ServerClientBatch scBatch, GroupTreeObject gto, boolean isDelAndUndeploySupported) {
        List<GroupTreeObject> elements;
        boolean isSuccess = false;
        String treePath = gto.getPath();
        if (isDelAndUndeploySupported) {
            TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Undeploy Deleted Elements");
            upd.setBlockOnOpen(true);
            upd.open();
            if (upd.getReturnCode() == 0) {
                this.m_elems4Deployment.clear();
            } else {
                isDelAndUndeploySupported = false;
            }
        }
        if (this.m_treeType.equals(BMUI.type_tree_policy)) {
            elements = gto.getAllElements();
            this.collectElements4Deployment(elements);
            isSuccess = usrv.syncWithServer(scBatch, treePath, "recursive", isDelAndUndeploySupported ? CMDS.ACTION_DEL_and_UNDEPLOY : CMDS.ACTION_DEL, gto.getType());
            this.checkIfAsnIDsReturned(usrv, isSuccess);
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            elements = gto.getAllElements();
            elements.add(gto);
            this.collectElements4Deployment(elements);
            isSuccess = usrv.syncAsnWithServer(scBatch, treePath, "recursive", isDelAndUndeploySupported ? CMDS.ACTION_DEL_and_UNDEPLOY : CMDS.ACTION_DEL, gto.getType());
            this.checkIfAsnIDsReturned(usrv, isSuccess);
        }
        if (isSuccess) {
            gto.getParent().removeElement(gto);
            if (this.m_treeType.equals(BMUI.type_tree_policy)) {
                List<GroupTreeObjectLast> al = GroupTreeObject.collectElements(gto);
                for (GroupTreeObjectLast gtol : al) {
                    PolicyView.closeTab(gtol.getName());
                }
            }
        } else {
            MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
        }
        return isSuccess;
    }

    private void checkIfAsnIDsReturned(UpdateServer usrv, boolean isSuccess) {
        String res;
        if (isSuccess && (res = usrv.m_resultString).indexOf(10) != -1) {
            String[] arr;
            String[] stringArray = arr = res.split("\n");
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (this.m_assignmentsID == null) {
                    this.m_assignmentsID = new ArrayList<String>(arr.length);
                }
                if (id.length() > 30) {
                    this.m_assignmentsID.add(id);
                }
                ++n2;
            }
        }
    }

    private void collectElements4Deployment(List<GroupTreeObject> elements) {
        if (elements == null) {
            return;
        }
        for (GroupTreeObject gto : elements) {
            if (gto instanceof GroupTreeObjectUnsubmitted) {
                GroupTreeObjectUnsubmitted gtolU = (GroupTreeObjectUnsubmitted)gto;
                this.removeUnsubmittedGTOL(gtolU);
                continue;
            }
            if (!gto.getType().equals(BMUI.type_mon) && !gto.getType().equals(BMUI.type_msg) && !gto.getType().equals(BMUI.type_assignment_pol) && !gto.getType().equals(BMUI.type_assignment_bin)) continue;
            this.m_elems4Deployment.add(gto);
        }
    }

    public void triggerUndeployment() {
        if (this.m_elems4Deployment.size() > 0 || this.m_assignmentsID != null) {
            TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Undeploy Deleted Elements");
            upd.setBlockOnOpen(true);
            upd.open();
            if (upd.getReturnCode() == 0) {
                List<Object> deletedElements = new LinkedList();
                if (this.m_assignmentsID == null) {
                    for (GroupTreeObject gto : this.m_elems4Deployment) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(gto.getName()).append('\u25ba').append(gto.getType());
                        deletedElements.add(sb.toString());
                    }
                } else {
                    deletedElements = this.m_assignmentsID;
                }
                ServerClient sc = null;
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "trigger deployments for " + deletedElements.size() + " elements");
                }
                sc = ServerClient.triggerDelayedDeploymentsFiltered(deletedElements.toArray(new String[0]));
                Repository.getJobManager().schedule(sc);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }

    private void removeUnsubmittedGTOL(GroupTreeObjectLast gtol) {
        CTabItem tab = PolicyView.getTab(gtol.getName());
        if (tab != null && !tab.isDisposed()) {
            if (tab instanceof MonitorPolicyTab) {
                MonitorPolicyTab mTab = (MonitorPolicyTab)tab;
                mTab.setDirty(false);
                mTab.dispose();
            } else if (tab instanceof FilterPolicyTab) {
                FilterPolicyTab fTab = (FilterPolicyTab)tab;
                fTab.setDirty(false);
                fTab.dispose();
            }
        }
        try {
            gtol.getParent().removeElement(gtol);
        }
        catch (Throwable throwable) {}
    }
}

