/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.TriggerDeploymentDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteLink
extends Action {
    private List<GroupTreeObjectLast> m_elements = new ArrayList<GroupTreeObjectLast>();
    private TreeViewer m_treeViewer = null;

    public DeleteLink(TreeViewer treeViewer) {
        super("DeleteLink");
        this.setText("Delete Link");
        this.setId("delete_Link");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1008) < 3) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (sel.size() > 0) {
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPGAModify(gtol);
                this.setEnabled(permittedPolicyModify);
                if (!permittedPolicyModify) {
                    return;
                }
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.m_elements.size() > 1) {
            this.setText("Delete Links");
        }
    }

    public void run() {
        block12: {
            try {
                String dialogTitle = this.getText();
                String title = "Do you want to delete the following Links:";
                String statusLine = String.valueOf(this.m_elements.size()) + " Links to delete!";
                String noElementsText = "No Links to delete!";
                if (this.m_elements.size() == 1) {
                    title = "Do you want to delete the following Link:";
                    statusLine = "1 Link to delete!";
                }
                ShowMessageDialog dialog = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), dialogTitle, title, statusLine, true, "Delete", this.m_elements, noElementsText);
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() != 0) break block12;
                ProgressDialog pd = new ProgressDialog("  Delete Links", "", 0, this.m_elements.size());
                try {
                    pd.setBlockOnOpen(false);
                    pd.open();
                    int processingNumber = 0;
                    LinkedList<GroupTreeObjectLast> notDeleted = new LinkedList<GroupTreeObjectLast>();
                    int i = 0;
                    while (i < this.m_elements.size()) {
                        GroupTreeObjectLast gtol = this.m_elements.get(i);
                        pd.setProgress("Delete Link  '" + gtol.getName() + "'", ++processingNumber);
                        boolean deleted = this.processOnServer(gtol);
                        if (!deleted) {
                            RTLogger.print(5, "Error deleting Link " + gtol.getName());
                            notDeleted.add(gtol);
                        }
                        ++i;
                    }
                    this.m_treeViewer.setSelection(null);
                    Object[] expanded = this.m_treeViewer.getExpandedElements();
                    this.m_treeViewer.refresh();
                    int index = 0;
                    while (index < expanded.length) {
                        this.m_treeViewer.setExpandedState(expanded[index], true);
                        ++index;
                    }
                    this.triggerUndeployment(notDeleted);
                }
                catch (Throwable throwable) {
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    pd.close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private boolean processOnServer(GroupTreeObjectLast gtol) {
        UpdateServer usrv = new UpdateServer();
        boolean isSuccess = usrv.syncAsnWithServer(gtol.getPath(), "nonrecursive", CMDS.ACTION_DELLINK, gtol.getType());
        if (isSuccess) {
            gtol.getParent().removeElement(gtol);
        } else {
            MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
        }
        return isSuccess;
    }

    public void triggerUndeployment(List<GroupTreeObjectLast> notDeleted) {
        if (this.m_elements.size() > 0) {
            LinkedList<String> affectedLinks = new LinkedList<String>();
            for (GroupTreeObjectLast gtol : this.m_elements) {
                if (notDeleted.contains(gtol)) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(gtol.getName()).append('\u25ba').append(gtol.getType());
                affectedLinks.add(sb.toString());
            }
            TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Undeploy Deleted Links");
            upd.setBlockOnOpen(true);
            upd.open();
            if (upd.getReturnCode() == 0) {
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "trigger deployments for " + affectedLinks.size() + " links");
                }
                ServerClient sc = ServerClient.triggerDelayedDeploymentsFiltered(affectedLinks.toArray(new String[0]));
                Repository.getJobManager().schedule(sc);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }
}

