/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.TriggerDeploymentDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyOverviewTab;
import com.blixx.boom.gui.views.PolicySearchTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.ctrl.sc.ServerClientBatch;
import com.blixx.ctrl.sc.in.ScDeletePolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeletePolicyAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private List<GroupTreeObjectLast> m_elements = new ArrayList<GroupTreeObjectLast>();
    private CTabItem m_tab = null;

    public DeletePolicyAction(GroupTreeObjectLast gtol) {
        super("deletePolicy");
        this.setText("Delete Policy");
        this.setId("Deleted_Policy");
        if (gtol == null || Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
        this.setEnabled(permittedPolicyModify);
        if (!permittedPolicyModify) {
            this.setEnabled(false);
            return;
        }
        this.m_elements.add(gtol);
    }

    public DeletePolicyAction(TreeViewer treeViewer) {
        super("deletePolicy");
        this.setText("Delete Policy");
        this.setId("Deleted_Policy");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (!sel.isEmpty()) {
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
                this.setEnabled(permittedPolicyModify);
                if (!permittedPolicyModify) {
                    this.setEnabled(false);
                    return;
                }
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.m_elements.size() > 1) {
            this.setText("Delete Policies");
        }
    }

    public DeletePolicyAction(TableViewer tableViewer, CTabItem tab) {
        super("deletePolicy");
        this.setText("Delete Policy");
        this.setId("Deleted_Policy");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        this.m_tab = tab;
        StructuredSelection sel = (StructuredSelection)tableViewer.getSelection();
        if (sel.size() > 0) {
            HashMap<String, GroupTreeObjectLast> policyGTOLs = this.getAllPolicyGTOLs();
            for (Object selected : sel) {
                if (!(selected instanceof String[])) continue;
                String[] item = (String[])selected;
                String polName = item[1];
                GroupTreeObjectLast gtol = policyGTOLs.get(polName);
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
                this.setEnabled(permittedPolicyModify);
                if (!permittedPolicyModify) {
                    return;
                }
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.m_elements.size() > 1) {
            this.setText("Delete Policies");
        }
    }

    public void run() {
        String header = "";
        String footer = "";
        String title = "";
        String noElementsText = "No Policies to delete!";
        if (this.m_elements.size() == 1) {
            title = "   Delete Policy";
            header = "Do you want to delete the following Policy:";
            footer = "1 Policy to delete!";
        } else if (this.m_elements.size() > 1) {
            title = "   Delete Policies";
            header = "Do you want to delete the following Policies:";
            footer = String.valueOf(this.m_elements.size()) + " Policies to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", this.m_elements, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            RTLogger.print(5, "Delete Policies ...");
            LinkedHashMap<GroupTreeObjectLast, String> notDeleted = new LinkedHashMap<GroupTreeObjectLast, String>();
            if (this.m_elements.size() != 0) {
                ServerClientBatch scBatch = new ServerClientBatch(Repository.getInstance());
                ProgressDialog pd = new ProgressDialog("   Delete Policies", "", 0, this.m_elements.size());
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    int processingNumber = 0;
                    int i = 0;
                    while (i < this.m_elements.size()) {
                        GroupTreeObjectLast gtol = this.m_elements.get(i);
                        pd.setProgress("Deleting " + gtol.getName(), ++processingNumber);
                        RTLogger.print(5, "Delete " + gtol.getPath());
                        if (gtol instanceof GroupTreeObjectUnsubmitted) {
                            this.removeUnsubmittedGTOL(gtol);
                        } else {
                            ScDeletePolicy.DeletePolicyRequest[] request = new ScDeletePolicy.DeletePolicyRequest[]{new ScDeletePolicy.DeletePolicyRequest(gtol.getName(), gtol.getType())};
                            ScDeletePolicy sdp = new ScDeletePolicy(null, request);
                            try {
                                scBatch.runBatch(sdp);
                            }
                            catch (Throwable throwable) {}
                            if (!sdp.isSuccess()) {
                                RTLogger.print(5, "Error deleting Policy " + gtol.getPath());
                                notDeleted.put(gtol, sdp.getResultObject());
                            } else {
                                PolicyView.closeTab(gtol.getName());
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        scBatch.close();
                    }
                    catch (Throwable throwable2) {}
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
                try {
                    scBatch.close();
                }
                catch (Throwable throwable) {}
                try {
                    pd.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.m_treeViewer == null) {
                this.m_treeViewer = PolicyListView.getInstance().getTreeViewer();
            }
            if (this.m_treeViewer != null) {
                Repository.getInstance().fetchPolicies(true);
                Repository.getInstance().fetchAssignments(true);
            }
            if (this.m_tab != null && this.m_tab instanceof PolicyOverviewTab) {
                ((PolicyOverviewTab)this.m_tab).reloadTable();
            } else if (this.m_tab != null && this.m_tab instanceof PolicySearchTab) {
                ((PolicySearchTab)this.m_tab).reRunSearch();
            }
            this.triggerUndeployment(notDeleted);
            for (GroupTreeObjectLast gtol : this.m_elements) {
                this.validateUnsubmittedTabsIfNecessary(gtol.getName(), gtol.getType());
            }
        }
    }

    private void validateUnsubmittedTabsIfNecessary(String polName, String polType) {
        Map<String, CTabItem> openTabs = PolicyView.getInstance().getTabList();
        for (CTabItem cTab : openTabs.values()) {
            AbstractPolicyTab tab;
            if (cTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)cTab;
                if (!((MonitorPolicyTab)tab).getPolicy().getName().equals(polName)) continue;
                ((MonitorPolicyTab)tab).validatePolicyName(polName);
                continue;
            }
            if (!(cTab instanceof FilterPolicyTab) || !((FilterPolicyTab)(tab = (FilterPolicyTab)cTab)).getPolicy().getName().equals(polName)) continue;
            ((FilterPolicyTab)tab).validatePolicyName(polName);
        }
    }

    private void removeUnsubmittedGTOL(GroupTreeObjectLast gtol) {
        CTabItem tab = PolicyView.getTab(gtol.getName());
        if (tab != null && !tab.isDisposed()) {
            if (tab instanceof MonitorPolicyTab) {
                MonitorPolicyTab mTab = (MonitorPolicyTab)tab;
                mTab.setDirty(false);
                mTab.dispose();
            } else if (tab instanceof FilterPolicyTab) {
                FilterPolicyTab fTab = (FilterPolicyTab)tab;
                fTab.setDirty(false);
                fTab.dispose();
            }
        }
        try {
            gtol.getParent().removeElement(gtol);
        }
        catch (Throwable throwable) {}
    }

    private HashMap<String, GroupTreeObjectLast> getAllPolicyGTOLs() {
        HashMap<String, GroupTreeObjectLast> policies = new HashMap<String, GroupTreeObjectLast>();
        GroupTreeObjectLast gtol = null;
        List<GroupTreeObject> list = PolicyManager.getInstance().getPolicyTree().getAllElements();
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject o = list.get(i);
            if (!(o instanceof GroupTreeObjectUnsubmitted) && o instanceof GroupTreeObjectLast) {
                gtol = (GroupTreeObjectLast)o;
                policies.put(gtol.getName(), gtol);
            }
            ++i;
        }
        return policies;
    }

    public void triggerUndeployment(Map<GroupTreeObjectLast, String> notDeleted) {
        if (this.m_elements.size() > 0) {
            LinkedList<String> deletedPolicies = new LinkedList<String>();
            for (GroupTreeObjectLast gtol : this.m_elements) {
                if (notDeleted.containsKey(gtol) || gtol instanceof GroupTreeObjectUnsubmitted) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(gtol.getName()).append('\u25ba').append(gtol.getType());
                deletedPolicies.add(sb.toString());
            }
            if (notDeleted.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<GroupTreeObjectLast, String> en : notDeleted.entrySet()) {
                    sb.append(en.getKey().getName()).append(": ").append(en.getValue());
                    sb.append('\n');
                }
                try {
                    ShowMessageDialog smd = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Server Error", "Error deleting policies:", sb.toString(), null, false, " Close ");
                    smd.open();
                }
                catch (Throwable throwable) {}
            }
            if (deletedPolicies.size() > 0) {
                TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Undeploy Deleted Policies");
                upd.setBlockOnOpen(true);
                upd.open();
                if (upd.getReturnCode() == 0) {
                    ServerClient sc = null;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, "trigger deployments for " + deletedPolicies.size() + " policies");
                    }
                    sc = ServerClient.triggerDelayedDeploymentsFiltered(deletedPolicies.toArray(new String[0]));
                    Repository.getJobManager().schedule(sc);
                }
            }
        }
    }
}

