/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.shared.UserRole;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteRoleAction
extends Action {
    private TreeViewer m_treeViewer = null;
    GroupTreeObject m_gto = null;

    public DeleteRoleAction(TreeViewer treeViewer, GroupTreeObject gto) {
        super("DeleteUserRole");
        this.setText("Delete User Role");
        this.setId("DeleteUserRole");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        this.m_gto = gto;
        if (Repository.getInstance().getRights(1004) < 3 || this.m_treeViewer == null || this.m_gto == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_gto.getName().trim().equals(UserManager.ADMINISTRATOR)) {
            MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"  Error", (String)"The Admin Role cannot be deleted!");
        } else if (this.m_gto.hasElements().booleanValue()) {
            MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"  Error", (String)"Only empty User Roles can be deleted!");
        } else {
            boolean b = MessageDialog.openQuestion((Shell)this.m_treeViewer.getControl().getShell(), (String)"  Delete User Role", (String)"Do you want to delete the User Role?   ");
            if (b) {
                UserRole role = Repository.getInstance().getUserManager().getRoleByName(this.m_gto.getName());
                Repository.getInstance().getUserManager().deleteRole(role);
            }
        }
    }
}

