/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteServerFilterAction
extends Action {
    private String m_type = null;
    private List<ForwardPolicy> m_fPolicies = null;
    private String m_fpNameOrig = null;
    private ForwardPolicy m_fp2Delete = null;
    private TableViewer m_tv = null;
    private String m_txt = null;

    public DeleteServerFilterAction(TableViewer tv, List<ForwardPolicy> fPolicies, String type) {
        super("DeleteServerFilter");
        this.setId("deleteseverfilter");
        this.setText("Delete Server Filter");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_tv = tv;
        this.m_fPolicies = fPolicies;
        this.m_type = type;
        if (this.m_fPolicies == null || this.m_fPolicies.size() == 0 || this.m_type == null) {
            this.setEnabled(false);
            return;
        }
        this.setTitle();
        if (this.m_type.equals("NOTIFICATION")) {
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
                return;
            }
        } else if (this.m_type.equals("USERS") && Repository.getInstance().getRights(1004) < 3) {
            this.setEnabled(false);
            return;
        }
    }

    public DeleteServerFilterAction(List<ForwardPolicy> fPolicies, String type) {
        super("DeleteServerFilter");
        this.setId("deleteseverfilter");
        this.setText("Delete Server Filter");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_fPolicies = fPolicies;
        this.m_type = type;
        if (this.m_fPolicies == null || this.m_fPolicies.size() == 0 || this.m_type == null) {
            this.setEnabled(false);
            return;
        }
        this.setTitle();
        if (this.m_type.equals("NOTIFICATION")) {
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
                return;
            }
        } else if (this.m_type.equals("USERS") && Repository.getInstance().getRights(1004) < 3) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String m_dialog_title = "   " + this.getText();
        String m_dialog_msg = "Do you want do delete the following " + this.m_txt + ":";
        String m_dialog_count = String.valueOf(this.m_fPolicies.size()) + " " + this.m_txt + " to delete!";
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), m_dialog_title, m_dialog_msg, m_dialog_count, true, "Delete", this.m_fPolicies, "");
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            Integer selIndex = null;
            if (this.m_tv != null) {
                selIndex = this.m_tv.getTable().getSelectionIndex();
            }
            if (this.m_fPolicies != null) {
                FPolicyManager.getInstance().deleteForwardPolicy(this.m_fPolicies);
            } else if (this.m_fp2Delete != null && this.m_fpNameOrig != null) {
                this.m_fp2Delete.setPolicyName(this.m_fpNameOrig);
                FPolicyManager.getInstance().deleteForwardPolicy(this.m_fp2Delete, this.m_fpNameOrig);
            }
            if (this.m_tv != null) {
                int newItemCount = this.m_tv.getTable().getItemCount() - this.m_fPolicies.size();
                if (selIndex >= newItemCount) {
                    selIndex = newItemCount - 1;
                }
            }
            if (this.m_type.equals("NOTIFICATION")) {
                ServerFilterView.getInstance().refreshNotificationFilterTab(false, null, true, selIndex);
            } else if (this.m_type.equals("USERS")) {
                ServerFilterUsersTab.getInstance().refreshUserFilterTab(false, null, true, selIndex, false);
            }
        }
    }

    public void setTitle() {
        if (this.m_type.equals("USERS")) {
            if (this.m_fPolicies.size() == 1) {
                this.setText("Delete User Filter");
                this.m_txt = "User Filter";
            } else {
                this.setText("Delete User Filters");
                this.m_txt = "User Filters";
            }
        } else if (this.m_type.equals("NOTIFICATION")) {
            if (this.m_fPolicies.size() == 1) {
                this.setText("Delete Notification Filter");
                this.m_txt = "Notification Filter";
            } else {
                this.setText("Delete Notification Filters");
                this.m_txt = "Notification Filters";
            }
        }
    }
}

