/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.shared.User;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DeleteUserAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private List<User> m_users = new ArrayList<User>();

    public DeleteUserAction(TreeViewer treeViewer, List<User> users) {
        super("DeleteUser");
        this.setText("Delete User");
        this.setId("DeleteUser");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_treeViewer = treeViewer;
        this.m_users = users;
        if (this.m_users != null && this.m_users.size() > 1) {
            this.setText("Delete Users");
        }
        if (Repository.getInstance().getRights(1004) < 3 || this.m_treeViewer == null || this.m_users == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        boolean isSuccess;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<User> users = new ArrayList<User>();
        int i = 0;
        while (i < this.m_users.size()) {
            User user = this.m_users.get(i);
            String loginName = user.m_loginName;
            if (loginName.equals(UserManager.ADMIN)) {
                MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"The Admin User cannot be deleted!");
                return;
            }
            users.add(user);
            names.add(loginName);
            ++i;
        }
        String title = "  Delete User";
        String header = "Do you want do delete the following User:";
        String footer = "1 User to delete!";
        String noElementsText = "No Users to delete!";
        if (names.size() > 1) {
            title = "  Delete Users";
            header = "Do you want do delete the following Users:";
            footer = names.size() + " Users to delete!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", users, noElementsText);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0 && this.m_users != null && !(isSuccess = Repository.getInstance().getUserManager().deleteUsers(this.m_users))) {
            MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"Error deleting users!");
        }
    }
}

